/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.emotion.base.emoji;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.hiyo.emotion.base.R;
import com.yy.hiyo.emotion.base.emoji.EmojiEntity;
import com.yy.hiyo.emotion.base.emoji.EmojiHolder;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.emotion.base.emoji.EmojiViewDelegate;
import java.util.ArrayList;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;

public class EmojiView
extends YYFrameLayout {
    static final int COLUMN = 7;
    private EmojiViewDelegate mEmojiViewDelegate;
    private RecyclerView mRecyclerView;
    private MultiTypeAdapter mAdapter;

    public EmojiView(Context context, EmojiViewDelegate delegate) {
        super(context);
        this.mEmojiViewDelegate = delegate;
        this.init();
    }

    private void init() {
        this.genEmojiPager();
    }

    private void genEmojiPager() {
        ArrayList<EmojiEntity> emojiArray = new ArrayList<EmojiEntity>();
        emojiArray.addAll(EmojiManager.INSTANCE.getEmojiData());
        this.mRecyclerView = new YYRecyclerView(this.getContext(), "EmojiView");
        this.mRecyclerView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.addView((View)this.mRecyclerView);
        final GridLayoutManager gridLayoutManager = new GridLayoutManager(this.getContext(), 7);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.mRecyclerView.setHasFixedSize(true);
        this.mAdapter = new MultiTypeAdapter();
        this.mAdapter.register(EmojiEntity.class, (ItemViewBinder)new BaseItemBinder<EmojiEntity, EmojiHolder>(){

            @NonNull
            protected EmojiHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new EmojiHolder(this.createItemView(inflater, parent, R.layout.layout_msg_emotion_item));
            }

            protected void onBindViewHolder(@NonNull EmojiHolder holder, @NonNull EmojiEntity item) {
                super.onBindViewHolder((BaseItemBinder.ViewHolder)holder, (Object)item);
                ViewGroup.LayoutParams params = holder.itemView.getLayoutParams();
                params.height = gridLayoutManager.getWidth() / gridLayoutManager.getSpanCount();
                holder.setOnItemClickListener(entity -> {
                    if (EmojiView.this.mEmojiViewDelegate != null) {
                        EmojiView.this.mEmojiViewDelegate.onEmojiSelected(entity);
                    }
                });
            }
        });
        this.mAdapter.setItems(emojiArray);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }
}

