/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.emotion.base.emoji;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.emotion.base.R;
import com.yy.hiyo.emotion.base.emoji.EmojiEntity;
import com.yy.hiyo.emotion.base.emoji.EmojiImageResourceHelper;
import com.yy.hiyo.emotion.base.emoji.EmojiSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum EmojiManager implements INotify
{
    INSTANCE;

    static Map<String, Integer> sResIds;
    static Map<String, Integer> sNewResIds;
    static Map<String, String> sContentForCodeMap;
    static Map<String, Integer> sContentResIds;
    private static final String TAG = "EmojiManager";
    private static final int EMOJI_IMAGE_WIDTH;
    private Map<String, EmojiEntity> emojiMap = new HashMap<String, EmojiEntity>();
    private List<EmojiEntity> emojis = new ArrayList<EmojiEntity>();

    private EmojiManager() {
        YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this));
    }

    public void init() {
        this.parseData();
    }

    private synchronized void parseData() {
        if (this.emojiMap.size() > 0) {
            return;
        }
        MLog.info((Object)TAG, (String)"parseData", (Object[])new Object[0]);
        try {
            this.initNewResIds();
            this.initResIds();
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"parseData error=%s", (Object[])new Object[]{e});
        }
    }

    private void initResIds() {
        for (String key : sResIds.keySet()) {
            if (TextUtils.isEmpty((CharSequence)key)) continue;
            EmojiEntity emojiEntity = new EmojiEntity();
            emojiEntity.setId(sResIds.get(key));
            emojiEntity.setCode(key);
            this.emojis.add(emojiEntity);
            this.emojiMap.put(key, emojiEntity);
        }
    }

    private void initNewResIds() {
        MLog.info((Object)TAG, (String)"initNewResIds", (Object[])new Object[0]);
        for (String key : sNewResIds.keySet()) {
            if (TextUtils.isEmpty((CharSequence)key)) continue;
            EmojiEntity emojiEntity = new EmojiEntity();
            emojiEntity.setId(sNewResIds.get(key));
            emojiEntity.setCode(key);
            this.emojis.add(emojiEntity);
            this.emojiMap.put(key, emojiEntity);
        }
    }

    public SpannableString getExpressionString(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return new SpannableString((CharSequence)"");
        }
        this.parseData();
        SpannableString spannableString = new SpannableString((CharSequence)str);
        String regexStr = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]|[\ud83e\udd00-\ud83e\uddff]|/[^/]+/";
        Pattern pattern = Pattern.compile(regexStr, 2);
        try {
            this.dealExpression(spannableString, pattern, 0);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"dealExpression %s", (Object[])new Object[]{e.getMessage()});
        }
        return spannableString;
    }

    public boolean hasExpressionString(String str) {
        String regexStr = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]|[\ud83e\udd00-\ud83e\uddff]|/[^/]+/";
        return str.matches(regexStr);
    }

    public String getExtendExpressionString(String str) {
        return str;
    }

    private void dealExpression(SpannableString spannableString, Pattern patten, int start) throws Exception {
        Matcher matcher = patten.matcher((CharSequence)spannableString);
        while (matcher.find()) {
            String key = matcher.group();
            if (matcher.start() < start) continue;
            int drawableId = -1;
            if (sContentResIds.containsKey(key)) {
                drawableId = sContentResIds.get(key);
            } else {
                EmojiEntity emojiEntity = this.emojiMap.get(key);
                if (emojiEntity == null) continue;
                drawableId = emojiEntity.getId();
            }
            if (drawableId == -1) continue;
            Drawable drawable2 = ResourceUtils.getDrawable((int)drawableId);
            drawable2.setBounds(0, 0, EMOJI_IMAGE_WIDTH, EMOJI_IMAGE_WIDTH);
            EmojiSpan imageSpan = new EmojiSpan(drawable2, 0);
            int end = matcher.start() + key.length();
            spannableString.setSpan((Object)imageSpan, matcher.start(), end, 17);
            if (end >= spannableString.length()) continue;
            start = end;
        }
    }

    public SpannableString getNewEmojiImage(String code) {
        EmojiEntity emojiEntity = this.emojiMap.get(code);
        SpannableString spannableString = new SpannableString((CharSequence)code);
        if (emojiEntity != null) {
            Drawable drawable2 = ResourceUtils.getDrawable((int)emojiEntity.getId());
            drawable2.setBounds(0, 0, EMOJI_IMAGE_WIDTH, EMOJI_IMAGE_WIDTH);
            EmojiSpan imageSpan = new EmojiSpan(drawable2, 0);
            spannableString.setSpan((Object)imageSpan, 0, code.length(), 33);
        }
        return spannableString;
    }

    public SpannableString getExpressionString(String str, int emojiWidth) {
        this.parseData();
        SpannableString spannableString = new SpannableString((CharSequence)str);
        String regexStr = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]|[\ud83e\udd00-\ud83e\uddff]|/[^/]+/";
        Pattern pattern = Pattern.compile(regexStr, 2);
        try {
            this.dealExpression(spannableString, pattern, 0, emojiWidth);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"dealExpression %s", (Object[])new Object[]{e.getMessage()});
        }
        return spannableString;
    }

    private void dealExpression(SpannableString spannableString, Pattern patten, int start, int emojiWidth) throws Exception {
        Matcher matcher = patten.matcher((CharSequence)spannableString);
        while (matcher.find()) {
            String key = matcher.group();
            if (matcher.start() < start) continue;
            int drawableId = -1;
            if (sContentResIds.containsKey(key)) {
                drawableId = sContentResIds.get(key);
            } else {
                EmojiEntity emojiEntity = this.emojiMap.get(key);
                if (emojiEntity == null) continue;
                drawableId = emojiEntity.getId();
            }
            if (drawableId == -1) continue;
            Drawable drawable2 = ResourceUtils.getDrawable((int)drawableId);
            drawable2.setBounds(0, 0, emojiWidth, emojiWidth);
            CenterAlignImageSpan imageSpan = new CenterAlignImageSpan(drawable2);
            int end = matcher.start() + key.length();
            spannableString.setSpan((Object)imageSpan, matcher.start(), end, 17);
            if (end >= spannableString.length()) continue;
            start = end;
        }
    }

    public String replaceSelfEmojiForCode(String str) {
        String regexStr = "/[^/]+/";
        Pattern pattern = Pattern.compile(regexStr, 2);
        Matcher matcher = pattern.matcher(str);
        int start = 0;
        while (matcher.find()) {
            String key = matcher.group();
            String newValue = "";
            if (matcher.start() < start) continue;
            if (sContentForCodeMap.containsKey(key)) {
                newValue = sContentForCodeMap.get(key);
            }
            if (TextUtils.isEmpty((CharSequence)newValue)) continue;
            str = str.replace(key, newValue);
        }
        return str;
    }

    public String removeTextEmoji(String str) {
        String regexStr = "/[^/]+/";
        Pattern pattern = Pattern.compile(regexStr, 2);
        Matcher matcher = pattern.matcher(str);
        int start = 0;
        String newValue = " ";
        while (matcher.find()) {
            String key = matcher.group();
            if (matcher.start() < start || !sContentResIds.containsKey(key) && this.emojiMap.get(key) == null) continue;
            str = str.replace(key, newValue);
        }
        return str;
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            YYTaskExecutor.execute(() -> {
                this.emojis.clear();
                this.emojiMap.clear();
                this.parseData();
            }, (long)2000L);
        }
    }

    public List<EmojiEntity> getEmojiData() {
        return this.emojis;
    }

    static {
        sResIds = EmojiImageResourceHelper.INSTANCE.getSResIds();
        sNewResIds = EmojiImageResourceHelper.INSTANCE.getSNewResIds();
        sContentForCodeMap = new HashMap<String, String>();
        sContentResIds = new HashMap<String, Integer>();
        sContentForCodeMap.put("/laughing/", "\ud83e\udd23");
        sContentForCodeMap.put("/grinning face/", "\ud83e\udd2a");
        sContentForCodeMap.put("/eyebrow raised/", "\ud83e\udd28");
        sContentForCodeMap.put("/face with monocle/", "\ud83e\uddd0");
        sContentForCodeMap.put("/nerd face/", "\ud83e\udd13");
        sContentForCodeMap.put("/grinning face with star/", "\ud83e\udd29");
        sContentForCodeMap.put("/serious face/", "\ud83e\udd2c");
        sContentForCodeMap.put("/shocked face/", "\ud83e\udd2f");
        sContentForCodeMap.put("/hugging face/", "\ud83e\udd17");
        sContentForCodeMap.put("/thinking face/", "\ud83e\udd14");
        sContentForCodeMap.put("/smiling face/", "\ud83e\udd2d");
        sContentForCodeMap.put("/shush/", "\ud83e\udd2b");
        sContentForCodeMap.put("/lying face/", "\ud83e\udd25");
        sContentForCodeMap.put("/drooling face/", "\ud83e\udd24");
        sContentForCodeMap.put("/zipper mouth/", "\ud83e\udd10");
        sContentForCodeMap.put("/nauseated face/", "\ud83e\udd22");
        sContentForCodeMap.put("/vomiting/", "\ud83e\udd2e");
        sContentForCodeMap.put("/sneezing face/", "\ud83e\udd27");
        sContentForCodeMap.put("/thermometer/", "\ud83e\udd12");
        sContentForCodeMap.put("/head bandage/", "\ud83e\udd15");
        sContentForCodeMap.put("/money mouth/", "\ud83e\udd11");
        sContentForCodeMap.put("/cowboy hat/", "\ud83e\udd20");
        sContentForCodeMap.put("/hand sign of love/", "\ud83e\udd1f");
        sContentForCodeMap.put("/handshake/", "\ud83e\udd1d");
        sContentForCodeMap.put("/adult/", "\ud83e\uddd1");
        sContentResIds.put("/laughing/", R.drawable.im_8_rolling_on_the_floor_laughing_1f923);
        sContentResIds.put("/grinning face/", R.drawable.im_25_grinning_face_with_one_large_and_one_small_eye_1f92a);
        sContentResIds.put("/eyebrow raised/", R.drawable.im_26_face_with_one_eyebrow_raised_1f928);
        sContentResIds.put("/face with monocle/", R.drawable.im_27_face_with_monocle_1f9d0);
        sContentResIds.put("/nerd face/", R.drawable.im_28_nerd_face_1f913);
        sContentResIds.put("/grinning face with star/", R.drawable.im_30_grinning_face_with_star_eyes_1f929);
        sContentResIds.put("/serious face/", R.drawable.im_48_serious_face_with_symbols_covering_mouth_1f92c);
        sContentResIds.put("/shocked face/", R.drawable.im_49_shocked_face_with_exploding_head_1f92f);
        sContentResIds.put("/hugging face/", R.drawable.im_56_hugging_face_1f917);
        sContentResIds.put("/thinking face/", R.drawable.im_57_thinking_face_1f914);
        sContentResIds.put("/smiling face/", R.drawable.im_58_smiling_face_1f92d);
        sContentResIds.put("/shush/", R.drawable.im_59_face_with_finger_covering_closed_lips_1f92b);
        sContentResIds.put("/lying face/", R.drawable.im_60_lying_face_1f925);
        sContentResIds.put("/drooling face/", R.drawable.im_72_drooling_face_1f924);
        sContentResIds.put("/zipper mouth/", R.drawable.im_75_zipper_mouth_face_1f910);
        sContentResIds.put("/nauseated face/", R.drawable.im_76_nauseated_face_1f922);
        sContentResIds.put("/vomiting/", R.drawable.im_77_face_with_open_mouth_vomiting_1f92e);
        sContentResIds.put("/sneezing face/", R.drawable.im_78_sneezing_face_1f927);
        sContentResIds.put("/thermometer/", R.drawable.im_80_face_with_thermometer_1f912);
        sContentResIds.put("/head bandage/", R.drawable.im_81_face_with_head_bandage_1f915);
        sContentResIds.put("/money mouth/", R.drawable.im_82_money_mouth_face_1f911);
        sContentResIds.put("/cowboy hat/", R.drawable.im_83_face_with_cowboy_hat_1f920);
        sContentResIds.put("/hand sign of love/", R.drawable.im_100_i_love_you_hand_sign_1f91f);
        sContentResIds.put("/handshake/", R.drawable.im_103_handshake_1f91d);
        sContentResIds.put("/adult/", R.drawable.im_126_adult_1f9d1);
        EMOJI_IMAGE_WIDTH = ResolutionUtils.dip2Px((float)20.0f);
    }

    public class CenterAlignImageSpan
    extends ImageSpan {
        public CenterAlignImageSpan(Drawable drawable2) {
            super(drawable2);
        }

        public CenterAlignImageSpan(Bitmap b) {
            super(b);
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable b = this.getDrawable();
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            int transY = (y + fm.descent + y + fm.ascent) / 2 - b.getBounds().bottom / 2;
            canvas.save();
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }
    }
}

