/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.SystemClock;
import android.text.TextUtils;
import com.yy.base.net.NetworkConnection;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.mobile.http.AuthFailureError;
import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.DateUtils;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Network;
import com.yy.mobile.http.NetworkError;
import com.yy.mobile.http.PoolingByteArrayOutputStream;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.RetryPolicy;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.http.TimeoutError;
import com.yy.mobile.http.httpsparser.HttpsParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import okhttp3.Call;
import org.apache.http.conn.ConnectTimeoutException;

public class BaseNetwork
implements Network {
    protected static int SLOW_REQUEST_THRESHOLD_MS = 3000;
    protected static final long DEFAULT_PROGRESS_PERCENT = 100L;
    protected static final String SOCKET_ERR_RESET_BY_PEER = "Connection reset by peer";
    protected long progressStep = 0L;
    protected long progressPercent = 100L;
    protected okhttp3.Request mRequest;
    protected Call mCall;
    protected static Map<String, String> COMMON_HEADERS;
    private NetworkConnection mConnection;
    private static NetworkConnection.Factory mConnectionFactory;
    private static volatile IDownloadNetworkCallBack sDownloadNetworkCallBack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseData performRequest(Request<?> request) throws RequestError {
        long requestStart = SystemClock.elapsedRealtime();
        while (true) {
            String localIP;
            String networkLibType = "";
            String realRequestHost = request.getHost();
            NetworkConnection.Connected connected = null;
            byte[] responseContents = null;
            Map<String, String> responseHeaders = new HashMap<String, String>();
            int statusCode = -1;
            InputStream inputStream = null;
            try {
                ResponseData rd;
                HttpLog.i("HttpRequestUrl:" + request.getUrl(), new Object[0]);
                NetworkConnection networkConnection = this.createNetworkRequest(request);
                networkLibType = networkConnection.networkLibType();
                realRequestHost = networkConnection.host();
                connected = networkConnection.execute();
                statusCode = connected.getResponseCode();
                HttpLog.i("response:" + statusCode + " HttpRequestUrl:" + request.getUrl(), new Object[0]);
                HttpLog.v(Thread.currentThread().getName() + " Network status code is %d", statusCode);
                responseHeaders = BaseNetwork.convertHeaders(connected.getResponseHeaderFields());
                if (statusCode == 304) {
                    ResponseData rd2;
                    ResponseData responseData = rd2 = new ResponseData(304, request.getCacheEntry().data, responseHeaders, true, networkLibType, realRequestHost);
                    return responseData;
                }
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException("httpcode = " + statusCode);
                }
                if (connected.getInputStream() != null) {
                    inputStream = connected.getInputStream();
                    responseContents = this.entityToBytes(request, connected, statusCode);
                } else {
                    responseContents = new byte[]{};
                }
                long requestLifetime = SystemClock.elapsedRealtime() - requestStart;
                this.logSlowRequests(requestLifetime, request, statusCode);
                ResponseData responseData = rd = new ResponseData(statusCode, responseContents, responseHeaders, false, networkLibType, realRequestHost);
                return responseData;
            }
            catch (SocketTimeoutException e) {
                localIP = NetworkUtils.getIpDnsInfo().getIp();
                HttpLog.e("guozhi,localIP:" + localIP + " SocketTimeoutException " + e.getMessage() + ",url:" + request.getUrl(), new Object[0]);
                this.attemptRetryOnException("Socket", request, new TimeoutError(e, 1, statusCode).networkLibType(networkLibType).realRequestHost(realRequestHost));
                continue;
            }
            catch (ConnectTimeoutException e) {
                localIP = NetworkUtils.getIpDnsInfo().getIp();
                HttpLog.e("guozhi,localIP:" + localIP + " no connection error " + e.getMessage() + ",url:" + request.getUrl(), new Object[0]);
                this.attemptRetryOnException("Connection", request, new TimeoutError(e, 9, statusCode).networkLibType(networkLibType).realRequestHost(realRequestHost));
                continue;
            }
            catch (MalformedURLException e) {
                final int httpCode = statusCode;
                throw new RequestError("Bad URL :" + request.getUrl()){

                    @Override
                    public int code() {
                        return 73;
                    }

                    @Override
                    public int httpCode() {
                        return httpCode;
                    }
                }.networkLibType(networkLibType).realRequestHost(realRequestHost);
            }
            catch (IOException e) {
                if (e instanceof SocketException && this.handleSocketException(request, (SocketException)e, statusCode)) continue;
                ResponseData responseData = null;
                HttpLog.e(e, Thread.currentThread().getName() + "guozhi, Unexpected response code %d for %s", statusCode, request.getUrl());
                int code = this.errCode(e);
                if (statusCode == 404) {
                    code = 53;
                } else if (statusCode >= 500) {
                    code = 60;
                } else if (statusCode >= 400) {
                    code = 54;
                }
                if (responseContents != null) {
                    responseData = new ResponseData(statusCode, responseContents, responseHeaders, false, networkLibType, realRequestHost);
                    if (statusCode == 401 || statusCode == 403) {
                        this.attemptRetryOnException("auth", request, new AuthFailureError(responseData, 61, statusCode).networkLibType(networkLibType).realRequestHost(realRequestHost));
                        continue;
                    }
                    String dataStr = "";
                    dataStr = BaseNetwork.isUTF_8(responseData.data) ? new String(responseData.data) : "not utf8 format, length=" + responseData.data.length;
                    String localIP2 = NetworkUtils.getIpDnsInfo().getIp();
                    HttpLog.e(e, Thread.currentThread().getName() + " localIP:" + localIP2 + " Server error code:" + responseData.statusCode + ", url:" + request.getUrl() + ", data:" + dataStr, new Object[0]);
                    throw new ServerError(responseData, code, statusCode).networkLibType(networkLibType).realRequestHost(realRequestHost);
                }
                throw new NetworkError(e, code, statusCode).networkLibType(networkLibType).realRequestHost(realRequestHost);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.mConnection == null) continue;
                this.mConnection.release();
                continue;
            }
            break;
        }
    }

    private int errCode(IOException e) {
        if (e != null) {
            String errMsg = e.toString();
            if (errMsg.contains("write failed") || errMsg.contains("ENOSPC") || errMsg.contains("No space left on device")) {
                return 74;
            }
            if (errMsg.contains("open failed") || errMsg.contains("ENOENT") || errMsg.contains("No such file or directory")) {
                return 75;
            }
            return NetworkUtils.getErrorCodeByExc((Throwable)e);
        }
        return 111;
    }

    private void addCommonHeaders(Map<String, String> headers) {
        if (COMMON_HEADERS != null && !COMMON_HEADERS.isEmpty()) {
            headers.putAll(COMMON_HEADERS);
        }
    }

    public static void setCommonHeaders(Map<String, String> commonHeaders) {
        COMMON_HEADERS = commonHeaders;
    }

    protected boolean handleSocketException(Request request, SocketException e, int httpCode) throws RequestError {
        if (e.getMessage().contains(SOCKET_ERR_RESET_BY_PEER)) {
            this.attemptRetryOnException(SOCKET_ERR_RESET_BY_PEER, request, new TimeoutError(e, 51, httpCode));
            return true;
        }
        return false;
    }

    protected void logSlowRequests(long requestLifetime, Request<?> request, int code) {
        if (requestLifetime > (long)SLOW_REQUEST_THRESHOLD_MS && HttpLog.isDebug()) {
            HttpLog.d("Slow request lifetime=%d, sc=%d, retryCount=%s, request=%s ", requestLifetime, code, request.getRetryPolicy().getCurrentRetryCount(), request);
        }
    }

    protected void attemptRetryOnException(String logPrefix, Request<?> request, RequestError exception) throws RequestError {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int oldTimeout = request.getTimeoutMs();
        try {
            retryPolicy.retry(request, exception);
        }
        catch (RequestError e) {
            HttpLog.e("%s timeout giveup,timeout=%s", logPrefix, oldTimeout);
            throw e;
        }
        HttpLog.v("%s %s retry,timeout=%s", Thread.currentThread().getName(), logPrefix, oldTimeout);
    }

    protected void addCacheHeaders(Map<String, String> headers, Cache.Entry entry) {
        if (entry == null) {
            return;
        }
        if (entry.etag != null) {
            headers.put("If-None-Match", entry.etag);
        }
        if (entry.serverDate > 0L) {
            Date refTime = new Date(entry.serverDate);
            String formatData = DateUtils.formatDate(refTime);
            headers.put("If-Modified-Since", formatData.substring(0, formatData.length() - 6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] entityToBytes(Request<?> request, NetworkConnection.Connected connected, int httpCode) throws IOException, ServerError {
        int count;
        if (TextUtils.equals((CharSequence)connected.getResponseHeaderField("Content-Encoding"), (CharSequence)"gzip")) {
            int len;
            long s = 0L;
            boolean progress = false;
            byte[] buff = new byte[4096];
            s = SystemClock.uptimeMillis();
            GZIPInputStream dis = new GZIPInputStream(connected.getInputStream());
            StringBuilder result = new StringBuilder();
            while ((len = ((InputStream)dis).read(buff)) != -1) {
                if (request.isCanceled()) {
                    connected.cancel();
                    break;
                }
                result.append(new String(buff, 0, len));
            }
            ((InputStream)dis).close();
            byte[] bytes = result.toString().getBytes();
            if (HttpLog.isDebug()) {
                HttpLog.v("%s copy Gzip response body timecost=%d", Thread.currentThread().getName(), SystemClock.uptimeMillis() - s);
            }
            return bytes;
        }
        ByteArrayPool pool = request.getRequestProcessor().getByteArrayPool();
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(pool, (int)connected.getContentLength());
        byte[] buffer = null;
        InputStream in = null;
        in = connected.getInputStream();
        if (in == null) {
            throw new ServerError("input stream is null", 111, httpCode);
        }
        buffer = pool.getBuf(1024);
        long progress = 0L;
        long total = connected.getContentLength();
        while ((count = in.read(buffer)) != -1) {
            if (request.isCanceled()) {
                connected.cancel();
                break;
            }
            bytes.write(buffer, 0, count);
            if (!this.needProgress(count, total, request, progress += (long)count)) continue;
            ProgressInfo progressInfo = new ProgressInfo(progress, total);
            request.postProgress(progressInfo);
        }
        byte[] byArray = bytes.toByteArray();
        try {
            connected.getInputStream().close();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                HttpLog.e(e, "InputStream close error.", e);
            }
        }
        catch (Exception e) {
            HttpLog.v("entity to bytes consumingContent error", new Object[0]);
        }
        pool.returnBuf(buffer);
        bytes.close();
        return byArray;
        catch (OutOfMemoryError oom) {
            byte[] byArray2;
            try {
                HttpLog.e(oom, "Bytes.toByteArray from network oom.", new Object[0]);
                System.gc();
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                try {
                    connected.getInputStream().close();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        HttpLog.e(e, "InputStream close error.", e);
                    }
                }
                catch (Exception e) {
                    HttpLog.v("entity to bytes consumingContent error", new Object[0]);
                }
                pool.returnBuf(buffer);
                bytes.close();
                throw throwable;
            }
            try {
                connected.getInputStream().close();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    HttpLog.e(e, "InputStream close error.", e);
                }
            }
            catch (Exception e) {
                HttpLog.v("entity to bytes consumingContent error", new Object[0]);
            }
            pool.returnBuf(buffer);
            bytes.close();
            return byArray2;
        }
    }

    protected boolean needProgress(long count, long total, Request<?> request, long progress) {
        if (request.getProgressListener() == null) {
            return false;
        }
        if (total < 0L) {
            return false;
        }
        this.progressStep += count;
        if (this.progressStep > total / this.progressPercent || progress >= total) {
            this.progressStep = 0L;
            return true;
        }
        return false;
    }

    protected static Map<String, String> convertHeaders(Map<String, List<String>> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (FP.empty(headers)) {
            return result;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            List<String> value = entry.getValue();
            String key = entry.getKey();
            result.put(key, value.get(value.size() - 1));
        }
        return result;
    }

    private Map<String, String> getRequestHeaders(Request<?> request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.addCacheHeaders(headers, request.getCacheEntry());
        this.addCommonHeaders(headers);
        for (String key : request.getHeaders().keySet()) {
            headers.put(key, request.getHeaders().get(key));
        }
        for (String key : request.getHttpParams().keySet()) {
            headers.put(key, request.getHttpParams().get(key).toString());
        }
        if (request.getHttpParams().containsKey("http.virtual-host")) {
            headers.put("Host", HttpsParser.getHost(request.getHttpParams().get("http.virtual-host").toString()));
        }
        return headers;
    }

    public NetworkConnection createNetworkRequest(Request<?> request) throws IOException, AuthFailureError, IllegalStateException {
        String url = "";
        IDownloadNetworkCallBack downloadNetworkCallBack = sDownloadNetworkCallBack;
        url = downloadNetworkCallBack != null ? downloadNetworkCallBack.getUrl(request.getUrl()) : request.getUrl();
        this.mConnection = mConnectionFactory.create(url);
        if (request.getTag() != null) {
            this.mConnection.tag(request.getTag());
        }
        this.mConnection.setRequestMethod("GET");
        Map<String, String> header = this.getRequestHeaders(request);
        for (String key : header.keySet()) {
            this.mConnection.addHeader(key, header.get(key));
        }
        return this.mConnection;
    }

    @Override
    public void cancel() {
        if (this.mConnection != null) {
            this.mConnection.cancel();
        }
    }

    public static boolean isUTF_8(byte[] str) {
        if (str.length < 3) {
            return false;
        }
        return (str[0] & 0xFF) == 239 && (str[1] & 0xFF) == 187 && (str[2] & 0xFF) == 191;
    }

    public static void setDownloadNetworkCallBack(IDownloadNetworkCallBack callBack) {
        sDownloadNetworkCallBack = callBack;
    }

    public static void setConnectionFactory(NetworkConnection.Factory mConnectionFactory) {
        BaseNetwork.mConnectionFactory = mConnectionFactory;
    }

    public static interface IDownloadNetworkCallBack {
        public String getUrl(String var1);
    }

    public static class RequestTag {
    }
}

