/*
 * Decompiled with CFR 0.152.
 */
package downloader.bspatch;

import downloader.bspatch.bzip2.BZip2CompressorInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BSUtil {
    public static final int HEADER_SIZE = 32;
    public static final int BUFFER_SIZE = 8192;

    public static final boolean readFromStream(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < len; totalBytesRead += bytesRead) {
            bytesRead = in.read(buf, offset + totalBytesRead, len - totalBytesRead);
            if (bytesRead >= 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] inputStreamToByte(InputStream in) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        int count = -1;
        while ((count = in.read(data, 0, 8192)) != -1) {
            outStream.write(data, 0, count);
        }
        data = null;
        return outStream.toByteArray();
    }

    public static byte toSigned(int unsigned) {
        return unsigned < 128 ? (byte)unsigned : (byte)(unsigned - 256);
    }

    public static short toUnsigned(byte signed) {
        if (signed >= 0) {
            return signed;
        }
        return (short)(256 + signed);
    }

    public static InputStream readBzip2Data(byte[] data, long offset, long length) throws IOException {
        if (length == -1L) {
            length = (long)data.length - offset;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, (int)offset, (int)length);
        BZip2CompressorInputStream bis = new BZip2CompressorInputStream(is);
        return bis;
    }

    public static long bZ2BzRead(InputStream bzip2is, byte[] dest, long offset, long length) throws IOException {
        int len;
        for (long i = 0L; i < length; i += (long)len) {
            len = bzip2is.read(dest, (int)(offset + i), (int)(length - i));
            if (len != -1) continue;
            throw new IOException("Bzip2 EOF");
        }
        return length;
    }

    public static long offtin(byte[] header, int offset) {
        long y = 0L;
        y = header[offset += 7] & 0x7F;
        boolean sign = (header[offset] & 0x80) != 0;
        for (int i = 6; i >= 0; --i) {
            y = y * 256L + (long)BSUtil.toUnsigned(header[--offset]);
        }
        if (sign) {
            y = -y;
        }
        return y;
    }
}

