/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.mobile.http.DefaultRequestProcessor;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestIntercepter;
import com.yy.mobile.http.RequestProcessor;

public class RequestManager {
    private static RequestManager mFactory;
    private RequestProcessor mCommonProcessor;
    private boolean mInit = false;

    private RequestManager() {
    }

    public static synchronized RequestManager instance() {
        if (mFactory == null) {
            mFactory = new RequestManager();
        }
        return mFactory;
    }

    public synchronized void init(Context context, String cacheDir) {
        this.init(context, cacheDir, new RequestIntercepter[]{null});
        this.mInit = true;
    }

    public synchronized void init(Context context, String cacheDir, RequestIntercepter ... intercepters) {
        this.mCommonProcessor = new DefaultRequestProcessor(1, "Http_");
        if (intercepters != null) {
            for (RequestIntercepter intercepter : intercepters) {
                if (intercepter == null) continue;
                this.mCommonProcessor.addRequestIntercepter(intercepter);
            }
        }
        this.mCommonProcessor.setDebug(RuntimeContext.sIsDebuggable);
        this.mCommonProcessor.start();
    }

    public Request submitRequest(Request req) {
        this.mCommonProcessor.add(req);
        return req;
    }

    public boolean isInit() {
        return this.mInit;
    }
}

