/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.base.net.NetworkConnection;
import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.ServerError;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DownloadNetwork
extends BaseNetwork {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String TMP_SURFIX = ".tmp";
    protected String mDownloadFilePath;
    protected String mDownloadFileTempPath;

    public DownloadNetwork(String downloadFilePath) {
        if (HttpLog.isDebug()) {
            HttpLog.d("Download file path " + downloadFilePath, new Object[0]);
        }
        this.mDownloadFilePath = downloadFilePath;
        this.mDownloadFileTempPath = DownloadNetwork.createTempPath(this.mDownloadFilePath);
    }

    protected static String createTempPath(String orginalPath) {
        String fileName = TMP_SURFIX;
        fileName = orginalPath.concat(fileName);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] entityToBytes(Request<?> request, NetworkConnection.Connected connected, int httpCode) throws IOException, ServerError {
        block17: {
            statusCode = connected.getResponseCode();
            if (statusCode < 200) return super.entityToBytes(request, connected, statusCode);
            if (statusCode > 299) {
                return super.entityToBytes(request, connected, statusCode);
            }
            HttpLog.v("Download file tmp path " + this.mDownloadFileTempPath, new Object[0]);
            file = new File(this.mDownloadFileTempPath);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            buffer = new byte[4096];
            in = null;
            try {
                in = connected.getInputStream();
                if (in == null) {
                    throw new ServerError("input stream is null", 111, statusCode);
                }
                total = connected.getContentLength();
                HttpLog.v("Download content length %d", new Object[]{total});
                progress = 0L;
lbl17:
                // 3 sources

                while ((count = in.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, count);
                    progress += (long)count;
                    if (request.isCanceled()) {
                        if (HttpLog.isDebug()) {
                            HttpLog.d("DownloadNetwork Download cancel. %s ", new Object[]{request.getUrl()});
                        }
                        connected.cancel();
                        this.onCancel(progress);
                        var14_12 = new byte[]{};
                        break block17;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl53
            }
            catch (Throwable var17_17) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (in == null) throw var17_17;
                    in.close();
                    throw var17_17;
                }
                catch (IOException e) {
                    HttpLog.e("entity to bytes consumingContent error", new Object[]{e});
                }
                throw var17_17;
            }
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            if (in == null) return var14_12;
            in.close();
            return var14_12;
        }
        catch (IOException e) {
            HttpLog.e("entity to bytes consumingContent error", new Object[]{e});
        }
        return var14_12;
lbl-1000:
        // 1 sources

        {
            if (!this.needProgress(count, total, request, progress)) ** GOTO lbl17
            progressInfo = new ProgressInfo(progress, total);
            request.postProgress(progressInfo);
            ** GOTO lbl17
lbl53:
            // 1 sources

            renameFileReulst = file.renameTo(new File(this.mDownloadFilePath));
            HttpLog.v("File file.length() %d", new Object[]{file.length()});
            HttpLog.v("File rename completed, result %d", new Object[]{renameFileReulst != false ? 1 : 0});
            var15_15 = this.mDownloadFilePath.getBytes();
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            if (in == null) return var15_15;
            in.close();
            return var15_15;
        }
        catch (IOException e) {
            HttpLog.e("entity to bytes consumingContent error", new Object[]{e});
        }
        return var15_15;
    }

    protected void onCancel(long progress) throws IOException {
        if (HttpLog.isDebug()) {
            HttpLog.d("OnCancel", new Object[0]);
        }
        this.cancel();
    }
}

