/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.HttpLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class DownloadContinueConfig {
    Properties properties = new Properties();
    File mPath;

    public DownloadContinueConfig(String path) {
        this.mPath = new File(path);
    }

    public boolean exists() {
        boolean result = this.mPath.exists();
        HttpLog.d("Download config exists=%b path=" + this.mPath, result);
        return result;
    }

    public void create() throws IOException {
        this.mPath.createNewFile();
        HttpLog.d("Create download config", new Object[0]);
    }

    public void put(String key, String value) {
        HttpLog.d("Put download config key=" + key + ",value=" + value, new Object[0]);
        this.properties.setProperty(key, value);
    }

    public String get(String key) {
        String value = this.properties.getProperty(key);
        HttpLog.d("Get download config key=" + key + ",value=" + value, new Object[0]);
        return value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            String value = this.get(key);
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return defaultValue;
        }
        catch (Exception e) {
            HttpLog.e(e, "Get boolean error", new Object[0]);
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            String value = this.get(key);
            if (value != null) {
                return Integer.valueOf(value);
            }
            return defaultValue;
        }
        catch (Exception e) {
            HttpLog.e(e, "Get Int error", new Object[0]);
            return defaultValue;
        }
    }

    public void load() throws IOException {
        HttpLog.d("Load download config", new Object[0]);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.mPath), "UTF-8");
        this.properties.load(inputStreamReader);
        inputStreamReader.close();
    }

    public OutputStreamWriter getWriter() throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this.mPath), "UTF-8");
    }

    public void store(OutputStreamWriter outputStreamWriter) throws IOException {
        this.properties.store(outputStreamWriter, null);
    }

    public void save() throws IOException {
        HttpLog.d("Save download config", new Object[0]);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.mPath), "UTF-8");
        this.properties.store(outputStreamWriter, null);
        outputStreamWriter.close();
    }

    public boolean delete() {
        HttpLog.d("Delete download config = " + this.mPath, new Object[0]);
        return this.mPath.delete();
    }
}

