/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.base.utils.URLEncodedUtils.BasicNameValuePair;
import com.yy.base.utils.URLEncodedUtils.URLEncodedUtils;
import com.yy.mobile.http.CacheController;
import com.yy.mobile.http.RequestParam;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultRequestParam
implements RequestParam {
    protected Map<String, String> urlParams = new ConcurrentHashMap<String, String>();
    protected Map<String, RequestParam.FileWrapper> fileParams = new ConcurrentHashMap<String, RequestParam.FileWrapper>();
    protected Map<String, List<String>> urlParamsWithArray = new ConcurrentHashMap<String, List<String>>();
    protected Map<String, RequestParam.FileData> fileDataParams = new ConcurrentHashMap<String, RequestParam.FileData>();
    protected String mParamEncoding = "UTF-8";
    protected CacheController mCacheController;

    @Override
    public Map<String, String> getUrlParams() {
        return this.urlParams;
    }

    @Override
    public Map<String, RequestParam.FileWrapper> getFileParams() {
        return this.fileParams;
    }

    @Override
    public Map<String, List<String>> getUrlParamsWithArray() {
        return this.urlParamsWithArray;
    }

    @Override
    public Map<String, RequestParam.FileData> getFileDataParams() {
        return this.fileDataParams;
    }

    @Override
    public void put(String key, String value) {
        if (key != null && value != null) {
            this.urlParams.put(key, value);
        }
    }

    @Override
    public void put(String key, RequestParam.FileWrapper file) {
        if (key != null && file != null) {
            this.fileParams.put(key, file);
        }
    }

    @Override
    public void put(String key, RequestParam.FileData fileData) {
        if (key != null && fileData != null) {
            this.fileDataParams.put(key, fileData);
        }
    }

    @Override
    public void put(String key, List<String> values) {
        if (key != null && values != null) {
            this.urlParamsWithArray.put(key, values);
        }
    }

    @Override
    public void add(String key, String value) {
        if (key != null && value != null) {
            List<String> paramArray = this.urlParamsWithArray.get(key);
            if (paramArray == null) {
                paramArray = new ArrayList<String>();
                this.put(key, paramArray);
            }
            paramArray.add(value);
        }
    }

    @Override
    public void remove(String key) {
        this.urlParams.remove(key);
        this.fileParams.remove(key);
        this.urlParamsWithArray.remove(key);
    }

    @Override
    public void setCacheController(CacheController controller) {
        this.mCacheController = controller;
    }

    @Override
    public CacheController getCacheController() {
        return this.mCacheController;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append("FILE");
        }
        for (Map.Entry<String, Object> entry : this.fileDataParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append("FILEDATA");
        }
        for (Map.Entry<String, Object> entry : this.urlParamsWithArray.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            List values = (List)entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    result.append("&");
                }
                result.append(entry.getKey());
                result.append("=");
                result.append((String)values.get(i));
            }
        }
        return result.toString();
    }

    protected List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.getUrlParams().entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.getUrlParamsWithArray().entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                params.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        return params;
    }

    @Override
    public String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)this.getParamsEncoding());
    }

    @Override
    public void setParamsEncoding(String encoding) {
        this.mParamEncoding = encoding;
    }

    @Override
    public String getParamsEncoding() {
        return this.mParamEncoding;
    }
}

