/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.Handler;
import com.yy.base.logger.MLog;
import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.CacheController;
import com.yy.mobile.http.CancelListener;
import com.yy.mobile.http.DefaultCacheController;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Network;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestProcessor;
import com.yy.mobile.http.Response;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.RetryPolicy;
import com.yy.mobile.http.httpsparser.HttpsParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.RequestBody;

public abstract class BaseRequest<T>
implements Request<T> {
    private static final String TAG = "BaseRequest";
    protected Network mNetwork;
    protected Cache mCache;
    protected Object mTag;
    protected int mMethod = 0;
    protected String mUrl;
    protected String mHost;
    protected Integer mSequence;
    protected RequestProcessor mRequestProcessor;
    protected Response<T> mResponse;
    protected boolean mShouldCache = true;
    protected AtomicBoolean mCanceled = new AtomicBoolean(false);
    protected boolean mResponseDelivered = false;
    protected RetryPolicy mRetryPolicy;
    protected Cache.Entry mCacheEntry = null;
    protected ResponseListener mSuccessListener;
    protected ResponseErrorListener mErrorListener;
    protected ProgressListener mProgressListener;
    protected CancelListener mCancelListener;
    protected boolean mNoExpire;
    protected Map<String, String> mHeader;
    protected Map<String, Object> mHttpParams;
    protected CacheController mCacheController = new DefaultCacheController();
    protected Request.Priority mPriority = Request.Priority.NORMAL;
    protected int mConnectTimeoutMs = 5000;
    public ResponseData mResponseData;

    public BaseRequest(Cache cache, String url, ResponseListener successListener, ResponseErrorListener errorListener) {
        this(cache, url, successListener, errorListener, null);
    }

    public BaseRequest(Cache cache, String url, ResponseListener successListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        this.mNetwork = new BaseNetwork();
        this.mCache = cache;
        this.mUrl = HttpsParser.convertToHttps(url);
        this.mSuccessListener = successListener;
        this.mErrorListener = errorListener;
        this.mProgressListener = progressListener;
        this.mRetryPolicy = new DefaultRetryPolicy();
        this.mHeader = new ConcurrentHashMap<String, String>();
        this.mHttpParams = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public int getMethod() {
        return this.mMethod;
    }

    @Override
    public void setMethod(int method) {
        this.mMethod = method;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.mHeader;
    }

    @Override
    public Map<String, Object> getHttpParams() {
        return this.mHttpParams;
    }

    @Override
    public void setTag(Object tag) {
        this.mTag = tag;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
    }

    @Override
    public void finish(String tag) {
        if (this.mRequestProcessor != null) {
            this.mRequestProcessor.finish(this);
        }
    }

    @Override
    public void setRequestProcessor(RequestProcessor requestProcessor) {
        this.mRequestProcessor = requestProcessor;
    }

    @Override
    public RequestProcessor getRequestProcessor() {
        return this.mRequestProcessor;
    }

    @Override
    public void setSequence(int sequence) {
        this.mSequence = sequence;
    }

    @Override
    public int getSequence() {
        return this.mSequence;
    }

    @Override
    public String getUrl() {
        return this.mUrl;
    }

    @Override
    public void setUrl(String url) {
        this.mUrl = url;
    }

    @Override
    public String getHost() {
        return this.mHost;
    }

    @Override
    public void setHost(String host) {
        this.mHost = host;
    }

    @Override
    public String getKey() {
        return this.getUrl();
    }

    @Override
    public void cancel() {
        MLog.info((Object)TAG, (String)"cancel request %s", (Object[])new Object[]{this.mUrl});
        if (this.mNetwork != null) {
            this.mNetwork.cancel();
        }
        this.mCanceled.set(true);
    }

    @Override
    public boolean isCanceled() {
        return this.mCanceled.get();
    }

    @Override
    public RequestBody getRequestBody() {
        return null;
    }

    @Override
    public String getParamsEncoding() {
        return "UTF-8";
    }

    @Override
    public void setShouldCache(boolean shouldCache) {
        this.mShouldCache = shouldCache;
    }

    @Override
    public boolean shouldCache() {
        return this.mShouldCache;
    }

    @Override
    public Request.Priority getPriority() {
        return this.mPriority;
    }

    @Override
    public void setPriority(Request.Priority priority) {
        this.mPriority = priority;
    }

    @Override
    public int getTimeoutMs() {
        return this.mRetryPolicy.getCurrentTimeout();
    }

    @Override
    public void setConnectTimeoutMs(int timeoutMs) {
        this.mConnectTimeoutMs = timeoutMs;
    }

    @Override
    public int getConnectTimeoutMs() {
        return this.mConnectTimeoutMs;
    }

    @Override
    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    @Override
    public Response<T> getResponse() {
        return this.mResponse;
    }

    @Override
    public abstract void parseDataToResponse(ResponseData var1);

    @Override
    public void postResponse() {
        this.postResponse(null);
    }

    @Override
    public void postResponse(Runnable runnable) {
        if (this.mRequestProcessor != null) {
            Handler handler = this.mRequestProcessor.getHandler();
            if (handler == null) {
                new ResponseDeliveryRunnable(this, this.getResponse(), runnable).run();
            } else {
                HttpLog.v("Deliver (success=%b) response for request url=%s", this.getResponse().isSuccess(), this.getUrl());
                handler.post((Runnable)new ResponseDeliveryRunnable(this, this.getResponse(), runnable));
            }
        }
    }

    @Override
    public void postError(RequestError error) {
        this.mResponse = Response.error(error);
        this.postResponse();
    }

    @Override
    public void postProgress(ProgressInfo progressInfo) {
        if (this.mRequestProcessor != null) {
            Handler handler;
            if (HttpLog.isDebug()) {
                HttpLog.d("On progress " + progressInfo, new Object[0]);
            }
            if ((handler = this.mRequestProcessor.getHandler()) == null) {
                new ProgressDeliveryRunnable(this, this.mProgressListener, progressInfo).run();
            } else {
                handler.post((Runnable)new ProgressDeliveryRunnable(this, this.mProgressListener, progressInfo));
            }
        }
    }

    @Override
    public void postCancel(String tag) {
        if (this.mRequestProcessor != null) {
            Handler handler = this.mRequestProcessor.getHandler();
            if (handler == null) {
                new CancelDeliveryRunnable(this, this.mCancelListener, tag).run();
            } else {
                handler.post((Runnable)new CancelDeliveryRunnable(this, this.mCancelListener, tag));
            }
        }
    }

    @Override
    public Network getNetwork() {
        return this.mNetwork;
    }

    @Override
    public void setNetwork(Network network) {
        this.mNetwork = network;
    }

    @Override
    public Cache getCache() {
        return this.mCache;
    }

    @Override
    public void markDelivered() {
        this.mResponseDelivered = true;
    }

    @Override
    public boolean hasHadResponseDelivered() {
        return this.mResponseDelivered;
    }

    @Override
    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    @Override
    public void setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
    }

    @Override
    public ResponseListener getSuccessListener() {
        return this.mSuccessListener;
    }

    @Override
    public ResponseErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    @Override
    public ProgressListener getProgressListener() {
        return this.mProgressListener;
    }

    @Override
    public void setCacheController(CacheController cacheController) {
        this.mCacheController = cacheController;
    }

    @Override
    public CacheController getCacheController() {
        return this.mCacheController;
    }

    @Override
    public void setSuccessListener(ResponseListener successListener) {
        this.mSuccessListener = successListener;
    }

    @Override
    public void setErrorListener(ResponseErrorListener errorListener) {
        this.mErrorListener = errorListener;
    }

    @Override
    public void setProgressListener(ProgressListener progressListener) {
        this.mProgressListener = progressListener;
    }

    @Override
    public void setCancelListener(CancelListener cancelListener) {
        this.mCancelListener = cancelListener;
    }

    @Override
    public int getThreshold() {
        return 0;
    }

    @Override
    public String getThresholdType() {
        return "DEFAULT";
    }

    @Override
    public void setUseGzip(boolean value) {
        if (value) {
            this.mHeader.put("Accept-Encoding", "gzip");
        } else {
            this.mHeader.put("Accept-Encoding", "");
        }
    }

    @Override
    public int compareTo(Request<T> other) {
        Request.Priority right;
        Request.Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? this.getSequence() - other.getSequence() : right.ordinal() - left.ordinal();
    }

    public String toString() {
        return this.getClass().getName() + "mUrl='" + this.mUrl + '\'' + '}';
    }

    protected class CancelDeliveryRunnable
    implements Runnable {
        private final Request mRequest;
        private final String mTag;
        private final CancelListener mListener;

        public CancelDeliveryRunnable(Request request, CancelListener cancelListener, String tag) {
            this.mRequest = request;
            this.mTag = tag;
            this.mListener = cancelListener;
        }

        @Override
        public void run() {
            this.mRequest.finish(this.mTag);
            if (this.mListener != null) {
                this.mListener.onCancel();
            }
        }
    }

    protected class ProgressDeliveryRunnable
    implements Runnable {
        private final Request mRequest;
        private final ProgressInfo mInfo;
        private final ProgressListener mListener;

        public ProgressDeliveryRunnable(Request request, ProgressListener progressListener, ProgressInfo progressInfo) {
            this.mRequest = request;
            this.mListener = progressListener;
            this.mInfo = progressInfo;
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("Canceled in delivery runnable");
                return;
            }
            if (this.mListener != null) {
                this.mListener.onProgress(this.mInfo);
            }
        }
    }

    protected class ResponseDeliveryRunnable
    implements Runnable {
        private final Request mRequest;
        private final Response mResponse;
        private final Runnable mRunnable;

        public ResponseDeliveryRunnable(Request request, Response response, Runnable runnable) {
            this.mRequest = request;
            this.mRunnable = runnable;
            this.mResponse = response;
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("canceled-at-delivery");
                return;
            }
            if (this.mResponse.isSuccess()) {
                if (this.mRequest.getSuccessListener() != null) {
                    try {
                        long start = System.currentTimeMillis();
                        this.mRequest.getSuccessListener().onResponse(this.mResponse.result);
                        this.logSlowResponse(System.currentTimeMillis() - start);
                    }
                    catch (Exception e) {
                        HttpLog.e("SuccessListener response error.", e);
                    }
                }
            } else if (this.mRequest.getErrorListener() != null) {
                try {
                    this.mRequest.getErrorListener().onErrorResponse(this.mResponse.error);
                }
                catch (Exception e) {
                    HttpLog.e("ErrorListener response error.", e);
                }
            }
            if (this.mResponse.intermediate) {
                HttpLog.v("intermediate-response", new Object[0]);
            } else {
                this.mRequest.finish("done");
            }
            if (this.mRunnable != null) {
                this.mRunnable.run();
            }
        }

        private void logSlowResponse(long usedTime) {
            if (usedTime > 100L && BaseRequest.this.getRequestProcessor().isDebug() && HttpLog.isDebug()) {
                HttpLog.d("OnResponse execute slow,time used %d,url=%s", usedTime, BaseRequest.this.getUrl());
            }
        }
    }
}

