/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.plugin;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadUtil;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadCenter;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadProcesser;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.UnzipError;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.IDownloadMessageSender;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.plugin.AbstractDownloadPlugin;
import downloader.bspatch.BSPatch;
import java.io.File;

public class DifferenceCombinationPlugin
extends AbstractDownloadPlugin {
    private static final String TAG = "DifferenceCombinationPlugin";

    public DifferenceCombinationPlugin(IDownloadCenter downloadCenter, IDownloadMessageSender messageSender, IDownloadProcesser defaultProcesser) {
        super(downloadCenter, messageSender, defaultProcesser);
    }

    @Override
    public boolean onTaskStateUpdated(final DownloadTask task, final int oldState) {
        if (task == null || !task.getExtendBoolean("incremental_download")) {
            return false;
        }
        int taskState = task.getInt("state", 1);
        if (taskState != 5) {
            return false;
        }
        task.putInt("state", 3);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                DifferenceCombinationPlugin.this.startCompose(task, oldState);
            }
        });
        return true;
    }

    private void startCompose(DownloadTask task, int oldState) {
        block19: {
            String oldFilePath = task.getExtendString("incremental_oldfile");
            String oldFileMd5 = task.getExtendString("incremental_oldfilemd5");
            String composedFilePath = task.getExtendString("incremental_composedfile");
            String composedFileMd5 = task.getExtendString("incremental_composedfilemd5");
            MLog.info((Object)TAG, (String)"startCompose oldFilePath:%s,oldFileMd5:%s,composedFilePath:%s,composedFileMd5:%s!", (Object[])new Object[]{oldFilePath, oldFileMd5, composedFilePath, composedFileMd5});
            File oldFile = new File(oldFilePath);
            File patchFile = new File(task.getString("path"), task.getString("filename"));
            File composedFile = new File(composedFilePath);
            if (oldFile.isDirectory() || !oldFile.exists()) {
                this.notifyError(task, oldState, 20, null);
            } else if (patchFile.isDirectory() || !patchFile.exists()) {
                this.notifyError(task, oldState, 22, null);
            } else if (StringUtils.isEmpty((String)composedFilePath)) {
                this.notifyError(task, oldState, 23, null);
            } else {
                int result = -1;
                try {
                    result = BSPatch.patchFast(oldFile, composedFile, patchFile, 0);
                }
                catch (Throwable throwable) {
                    this.notifyError(task, oldState, 24, throwable);
                }
                if (result != 1) {
                    if (result != -1) {
                        this.notifyError(task, oldState, 24, new Exception("Compose Happen File error, code:" + result));
                    }
                } else {
                    try {
                        String md5File = MD5Utils.getFileMD5String((File)composedFile);
                        if (StringUtils.equal((String)md5File, (String)composedFileMd5)) {
                            YYFileUtils.delete((File)oldFile);
                            YYFileUtils.delete((File)patchFile);
                            this.notifySucess(task, oldState);
                            break block19;
                        }
                        String oldFileMd5Get = null;
                        if (StringUtils.isNotEmpty((String)oldFileMd5)) {
                            try {
                                oldFileMd5Get = MD5Utils.getFileMD5String((File)oldFile);
                            }
                            catch (Exception e) {
                                MLog.error((Object)TAG, (Throwable)e);
                            }
                        }
                        if (oldFileMd5Get != null && !StringUtils.equal((String)oldFileMd5Get, (String)oldFileMd5)) {
                            this.notifyError(task, oldState, 21, new Exception("md5ToCompare:" + oldFileMd5 + ", but file md5:" + oldFileMd5Get));
                        } else {
                            this.notifyError(task, oldState, 25, new Exception("md5ToCompare:" + composedFileMd5 + ", but file md5:" + md5File));
                        }
                    }
                    catch (Exception e) {
                        this.notifyError(task, oldState, 25, e);
                    }
                }
            }
        }
    }

    private void notifyError(final DownloadTask task, final int oldState, final int errorType, final Throwable throwable) {
        MLog.error((Object)TAG, (String)"notifyError task:%s, errorType:%d, error:%s!", (Object[])new Object[]{task != null ? task.toString() : "", errorType, throwable != null ? throwable.toString() : ""});
        boolean deletePatchWhenError = task.getExtendBoolean("incremental_deletepatch_when_error");
        if (deletePatchWhenError && errorType != 22) {
            File patchFile = new File(task.getString("path"), task.getString("filename"));
            YYFileUtils.delete((File)patchFile);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                task.putInt("state", 4);
                if (errorType >= 0) {
                    task.putInt("errortype", errorType);
                }
                if (throwable != null) {
                    task.putString("errorinfo", throwable.toString());
                }
                if (DifferenceCombinationPlugin.this.mDefaultProcesser != null) {
                    DifferenceCombinationPlugin.this.mDefaultProcesser.onTaskStateUpdated(task, oldState);
                }
            }
        });
    }

    private void notifySucess(final DownloadTask task, final int oldState) {
        boolean needUnzip = task.getInt("unzip") == 1;
        String composedFilePath = task.getExtendString("incremental_composedfile");
        MLog.info((Object)TAG, (String)"notifySucess task:%s, composedFilePath:%s!", (Object[])new Object[]{task != null ? task.toString() : "", composedFilePath});
        try {
            if (needUnzip) {
                DownloadUtil.unzip(composedFilePath, composedFilePath);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    task.putInt("state", 5);
                    if (DifferenceCombinationPlugin.this.mDefaultProcesser != null) {
                        DifferenceCombinationPlugin.this.mDefaultProcesser.onTaskStateUpdated(task, oldState);
                    }
                }
            });
        }
        catch (UnzipError e) {
            this.notifyError(task, oldState, 26, e);
        }
    }
}

