/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.network;

import com.yy.base.logger.MLog;
import com.yy.base.net.NetworkConnection;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadUtil;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequest;
import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.ServerError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class MyDownloadContinueNetwork
extends BaseNetwork {
    private static final String TAG = "MyDownloadContinueNetwo";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String TMP_SURFIX = ".tmp";
    protected RandomAccessFile mRandomAccessFile;
    private DownloadRequest mRequest;
    protected String mDownloadFilePath;
    protected String mDownloadFileTempPath;
    private long mStartPos;
    private long mSpeedLimitValuePerMicSecond = -1L;
    private long mProgressInterval = 1000L;
    private Thread mCurSleepThread;

    public MyDownloadContinueNetwork(String downloadFilePath, DownloadRequest request) {
        this.mRequest = request;
        this.mDownloadFilePath = downloadFilePath;
        this.mDownloadFileTempPath = MyDownloadContinueNetwork.createTempPath(this.mDownloadFilePath);
    }

    public void setStartPos(long startPos) {
        this.mStartPos = startPos;
    }

    public void deleteTempFile() {
        File tempFile = new File(this.mDownloadFileTempPath);
        if (tempFile.exists() && tempFile.isFile()) {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskSpeedLimitPerMicsecondValue(long value) {
        long old = this.mSpeedLimitValuePerMicSecond;
        this.mSpeedLimitValuePerMicSecond = value;
        if (old != value && this.mCurSleepThread != null) {
            try {
                MLog.info((Object)"lllllllllllllll", (String)"mCurSleepThread.interrupt", (Object[])new Object[0]);
                this.mCurSleepThread.interrupt();
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
            finally {
                this.mCurSleepThread = null;
            }
        }
    }

    public void setProgressInterval(long value) {
        if (value > 0L) {
            this.mProgressInterval = value;
        }
    }

    protected static String createTempPath(String orginalPath) {
        String fileName = TMP_SURFIX;
        fileName = orginalPath.concat(fileName);
        return fileName;
    }

    public ResponseData performTheRequest(Request<?> request) throws RequestError {
        try {
            MLog.info((Object)"MyDownloadContinueNetwork", (String)"performTheRequest %s", (Object[])new Object[]{request.getUrl()});
            File tempFile = new File(this.mDownloadFileTempPath);
            if (tempFile.exists() && tempFile.isFile()) {
                this.mStartPos = tempFile.length();
                if (this.mStartPos > 0L) {
                    if (HttpLog.isDebug()) {
                        HttpLog.d("Last progress = " + this.mStartPos, new Object[0]);
                    }
                    request.getHeaders().put("Range", "bytes=" + this.mStartPos + "-");
                }
                this.mRequest.onRange(this.mStartPos);
            } else {
                this.mRequest.onRange(-1L);
                tempFile.createNewFile();
                request.getHeaders().remove("Range");
            }
        }
        catch (Exception e) {
            HttpLog.e(e, "Load config file error", new Object[0]);
        }
        return super.performRequest(request);
    }

    public void initRandomAccessFile() throws IOException {
        boolean result;
        File tempFile = new File(this.mDownloadFileTempPath);
        if (!(tempFile.exists() && tempFile.isFile() || (result = tempFile.createNewFile()))) {
            MLog.error((Object)TAG, (String)"tempFile.createNewFile() error", (Object[])new Object[0]);
        }
        this.mRandomAccessFile = new RandomAccessFile(tempFile, "rw");
    }

    @Override
    public ResponseData performRequest(Request<?> request) throws RequestError {
        if (this.mRequest != null) {
            this.mRequest.onPerform();
        }
        ResponseData result = null;
        try {
            result = this.performTheRequest(request);
            if (this.mRequest != null) {
                this.mRequest.onPerformEnd(null);
            }
            return result;
        }
        catch (RequestError e) {
            if (this.mRequest != null) {
                this.mRequest.onPerformEnd(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] entityToBytesInner(Request<?> request, NetworkConnection.Connected connected) throws IOException, ServerError {
        int statusCode = connected.getResponseCode();
        if (request != null) {
            MLog.info((Object)"MyDownloadContinueNetwork", (String)"entityToBytesInner %d %s", (Object[])new Object[]{statusCode, request.getUrl()});
        }
        if (statusCode < 200 || statusCode > 299) {
            return super.entityToBytes(request, connected, statusCode);
        }
        if (request == null || request.getRequestProcessor() == null) {
            throw new IOException("request params error");
        }
        if (HttpLog.isDebug()) {
            HttpLog.d("Start continue download url=" + request.getUrl(), new Object[0]);
        }
        if (HttpLog.isDebug()) {
            HttpLog.d("Download file tmp path " + this.mDownloadFileTempPath, new Object[0]);
        }
        byte[] buffer = new byte[4096];
        long total = 0L;
        long progress = 0L;
        long hasReadCount = 0L;
        try {
            File tempFile;
            int count;
            long time;
            InputStream in = connected.getInputStream();
            if (in == null) {
                throw new ServerError("input stream is null", 111, statusCode);
            }
            this.initRandomAccessFile();
            int seekLocation = this.seekLocationAndReturn(connected);
            progress = seekLocation;
            long contentLength = connected.getContentLength();
            total = contentLength + (long)seekLocation;
            if (HttpLog.isDebug()) {
                HttpLog.d("Download content length %d", total);
            }
            long startTime = time = System.currentTimeMillis();
            long lastSleepTime = -1L;
            long curTime = -1L;
            long exceedSize = -1L;
            Thread curThread = Thread.currentThread();
            while ((count = in.read(buffer)) != -1) {
                long speedLimitValue = this.mSpeedLimitValuePerMicSecond;
                if (request.isCanceled()) {
                    if (HttpLog.isDebug()) {
                        HttpLog.d("MyDownloadContinueNetwork Download cancel. %s ", request.getUrl());
                    }
                    connected.cancel();
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                this.mRandomAccessFile.write(buffer, 0, count);
                progress += (long)count;
                hasReadCount += (long)count;
                if (this.mRequest != null) {
                    this.mRequest.onReceivedSizeUpdated(progress);
                }
                curTime = System.currentTimeMillis();
                if (progress == total || this.needProgress(count, total, request, progress) && curTime - time >= this.mProgressInterval) {
                    time = curTime;
                    ProgressInfo progressInfo = new ProgressInfo(progress, total);
                    request.postProgress(progressInfo);
                }
                if (curThread == null || speedLimitValue <= 0L || curTime - lastSleepTime <= 1000L || (exceedSize = hasReadCount - (curTime - startTime) * speedLimitValue) <= 0L) continue;
                lastSleepTime = curTime;
                try {
                    MLog.info((Object)"lllllllllllllll", (String)"sleep:%d hasReadCount :%d timeGap:%d", (Object[])new Object[]{exceedSize / speedLimitValue, hasReadCount, curTime - startTime});
                    this.mCurSleepThread = curThread;
                    Thread.sleep(exceedSize / speedLimitValue);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    this.mCurSleepThread = null;
                }
            }
            in.close();
            if (contentLength > 0L && progress < total) {
                throw new ServerError("Download progress less than contentLength " + progress + "/" + total, 60, statusCode);
            }
            if (HttpLog.isDebug()) {
                HttpLog.d("File download completed", new Object[0]);
            }
            boolean tempFileExisted = (tempFile = new File(this.mDownloadFileTempPath)).exists() && tempFile.isFile();
            long tempFileSize = tempFile.length();
            boolean renameResult = tempFile.renameTo(new File(this.mDownloadFilePath));
            if (!renameResult && this.mRequest != null) {
                this.mRequest.onRenameError(tempFileExisted, tempFileSize);
            }
            if (HttpLog.isDebug()) {
                HttpLog.d("File rename completed ", new Object[0]);
            }
            if (HttpLog.isDebug()) {
                HttpLog.d("File download completed url:%s, total size:%d, consume time:%d", request.getUrl(), hasReadCount, curTime - startTime);
            }
            byte[] byArray = this.mDownloadFilePath.getBytes();
            return byArray;
        }
        catch (IOException e) {
            HttpLog.e("Download file: " + e.toString(), new Object[0]);
            File downloadDir = new File(this.mDownloadFilePath).getParentFile();
            long internalTotalSpace = DownloadUtil.getTotalInternalSpace();
            long internalAvailabeSpace = DownloadUtil.getAvailableInternalSpace();
            long dirUsableSpace = downloadDir != null ? DownloadUtil.getUsableSpace(downloadDir) : 0L;
            String spaceMsg = "iTSpace:" + internalTotalSpace + " iASpace:" + internalAvailabeSpace + " dUSpace:" + dirUsableSpace;
            HttpLog.e("Download IOError: " + spaceMsg, new Object[0]);
            if ((dirUsableSpace < 5120L || dirUsableSpace * 1024L < total - progress) && this.mRequest != null) {
                this.mRequest.onIOExceptionWithNoSpace(spaceMsg);
            }
            throw e;
        }
        finally {
            if (this.mRandomAccessFile != null) {
                this.mRandomAccessFile.close();
            }
        }
    }

    @Override
    public byte[] entityToBytes(Request<?> request, NetworkConnection.Connected connected, int httpCode) throws IOException, ServerError {
        if (connected != null) {
            int statusCode = connected.getResponseCode();
            if (request != null && this.mRequest != null) {
                this.mRequest.onHttpResponsed(statusCode, request, connected);
            }
        }
        return this.entityToBytesInner(request, connected);
    }

    public int seekLocationAndReturn(NetworkConnection.Connected connected) throws IOException {
        int seekLocation = 0;
        if (connected.getResponseHeaderField(CONTENT_RANGE) != null) {
            String rangeValue = connected.getResponseHeaderField(CONTENT_RANGE);
            HttpLog.v("seekLocationAndReturn rangeValue = " + rangeValue, new Object[0]);
            String[] rangeValues = rangeValue.split(" ");
            if (rangeValues.length > 1 && rangeValues[1].contains("-")) {
                String bytesString = rangeValues[1].split("-")[0];
                try {
                    seekLocation = Integer.parseInt(bytesString);
                }
                catch (NumberFormatException e) {
                    HttpLog.e(e, "Range number parse error", new Object[0]);
                }
                HttpLog.v("SeekLocation = " + seekLocation, new Object[0]);
                if (seekLocation < 0) {
                    seekLocation = 0;
                }
                this.mRandomAccessFile.seek(seekLocation);
            }
        }
        return seekLocation;
    }
}

