/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter;

import android.os.Bundle;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.ContextManager;
import com.yy.mobile.backgroundprocess.services.IBackgroundProcessListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadCenter;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.IDownloadListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.model.DownloadModel;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequestManager;
import com.yy.mobile.http.ProgressInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DownloadCenter
implements IDownloadCenter {
    private DownloadRequestManager mRequestManager;
    private DownloadModel mModel;
    private IDownloadListener mDownloadListener;
    private IBackgroundProcessListener mProcessListener;

    public DownloadCenter(IBackgroundProcessListener callback, IDownloadListener listener) {
        DownloadRequestManager.IDownloadListener requestManagerCallBack = new DownloadRequestManager.IDownloadListener(){

            @Override
            public void onProgress(DownloadTask task, ProgressInfo info) {
                if (task == null) {
                    return;
                }
                boolean needNotifyClient = true;
                long lastProgressUpdateTime = -1L;
                Map<String, Object> localData = task.getProcessLocalInfo();
                if (localData.get("lastProgressUpdateTime") instanceof Long) {
                    lastProgressUpdateTime = (Long)localData.get("lastProgressUpdateTime");
                }
                long curTime = System.currentTimeMillis();
                if (lastProgressUpdateTime > 0L && Math.abs(curTime - lastProgressUpdateTime) < 200L) {
                    needNotifyClient = false;
                }
                long totalSize = info.getTotal();
                long curSize = info.getProgress();
                long oldCurSize = task.getLong("cursize");
                if (curSize < 0L) {
                    needNotifyClient = false;
                }
                if (needNotifyClient && totalSize <= 0L && Math.abs(curSize - oldCurSize) < 50000L) {
                    needNotifyClient = false;
                }
                DownloadCenter.this.mModel.updateTaskProgress(task, totalSize, curSize);
                if (needNotifyClient && DownloadCenter.this.mDownloadListener != null) {
                    DownloadCenter.this.mDownloadListener.onTaskProgressUpdated(task, oldCurSize);
                    localData.put("lastProgressUpdateTime", curTime);
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)DownloadCenter.this, (String)("task fileName:" + task.getString("filename") + " size:" + totalSize + "cursize:" + curSize), (Object[])new Object[0]);
                }
            }

            @Override
            public void onError(DownloadTask task, Exception error) {
                if (task == null) {
                    return;
                }
                int oldState = task.getInt("state", 1);
                DownloadCenter.this.mModel.updateTaskState(task, 4);
                if (error != null) {
                    task.putString("errorinfo", error.toString());
                }
                if (DownloadCenter.this.mDownloadListener != null) {
                    DownloadCenter.this.mDownloadListener.onTaskStateUpdated(task, oldState);
                }
                DownloadCenter.this.releaseCpuWakeLockIfNeed();
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)DownloadCenter.this, (String)("task fileName:" + task.getString("filename") + "task error:" + error.toString()), (Object[])new Object[0]);
                }
            }

            @Override
            public void onSuccess(DownloadTask task) {
                if (task == null) {
                    return;
                }
                int oldState = task.getInt("state", 1);
                DownloadCenter.this.mModel.updateTaskState(task, 5);
                if (DownloadCenter.this.mDownloadListener != null) {
                    DownloadCenter.this.mDownloadListener.onTaskStateUpdated(task, oldState);
                }
                DownloadCenter.this.releaseCpuWakeLockIfNeed();
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)DownloadCenter.this, (String)("task fileName:" + task.getString("filename") + "success!"), (Object[])new Object[0]);
                }
            }

            @Override
            public void onRetry(DownloadTask task, boolean clearSize) {
                if (task == null) {
                    return;
                }
                int curRetryTimes = task.getInt("crtimes", 0);
                if (!DownloadCenter.this.isLastNetError(task)) {
                    DownloadCenter.this.mModel.updateTaskRetryTimes(task, curRetryTimes + 1);
                }
                if (clearSize) {
                    this.onProgress(task, new ProgressInfo(0L, task.getLong("size")));
                }
                if (DownloadCenter.this.mDownloadListener != null) {
                    DownloadCenter.this.mDownloadListener.onTaskRetry(task);
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)DownloadCenter.this, (String)("task fileName:" + task.getString("filename") + "onretry curRetryTimes:" + (curRetryTimes + 1)), (Object[])new Object[0]);
                }
            }

            @Override
            public void onPaused(DownloadTask task) {
                if (task == null) {
                    return;
                }
                int oldState = task.getInt("state", 1);
                if (oldState != 1) {
                    DownloadCenter.this.mModel.updateTaskState(task, 1);
                    if (DownloadCenter.this.mDownloadListener != null) {
                        DownloadCenter.this.mDownloadListener.onTaskStateUpdated(task, oldState);
                    }
                }
            }

            @Override
            public void onStarted(DownloadTask task) {
                int oldState = task.getInt("state", 1);
                if (oldState != 3) {
                    DownloadCenter.this.mModel.updateTaskState(task, 3);
                    if (DownloadCenter.this.mDownloadListener != null) {
                        DownloadCenter.this.mDownloadListener.onTaskStateUpdated(task, oldState);
                    }
                }
                if (DownloadCenter.this.mProcessListener != null) {
                    DownloadCenter.this.mProcessListener.acquireCpuWakeLock();
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)DownloadCenter.this, (String)("task fileName:" + task.getString("filename") + "onStarted!"), (Object[])new Object[0]);
                }
            }
        };
        this.mRequestManager = new DownloadRequestManager(requestManagerCallBack);
        this.mModel = new DownloadModel(ContextManager.getApplicationContext());
        this.mDownloadListener = listener;
        this.mProcessListener = callback;
    }

    private boolean isLastNetError(DownloadTask task) {
        ArrayList errorInfoList = null;
        Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
        if (tempErrorInfoObject instanceof ArrayList) {
            errorInfoList = (ArrayList)tempErrorInfoObject;
        }
        if (errorInfoList == null || errorInfoList.size() < 1) {
            return false;
        }
        HashMap lastErrorInfo = (HashMap)errorInfoList.get(errorInfoList.size() - 1);
        if (lastErrorInfo != null) {
            boolean netError = false;
            if (lastErrorInfo.containsKey("netc") && !StringUtils.equal((String)"1", (String)((String)lastErrorInfo.get("netc")))) {
                netError = true;
            }
            return netError;
        }
        return false;
    }

    private void releaseCpuWakeLockIfNeed() {
        if (!this.mRequestManager.isTaskDownloading() && this.mProcessListener != null) {
            this.mProcessListener.releaseCpuWakeLock();
        }
    }

    private static boolean isTaskDataValid(DownloadTask task) {
        if (task == null) {
            return false;
        }
        int taskType = task.getInt("type");
        if (taskType == -1) {
            return false;
        }
        int taskGroup = task.getInt("dgroup");
        if (taskGroup == -1) {
            return false;
        }
        String url = task.getString("url");
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        String fileName = task.getString("filename");
        if (StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        if (!FileUtils.isFileNameCorrect((String)fileName)) {
            return false;
        }
        String filePath = task.getString("path");
        return !StringUtils.isEmpty((String)filePath);
    }

    @Override
    public int createTask(DownloadTask task) {
        String fileName;
        if (!DownloadCenter.isTaskDataValid(task)) {
            return -1;
        }
        DownloadTask existedTask = null;
        existedTask = this.mModel.findTask(task.getString("url"));
        if (existedTask != null) {
            if (StringUtils.equal((String)task.getString("path"), (String)existedTask.getString("path"))) {
                if (StringUtils.equal((String)task.getString("filename"), (String)existedTask.getString("filename"))) {
                    return -2;
                }
                return -3;
            }
            return -3;
        }
        String filePath = task.getString("path");
        existedTask = this.mModel.findTask(filePath, fileName = task.getString("filename"));
        if (existedTask != null) {
            return -4;
        }
        File dir = new File(filePath);
        File downFile = new File(dir, fileName);
        if (downFile.exists()) {
            return -5;
        }
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            return -6;
        }
        task.putLong("ctime", System.currentTimeMillis());
        this.mModel.addTask(task);
        this.mRequestManager.submitTask(task);
        this.mModel.updateTaskState(task, 1);
        if (this.mDownloadListener != null) {
            this.mDownloadListener.onTaskCreated(task);
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)this, (String)("task fileName:" + task.getString("filename") + "oncreated!"), (Object[])new Object[0]);
        }
        return 0;
    }

    @Override
    public void startTask(DownloadTask task) {
        int oldState;
        if (task == null) {
            return;
        }
        DownloadTask existedTask = null;
        existedTask = this.mModel.findTask(task.getString("url"));
        if (existedTask == null) {
            return;
        }
        int newState = oldState = existedTask.getInt("state", 1);
        if (oldState != 3) {
            if (oldState == 2 || oldState == 1 || oldState == 4) {
                if (!this.mRequestManager.containTask(existedTask)) {
                    this.mRequestManager.submitTask(existedTask);
                }
                newState = 1;
                this.mModel.updateTaskState(existedTask, newState);
            } else if (oldState == 5) {
                // empty if block
            }
        } else if (!this.mRequestManager.containTask(existedTask)) {
            this.mRequestManager.submitTask(existedTask);
            newState = 1;
            this.mModel.updateTaskState(existedTask, newState);
        }
        if (newState != oldState && this.mDownloadListener != null) {
            this.mDownloadListener.onTaskStateUpdated(task, oldState);
        }
    }

    @Override
    public void deleteTask(DownloadTask task, boolean deleteFile) {
        if (task == null) {
            return;
        }
        DownloadTask existedTask = null;
        existedTask = this.mModel.findTask(task.getString("url"));
        if (existedTask != null) {
            if (deleteFile) {
                FileUtils.deleteFile((File)new File(task.getString("path"), task.getString("filename")));
            }
            this.mModel.deleteTask(existedTask);
            this.mRequestManager.deleteTask(existedTask);
            if (this.mDownloadListener != null) {
                this.mDownloadListener.onTaskDeleted(task);
            }
        }
    }

    @Override
    public void pauseTask(DownloadTask task) {
        if (task == null) {
            return;
        }
        DownloadTask existedTask = null;
        existedTask = this.mModel.findTask(task.getString("url"));
        if (existedTask == null) {
            return;
        }
        int oldState = existedTask.getInt("state", 1);
        if (oldState == 2) {
            this.mRequestManager.deleteTask(existedTask);
            return;
        }
        if (oldState == 3 || oldState == 1) {
            this.mModel.updateTaskState(existedTask, 2);
            this.mRequestManager.deleteTask(existedTask);
        }
        if (oldState != task.getInt("state", 1) && this.mDownloadListener != null) {
            this.mDownloadListener.onTaskStateUpdated(task, oldState);
        }
    }

    @Override
    public void restoreAllTasks() {
        ArrayList<DownloadTask> tasks = this.mModel.getAllTasks();
        if (tasks != null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)this, (String)("restoreAllTasks:" + tasks.size()), (Object[])new Object[0]);
            }
            for (DownloadTask task : tasks) {
                if (task.getInt("state") == 5) continue;
                this.startTask(task);
                if (MLog.isLogLevelAboveDebug()) continue;
                MLog.debug((Object)this, (String)this.getTaskString(task), (Object[])new Object[0]);
            }
        }
    }

    private String getTaskString(DownloadTask task) {
        Bundle bundle = task.getBundle();
        StringBuilder builder = new StringBuilder();
        boolean firstKey = true;
        String value = null;
        Set keys = bundle.keySet();
        for (String key : keys) {
            if (bundle.get(key) == null || StringUtils.isEmpty((String)(value = bundle.get(key).toString()))) continue;
            if (firstKey) {
                firstKey = false;
            } else {
                builder.append(" ");
            }
            builder.append(key);
            builder.append(" ");
            builder.append(value);
        }
        return builder.toString();
    }

    public void onNetConnectChanged() {
        this.mRequestManager.onNetConnectChanged();
    }
}

