/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.base;

import android.os.Bundle;
import android.os.Parcelable;
import com.yy.base.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DownloadTask {
    private static final String EXTERNAL_MAP_SPERATOR = "<==>";
    private static final String EXTERNAL_MAP_KEY_VALUE_SPERATOR = "==>>";
    private Bundle mBundle = null;
    private Bundle mExtendBudle = null;
    private Map<String, Object> mProcessLocalInfo;

    private DownloadTask() {
        this.mBundle = new Bundle();
    }

    private DownloadTask(Bundle bundle) {
        this.mBundle = bundle;
        if (bundle != null && this.mExtendBudle == null) {
            this.mExtendBudle = (Bundle)bundle.getParcelable("extmap");
        }
    }

    public static DownloadTask newDownloadTask(Bundle bundle) {
        if (null == bundle) {
            return null;
        }
        return new DownloadTask(bundle);
    }

    public static DownloadTask newDownloadTask(String taskUrl, String taskPath, String fileName) {
        if (StringUtils.isEmpty((String)taskUrl) || StringUtils.isEmpty((String)taskPath) || StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        return DownloadTask.newDownloadTask(taskUrl, taskPath, fileName, 2, 1, null);
    }

    public static DownloadTask newDownloadTask(String taskUrl, String taskPath, String fileName, int taskType, int taskGroup) {
        if (StringUtils.isEmpty((String)taskUrl) || StringUtils.isEmpty((String)taskPath) || StringUtils.isEmpty((String)fileName) || taskType < 0 || taskGroup < 0) {
            return null;
        }
        return DownloadTask.newDownloadTask(taskUrl, taskPath, fileName, taskType, taskGroup, null);
    }

    public static DownloadTask newDownloadTask(String taskUrl, String taskPath, String fileName, int taskType, int taskGroup, String taskLabel) {
        if (StringUtils.isEmpty((String)taskUrl) || StringUtils.isEmpty((String)taskPath) || StringUtils.isEmpty((String)fileName) || taskType < 0 || taskGroup < 0) {
            return null;
        }
        DownloadTask task = new DownloadTask();
        task.putInt("type", taskType);
        task.putInt("dgroup", taskGroup);
        if (!StringUtils.isEmpty((String)taskLabel)) {
            task.putString("label", taskLabel);
        }
        task.putString("url", taskUrl);
        task.putString("path", taskPath);
        task.putString("filename", fileName);
        task.putInt("state", 1);
        return task;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public void putExtendString(String key, String value) {
        this.getExtendBudle().putString(key, value);
    }

    public void putExtendBoolean(String key, boolean value) {
        this.getExtendBudle().putBoolean(key, value);
    }

    public String getExtendString(String key) {
        return this.getExtendBudle().getString(key, "");
    }

    public boolean getExtendBoolean(String key) {
        return this.getExtendBudle().getBoolean(key, false);
    }

    private Bundle getExtendBudle() {
        if (this.mExtendBudle == null) {
            this.mExtendBudle = new Bundle();
            this.mBundle.putParcelable("extmap", (Parcelable)this.mExtendBudle);
        }
        return this.mExtendBudle;
    }

    public String getExtendMapString() {
        if (this.mExtendBudle == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean firstKey = true;
        Set keys = this.mExtendBudle.keySet();
        String value = null;
        for (String key : keys) {
            value = this.mExtendBudle.getString(key);
            if (StringUtils.isEmpty((String)value)) continue;
            if (firstKey) {
                firstKey = false;
            } else {
                builder.append(EXTERNAL_MAP_SPERATOR);
            }
            builder.append(key);
            builder.append(EXTERNAL_MAP_KEY_VALUE_SPERATOR);
            builder.append(value);
        }
        return builder.toString();
    }

    public void parseExternalMap(String externalMapStr) {
        String[] externalKeyValues;
        if (StringUtils.isEmpty((String)externalMapStr)) {
            return;
        }
        Bundle extendBudle = this.getExtendBudle();
        String[] strArray = null;
        for (String keyValue : externalKeyValues = externalMapStr.split(EXTERNAL_MAP_SPERATOR)) {
            strArray = keyValue.split(EXTERNAL_MAP_KEY_VALUE_SPERATOR);
            if (strArray.length != 2) continue;
            extendBudle.putString(strArray[0], strArray[1]);
        }
    }

    public int getInt(String key) {
        return this.mBundle.getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        return this.mBundle.getInt(key, defaultValue);
    }

    public long getLong(String key) {
        return this.mBundle.getLong(key, -1L);
    }

    public String getString(String key) {
        return this.mBundle.getString(key, "");
    }

    public void putInt(String key, int value) {
        this.mBundle.putInt(key, value);
    }

    public void putLong(String key, long value) {
        this.mBundle.putLong(key, value);
    }

    public void putString(String key, String value) {
        this.mBundle.putString(key, value);
    }

    public Map<String, Object> getProcessLocalInfo() {
        if (this.mProcessLocalInfo == null) {
            this.mProcessLocalInfo = new HashMap<String, Object>();
        }
        return this.mProcessLocalInfo;
    }

    public String toString() {
        return this.mBundle.toString();
    }
}

