/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.base.logger.MLog;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RetryPolicy;
import com.yy.mobile.http.httpsparser.HttpsParser;

public class DefaultRetryPolicy
implements RetryPolicy {
    private static final String TAG = "DefaultRetryPolicy";
    private int mCurrentTimeoutMs;
    private int mCurrentRetryCount;
    private final int mMaxNumRetries;
    private final float mBackoffMultiplier;
    public static final int DEFAULT_TIMEOUT_MS = 2500;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final float DEFAULT_BACKOFF_MULT = 1.0f;

    public DefaultRetryPolicy() {
        this(2500, 1, 1.0f);
    }

    public DefaultRetryPolicy(int initialTimeoutMs, int maxNumRetries, float backoffMultiplier) {
        this.mCurrentTimeoutMs = initialTimeoutMs;
        this.mMaxNumRetries = maxNumRetries;
        this.mBackoffMultiplier = backoffMultiplier;
    }

    @Override
    public int getCurrentTimeout() {
        return this.mCurrentTimeoutMs;
    }

    @Override
    public int getCurrentRetryCount() {
        return this.mCurrentRetryCount;
    }

    @Override
    public void retry(Request request, RequestError error) throws RequestError {
        ++this.mCurrentRetryCount;
        this.mCurrentTimeoutMs = (int)((float)this.mCurrentTimeoutMs + (float)this.mCurrentTimeoutMs * this.mBackoffMultiplier);
        MLog.info((Object)TAG, (String)"currentRetryCount:%d, MaxNumRetries:%d", (Object[])new Object[]{this.mCurrentRetryCount, this.mMaxNumRetries});
        if (!this.hasAttemptRemaining()) {
            throw error;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"retry, old url: %s", (Object[])new Object[]{request.getUrl()});
        }
        request.setUrl(HttpsParser.convertToHttp(request.getUrl()));
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"retry, new url: %s", (Object[])new Object[]{request.getUrl()});
        }
    }

    protected boolean hasAttemptRemaining() {
        return this.mCurrentRetryCount <= this.mMaxNumRetries;
    }
}

