/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.mobile.backgroundprocess.MessageDef;
import com.yy.mobile.backgroundprocess.RemoteProcess;
import com.yy.mobile.backgroundprocess.Util.sharedpref.BackgroundProcessPref;
import com.yy.mobile.backgroundprocess.processprotecter.ForegroundAssistServiceBg;
import com.yy.mobile.backgroundprocess.processprotecter.ServiceForegroundHelper;
import com.yy.mobile.backgroundprocess.services.AbstractBackgroundService;
import com.yy.mobile.backgroundprocess.services.IBackgroundProcessListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.DownloadService;
import com.yy.mobile.backgroundprocess.services.pushcenter.service.PushService;
import java.util.ArrayList;

public class RemoteBackgroundProcess
extends Service
implements IBackgroundProcessListener {
    private static final String TAG = "bgprocess:RemoteBackgroundProcess";
    private static boolean sIsProcessFirstCreate = true;
    private final ArrayList<AbstractBackgroundService> mBusinessServices = new ArrayList();
    private final Messenger mMessenger = new Messenger((Handler)new IncomingHandler());
    private ServiceForegroundHelper mForegroundHelper = null;
    private boolean mNeedSetServiceForeground = true;
    private int mStartType = 0;
    private PowerManager.WakeLock mCpuWakeLock = null;
    private int mWakeLockCount = 0;
    private Runnable mKillProcessRunnable;

    private AbstractBackgroundService getServiceById(int serviceId) {
        for (AbstractBackgroundService service : this.mBusinessServices) {
            if (service == null || service.getServiceId() != serviceId) continue;
            return service;
        }
        return null;
    }

    private void updateBaseInfo(Bundle data) {
        if (data != null) {
            if (data.get("uid") instanceof Long) {
                this.setUid(data.getLong("uid"));
            }
            if (data.get("devver") instanceof Boolean) {
                this.setDevVerFlag(data.getBoolean("devver"));
            }
            if (data.get("cdswitch") instanceof Boolean) {
                this.setDownloadCollectDataSwitch(data.getBoolean("cdswitch"));
            }
        }
    }

    private void dispatchMessage(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.arg1 == 0 && msg.what == MessageDef.ClientSendMessage.TRANSMIT_BASE_INFO) {
            this.updateBaseInfo(msg.getData());
            return;
        }
        AbstractBackgroundService service = this.getServiceById(msg.arg1);
        if (service != null) {
            service.handleMessage(msg);
        }
    }

    private void dispatchBroadcastEvent(Intent intent) {
        for (AbstractBackgroundService service : this.mBusinessServices) {
            if (service == null) continue;
            service.handleBroadcastEvent(intent);
        }
    }

    private void initServices() {
        if (this.mBusinessServices.size() == 0) {
            this.mCpuWakeLock = SystemServiceUtils.getPowerManager((Context)this).newWakeLock(1, this.getClass().getCanonicalName());
            this.mBusinessServices.add(new DownloadService(1, this));
            this.mBusinessServices.add(new PushService(2, this));
        }
    }

    private void setServiceForeground(boolean forground) {
        if (forground) {
            if (null == this.mForegroundHelper) {
                this.mForegroundHelper = new ServiceForegroundHelper(this);
            }
            this.mForegroundHelper.startForeground(ForegroundAssistServiceBg.class);
        } else if (this.mForegroundHelper != null) {
            this.mForegroundHelper.stopForeground();
        }
    }

    @Override
    public long getUid() {
        return BackgroundProcessPref.instance().getLong("uid", -1L);
    }

    @Override
    public boolean isDownloadCollectDataSwitchOn() {
        return BackgroundProcessPref.instance().getBoolean("dc_switch", false);
    }

    @Override
    public Context getContext() {
        return this;
    }

    private void setUid(long uid) {
        if (this.getUid() != uid) {
            BackgroundProcessPref.instance().putLong("uid", uid);
        }
    }

    private boolean isDevVer() {
        return RuntimeContext.sIsDebuggable || BackgroundProcessPref.instance().getBoolean("devVer", false);
    }

    private void setDevVerFlag(boolean isDev) {
        if (this.isDevVer() != isDev) {
            BackgroundProcessPref.instance().putBoolean("devVer", isDev);
        }
    }

    private void setDownloadCollectDataSwitch(boolean switchOn) {
        if (BackgroundProcessPref.instance().getBoolean("dc_switch", false) != switchOn) {
            BackgroundProcessPref.instance().putBoolean("dc_switch", switchOn);
        }
    }

    public void onCreate() {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"service onCreate.", (Object[])new Object[0]);
        }
        if (sIsProcessFirstCreate) {
            sIsProcessFirstCreate = false;
        }
        RemoteProcess.initBaseEnv(this.getApplicationContext());
        this.initServices();
        if (this.mNeedSetServiceForeground) {
            this.setServiceForeground(true);
            this.mNeedSetServiceForeground = false;
        }
        if (this.mKillProcessRunnable != null) {
            YYTaskExecutor.removeTask((Runnable)this.mKillProcessRunnable);
        }
        ServiceForegroundHelper.clearForegroundStatus(this);
    }

    public void onDestroy() {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"service onDestroy.", (Object[])new Object[0]);
        }
        this.mNeedSetServiceForeground = true;
        for (AbstractBackgroundService service : this.mBusinessServices) {
            if (service == null) continue;
            service.onDestroy();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Message message;
        int intentType = 2;
        int broadcastType = -1;
        if (null != intent && null != intent.getExtras() && (intentType = intent.getIntExtra("startType", 2)) == 1) {
            broadcastType = intent.getIntExtra("broadcast_type", 0);
        }
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("onStartCommand intentType:" + intentType + " broadcastType:" + broadcastType + " mStartType =" + this.mStartType), (Object[])new Object[0]);
        }
        if (this.mStartType == 0) {
            this.mStartType = intentType;
        } else if (intentType == 1) {
            this.dispatchBroadcastEvent(intent);
        }
        if (null != intent && null != intent.getExtras() && intent.getExtras().containsKey("startMessege") && (message = (Message)intent.getExtras().getParcelable("startMessege")) != null) {
            this.dispatchMessage(message);
        }
        if (this.mNeedSetServiceForeground) {
            this.setServiceForeground(true);
            this.mNeedSetServiceForeground = false;
        }
        super.onStartCommand(intent, flags, startId);
        return 1;
    }

    public boolean onUnbind(Intent intent) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("service onUnBind:" + intent.toString()), (Object[])new Object[0]);
        }
        return super.onUnbind(intent);
    }

    public IBinder onBind(Intent intent) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("service bind:" + intent.toString()), (Object[])new Object[0]);
        }
        return this.mMessenger.getBinder();
    }

    @Override
    public void acquireCpuWakeLock() {
        ++this.mWakeLockCount;
        try {
            if (this.mWakeLockCount == 1) {
                this.mCpuWakeLock.acquire();
                this.setServiceForeground(true);
            }
        }
        catch (Throwable e) {
            Log.e((String)"RemoteBackgroundProcess", (String)(" error ignore: " + e.getMessage()));
        }
    }

    @Override
    public void releaseCpuWakeLock() {
        --this.mWakeLockCount;
        try {
            if (this.mWakeLockCount == 0) {
                this.mCpuWakeLock.release();
                this.setServiceForeground(false);
            }
        }
        catch (Throwable e) {
            Log.e((String)"RemoteBackgroundProcess", (String)(" error ignore: " + e.getMessage()));
        }
    }

    private class IncomingHandler
    extends Handler {
        IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg != null) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)RemoteBackgroundProcess.TAG, (String)("handleMessage:" + msg.toString()), (Object[])new Object[0]);
                }
                RemoteBackgroundProcess.this.dispatchMessage(msg);
            }
        }
    }
}

