/*
 * Decompiled with CFR 0.152.
 */
package downloader;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.http.RequestManager;
import downloader.Downloader;
import downloader.IDownloadCallback;
import downloader.client.IBasicParamsProvider;
import downloader.client.IDownloadClientCallBack;
import downloader.client.LocalDownloadClient;
import downloader.client.RemoteDownloadClient;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DownloadClient {
    private static final String TAG = "DownloadClient";
    private static volatile DownloadClient sInstance;
    private RemoteDownloadClient mRemoteClient;
    private LocalDownloadClient mLocalClient;
    private List<Downloader> mDownloaders = new ArrayList<Downloader>();
    private IDownloadClientCallBack mClientCallBack;
    private static volatile IBasicParamsProvider sBasicParamsProvider;
    private boolean mUseRemote = false;
    private final IQueueTaskExecutor mQueueTask = YYTaskExecutor.createAQueueExcuter();

    private DownloadClient() {
        RequestManager.instance().init(RuntimeContext.sApplicationContext, "yyhigo" + File.separator + "mainprocess/http");
        this.createClientsCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadClient instance() {
        if (sInstance != null) return sInstance;
        Class<DownloadClient> clazz = DownloadClient.class;
        synchronized (DownloadClient.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DownloadClient();
            if (!RuntimeContext.sIsDebuggable || RuntimeContext.sIsAppStartFinished) return sInstance;
            MLog.error((Object)TAG, (Throwable)new RuntimeException("downloadclient inited before startup finish!"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void setBasicParamsProvider(IBasicParamsProvider basicParamsProvider) {
        sBasicParamsProvider = basicParamsProvider;
    }

    private RemoteDownloadClient getRemoteClient() {
        if (this.mRemoteClient == null) {
            this.mRemoteClient = new RemoteDownloadClient(this.mClientCallBack);
        }
        return this.mRemoteClient;
    }

    private LocalDownloadClient getLocalClient() {
        if (this.mLocalClient == null) {
            this.mLocalClient = new LocalDownloadClient();
            this.mLocalClient.setClientCallBack(this.mClientCallBack);
        }
        return this.mLocalClient;
    }

    private void createClientsCallback() {
        this.mClientCallBack = new IDownloadClientCallBack(){

            @Override
            public void onSubmitTaskErrored(DownloadTask task) {
                if (task == null) {
                    return;
                }
                Downloader item = DownloadClient.this.findItem(task.getString("url"));
                if (item != null) {
                    DownloadClient.this.getLocalClient().submitTask(item.getTask());
                }
            }

            @Override
            public void onComplete(DownloadTask task) {
                if (task == null) {
                    return;
                }
                Downloader item = DownloadClient.this.findItem(task.getString("url"));
                if (item != null) {
                    DownloadClient.this.notifyItemComplete(item);
                }
            }

            @Override
            public void onError(DownloadTask task, int errorType, String errorInfo) {
                if (task == null) {
                    return;
                }
                Downloader item = DownloadClient.this.findItem(task.getString("url"));
                if (item != null) {
                    DownloadClient.this.notifyItemError(item, errorType, errorInfo);
                }
            }

            @Override
            public void onProgressChange(DownloadTask task, long totalSize, long curSize) {
                if (task == null) {
                    return;
                }
                Downloader item = DownloadClient.this.findItem(task.getString("url"));
                if (item != null) {
                    DownloadClient.this.notifyItemProgressChange(item, totalSize, curSize);
                }
            }

            @Override
            public void onStart(DownloadTask task) {
                if (task == null) {
                    return;
                }
                Downloader item = DownloadClient.this.findItem(task.getString("url"));
                if (item != null) {
                    DownloadClient.this.notifyItemStart(item);
                }
            }

            @Override
            public void onCreate(DownloadTask task) {
                Downloader item = DownloadClient.this.findItem(task.getString("url"));
                if (item != null) {
                    DownloadClient.this.notifyItemCreate(item);
                }
            }

            @Override
            public IBasicParamsProvider getBasicParamsProvider() {
                return sBasicParamsProvider;
            }
        };
    }

    void submitTask(final Downloader downloader) {
        if (downloader == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"downloader: %s", (Object[])new Object[]{downloader.getUrl()});
        }
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add((String)("Downloader_" + downloader.getUrl()), (Object[])new Object[0]);
        }
        final String dirPath = downloader.getFileParentPath();
        this.mQueueTask.execute(new Runnable(){

            @Override
            public void run() {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)DownloadClient.TAG, (String)"downloader run %s ", (Object[])new Object[]{dirPath});
                }
                DownloadClient.this.ensureDownloadPath(dirPath);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List list = DownloadClient.this.mDownloaders;
                        synchronized (list) {
                            if (DownloadClient.this.mDownloaders.contains(downloader)) {
                                if (downloader.getCallback() != null) {
                                    String reason = StringUtils.format((String)"the same download task[%s] had been added to queue, do not need to submit task again, and this task will force to end", (Object[])new Object[]{downloader});
                                    downloader.getCallback().onError(downloader, 3, reason);
                                }
                                return;
                            }
                            Downloader oldDownloader = DownloadClient.this.findItem(downloader.getUrl());
                            if (oldDownloader != null && StringUtils.equal((String)oldDownloader.getFilePath(), (String)downloader.getFilePath())) {
                                if (downloader.getCallback() != null) {
                                    String reason = StringUtils.format((String)"the download task with the same url[%s] and file path[%s] had been added to queue, do not need to submit task again, and this task will force to end", (Object[])new Object[]{downloader.getUrl(), downloader.getFilePath()});
                                    downloader.getCallback().onError(downloader, 3, reason);
                                }
                                if (downloader.getPriority() > oldDownloader.getPriority()) {
                                    DownloadClient.this.getLocalClient().updateTask(oldDownloader.getTask(), downloader.getTask());
                                    DownloadClient.this.mDownloaders.remove(oldDownloader);
                                    DownloadClient.this.mDownloaders.add(downloader);
                                }
                                return;
                            }
                            DownloadClient.this.mDownloaders.add(downloader);
                        }
                        if (RuntimeContext.sIsDebuggable) {
                            MLog.info((Object)DownloadClient.TAG, (String)"downloader run submit %s ", (Object[])new Object[]{dirPath});
                        }
                        if (DownloadClient.this.mUseRemote) {
                            DownloadClient.this.getRemoteClient().submitTask(downloader.getTask());
                        } else {
                            DownloadClient.this.getLocalClient().submitTask(downloader.getTask());
                        }
                    }
                }, (long)0L);
            }
        }, 0L);
    }

    public void removeTask(final Downloader downloader) {
        if (downloader == null) {
            return;
        }
        this.executeInMain(new Runnable(){

            @Override
            public void run() {
                DownloadClient.this.deleteTask(downloader.getUrl());
            }
        });
    }

    private void executeInMain(Runnable command) {
        if (command != null) {
            if (YYTaskExecutor.isMainThread()) {
                command.run();
            } else {
                YYTaskExecutor.postToMainThread((Runnable)command);
            }
        }
    }

    public void removeTask(final String url) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadClient.this.deleteTask(url);
            }
        });
    }

    public void removeAllByGroup(final int group) {
        if (group <= 0) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = DownloadClient.this.mDownloaders;
                synchronized (list) {
                    if (DownloadClient.this.mDownloaders.size() <= 0) {
                        return;
                    }
                }
                Object item = null;
                ArrayList<Downloader> downloaders = new ArrayList<Downloader>(1);
                DownloadTask task = null;
                List list2 = DownloadClient.this.mDownloaders;
                synchronized (list2) {
                    for (Downloader downloader : DownloadClient.this.mDownloaders) {
                        task = downloader.getTask();
                        if (task == null || task.getInt("dgroup") != group) continue;
                        downloaders.add(downloader);
                    }
                }
                for (Downloader tempItem : downloaders) {
                    DownloadClient.this.deleteTask(tempItem);
                }
            }
        });
    }

    public void updateUid(final long uid) {
        if (this.mRemoteClient == null) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DownloadClient.this.mRemoteClient != null) {
                    DownloadClient.this.mRemoteClient.updateUid(uid);
                }
            }
        });
    }

    public void updateCollectDataSwitch(final boolean switchOn) {
        if (this.mRemoteClient == null) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DownloadClient.this.mRemoteClient != null) {
                    DownloadClient.this.mRemoteClient.updateCollectDataSwitch(switchOn);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Downloader findItem(String url) {
        Downloader item = null;
        List<Downloader> list = this.mDownloaders;
        synchronized (list) {
            for (Downloader downloader : this.mDownloaders) {
                if (!StringUtils.equal((String)downloader.getUrl(), (String)url)) continue;
                item = downloader;
                break;
            }
        }
        return item;
    }

    private void deleteTask(String url) {
        this.mQueueTask.execute(() -> {
            final Downloader item = this.findItem(url);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    DownloadClient.this.deleteTask(item);
                }
            });
        }, 0L);
    }

    private void deleteTask(Downloader downloader) {
        if (downloader != null) {
            if (this.mLocalClient != null) {
                this.mLocalClient.deleteTask(downloader.getTask());
            }
            this.deleteItem(downloader);
            if (this.mUseRemote) {
                this.getRemoteClient().deleteTask(downloader.getUrl(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteItem(Downloader downloader) {
        if (downloader == null) {
            return;
        }
        List<Downloader> list = this.mDownloaders;
        synchronized (list) {
            this.mDownloaders.remove(downloader);
        }
    }

    private void notifyItemComplete(Downloader downloader) {
        if (downloader != null) {
            IDownloadCallback callback = downloader.getCallback();
            if (callback != null) {
                callback.onComplete(downloader);
            }
            this.deleteItem(downloader);
        }
    }

    private void notifyItemError(Downloader downloader, int errorType, String errorInfo) {
        if (downloader != null) {
            IDownloadCallback callback = downloader.getCallback();
            if (callback != null) {
                callback.onError(downloader, errorType, errorInfo);
            }
            this.deleteItem(downloader);
        }
    }

    private void notifyItemProgressChange(Downloader downloader, long totalSize, long curSize) {
        IDownloadCallback callback;
        if (downloader != null && (callback = downloader.getCallback()) != null) {
            callback.onProgressChange(downloader, totalSize, curSize);
        }
    }

    private void notifyItemStart(Downloader downloader) {
        IDownloadCallback callback;
        if (downloader != null && (callback = downloader.getCallback()) != null) {
            callback.onStart(downloader);
        }
    }

    private void notifyItemCreate(Downloader downloader) {
        IDownloadCallback callback;
        if (downloader != null && (callback = downloader.getCallback()) != null) {
            callback.onCreate(downloader);
        }
    }

    private boolean ensureDownloadPath(String downloadDirPath) {
        if (StringUtils.isEmpty((String)downloadDirPath)) {
            return false;
        }
        File downloadDir = new File(downloadDirPath);
        if (!downloadDir.exists() || !downloadDir.isDirectory()) {
            boolean result = downloadDir.mkdirs();
            if (!result) {
                MLog.error((Object)TAG, (String)("ensureDownloadPath error:" + downloadDirPath), (Object[])new Object[0]);
            }
            return downloadDir.exists() && downloadDir.isDirectory();
        }
        return true;
    }
}

