/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import com.yy.base.logger.MLog;
import com.yy.mobile.backgroundprocess.MessageDef;
import com.yy.mobile.backgroundprocess.services.BgProcessBinder;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class AbstractMessageDispater
implements BgProcessBinder.IServiceBinderListener {
    private static BgProcessBinder sBgProcessBinder;
    private final LinkedList<Message> mWaitingMsgList = new LinkedList();
    private final Handler mHandler = new ServerMessengerHandler();
    private final Messenger mClientMessenger = new Messenger(this.mHandler);
    private int mServiceId;
    private int mRemoteServiceRetryCount = 2;

    public AbstractMessageDispater(Context context, int serviceId) {
        this.mServiceId = serviceId;
        if (sBgProcessBinder == null) {
            sBgProcessBinder = new BgProcessBinder(context);
        }
        if (!sBgProcessBinder.isConnected() && !sBgProcessBinder.isConnecting()) {
            sBgProcessBinder.startRemoteProcessService();
        }
        sBgProcessBinder.addBinderListener(this);
    }

    public void sendMessage(Message msg) {
        if (msg == null) {
            return;
        }
        this.mWaitingMsgList.addLast(msg);
        this.handleMessageQueue();
    }

    private void sendInitMessage(Message msg) {
        sBgProcessBinder.sendMessage(msg);
    }

    private void handleMessageQueue() {
        if (sBgProcessBinder.isConnected()) {
            while (!this.mWaitingMsgList.isEmpty() && sBgProcessBinder.isConnected()) {
                Message msg = this.mWaitingMsgList.remove();
                boolean result = sBgProcessBinder.sendMessage(msg);
                if (result) continue;
                this.mWaitingMsgList.addFirst(msg);
            }
        } else if (sBgProcessBinder.isDisconnected()) {
            sBgProcessBinder.startRemoteProcessService();
        }
    }

    private void notifySendMsgError() {
        if (this.mWaitingMsgList.isEmpty()) {
            return;
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.addAll(this.mWaitingMsgList);
        this.mWaitingMsgList.clear();
        this.onMsgsSendErrored(messages);
    }

    @Override
    public void onServiceConnectioned() {
        Message msg = this.createBaseMessage();
        msg.what = MessageDef.ClientSendMessage.REGISTER;
        msg.replyTo = this.mClientMessenger;
        this.sendInitMessage(msg);
        this.handleMessageQueue();
    }

    @Override
    public void onServiceDisconnected() {
        this.notifySendMsgError();
    }

    public void cleanUpOnExit() {
        sBgProcessBinder.removeBinderListener(this);
        if (sBgProcessBinder.isConnected()) {
            Message msg = this.createBaseMessage();
            msg.what = MessageDef.ClientSendMessage.UNREGISTER;
            msg.replyTo = this.mClientMessenger;
            sBgProcessBinder.sendMessage(msg);
        }
    }

    private Message createBaseMessage() {
        Message message = Message.obtain();
        message.arg1 = this.mServiceId;
        return message;
    }

    protected abstract void handleCallBackMessage(Message var1);

    protected abstract void onMsgsSendErrored(ArrayList<Message> var1);

    private class ServerMessengerHandler
    extends Handler {
        ServerMessengerHandler() {
        }

        public void handleMessage(Message msg) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"bgprocess:AbstractMessageDispater", (String)("handleMessage:" + msg.toString()), (Object[])new Object[0]);
            }
            AbstractMessageDispater.this.handleCallBackMessage(msg);
        }
    }
}

