/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services;

import android.content.Intent;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.yy.base.logger.MLog;
import com.yy.mobile.backgroundprocess.MessageDef;
import com.yy.mobile.backgroundprocess.services.IBackgroundProcessListener;
import java.util.ArrayList;

public abstract class AbstractBackgroundService {
    private static final String TAG = "bgprocess:AbstractBackgroundService";
    private final int mServiceId;
    private final ArrayList<Messenger> mClientMessengers = new ArrayList();
    protected IBackgroundProcessListener mProcessListener;

    public AbstractBackgroundService(int serviceId, IBackgroundProcessListener callback) {
        this.mServiceId = serviceId;
        this.mProcessListener = callback;
    }

    public void handleMessage(Message message) {
        if (message == null) {
            return;
        }
        int msgType = message.what;
        if (msgType == MessageDef.ClientSendMessage.REGISTER) {
            if (message.replyTo != null && !this.mClientMessengers.contains(message.replyTo)) {
                this.mClientMessengers.add(message.replyTo);
            }
        } else if (msgType == MessageDef.ClientSendMessage.UNREGISTER && message.replyTo != null && this.mClientMessengers.contains(message.replyTo)) {
            this.mClientMessengers.remove(message.replyTo);
        }
    }

    public void handleBroadcastEvent(Intent intent) {
    }

    public final int getServiceId() {
        return this.mServiceId;
    }

    protected boolean sendMessageToClients(Message message) {
        if (message == null) {
            return true;
        }
        boolean result = false;
        for (int i = this.mClientMessengers.size() - 1; i >= 0; --i) {
            try {
                this.mClientMessengers.get(i).send(message);
                result = true;
                continue;
            }
            catch (RemoteException e) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("service id:" + this.getServiceId() + " Client Messenger is not here, remove it"), (Object[])new Object[0]);
                }
                this.mClientMessengers.remove(i);
            }
        }
        return result;
    }

    public void onDestroy() {
    }
}

