/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.Handler;
import android.os.Looper;
import androidx.collection.ArrayMap;
import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.http.CacheDispatcher;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.NetworkDispatcher;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestIntercepter;
import com.yy.mobile.http.RequestProcessor;
import com.yy.mobile.http.SafeDispatchHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultRequestProcessor
implements RequestProcessor {
    protected static int DEFAULT_POOL_SIZE = 4096;
    protected final Map<String, Queue<Request>> mWaitingRequests = new ArrayMap(8);
    protected final Set<Request> mCurrentRequests = new HashSet<Request>(10);
    protected final PriorityBlockingQueue<Request> mCacheQueue = new PriorityBlockingQueue(32);
    protected final PriorityBlockingQueue<Request> mNetworkQueue = new PriorityBlockingQueue(32);
    protected final Map<String, ThresholdRequestHolder> mThresholdRequests = new ArrayMap(8);
    protected static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    protected AtomicInteger mSequenceGenerator = new AtomicInteger();
    protected NetworkDispatcher[] mDispatchers;
    protected CacheDispatcher mCacheDispatcher;
    protected Handler mHandler;
    protected final ByteArrayPool mPool;
    protected final String mName;
    protected final AtomicBoolean paused = new AtomicBoolean(false);
    protected final List<RequestIntercepter> mRequestIntercepters = new ArrayList<RequestIntercepter>(2);
    protected boolean mDebug = false;

    public DefaultRequestProcessor(int threadPoolSize, Handler handler, String name) {
        this.mDispatchers = new NetworkDispatcher[threadPoolSize];
        this.mHandler = handler;
        this.mPool = new ByteArrayPool(DEFAULT_POOL_SIZE);
        this.mName = name;
    }

    public DefaultRequestProcessor(int threadPoolSize, String name) {
        this(threadPoolSize, new SafeDispatchHandler(Looper.getMainLooper()), name);
    }

    public DefaultRequestProcessor() {
        this(4, "DefaultRequestThread");
    }

    @Override
    public void start() {
        this.stop();
        this.mCacheDispatcher = new CacheDispatcher(this.mCacheQueue, this.mNetworkQueue, this.mName, this);
        this.mCacheDispatcher.start();
        for (int i = 0; i < this.mDispatchers.length; ++i) {
            NetworkDispatcher networkDispatcher;
            this.mDispatchers[i] = networkDispatcher = new NetworkDispatcher(this.mNetworkQueue, this.mName + "#" + i, this);
            networkDispatcher.start();
        }
    }

    @Override
    public void stop() {
        this.cancelAll();
        if (this.mCacheDispatcher != null) {
            this.mCacheDispatcher.quit();
        }
        for (int i = 0; i < this.mDispatchers.length; ++i) {
            if (this.mDispatchers[i] == null) continue;
            this.mDispatchers[i].quit();
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    @Override
    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public ByteArrayPool getByteArrayPool() {
        return this.mPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll(RequestProcessor.RequestFilter filter) {
        if (filter == null) {
            return;
        }
        Set<Request> set = this.mCurrentRequests;
        synchronized (set) {
            for (Request request : this.mCurrentRequests) {
                if (!filter.apply(request)) continue;
                request.cancel();
            }
        }
    }

    @Override
    public void cancelAll(final Object tag) {
        if (tag == null) {
            return;
        }
        this.cancelAll(new RequestProcessor.RequestFilter(){

            @Override
            public boolean apply(Request<?> request) {
                return tag.equals(request.getTag());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Set<Request> set = this.mCurrentRequests;
        synchronized (set) {
            for (Request request : this.mCurrentRequests) {
                request.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request add(Request request) {
        if (request == null) {
            return request;
        }
        for (int i = 0; i < this.mRequestIntercepters.size(); ++i) {
            RequestIntercepter requestIntercepter = this.mRequestIntercepters.get(i);
            if (requestIntercepter.onIntercept(request)) continue;
            return request;
        }
        request.setRequestProcessor(this);
        Object object = this.mCurrentRequests;
        synchronized (object) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        if (!request.shouldCache()) {
            if (!this.shouldWaitForThreshold(request)) {
                this.mNetworkQueue.add(request);
            }
            return request;
        }
        object = this.mWaitingRequests;
        synchronized (object) {
            String cacheKey = request.getKey();
            if (this.mWaitingRequests.containsKey(cacheKey)) {
                Queue<Request> stagedRequests = this.mWaitingRequests.get(cacheKey);
                if (stagedRequests == null) {
                    stagedRequests = new LinkedList<Request>();
                }
                stagedRequests.add(request);
                this.mWaitingRequests.put(cacheKey, stagedRequests);
            } else if (!this.shouldWaitForThreshold(request)) {
                this.mWaitingRequests.put(cacheKey, null);
                this.mCacheQueue.add(request);
            }
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(Request request) {
        if (request == null) {
            return;
        }
        Object object = this.mCurrentRequests;
        synchronized (object) {
            this.mCurrentRequests.remove(request);
        }
        if (request.shouldCache()) {
            object = this.mWaitingRequests;
            synchronized (object) {
                String cacheKey = request.getKey();
                Queue<Request> waitingRequests = this.mWaitingRequests.remove(cacheKey);
                if (waitingRequests != null) {
                    HttpLog.v("Releasing %d waiting requests for cacheKey=%s.", waitingRequests.size(), cacheKey);
                    this.mCacheQueue.addAll(waitingRequests);
                }
            }
        }
        String thresholdType = request.getThresholdType();
        if (request.getThreshold() > 0 && thresholdType != null) {
            Map<String, ThresholdRequestHolder> map = this.mThresholdRequests;
            synchronized (map) {
                ThresholdRequestHolder holder = this.mThresholdRequests.get(thresholdType);
                if (holder != null) {
                    holder.runningRequests.remove(request);
                    holder.waitingRequests.remove(request);
                    this.mThresholdRequests.put(thresholdType, holder);
                    if (holder.waitingRequests.size() > 0) {
                        Request r = holder.waitingRequests.first();
                        this.add2(r);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request add2(Request request) {
        if (request == null) {
            return request;
        }
        if (!request.shouldCache()) {
            if (!this.shouldWaitForThreshold2(request)) {
                this.mNetworkQueue.add(request);
            }
            return request;
        }
        Map<String, Queue<Request>> map = this.mWaitingRequests;
        synchronized (map) {
            String cacheKey = request.getKey();
            if (this.mWaitingRequests.containsKey(cacheKey)) {
                Queue<Request> stagedRequests = this.mWaitingRequests.get(cacheKey);
                if (stagedRequests == null) {
                    stagedRequests = new LinkedList<Request>();
                }
                stagedRequests.add(request);
                this.mWaitingRequests.put(cacheKey, stagedRequests);
            } else if (!this.shouldWaitForThreshold2(request)) {
                this.mWaitingRequests.put(cacheKey, null);
                this.mCacheQueue.add(request);
            }
            return request;
        }
    }

    public boolean shouldWaitForThreshold2(Request request) {
        boolean shouldWaitForThreshold = false;
        String thresholdType = request.getThresholdType();
        if (request.getThreshold() > 0 && thresholdType != null) {
            if (this.mThresholdRequests.containsKey(thresholdType)) {
                ThresholdRequestHolder holder = this.mThresholdRequests.get(thresholdType);
                if (holder.runningRequests.size() >= request.getThreshold()) {
                    shouldWaitForThreshold = true;
                    holder.waitingRequests.add(request);
                } else {
                    holder.runningRequests.add(request);
                    holder.waitingRequests.remove(request);
                }
                this.mThresholdRequests.put(thresholdType, holder);
            } else {
                ThresholdRequestHolder holder = new ThresholdRequestHolder();
                holder.runningRequests.add(request);
                this.mThresholdRequests.put(thresholdType, holder);
            }
        }
        return shouldWaitForThreshold;
    }

    @Override
    public void pause() {
        this.paused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        AtomicBoolean atomicBoolean = this.paused;
        synchronized (atomicBoolean) {
            this.paused.set(false);
            this.paused.notifyAll();
        }
    }

    @Override
    public AtomicBoolean getPause() {
        return this.paused;
    }

    @Override
    public void setDebug(boolean debug) {
        if (HttpLog.isDebug()) {
            HttpLog.d("Set debug to %b", debug);
        }
        this.mDebug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.mDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestIntercepter(RequestIntercepter intercepter) {
        List<RequestIntercepter> list = this.mRequestIntercepters;
        synchronized (list) {
            this.mRequestIntercepters.add(intercepter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldWaitForThreshold(Request request) {
        boolean shouldWaitForThreshold = false;
        String thresholdType = request.getThresholdType();
        if (request.getThreshold() > 0 && thresholdType != null) {
            Map<String, ThresholdRequestHolder> map = this.mThresholdRequests;
            synchronized (map) {
                if (this.mThresholdRequests.containsKey(thresholdType)) {
                    ThresholdRequestHolder holder = this.mThresholdRequests.get(thresholdType);
                    if (holder.runningRequests.size() >= request.getThreshold()) {
                        shouldWaitForThreshold = true;
                        holder.waitingRequests.add(request);
                        HttpLog.v("Threshold control waiting,type=%s,url=%s,running=%s,waiting=%d", thresholdType, request.getUrl(), holder.runningRequests, holder.waitingRequests.size());
                    } else {
                        holder.runningRequests.add(request);
                        holder.waitingRequests.remove(request);
                    }
                    this.mThresholdRequests.put(thresholdType, holder);
                } else {
                    ThresholdRequestHolder holder = new ThresholdRequestHolder();
                    holder.runningRequests.add(request);
                    this.mThresholdRequests.put(thresholdType, holder);
                }
            }
        }
        return shouldWaitForThreshold;
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("mWaitingRequests.size=").append(this.mWaitingRequests.size()).append(" , ").append("mCurrentRequests.size=").append(this.mCurrentRequests.size()).append(" , ").append("mCacheQueue.size=").append(this.mCacheQueue.size()).append(" , ").append("mNetworkQueue.size=").append(this.mNetworkQueue.size()).append(" , ").append("mThresholdRequests.size=").append(this.mThresholdRequests.size()).append("\n");
        sb.append("mWaitingRequests[");
        Set<String> keys = this.mWaitingRequests.keySet();
        for (String key : keys) {
            Queue<Request> q = this.mWaitingRequests.get(key);
            sb.append("queue.size=").append(q != null ? q.size() : 0).append(" , ").append(key).append(" ;\n ");
        }
        sb.append("]\n");
        sb.append("mCurrentRequests[");
        for (Request request : this.mCurrentRequests) {
            sb.append(request.getUrl()).append(" ,\n");
        }
        sb.append("]\n");
        sb.append("mCacheQueue[");
        for (Request request : this.mCacheQueue) {
            sb.append(request.getUrl()).append(" ,\n");
        }
        sb.append("]\n");
        sb.append("mNetworkQueue[");
        for (Request request : this.mNetworkQueue) {
            sb.append(request.getUrl()).append(" ,\n");
        }
        sb.append("]\n");
        sb.append("mThresholdRequests[");
        Set<String> ks = this.mThresholdRequests.keySet();
        for (String k : ks) {
            ThresholdRequestHolder holder = this.mThresholdRequests.get(k);
            sb.append("thresholdType=").append(k).append(" , ");
            sb.append("waitingRequests[");
            for (Request runningReq : holder.runningRequests) {
                sb.append(runningReq.getUrl()).append(" , ");
            }
            sb.append(" ]\n");
            sb.append("waitingRequests[");
            for (Request waitingReq : holder.waitingRequests) {
                sb.append(waitingReq.getUrl()).append(" , ");
            }
            sb.append(" ]\n");
        }
        sb.append(" ]\n");
        return sb.toString();
    }

    private static class ThresholdRequestHolder {
        TreeSet<Request> waitingRequests = new TreeSet();
        Set<Request> runningRequests = new HashSet<Request>();

        private ThresholdRequestHolder() {
        }
    }
}

