/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.servicewrapper;

import android.os.Bundle;
import android.os.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.mobile.backgroundprocess.Util.AssertUtil;
import com.yy.mobile.backgroundprocess.servicewrapper.GeneralMessageDispater;

public class GeneralServiceWrapper {
    private GeneralMessageDispater mMessageDispater = null;
    private int mServiceId;

    public GeneralServiceWrapper(int serviceId) {
        this.mServiceId = serviceId;
        this.mMessageDispater = new GeneralMessageDispater(RuntimeContext.sApplicationContext, this.mServiceId);
    }

    public void setMsgsSendErroredListener(GeneralMessageDispater.IMsgsSendErroredListener msgsSendErroredListener) {
        this.mMessageDispater.setMsgsSendErroredListener(msgsSendErroredListener);
    }

    public void setRemoteCallBack(GeneralMessageDispater.IRemoteCallBack listener) {
        this.mMessageDispater.setRemoteCallBack(listener);
    }

    public void sendMessage(int messageType, Bundle data) {
        Message message = this.obtainMessage();
        message.what = messageType;
        message.setData(data);
        this.mMessageDispater.sendMessage(message);
    }

    public void sendMessage(Message message) {
        if (message == null) {
            return;
        }
        this.mMessageDispater.sendMessage(message);
    }

    public void sendMessage(int to, int messageType, Bundle data) {
        Message message = Message.obtain();
        message.arg1 = to;
        message.what = messageType;
        message.setData(data);
        this.mMessageDispater.sendMessage(message);
    }

    public Message obtainMessage() {
        Message message = Message.obtain();
        message.arg1 = this.mServiceId;
        return message;
    }

    public void onDestroy() {
        AssertUtil.assertMainThread();
        this.onExit();
    }

    private void onExit() {
        this.mMessageDispater.cleanUpOnExit();
        this.mMessageDispater = null;
    }
}

