/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper;

import android.content.Context;
import android.os.Message;
import com.yy.mobile.backgroundprocess.services.AbstractMessageDispater;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.MessageDef;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.ITaskProgressListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.ITaskStateChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class MessageDispater
extends AbstractMessageDispater {
    private ArrayList<WeakReference<ITaskProgressListener>> mTaskProgressListeners = new ArrayList();
    private ArrayList<WeakReference<ITaskStateChangeListener>> mTaskStateChangeListeners = new ArrayList();
    private IMsgsSendErroredListener mMsgsSendErroredListener;

    public MessageDispater(Context context) {
        super(context, 1);
    }

    public void setMsgsSendErroredListener(IMsgsSendErroredListener msgsSendErroredListener) {
        this.mMsgsSendErroredListener = msgsSendErroredListener;
    }

    public void registerTaskStateChangeListener(ITaskStateChangeListener listener) {
        if (this.containTaskStateChangeListener(listener)) {
            return;
        }
        this.mTaskStateChangeListeners.add(new WeakReference<ITaskStateChangeListener>(listener));
    }

    private boolean containTaskStateChangeListener(ITaskStateChangeListener listener) {
        ITaskStateChangeListener item = null;
        for (WeakReference<ITaskStateChangeListener> weakReference : this.mTaskStateChangeListeners) {
            item = (ITaskStateChangeListener)weakReference.get();
            if (item != listener) continue;
            return true;
        }
        return false;
    }

    private boolean containTaskProcessListener(ITaskProgressListener listener) {
        ITaskProgressListener item = null;
        for (WeakReference<ITaskProgressListener> weakReference : this.mTaskProgressListeners) {
            item = (ITaskProgressListener)weakReference.get();
            if (item != listener) continue;
            return true;
        }
        return false;
    }

    public void registerTaskProgressListener(ITaskProgressListener listener) {
        if (this.containTaskProcessListener(listener)) {
            return;
        }
        this.mTaskProgressListeners.add(new WeakReference<ITaskProgressListener>(listener));
    }

    @Override
    public void handleCallBackMessage(Message message) {
        block6: {
            block7: {
                block5: {
                    if (message == null || message.getData() == null) {
                        return;
                    }
                    if (message.what != MessageDef.ServiceCallMessage.ON_TASK_PROGRESS_UPDATED) break block5;
                    DownloadTask task = DownloadTask.newDownloadTask(message.getData());
                    long curSize = task.getLong("cursize");
                    long totalSize = task.getLong("size");
                    int percent = -1;
                    if (totalSize > 0L && curSize > 0L) {
                        percent = (int)((float)curSize / (float)totalSize * 100.0f);
                    }
                    ITaskProgressListener item = null;
                    for (WeakReference<ITaskProgressListener> weakReference : this.mTaskProgressListeners) {
                        item = (ITaskProgressListener)weakReference.get();
                        if (item == null) continue;
                        item.onTaskProcessUpdated(percent, task);
                    }
                    break block6;
                }
                if (message.what != MessageDef.ServiceCallMessage.ON_TASK_CREATE_RESULT) break block7;
                ITaskStateChangeListener item = null;
                DownloadTask task = DownloadTask.newDownloadTask(message.getData());
                for (WeakReference<ITaskStateChangeListener> weakReference : this.mTaskStateChangeListeners) {
                    item = (ITaskStateChangeListener)weakReference.get();
                    if (item == null) continue;
                    item.onCreateTaskResult(message.arg1, task, message.obj);
                }
                break block6;
            }
            if (message.what != MessageDef.ServiceCallMessage.ON_TASK_STATE_UPDATED) break block6;
            ITaskStateChangeListener item = null;
            DownloadTask task = DownloadTask.newDownloadTask(message.getData());
            for (WeakReference<ITaskStateChangeListener> weakReference : this.mTaskStateChangeListeners) {
                item = (ITaskStateChangeListener)weakReference.get();
                if (item == null) continue;
                item.onTaskStateChanged(message.arg1, task, message.obj);
            }
        }
    }

    @Override
    public void onMsgsSendErrored(ArrayList<Message> messages) {
        if (this.mMsgsSendErroredListener != null) {
            this.mMsgsSendErroredListener.onMsgsSendErrored(messages);
        }
    }

    @Override
    public void cleanUpOnExit() {
        super.cleanUpOnExit();
    }

    public static interface IMsgsSendErroredListener {
        public void onMsgsSendErrored(ArrayList<Message> var1);
    }
}

