/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SHAUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadUtil;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequest;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequestBuilder;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.IRequestStartedListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.EmptyFileError;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.EtagError;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.ShaCheckError;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.UnzipError;
import com.yy.mobile.http.CancelListener;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.conn.ConnectTimeoutException;

public class DownloadRequestManager
implements IRequestStartedListener {
    private static final String TAG = "DownloadRequestManager";
    private static final Comparator<WaitingTask> WAIT_TASK_COMPARATOR = new Comparator<WaitingTask>(){

        @Override
        public int compare(WaitingTask o1, WaitingTask o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getPriority() == o2.getPriority()) {
                long dif = o1.getCreateTime() - o2.getCreateTime();
                return dif == 0L ? 0 : (dif > 0L ? 1 : -1);
            }
            return o2.getPriority() - o1.getPriority();
        }
    };
    private boolean mIsNetConnected = false;
    private int mNetWorkType;
    private IDownloadListener mListener;
    private final HashMap<DownloadTask, DownloadRequest> mSubmitedTasks = new HashMap();
    private final ArrayList<WaitingTask> mWaitingTasks = new ArrayList();
    private final ArrayList<DownloadTask> mRetryTasks = new ArrayList();
    private RetryManager mRetryManager;
    private Runnable mCheckNetRunnable;
    private boolean mCheckingNet;
    private BroadcastReceiver mNetWorkBroadcastReceiver;

    public DownloadRequestManager(IDownloadListener listener) {
        this.mListener = listener;
        this.mRetryManager = new RetryManager();
        this.updateNetWorkInfo();
    }

    public static boolean isInMainThread() {
        return YYTaskExecutor.isMainThread();
    }

    private void updateNetWorkInfo() {
        this.mIsNetConnected = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        this.mNetWorkType = NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext);
    }

    public boolean isTaskDownloading() {
        return !this.mSubmitedTasks.isEmpty();
    }

    public boolean submitTask(DownloadTask task) {
        if (task == null) {
            return false;
        }
        boolean result = this.findTask(task);
        String url = task.getString("url");
        if (result) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"submitTask has existed %s ", (Object[])new Object[]{url});
            }
            return false;
        }
        this.addToWaitingList(task, null, this.mWaitingTasks.size());
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"submitTask add wo waiting list size %d %s ", (Object[])new Object[]{this.mWaitingTasks.size(), url});
        }
        this.excuteNextDownloadTasks();
        this.registerNetWorkReceiver();
        return true;
    }

    public void updateTask(DownloadTask oldTask, DownloadTask newTask) {
        if (oldTask == null || newTask == null) {
            return;
        }
        WaitingTask waitingTask = this.removeWaitingTask(oldTask);
        String speedLimitValue = newTask.getExtendString("speedlimit");
        String progressInterval = newTask.getExtendString("progressinterval");
        long limitSecond = StringUtils.parseLong((String)speedLimitValue, (long)-1L);
        long progress = StringUtils.parseLong((String)progressInterval, (long)-1L);
        if (waitingTask != null) {
            if (waitingTask.request != null) {
                waitingTask.request.setTaskSpeedLimitPerMicsecondValue(limitSecond);
                waitingTask.request.setProgressInterval(progress);
            }
            this.addToWaitingList(newTask, waitingTask.request, this.mWaitingTasks.size());
        }
        this.updateSubmitLimitSecond(oldTask, limitSecond, progress);
    }

    private void updateSubmitLimitSecond(DownloadTask oldTask, long limitSecond, long progress) {
        if (FP.empty(this.mSubmitedTasks)) {
            return;
        }
        DownloadRequest request = null;
        request = this.mSubmitedTasks.get(oldTask);
        if (request != null) {
            if (request.getSpeedLimitValuePerMicSecond() != limitSecond) {
                request.setTaskSpeedLimitPerMicsecondValue(limitSecond);
            }
            request.setProgressInterval(progress);
        }
    }

    private void removeTaskFromLists(DownloadTask task) {
        if (task == null) {
            return;
        }
        this.mSubmitedTasks.remove(task);
        this.removeWaitingTask(task);
        this.mRetryTasks.remove(task);
    }

    public void deleteTask(DownloadTask task) {
        DownloadRequest request = null;
        if (this.mSubmitedTasks.containsKey(task)) {
            request = this.mSubmitedTasks.get(task);
        }
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"deleteTask : %s", (Object[])new Object[]{request != null ? request.getUrl() : ""});
        }
        this.onCancel(request);
        this.removeTaskFromLists(task);
        if (request != null) {
            request.cancel();
        }
        this.excuteNextDownloadTasks();
    }

    public boolean containTask(DownloadTask originTask) {
        return originTask != null && this.findTask(originTask);
    }

    private DownloadTask getTaskFromSubmitedTasks(DownloadRequest request) {
        if (request == null) {
            return null;
        }
        DownloadTask task = null;
        Set<DownloadTask> tasks = this.mSubmitedTasks.keySet();
        if (tasks.size() > 0) {
            for (DownloadTask tempTask : tasks) {
                if (request != this.mSubmitedTasks.get(tempTask)) continue;
                task = tempTask;
                break;
            }
        }
        return task;
    }

    private WaitingTask removeWaitingTask(DownloadTask task) {
        if (task != null) {
            for (WaitingTask waitingTask : this.mWaitingTasks) {
                if (task != waitingTask.task) continue;
                this.mWaitingTasks.remove(waitingTask);
                return waitingTask;
            }
        }
        return null;
    }

    private ArrayList<DownloadTask> getLowPriorityTasks(DownloadTask task) {
        if (this.mSubmitedTasks.size() <= 0) {
            return null;
        }
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>(5);
        Set<DownloadTask> keys = this.mSubmitedTasks.keySet();
        for (DownloadTask item : keys) {
            if (item.getInt("dgroup") != task.getInt("dgroup") || WaitingTask.getPriority(task) <= WaitingTask.getPriority(item)) continue;
            tasks.add(item);
        }
        return tasks;
    }

    private void addToWaitingList(DownloadTask task, DownloadRequest request, int index) {
        if (task != null) {
            WaitingTask waitingTask = new WaitingTask(task, request);
            if (index < 0 || index > this.mWaitingTasks.size()) {
                this.mWaitingTasks.add(waitingTask);
            } else {
                this.mWaitingTasks.add(index, waitingTask);
            }
            ArrayList<DownloadTask> lowPriorityTasks = this.getLowPriorityTasks(task);
            if (lowPriorityTasks != null && lowPriorityTasks.size() > 0) {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"start delete lowPriorityTasks %d", (Object[])new Object[]{lowPriorityTasks.size()});
                }
                for (DownloadTask item : lowPriorityTasks) {
                    this.deleteTask(item);
                    if (!RuntimeContext.sIsDebuggable || !MLog.isLogLevelBlowInfo()) continue;
                    MLog.info((Object)TAG, (String)"start delete lowPriorityTask %s", (Object[])new Object[]{item.getString("url")});
                }
                for (DownloadTask item : lowPriorityTasks) {
                    this.mWaitingTasks.add(new WaitingTask(item, null));
                }
            }
            Collections.sort(this.mWaitingTasks, WAIT_TASK_COMPARATOR);
        }
    }

    private void addRetryTask(DownloadTask task) {
        if (task != null && !this.mRetryTasks.contains(task)) {
            this.mRetryTasks.add(task);
        }
    }

    private boolean findTask(DownloadTask task) {
        if (this.mSubmitedTasks.containsKey(task)) {
            return true;
        }
        for (WaitingTask waitingTask : this.mWaitingTasks) {
            if (task != waitingTask.task) continue;
            return true;
        }
        return this.mRetryTasks.contains(task);
    }

    private ArrayList<String> getHostAddressesFromSystem(String host) {
        ArrayList<String> hostAddressedFromDns = new ArrayList<String>();
        InetAddress[] result = null;
        try {
            result = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e1) {
            Log.e((String)"DownloadRequest", (String)(" error ignore: " + e1.getMessage()));
        }
        if (result != null && result.length > 0) {
            String hostAddress = null;
            for (InetAddress item : result) {
                if (item != null) {
                    hostAddress = item.getHostAddress();
                }
                if (StringUtils.isEmpty(hostAddress)) continue;
                hostAddressedFromDns.add(hostAddress);
            }
        }
        return hostAddressedFromDns;
    }

    @Nullable
    private DownloadRequest createRequest(DownloadTask task) {
        return DownloadRequestBuilder.createRequest(task);
    }

    private void startDownload(DownloadTask task, DownloadRequest request) {
        if (task == null) {
            return;
        }
        this.mSubmitedTasks.put(task, request);
        if (request == null) {
            DownloadRequest realRequest = DownloadRequestBuilder.createRequest(task);
            if (realRequest != null) {
                this.mSubmitedTasks.put(task, realRequest);
                this.startDownload(realRequest);
            } else {
                this.mSubmitedTasks.remove(task);
            }
        } else {
            this.startDownload(request);
        }
    }

    private void startDownload(final DownloadRequest request) {
        if (request == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startDownload:%s", (Object[])new Object[]{request.getUrl()});
        }
        request.setSuccessListener(new ResponseListener(){

            public void onResponse(Object response) {
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)DownloadRequestManager.TAG, (String)"startDownload success! %s", (Object[])new Object[]{request.getUrl()});
                }
                if (DownloadRequestManager.isInMainThread()) {
                    DownloadRequestManager.this.onSuccessResponse(request, response);
                } else {
                    final Object finalResponse = response;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DownloadRequestManager.this.onSuccessResponse(request, finalResponse);
                        }
                    });
                }
            }
        });
        request.setErrorListener(new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)DownloadRequestManager.TAG, (String)"startDownload url %s, error:%s ", (Object[])new Object[]{request.getUrl(), error != null ? error.toString() : ""});
                }
                if (DownloadRequestManager.isInMainThread()) {
                    DownloadRequestManager.this.onErrorResponse(request, error);
                } else {
                    final RequestError finalError = error;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DownloadRequestManager.this.onErrorResponse(request, finalError);
                        }
                    });
                }
            }
        });
        request.setProgressListener(new ProgressListener(){

            @Override
            public void onProgress(ProgressInfo info) {
                if (DownloadRequestManager.isInMainThread()) {
                    DownloadRequestManager.this.onProgress(request, info);
                } else {
                    final ProgressInfo finalInfo = info;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DownloadRequestManager.this.onProgress(request, finalInfo);
                        }
                    });
                }
            }
        });
        request.setCancelListener(new CancelListener(){

            @Override
            public void onCancel() {
                if (DownloadRequestManager.isInMainThread()) {
                    DownloadRequestManager.this.onCancel(request);
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DownloadRequestManager.this.onCancel(request);
                        }
                    });
                }
            }
        });
        request.setStartedListener(this);
        RequestManager.instance().submitRequest(request);
    }

    private void excuteNextDownloadTasks() {
        if (!this.mIsNetConnected || this.mCheckingNet) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"excuteNextDownloadTasks no network return!", (Object[])new Object[0]);
            }
            return;
        }
        int sizeToSubmit = 6 - this.mSubmitedTasks.size();
        if (sizeToSubmit <= 0 || this.mWaitingTasks.size() <= 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"excuteNextDownloadTasks  mWaitingTasks 0 return!", (Object[])new Object[0]);
            }
            return;
        }
        boolean above3g = false;
        if (this.mNetWorkType == 1 || this.mNetWorkType == 4) {
            above3g = true;
        } else if (this.mNetWorkType == 5) {
            above3g = true;
        }
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"excuteNextDownloadTasks  above3g %d", (Object[])new Object[]{above3g ? 1 : 0});
        }
        WaitingTask waitingTask = null;
        DownloadTask task = null;
        DownloadRequest request = null;
        boolean needSubmit = false;
        int i = 0;
        while (i < this.mWaitingTasks.size()) {
            waitingTask = this.mWaitingTasks.get(i);
            needSubmit = false;
            if (waitingTask != null) {
                task = waitingTask.task;
                request = waitingTask.request;
            }
            if (task == null) {
                ++i;
                continue;
            }
            if (task.getInt("tgabove") == 1) {
                if (above3g) {
                    needSubmit = true;
                }
            } else {
                needSubmit = true;
            }
            if (needSubmit) {
                boolean bl = needSubmit = !this.isOver(task);
            }
            if (needSubmit) {
                this.mWaitingTasks.remove(waitingTask);
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"excuteNextDownloadTasks  start %s", (Object[])new Object[]{task.getString("url")});
                }
                this.startDownload(task, request);
                if (--sizeToSubmit > 0) continue;
                break;
            }
            ++i;
        }
    }

    private boolean isOver(DownloadTask taskToStart) {
        boolean result;
        DownloadTask task;
        if (taskToStart == null || this.mSubmitedTasks.size() <= 0) {
            return false;
        }
        String type = String.valueOf(taskToStart.getInt("dgroup"));
        int maxNum = StringUtils.parseInt((String)taskToStart.getExtendString("maxconcurrency"));
        if (maxNum <= 0) {
            return true;
        }
        Set<DownloadTask> keys = this.mSubmitedTasks.keySet();
        DownloadRequest item = null;
        Iterator<DownloadTask> iterator = keys.iterator();
        while (iterator.hasNext() && ((item = this.mSubmitedTasks.get(task = iterator.next())) == null || !StringUtils.equal((String)item.getThresholdType(), (String)type) || --maxNum > 0)) {
        }
        boolean bl = result = maxNum <= 0;
        if (!RuntimeContext.sIsDebuggable || result) {
            // empty if block
        }
        return result;
    }

    private void onProgress(DownloadRequest request, ProgressInfo info) {
        DownloadTask task = this.getTaskFromSubmitedTasks(request);
        if (task == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onProgress(task, info);
        }
    }

    private void onCancel(DownloadRequest request) {
        DownloadTask task = this.getTaskFromSubmitedTasks(request);
        if (task == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onPaused(task);
        }
    }

    private File getTaskFile(DownloadTask task) {
        return DownloadUtil.getTaskFile(task);
    }

    private void onErrorResponse(DownloadRequest request, RequestError error) {
        DownloadTask task = this.getTaskFromSubmitedTasks(request);
        if (task == null) {
            return;
        }
        task.putExtendString("download_type", request.getExtendParam(DownloadRequest.ExtendKey.DOWNLOAD_TYPE));
        String realRequestHost = error.mRealRequestHost;
        String networkLibType = error.mNetworkLibType;
        task.putExtendString("real_host", realRequestHost);
        task.putExtendString("network_type", networkLibType);
        this.mRetryManager.onDownloadErrorResponse(task, request, error);
    }

    private void onSuccessResponse(final DownloadRequest request, Object response) {
        final DownloadTask task = this.getTaskFromSubmitedTasks(request);
        if (task == null) {
            return;
        }
        final File taskFile = this.getTaskFile(task);
        if (taskFile == null) {
            this.mSubmitedTasks.remove(task);
            return;
        }
        final String etag = request.getExtendParam(DownloadRequest.ExtendKey.ETAG);
        final boolean needUnzip = task.getInt("unzip") == 1 && !task.getExtendBoolean("incremental_download");
        final String fileCheckType = task.getString("etagkey");
        task.putExtendString("download_type", request.getExtendParam(DownloadRequest.ExtendKey.DOWNLOAD_TYPE));
        String realRequestHost = request.getHost();
        String networkLibType = "okhttp";
        if (request.mResponseData != null) {
            realRequestHost = request.mResponseData.mRealRequestHost;
            networkLibType = request.mResponseData.mNetworkLibType;
        }
        task.putExtendString("real_host", realRequestHost);
        task.putExtendString("network_type", networkLibType);
        final String realRequestHostFinal = realRequestHost;
        final String networkLibTypeFinal = networkLibType;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean success = true;
                RequestError error = null;
                String taskFilePath = taskFile.getPath();
                if (!taskFile.exists()) {
                    success = false;
                    error = new EmptyFileError("downloaded file:" + taskFilePath + "not existed", 70, 200).networkLibType(networkLibTypeFinal).realRequestHost(realRequestHostFinal);
                } else if (taskFile.length() <= 0L) {
                    success = false;
                    error = new EmptyFileError("downloaded file:" + taskFilePath + "size is 0", 70, 200).networkLibType(networkLibTypeFinal).realRequestHost(realRequestHostFinal);
                }
                if (StringUtils.equal((String)fileCheckType, (String)"sha1")) {
                    if (success && !StringUtils.isEmpty((String)etag)) {
                        try {
                            String sha1 = SHAUtils.getFileSHAString((String)taskFilePath);
                            if (!etag.equalsIgnoreCase(sha1)) {
                                success = false;
                                error = new ShaCheckError("check SHA1 Hash failed, size:" + taskFile.length() + " real hash:" + etag + " wrong hash:" + (sha1 == null ? "null" : sha1), 71, 200).networkLibType(networkLibTypeFinal).realRequestHost(realRequestHostFinal);
                            }
                        }
                        catch (Exception e) {
                            success = false;
                            error = new ShaCheckError("check SHA1 Hash failed: size:" + taskFile.length() + " " + e.toString(), 71, 200).networkLibType(networkLibTypeFinal).realRequestHost(realRequestHostFinal);
                        }
                    }
                } else if (StringUtils.equal((String)fileCheckType, (String)"md5") && success && !StringUtils.isEmpty((String)etag)) {
                    try {
                        String md5Key = MD5Utils.getFileMd5String((String)taskFilePath);
                        if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTPatch", (String)("etag = " + etag + "   md5Key = " + md5Key + " url = " + request.getUrl()), (Object[])new Object[0]);
                        }
                        if (!etag.equalsIgnoreCase(md5Key)) {
                            success = false;
                            error = new ShaCheckError("check Md5 Hash failed, size:" + taskFile.length() + " real hash:" + etag + " wrong hash:" + (md5Key == null ? "null" : md5Key), 71, 200).networkLibType(networkLibTypeFinal).realRequestHost(realRequestHostFinal);
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        error = new ShaCheckError("check Md5 Hash failed: size:" + taskFile.length() + " " + e.toString(), 71, 200).networkLibType(networkLibTypeFinal).realRequestHost(realRequestHostFinal);
                    }
                }
                if (success && needUnzip) {
                    try {
                        DownloadUtil.unzip(taskFilePath, taskFilePath);
                    }
                    catch (UnzipError e) {
                        success = false;
                        error = e;
                    }
                }
                final boolean result = success;
                final RequestError errorResult = error;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (result) {
                            long netUseTime = -1L;
                            long range = -1L;
                            try {
                                netUseTime = request.getExtendParamLong(DownloadRequest.ExtendKey.NETWORK_USE_TIME);
                                range = request.getExtendParamLong(DownloadRequest.ExtendKey.START_RANGE);
                                if (range <= 0L && netUseTime > 0L) {
                                    task.putExtendString("netusetime", String.valueOf(netUseTime));
                                }
                                task.putExtendString("contentlength", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.CONTENT_LENGTH)));
                            }
                            catch (Throwable e) {
                                MLog.error((Object)DownloadRequestManager.TAG, (Throwable)e);
                            }
                            if (DownloadRequestManager.this.mSubmitedTasks.containsKey(task)) {
                                DownloadRequestManager.this.mSubmitedTasks.remove(task);
                                if (DownloadRequestManager.this.mListener != null) {
                                    DownloadRequestManager.this.mListener.onSuccess(task);
                                }
                            }
                            DownloadRequestManager.this.excuteNextDownloadTasks();
                        } else {
                            DownloadRequestManager.this.mRetryManager.onDownloadErrorResponse(task, request, errorResult);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onStarted(final DownloadRequest request) {
        if (request == null) {
            return;
        }
        if (DownloadRequestManager.isInMainThread()) {
            this.onRequestStarted(request);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    DownloadRequestManager.this.onRequestStarted(request);
                }
            });
        }
    }

    private void onRequestStarted(DownloadRequest request) {
        DownloadTask task = this.getTaskFromSubmitedTasks(request);
        if (task == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onRequestStarted : %s", (Object[])new Object[]{request != null ? request.getUrl() : ""});
        }
        if (this.mListener != null) {
            this.mListener.onStarted(task);
        }
    }

    private void registerNetWorkReceiver() {
        if (this.mNetWorkBroadcastReceiver == null) {
            this.updateNetWorkInfo();
            this.mNetWorkBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    DownloadRequestManager.this.onNetConnectChanged();
                }
            };
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            RuntimeContext.sApplicationContext.registerReceiver(this.mNetWorkBroadcastReceiver, filter);
        }
    }

    public void onNetConnectChanged() {
        this.mCheckingNet = true;
        if (this.mCheckNetRunnable != null) {
            YYTaskExecutor.removeTask((Runnable)this.mCheckNetRunnable);
        } else {
            this.mCheckNetRunnable = new Runnable(){

                @Override
                public void run() {
                    DownloadRequestManager.this.mCheckingNet = false;
                    DownloadRequestManager.this.updateNetWorkInfo();
                    DownloadRequestManager.this.excuteNextDownloadTasks();
                    if (!DownloadRequestManager.this.mIsNetConnected) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                DownloadRequestManager.this.updateNetWorkInfo();
                                DownloadRequestManager.this.excuteNextDownloadTasks();
                            }
                        }, (long)3000L);
                    }
                }
            };
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mCheckNetRunnable, (long)5000L);
    }

    private static class WaitingTask {
        public DownloadTask task;
        public DownloadRequest request;

        WaitingTask(DownloadTask task, DownloadRequest request) {
            this.task = task;
            this.request = request;
        }

        public int getPriority() {
            if (this.task != null) {
                return this.task.getInt("priority");
            }
            return 0;
        }

        public long getCreateTime() {
            if (this.task != null) {
                return this.task.getLong("ctime");
            }
            return 0L;
        }

        public static int getPriority(DownloadTask task) {
            if (task != null) {
                return task.getInt("priority");
            }
            return 0;
        }

        public static long getCreateTime(DownloadTask task) {
            if (task != null) {
                return task.getLong("ctime");
            }
            return 0L;
        }
    }

    public static interface IDownloadListener {
        public void onProgress(DownloadTask var1, ProgressInfo var2);

        public void onError(DownloadTask var1, Exception var2);

        public void onSuccess(DownloadTask var1);

        public void onRetry(DownloadTask var1, boolean var2);

        public void onStarted(DownloadTask var1);

        public void onPaused(DownloadTask var1);
    }

    private class RetryManager {
        private RetryManager() {
        }

        private void printErrorInfo(DownloadTask task, DownloadRequest request, Exception error) {
            File taskFile = DownloadRequestManager.this.getTaskFile(task);
            if (error != null && taskFile != null) {
                StringBuilder errorInfo = new StringBuilder();
                errorInfo.append("[download] url:");
                errorInfo.append(task.getString("url"));
                errorInfo.append(" error:");
                errorInfo.append(error.toString());
                errorInfo.append(" context info:[");
                if (taskFile.exists()) {
                    errorInfo.append(" filesize:");
                    errorInfo.append(String.valueOf(taskFile.length()));
                    if (!taskFile.canWrite()) {
                        errorInfo.append(" file can not write");
                    }
                    if (taskFile.isDirectory()) {
                        errorInfo.append(" file is dir");
                    }
                } else {
                    File parent = taskFile.getParentFile();
                    if (parent == null || !parent.exists() || !parent.isDirectory()) {
                        errorInfo.append(" parent dir:" + (parent != null ? parent.getPath() : ""));
                        errorInfo.append(" not Existed");
                    }
                }
                errorInfo.append("]");
                MLog.error((Object)DownloadRequestManager.TAG, (String)errorInfo.toString(), (Object[])new Object[0]);
            }
        }

        private void notifyError(final DownloadRequest request, final DownloadTask task, Exception error) {
            if (task == null) {
                return;
            }
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RetryManager.this.deleteDownloadFile(request, task);
                    }
                });
            } else {
                this.deleteDownloadFile(request, task);
            }
            DownloadRequestManager.this.removeTaskFromLists(task);
            DownloadRequestManager.this.excuteNextDownloadTasks();
            if (DownloadRequestManager.this.mListener != null) {
                DownloadRequestManager.this.mListener.onError(task, error);
            }
        }

        private void deleteDownloadFile(DownloadRequest request, DownloadTask task) {
            File taskFile = DownloadRequestManager.this.getTaskFile(task);
            if (taskFile != null && taskFile.exists()) {
                taskFile.delete();
            }
            if (request != null) {
                request.deleteTempFile();
            }
        }

        private void retryTask(DownloadTask task, DownloadRequest request, boolean fileDeleted) {
            if (task == null) {
                return;
            }
            if (!DownloadRequestManager.this.mRetryTasks.contains(task)) {
                return;
            }
            DownloadRequestManager.this.mRetryTasks.remove(task);
            if (DownloadRequestManager.this.mListener != null) {
                DownloadRequestManager.this.mListener.onRetry(task, fileDeleted);
            }
            DownloadRequestManager.this.addToWaitingList(task, request, 0);
            DownloadRequestManager.this.excuteNextDownloadTasks();
        }

        private void retryTask(final DownloadTask task, final DownloadRequest request, final boolean fileDeleted, long delayTime) {
            if (delayTime <= 0L) {
                this.retryTask(task, request, fileDeleted);
            }
            if (!DownloadRequestManager.this.mRetryTasks.contains(task)) {
                return;
            }
            Runnable delayRetryRunnable = new Runnable(){

                @Override
                public void run() {
                    RetryManager.this.retryTask(task, request, fileDeleted);
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)delayRetryRunnable, (long)delayTime);
            DownloadRequestManager.this.excuteNextDownloadTasks();
        }

        private HashMap<String, String> addErrorInfo(DownloadTask task, DownloadRequest request, Exception error) {
            int renameError;
            File taskFile;
            if (task == null || request == null) {
                return null;
            }
            int errorInfoMaxNum = 5;
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> errorInfoList = null;
            Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
            if (tempErrorInfoObject instanceof ArrayList) {
                errorInfoList = (ArrayList<HashMap<String, String>>)tempErrorInfoObject;
                if (errorInfoList.size() == 5) {
                    errorInfoList.remove(0);
                }
            } else {
                errorInfoList = new ArrayList<HashMap<String, String>>(5);
                task.getProcessLocalInfo().put("errorinfo", errorInfoList);
            }
            if (error != null) {
                if (error.toString().length() > 250) {
                    errorInfo.put("exc", error.toString().substring(0, 250));
                } else {
                    errorInfo.put("exc", error.toString());
                }
            }
            if (this.isNoSpaceError(error)) {
                errorInfoList.add(errorInfo);
                return errorInfo;
            }
            if ((error instanceof UnzipError || error instanceof ShaCheckError || this.isIoError(error)) && (taskFile = DownloadRequestManager.this.getTaskFile(task)) != null && taskFile.exists()) {
                errorInfo.put("filesize", String.valueOf(taskFile.length()));
            }
            if ((taskFile = DownloadRequestManager.this.getTaskFile(task)) != null) {
                File parent = taskFile.getParentFile();
                if (parent == null || !parent.exists() || !parent.isDirectory()) {
                    errorInfo.put("nodir", String.valueOf("1"));
                }
                errorInfo.put("name", taskFile.getName());
            }
            errorInfo.put("useuptime", String.valueOf(request.getExtendParamLong(DownloadRequest.ExtendKey.NETWORK_USE_TIME)));
            errorInfo.put("cthreaduptime", String.valueOf(request.getExtendParamLong(DownloadRequest.ExtendKey.THREAD_USE_TIME)));
            int httpCode = request.getExtendParamInt(DownloadRequest.ExtendKey.RESPONSE_CODE);
            if (httpCode != -1) {
                errorInfo.put("httpcode", String.valueOf(httpCode));
                errorInfo.put("etag", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.ETAG)));
                errorInfo.put("contentlength", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.CONTENT_LENGTH)));
                errorInfo.put("contentlocation", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.CONTENT_LOCATION)));
                errorInfo.put("contenttype", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.CONTENT_TYPE)));
                errorInfo.put("location", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.LOCATION)));
                errorInfo.put("dsize", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.RECEIVED_SIZE)));
            }
            if (request.getExtendParam(DownloadRequest.ExtendKey.SPACE_INFO) != null) {
                errorInfo.put("spaceinfo", String.valueOf(request.getExtendParam(DownloadRequest.ExtendKey.SPACE_INFO)));
            }
            if ((renameError = request.getExtendParamInt(DownloadRequest.ExtendKey.RENAME_ERROR)) == 1) {
                errorInfo.put("renameerror", String.valueOf(renameError));
                errorInfo.put("notempfile", String.valueOf(request.getExtendParamInt(DownloadRequest.ExtendKey.TEMP_FILE_NOT_EXIST)));
                errorInfo.put("tempfilesize", String.valueOf(request.getExtendParamInt(DownloadRequest.ExtendKey.TEMP_FILE_SIZE)));
            }
            errorInfo.put("url", request.getExtendParam(DownloadRequest.ExtendKey.URL));
            errorInfo.put("net", String.valueOf(DownloadRequestManager.this.mNetWorkType));
            errorInfo.put("netc", DownloadRequestManager.this.mIsNetConnected ? "1" : "0");
            errorInfoList.add(errorInfo);
            return errorInfo;
        }

        private String getPenultimateExceptionInfo(DownloadTask task) {
            ArrayList errorInfoList = null;
            Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
            if (tempErrorInfoObject instanceof ArrayList) {
                errorInfoList = (ArrayList)tempErrorInfoObject;
            }
            if (errorInfoList == null || errorInfoList.size() < 2) {
                return null;
            }
            return (String)((HashMap)errorInfoList.get(errorInfoList.size() - 2)).get("exc");
        }

        private HashMap<String, String> getLastExceptionInfo(DownloadTask task) {
            ArrayList errorInfoList = null;
            Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
            if (tempErrorInfoObject instanceof ArrayList) {
                errorInfoList = (ArrayList)tempErrorInfoObject;
            }
            if (errorInfoList == null || errorInfoList.size() < 1) {
                return null;
            }
            return (HashMap)errorInfoList.get(errorInfoList.size() - 1);
        }

        private boolean isEtagError(Exception error) {
            if (error instanceof EtagError) {
                return true;
            }
            return error != null && error.getCause() instanceof EtagError;
        }

        private boolean shouldJudgeResponedContent(HashMap<String, String> errorInfo) {
            if (errorInfo == null) {
                return false;
            }
            String contentLength = errorInfo.get("contentlength");
            if (contentLength == null || contentLength.length() <= 0) {
                return false;
            }
            String exception = errorInfo.get("exc");
            if (exception != null && StringUtils.equal((String)"1", (String)errorInfo.get("netc")) && !StringUtils.equal((String)"1", (String)errorInfo.get("wnet"))) {
                String httpCode = errorInfo.get("httpcode");
                String contentType = errorInfo.get("contenttype");
                boolean judgeContentType = false;
                if (exception.contains("EtagError")) {
                    judgeContentType = true;
                } else if (exception.contains("com.yy.mobile.http.ServerError")) {
                    int httpCodeInt = -1;
                    try {
                        httpCodeInt = Integer.parseInt(httpCode);
                    }
                    catch (Exception e) {
                        Log.e((String)"DownloadRequest", (String)(" error ignore: " + e.getMessage()));
                    }
                    if (httpCodeInt >= 400 && httpCodeInt <= 599) {
                        judgeContentType = true;
                    }
                }
                if (judgeContentType) {
                    if (StringUtils.equal((String)"text/html", (String)contentType)) {
                        return true;
                    }
                    if (contentType != null && contentType.startsWith("text/html;")) {
                        return true;
                    }
                }
            }
            return false;
        }

        private void notifyErrorAfterCollectHtmlError(final DownloadRequest request, final DownloadTask task, final Exception error) {
            if (task == null) {
                return;
            }
            boolean needCollectHtml = false;
            HashMap lastErrorInfo = null;
            ArrayList errorInfoList = null;
            Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
            if (tempErrorInfoObject instanceof ArrayList) {
                errorInfoList = (ArrayList)tempErrorInfoObject;
            }
            if (errorInfoList != null && errorInfoList.size() >= 3 && this.shouldJudgeResponedContent(lastErrorInfo = (HashMap)errorInfoList.get(errorInfoList.size() - 1)) && this.shouldJudgeResponedContent((HashMap)errorInfoList.get(errorInfoList.size() - 2)) && this.shouldJudgeResponedContent((HashMap)errorInfoList.get(errorInfoList.size() - 3))) {
                needCollectHtml = true;
            }
            if (needCollectHtml) {
                final HashMap fLastErrorInfo = lastErrorInfo;
                final String taskUrl = task.getString("url");
                final Object[] htmlResult = new Object[1];
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        htmlResult[0] = DownloadUtil.getHtmlContent(taskUrl);
                    }
                }, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (fLastErrorInfo != null && htmlResult[0] instanceof String) {
                            fLastErrorInfo.put("fhead", (String)htmlResult[0]);
                        }
                        RetryManager.this.notifyError(request, task, error);
                    }
                });
            } else {
                this.notifyError(request, task, error);
            }
        }

        private void handleError(DownloadTask task, DownloadRequest request, Exception error) {
            int retryTimes = task.getInt("mrtimes");
            int curRetryTimes = task.getInt("crtimes");
            if (retryTimes <= 0 || retryTimes <= curRetryTimes) {
                this.notifyErrorAfterCollectHtmlError(request, task, error);
                return;
            }
            if (this.isNoSpaceError(error)) {
                this.handleNoSpaceOnDevice(request, task, error);
            } else if (error instanceof UnzipError) {
                this.handleUnzipError(request, task, error);
            } else if (this.isEtagError(error)) {
                this.deleteDownloadFile(request, task);
                HashMap<String, String> lastErrorInfo = this.getLastExceptionInfo(task);
                if (lastErrorInfo != null && !StringUtils.equal((String)"1", (String)lastErrorInfo.get("pnet"))) {
                    this.retryAfterPingBaiduSuccess(task, request, error, 0);
                } else {
                    this.useRetry(task);
                }
            } else if (error instanceof ShaCheckError) {
                this.deleteDownloadFile(request, task);
                String exceptionInfo = this.getPenultimateExceptionInfo(task);
                if (!StringUtils.isEmpty((String)exceptionInfo) && exceptionInfo.contains("ShaCheckError")) {
                    this.useRetry(task);
                } else {
                    this.retryTask(task, request, true, 0L);
                }
            } else if (error instanceof EmptyFileError) {
                this.deleteDownloadFile(request, task);
                String exceptionInfo = this.getPenultimateExceptionInfo(task);
                if (!StringUtils.isEmpty((String)exceptionInfo) && exceptionInfo.contains("EmptyFileError")) {
                    this.retryTask(task, null, true, 0L);
                } else {
                    this.retryTask(task, request, true, 0L);
                }
            } else if (!DownloadRequestManager.this.mIsNetConnected || DownloadRequestManager.this.mCheckingNet) {
                int delayTime = this.getDelayTime(task, task.getInt("crtimes"));
                this.retryTask(task, request, false, delayTime);
            } else if (this.isFileNotFoundExceptionError(error) || this.isFileNotFoundExceptionError(error.getCause())) {
                this.handleFileNotFoundExceptionError(request, task, error);
            } else if (this.isThrowableHostError(error) || this.isThrowableHostError(error.getCause())) {
                this.handleHostError(task, request);
            } else if (this.isConnectTimeoutException(error)) {
                this.handleConnectTimeoutException(task, request);
            } else {
                int delayTime = this.getDelayTime(task, task.getInt("crtimes"));
                this.retryTask(task, null, false, delayTime);
            }
            DownloadRequestManager.this.excuteNextDownloadTasks();
        }

        private boolean isThrowableHostError(Throwable throwable) {
            if (throwable instanceof UnknownHostException) {
                return true;
            }
            return throwable instanceof NoRouteToHostException;
        }

        private boolean isConnectTimeoutException(Exception error) {
            if (error instanceof ConnectTimeoutException) {
                return true;
            }
            return error != null && error.getCause() instanceof ConnectTimeoutException;
        }

        private void retryAfterPingBaiduSuccess(final DownloadTask task, final DownloadRequest request, final Exception error, final int retryConncetTimes) {
            if (retryConncetTimes >= 10) {
                this.retryTask(task, request, false);
                return;
            }
            final Object[] connectBaiduResult = new Object[1];
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    connectBaiduResult[0] = NetworkUtils.pingHost((String)"www.google.com");
                }
            }, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (connectBaiduResult[0] instanceof Boolean) {
                        if (((Boolean)connectBaiduResult[0]).booleanValue()) {
                            int delayTime = RetryManager.this.getDelayTime(task, task.getInt("crtimes"));
                            RetryManager.this.retryTask(task, request, false, delayTime);
                        } else {
                            RetryManager.this.retryAfterPingBaiduSuccess(task, request, error, retryConncetTimes + 1);
                        }
                    }
                }
            }, (long)60000L);
        }

        private void useRetry(DownloadTask task) {
            int delayTime = this.getDelayTime(task, task.getInt("crtimes"));
            DownloadRequest realRequest = DownloadRequestManager.this.createRequest(task);
            if (realRequest != null) {
                this.retryTask(task, realRequest, false, delayTime);
            }
        }

        private void retryAfterConnectGoogleSuccess(final DownloadTask task, final DownloadRequest request, final int retryConncetTimes) {
            if (retryConncetTimes >= 10) {
                this.retryTask(task, request, false);
                return;
            }
            final Object[] connectBaiduResult = new Object[1];
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    connectBaiduResult[0] = DownloadUtil.isNetWorkOkByConnectedGoogle();
                }
            }, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (connectBaiduResult[0] instanceof Boolean) {
                        if (((Boolean)connectBaiduResult[0]).booleanValue()) {
                            int delayTime = RetryManager.this.getDelayTime(task, task.getInt("crtimes"));
                            RetryManager.this.retryTask(task, request, false, delayTime);
                        } else {
                            RetryManager.this.retryAfterConnectGoogleSuccess(task, request, retryConncetTimes + 1);
                        }
                    }
                }
            }, (long)60000L);
        }

        private void handleConnectTimeoutException(DownloadTask task, DownloadRequest request) {
            String exceptionInfo = this.getPenultimateExceptionInfo(task);
            if (!StringUtils.isEmpty((String)exceptionInfo) && exceptionInfo.contains("org.apache.com.yy.mobile.http.conn.ConnectTimeoutException: Connect to")) {
                this.useRetry(task);
            } else {
                int delayTime = this.getDelayTime(task, task.getInt("crtimes"));
                this.retryTask(task, null, false, delayTime);
            }
        }

        private void handleHostError(DownloadTask task, DownloadRequest request) {
            HashMap<String, String> lastErrorInfo = this.getLastExceptionInfo(task);
            if (lastErrorInfo != null && StringUtils.equal((String)"1", (String)lastErrorInfo.get("wnet"))) {
                this.retryAfterConnectGoogleSuccess(task, request, 0);
            } else {
                this.useRetry(task);
            }
        }

        private void onDownloadErrorResponse(final DownloadTask task, final DownloadRequest request, final Exception error) {
            if (task == null || request == null || !DownloadRequestManager.this.mSubmitedTasks.containsKey(task)) {
                DownloadRequestManager.this.excuteNextDownloadTasks();
                return;
            }
            DownloadRequestManager.this.mSubmitedTasks.remove(task);
            DownloadRequestManager.this.addRetryTask(task);
            DownloadRequestManager.this.updateNetWorkInfo();
            this.printErrorInfo(task, request, error);
            final HashMap<String, String> errorInfo = this.addErrorInfo(task, request, error);
            final File taskFile = DownloadUtil.getTaskFile(task);
            final boolean needGetFileHeadAndTail = errorInfo != null && error instanceof ShaCheckError;
            final boolean needEnsureDir = errorInfo != null && taskFile != null && StringUtils.equal((String)"1", (String)errorInfo.get("nodir"));
            final boolean needPingBaidu = this.isEtagError(error);
            final boolean needConnectBaidu = errorInfo != null && DownloadRequestManager.this.mIsNetConnected && this.needCollectNetInfo(error);
            final Object[] getFileHeadAndTailResult = new Object[2];
            final Object[] connectBaiduErrorResult = new Object[1];
            final Object[] pingBaiduResult = new Object[1];
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean result;
                    File parent;
                    if (needGetFileHeadAndTail) {
                        getFileHeadAndTailResult[0] = DownloadUtil.readFileHead(taskFile);
                        getFileHeadAndTailResult[1] = DownloadUtil.readFileTail(taskFile);
                    }
                    if (needConnectBaidu) {
                        connectBaiduErrorResult[0] = !DownloadUtil.isNetWorkOkByConnectedGoogle();
                    }
                    if (needEnsureDir && (parent = taskFile.getParentFile()) != null && !(result = parent.mkdirs()) && parent.getPath() != null) {
                        MLog.error((Object)DownloadRequestManager.TAG, (String)("ensureDownloadDir error:" + parent.getPath()), (Object[])new Object[0]);
                    }
                    if (needPingBaidu) {
                        pingBaiduResult[0] = NetworkUtils.pingHost((String)"www.google.com");
                    }
                }
            }, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (needGetFileHeadAndTail) {
                        if (getFileHeadAndTailResult[0] instanceof String) {
                            errorInfo.put("fhead", (String)getFileHeadAndTailResult[0]);
                        }
                        if (getFileHeadAndTailResult[1] instanceof String) {
                            errorInfo.put("ftail", (String)getFileHeadAndTailResult[1]);
                        }
                    }
                    if (needConnectBaidu && connectBaiduErrorResult[0] instanceof Boolean) {
                        errorInfo.put("wnet", (Boolean)connectBaiduErrorResult[0] != false ? "1" : "0");
                    }
                    if (needPingBaidu && pingBaiduResult[0] instanceof Boolean) {
                        errorInfo.put("pnet", (Boolean)pingBaiduResult[0] != false ? "1" : "0");
                    }
                    RetryManager.this.handleError(task, request, error);
                }
            }, (long)(needEnsureDir ? 90000L : 0L));
        }

        private boolean needCollectNetInfo(Exception error) {
            return !this.isNoSpaceError(error) && !(error instanceof UnzipError);
        }

        private int getDelayTime(DownloadTask task, int curRetryTimes) {
            if (curRetryTimes <= 0) {
                return 5000;
            }
            if (curRetryTimes == 1) {
                return 10000;
            }
            if (curRetryTimes == 2 || curRetryTimes == 3) {
                return 20000;
            }
            if (curRetryTimes == 4 || curRetryTimes == 5) {
                return 40000;
            }
            if (DownloadUtil.isScreenOn(RuntimeContext.sApplicationContext)) {
                return 180000;
            }
            return 600000;
        }

        private boolean isFileNotFoundExceptionError(Throwable throwable) {
            return throwable instanceof FileNotFoundException;
        }

        private void handleUnzipError(final DownloadRequest request, final DownloadTask task, Exception error) {
            File taskFile;
            int curRetryTimes = task.getInt("crtimes");
            String fileSha1 = null;
            if (request != null) {
                fileSha1 = request.getExtendParam(DownloadRequest.ExtendKey.ETAG);
            }
            if ((taskFile = DownloadUtil.getTaskFile(task)) != null && !StringUtils.isEmpty((String)fileSha1)) {
                final String taskFilePath = taskFile.getPath();
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean success = true;
                        UnzipError error = null;
                        try {
                            DownloadUtil.unzip(taskFilePath, taskFilePath);
                        }
                        catch (UnzipError e) {
                            success = false;
                            error = e;
                        }
                        final boolean result = success;
                        UnzipError errorResult = error;
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (result) {
                                    if (DownloadRequestManager.this.mSubmitedTasks.containsKey(task)) {
                                        DownloadRequestManager.this.mSubmitedTasks.remove(task);
                                        if (DownloadRequestManager.this.mListener != null) {
                                            DownloadRequestManager.this.mListener.onSuccess(task);
                                        }
                                    }
                                    DownloadRequestManager.this.excuteNextDownloadTasks();
                                } else {
                                    RetryManager.this.deleteDownloadFile(request, task);
                                    RetryManager.this.retryTask(task, request, true, 0L);
                                }
                            }
                        });
                    }
                }, (long)this.getDelayTime(task, curRetryTimes));
            } else {
                this.deleteDownloadFile(request, task);
                this.retryTask(task, request, true, 0L);
            }
        }

        private boolean isIoError(Exception error) {
            Throwable cause;
            if (error instanceof IOException) {
                return true;
            }
            return error != null && (cause = error.getCause()) instanceof IOException;
        }

        private boolean isNoSpaceError(Exception error) {
            boolean noSpaceOnDevice = false;
            if (error instanceof IOException) {
                if (error.toString().contains("No space left on device")) {
                    noSpaceOnDevice = true;
                }
            } else {
                Throwable cause = error.getCause();
                if (cause instanceof IOException && cause.toString().contains("No space left on device")) {
                    noSpaceOnDevice = true;
                }
            }
            return noSpaceOnDevice;
        }

        private void handleNoSpaceOnDevice(DownloadRequest request, DownloadTask task, Exception error) {
            this.notifyError(request, task, error);
        }

        private void handleFileNotFoundExceptionError(DownloadRequest request, DownloadTask task, Exception error) {
            int delayTime = this.getDelayTime(task, task.getInt("crtimes"));
            this.retryTask(task, request, false, delayTime);
        }
    }
}

