/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request;

import android.os.SystemClock;
import android.util.SparseArray;
import com.yy.base.logger.MLog;
import com.yy.base.net.NetworkConnection;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.network.MyDownloadContinueNetwork;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.network.MyDownloadNetwork;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.IRequestStartedListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.error.EtagError;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.HttpHeaderParser;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.NoCache;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.http.StringQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadRequest
extends StringQueryRequest {
    private static final String TAG = "DownloadRequest";
    public static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 15000;
    private static final int MAX_RETRIES = 2;
    private static final float BACKOFF_MULT = 1.0f;
    private static final String THRESHOLD_TYPE = "DownloadCenter";
    private IRequestStartedListener mStartedListener;
    private final SparseArray<Object> mExtendParams = new SparseArray();
    private int mConnectTimeOutMs = 15000;
    private int mEtagCheckType = 1;
    private String mUseLocalEtag = "";
    private String mDownloadGroup = "DownloadCenter";
    private int mMaxConcurrency = 1;
    private long mSpeedLimitValuePerMicSecond = -1L;
    private long mProgressInterval = -1L;
    private String mDownloadType = "";

    DownloadRequest(String url, String downloadFilePath, boolean useContinueDownload) {
        this(url, downloadFilePath, useContinueDownload, 15000, 10000);
    }

    DownloadRequest(String url, String downloadFilePath, boolean useContinueDownload, int connectTimeOutMs, int readTimeOutMs) {
        super((Cache)new NoCache(), url, null, null);
        if (downloadFilePath == null || downloadFilePath.length() == 0) {
            HttpLog.e("DownloadFilePath is empty.", new Object[0]);
            return;
        }
        this.mNetwork = useContinueDownload ? new MyDownloadContinueNetwork(downloadFilePath, this) : new MyDownloadNetwork(downloadFilePath, this);
        if (connectTimeOutMs > 0) {
            this.mConnectTimeOutMs = connectTimeOutMs;
        }
        this.setShouldCache(false);
        this.setRetryPolicy(new DefaultRetryPolicy(readTimeOutMs > 0 ? readTimeOutMs : 10000, 2, 1.0f));
    }

    public void setStartPos(long startPos) {
        if (this.mNetwork instanceof MyDownloadContinueNetwork) {
            ((MyDownloadContinueNetwork)this.mNetwork).setStartPos(startPos);
        }
    }

    public void setEtagCheckType(int etagCheckType) {
        this.mEtagCheckType = etagCheckType;
    }

    public void setDownloadGroup(String group, int maxConcurrency) {
        if (StringUtils.isNotEmpty((String)group)) {
            this.mDownloadGroup = group;
        }
        this.mMaxConcurrency = maxConcurrency;
    }

    public void setDownloadType(String type) {
        this.mDownloadType = type;
    }

    public void setTaskSpeedLimitPerMicsecondValue(long value) {
        if (this.mNetwork instanceof MyDownloadContinueNetwork) {
            ((MyDownloadContinueNetwork)this.mNetwork).setTaskSpeedLimitPerMicsecondValue(value);
            this.mSpeedLimitValuePerMicSecond = value;
        }
    }

    public void setProgressInterval(long value) {
        if (this.mNetwork instanceof MyDownloadContinueNetwork) {
            ((MyDownloadContinueNetwork)this.mNetwork).setProgressInterval(value);
            this.mProgressInterval = value;
        }
    }

    public long getSpeedLimitValuePerMicSecond() {
        return this.mSpeedLimitValuePerMicSecond;
    }

    public void setLocalEtagContent(String content) {
        this.mUseLocalEtag = content;
    }

    public void deleteTempFile() {
        if (this.mNetwork instanceof MyDownloadContinueNetwork) {
            ((MyDownloadContinueNetwork)this.mNetwork).deleteTempFile();
        } else if (this.mNetwork instanceof MyDownloadNetwork) {
            ((MyDownloadNetwork)this.mNetwork).deleteTempFile();
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"deleteTempFile()", (Object[])new Object[0]);
        }
    }

    public static DefaultRetryPolicy createPolicy(int readTimeOutMs) {
        return new DefaultRetryPolicy(readTimeOutMs > 0 ? readTimeOutMs : 10000, 2, 1.0f);
    }

    private void addStat(int key, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        this.setExtendParam(key, value);
    }

    public void onHttpResponsed(int statusCode, Request<?> request, NetworkConnection.Connected connected) throws ServerError {
        this.setExtendParam(ExtendKey.RESPONSE_CODE, statusCode);
        Map headers = connected.getResponseHeaderFields();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            responseHeaders.put(key, (String)((List)headers.get(key)).get(0));
        }
        if (responseHeaders.size() > 0) {
            if (!StringUtils.isEmpty((String)this.mUseLocalEtag)) {
                this.addStat(ExtendKey.ETAG, this.mUseLocalEtag);
            } else {
                this.addStat(ExtendKey.ETAG, HttpHeaderParser.getETag(responseHeaders));
            }
            this.addStat(ExtendKey.CONTENT_TYPE, (String)responseHeaders.get("Content-Type"));
            this.addStat(ExtendKey.CONTENT_LENGTH, (String)responseHeaders.get("Content-Length"));
            this.addStat(ExtendKey.CONTENT_LOCATION, (String)responseHeaders.get("Content-Location"));
            this.addStat(ExtendKey.LOCATION, (String)responseHeaders.get("Location"));
        }
        if ((this.mEtagCheckType == 2 || this.mEtagCheckType == 3) && StringUtils.isEmpty((String)this.mUseLocalEtag) && statusCode >= 200 && statusCode <= 299) {
            if (StringUtils.isEmpty((String)this.getExtendParam(ExtendKey.ETAG))) {
                throw new EtagError("response etag empty", 60, statusCode);
            }
            if (this.mEtagCheckType == 2 && this.getExtendParam(ExtendKey.ETAG).length() != 40) {
                throw new EtagError("response etag is not sha1 key :" + this.getExtendParam(ExtendKey.ETAG), 60, statusCode);
            }
            if (this.mEtagCheckType == 3 && this.getExtendParam(ExtendKey.ETAG).length() != 32) {
                throw new EtagError("response etag is not Md5 key :" + this.getExtendParam(ExtendKey.ETAG), 60, statusCode);
            }
        }
    }

    public void onReceivedSizeUpdated(long size) {
        this.addStat(ExtendKey.RECEIVED_SIZE, String.valueOf(size));
    }

    public void onIOExceptionWithNoSpace(String spaceInfo) {
        if (spaceInfo != null) {
            this.setExtendParam(ExtendKey.SPACE_INFO, spaceInfo);
        }
    }

    public void onRenameError(boolean tempFileExisted, long tempFileSize) {
        this.setExtendParam(ExtendKey.RENAME_ERROR, 1);
        if (!tempFileExisted) {
            this.setExtendParam(ExtendKey.TEMP_FILE_NOT_EXIST, 1);
        } else {
            this.setExtendParam(ExtendKey.TEMP_FILE_SIZE, tempFileSize);
        }
    }

    public String getExtendParam(int paramKey) {
        if (this.mExtendParams.get(paramKey) instanceof String) {
            return (String)this.mExtendParams.get(paramKey);
        }
        return "";
    }

    public long getExtendParamLong(int paramKey) {
        if (this.mExtendParams.get(paramKey) instanceof Long) {
            return (Long)this.mExtendParams.get(paramKey);
        }
        return -1L;
    }

    public int getExtendParamInt(int paramKey) {
        if (this.mExtendParams.get(paramKey) instanceof Integer) {
            return (Integer)this.mExtendParams.get(paramKey);
        }
        return -1;
    }

    public boolean getExtendParamBoolean(int paramKey) {
        if (this.mExtendParams.get(paramKey) instanceof Boolean) {
            return (Boolean)this.mExtendParams.get(paramKey);
        }
        return false;
    }

    private void setExtendParam(int paramKey, Object object) {
        this.mExtendParams.put(paramKey, object);
    }

    public void onPerform() {
        if (this.mStartedListener != null) {
            this.mStartedListener.onStarted(this);
        }
        this.mExtendParams.clear();
        if (!StringUtils.isEmpty((String)this.getUrl())) {
            if (this.getHeaders().containsKey("Host")) {
                this.setExtendParam(ExtendKey.URL, this.getUrl() + " host: " + this.getHeaders().get("Host"));
            } else {
                this.setExtendParam(ExtendKey.URL, this.getUrl());
            }
        }
        this.setExtendParam(ExtendKey.RECEIVED_SIZE, String.valueOf(-1));
        this.setExtendParam(ExtendKey.START_TIME, SystemClock.elapsedRealtime());
        this.setExtendParam(ExtendKey.START_TIME_THREAD, SystemClock.currentThreadTimeMillis());
        this.setExtendParam(ExtendKey.DOWNLOAD_TYPE, this.mDownloadType);
    }

    public void onPerformEnd(RequestError e) {
        long requestThreadUseTime;
        long requestNetUseTime = SystemClock.elapsedRealtime() - this.getExtendParamLong(ExtendKey.START_TIME);
        if (requestNetUseTime > 0L && this.mSpeedLimitValuePerMicSecond <= 0L) {
            this.setExtendParam(ExtendKey.NETWORK_USE_TIME, requestNetUseTime);
        }
        if ((requestThreadUseTime = SystemClock.currentThreadTimeMillis() - this.getExtendParamLong(ExtendKey.START_TIME_THREAD)) > 0L) {
            this.setExtendParam(ExtendKey.THREAD_USE_TIME, requestThreadUseTime);
        }
        this.setExtendParam(ExtendKey.DOWNLOAD_TYPE, this.mDownloadType);
    }

    public void onRange(long range) {
        this.setExtendParam(ExtendKey.START_RANGE, range);
    }

    public void setStartedListener(IRequestStartedListener listener) {
        this.mStartedListener = listener;
    }

    @Override
    public void setConnectTimeoutMs(int timeoutMs) {
        this.mConnectTimeOutMs = timeoutMs;
    }

    @Override
    public int getThreshold() {
        return this.mMaxConcurrency > 0 ? this.mMaxConcurrency : 1;
    }

    @Override
    public int getConnectTimeoutMs() {
        return this.mConnectTimeOutMs;
    }

    @Override
    public String getThresholdType() {
        return this.mDownloadGroup;
    }

    public static class EtagCheckType {
        public static final int NONE = 1;
        public static final int SHA1 = 2;
        public static final int MD5 = 3;
    }

    public static class ExtendKey {
        public static final int VALUE_TRUE = 1;
        private static int BASE_ID = 1;
        public static final int NETWORK_USE_TIME = BASE_ID++;
        public static final int THREAD_USE_TIME = BASE_ID++;
        public static final int SUBMIT_TIME = BASE_ID++;
        public static final int SUBMIT_UP_TIME = BASE_ID++;
        public static final int RESPONSE_CODE = BASE_ID++;
        public static final int ETAG = BASE_ID++;
        public static final int LOCATION = BASE_ID++;
        public static final int CONTENT_LENGTH = BASE_ID++;
        public static final int CONTENT_TYPE = BASE_ID++;
        public static final int CONTENT_LOCATION = BASE_ID++;
        public static final int RECEIVED_SIZE = BASE_ID++;
        public static final int RENAME_ERROR = BASE_ID++;
        public static final int TEMP_FILE_SIZE = BASE_ID++;
        public static final int TEMP_FILE_NOT_EXIST = BASE_ID++;
        public static final int START_TIME = BASE_ID++;
        public static final int START_TIME_THREAD = BASE_ID++;
        public static final int URL = BASE_ID++;
        public static final int SPACE_INFO = BASE_ID++;
        public static final int START_RANGE = BASE_ID++;
        public static final int DOWNLOAD_TYPE = BASE_ID++;
    }
}

