/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.model;

import android.content.Context;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.model.DownloadTaskDataBaseHelper;
import java.io.File;
import java.util.ArrayList;

public class DownloadModel {
    private static final String DATA_BASE = "download_database.db";
    private static final int DATA_BASE_VERION = 1;
    private final ArrayList<DownloadTask> mTasks = new ArrayList();
    private DownloadTaskDataBaseHelper mSqlDataBaseHelper;

    public DownloadModel(Context context) {
        this.mSqlDataBaseHelper = new DownloadTaskDataBaseHelper(context, DATA_BASE, null, 1);
        this.load();
    }

    private void load() {
        ArrayList<DownloadTask> arrayList = this.mSqlDataBaseHelper.load();
        if (arrayList != null && arrayList.size() > 0) {
            this.mTasks.addAll(arrayList);
        }
    }

    public void addTask(DownloadTask task) {
        if (task == null || this.mTasks.contains(task)) {
            return;
        }
        this.mTasks.add(task);
        this.mSqlDataBaseHelper.addTask(task);
    }

    public void deleteTask(DownloadTask task) {
        if (!this.mTasks.contains(task)) {
            return;
        }
        this.mTasks.remove(task);
        this.mSqlDataBaseHelper.deleteTask(task);
    }

    public void updateTaskState(DownloadTask task, int state) {
        if (!this.mTasks.contains(task)) {
            return;
        }
        if (task != null && state != task.getInt("state")) {
            task.putInt("state", state);
            this.mSqlDataBaseHelper.updateState(task);
        }
    }

    public void updateTaskRetryTimes(DownloadTask task, int retryTimes) {
        if (!this.mTasks.contains(task)) {
            return;
        }
        if (task != null && retryTimes != task.getInt("crtimes")) {
            task.putInt("crtimes", retryTimes);
            this.mSqlDataBaseHelper.updateRetryTimes(task);
        }
    }

    public void updateTaskProgress(DownloadTask task, long total, long cursize) {
        if (!this.mTasks.contains(task)) {
            return;
        }
        if (task != null) {
            task.putLong("size", total);
            task.putLong("cursize", cursize);
            this.mSqlDataBaseHelper.updateProgress(task);
        }
    }

    public boolean contain(DownloadTask task) {
        return task == null ? false : this.mTasks.contains(task);
    }

    public DownloadTask findTask(String requestUrl) {
        if (StringUtils.isEmpty((String)requestUrl)) {
            return null;
        }
        DownloadTask result = null;
        for (DownloadTask task : this.mTasks) {
            if (task == null || !StringUtils.equal((String)requestUrl, (String)task.getString("url"), (boolean)true)) continue;
            result = task;
            break;
        }
        return result;
    }

    public DownloadTask findTask(String dirPath, String fileName) {
        if (StringUtils.isEmpty((String)dirPath) || StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        DownloadTask result = null;
        String tempDirPath = null;
        for (DownloadTask task : this.mTasks) {
            if (task == null || !StringUtils.equal((String)fileName, (String)task.getString("filename"), (boolean)true)) continue;
            tempDirPath = task.getString("path");
            if (!dirPath.endsWith(File.separator)) {
                if (tempDirPath.endsWith(File.separator)) {
                    dirPath = dirPath + File.separator;
                }
            } else if (!tempDirPath.endsWith(File.separator)) {
                tempDirPath = tempDirPath + File.separator;
            }
            if (!StringUtils.equal((String)dirPath, (String)tempDirPath, (boolean)true)) continue;
            result = task;
            break;
        }
        return result;
    }

    public ArrayList<DownloadTask> getAllTasks() {
        return this.mTasks;
    }
}

