/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service;

import android.content.Intent;
import android.os.Message;
import com.yy.base.logger.MLog;
import com.yy.mobile.backgroundprocess.ContextManager;
import com.yy.mobile.backgroundprocess.services.AbstractBackgroundService;
import com.yy.mobile.backgroundprocess.services.IBackgroundProcessListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.MessageDef;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.DownloadStatsHelper;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadProcesser;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.DownloadCenter;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.IDownloadListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.DefaultDownloadProcesser;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.IDownloadMessageSender;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.plugin.DifferenceCombinationPlugin;
import java.util.Iterator;
import java.util.LinkedList;

@Deprecated
public class DownloadService
extends AbstractBackgroundService
implements IDownloadListener,
IDownloadMessageSender {
    private static final String TAG = "bgprocess:DownloadService";
    private final LinkedList<IDownloadProcesser> mProcesserList = new LinkedList();
    private DownloadCenter mDownloadCenter;

    public DownloadService(int serviceId, IBackgroundProcessListener callback) {
        super(serviceId, callback);
        this.mDownloadCenter = new DownloadCenter(callback, this);
        this.createDownloadProcessers();
        for (IDownloadProcesser listener : this.mProcesserList) {
            if (!listener.restoreAllTasks()) continue;
            return;
        }
    }

    private void createDownloadProcessers() {
        DefaultDownloadProcesser processer = new DefaultDownloadProcesser(this.mDownloadCenter, this);
        this.mProcesserList.add(new DifferenceCombinationPlugin(this.mDownloadCenter, this, processer));
        this.mProcesserList.add(processer);
    }

    @Override
    public void handleMessage(Message message) {
        if (message == null) {
            return;
        }
        super.handleMessage(message);
        int msgType = message.what;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("handleMessage:" + msgType + " data:" + message.getData()), (Object[])new Object[0]);
        }
        if (msgType == MessageDef.ClientSendMessage.CREATE_TASK) {
            DownloadTask task = DownloadTask.newDownloadTask(message.getData());
            for (IDownloadProcesser listener : this.mProcesserList) {
                if (!listener.createTask(task)) continue;
                return;
            }
        } else if (msgType == MessageDef.ClientSendMessage.START_TASK) {
            DownloadTask task = DownloadTask.newDownloadTask(message.getData());
            for (IDownloadProcesser listener : this.mProcesserList) {
                if (!listener.startTask(task)) continue;
                return;
            }
        } else if (msgType == MessageDef.ClientSendMessage.DELETE_TASK) {
            DownloadTask task = DownloadTask.newDownloadTask(message.getData());
            for (IDownloadProcesser listener : this.mProcesserList) {
                if (!listener.deleteTask(task, message.arg2 == 1)) continue;
                return;
            }
        } else if (msgType == MessageDef.ClientSendMessage.PAUSE_TASK) {
            DownloadTask task = DownloadTask.newDownloadTask(message.getData());
            for (IDownloadProcesser listener : this.mProcesserList) {
                if (!listener.pauseTask(task)) continue;
                return;
            }
        } else {
            for (IDownloadProcesser listener : this.mProcesserList) {
                if (!listener.handleExtraMsg(message)) continue;
                return;
            }
        }
    }

    @Override
    public void onTaskStateUpdated(DownloadTask task, int oldState) {
        int newState = task.getInt("state", 1);
        if (this.mProcessListener != null && this.mProcessListener.isDownloadCollectDataSwitchOn()) {
            if (newState == 4) {
                DownloadStatsHelper.addDownloadErrorStats(ContextManager.getApplicationContext(), task, this.mProcessListener.getUid(), true);
            } else if (newState == 5) {
                DownloadStatsHelper.addDownloadSuccessStats(ContextManager.getApplicationContext(), task, this.mProcessListener.getUid(), true);
            }
        }
        for (IDownloadProcesser listener : this.mProcesserList) {
            if (!listener.onTaskStateUpdated(task, oldState)) continue;
            return;
        }
    }

    @Override
    public void onTaskDeleted(DownloadTask task) {
        for (IDownloadProcesser listener : this.mProcesserList) {
            if (!listener.onTaskDeleted(task)) continue;
            return;
        }
    }

    @Override
    public void onTaskRetry(DownloadTask task) {
        IDownloadProcesser listener;
        int maxRetryTimes;
        Object hasCollectError;
        if (this.mProcessListener != null && task != null && this.mProcessListener.isDownloadCollectDataSwitchOn() && ((hasCollectError = task.getProcessLocalInfo().get("datacollected")) == null || hasCollectError instanceof Boolean && !((Boolean)hasCollectError).booleanValue()) && (maxRetryTimes = task.getInt("mrtimes")) > 10 && task.getInt("crtimes") == 5) {
            DownloadStatsHelper.addDownloadErrorStats(ContextManager.getApplicationContext(), task, this.mProcessListener.getUid(), true);
            task.getProcessLocalInfo().put("datacollected", true);
        }
        Iterator iterator = this.mProcesserList.iterator();
        while (iterator.hasNext() && !(listener = (IDownloadProcesser)iterator.next()).onTaskRetry(task)) {
        }
    }

    @Override
    public void onTaskCreated(DownloadTask task) {
        for (IDownloadProcesser listener : this.mProcesserList) {
            if (!listener.onTaskCreated(task)) continue;
            return;
        }
    }

    @Override
    public void onTaskProgressUpdated(DownloadTask task, long oldSize) {
        for (IDownloadProcesser listener : this.mProcesserList) {
            if (!listener.onTaskProgressUpdated(task, oldSize)) continue;
            return;
        }
    }

    @Override
    public boolean sendMessageToClients(Message message) {
        return super.sendMessageToClients(message);
    }

    @Override
    public void handleBroadcastEvent(Intent intent) {
        String intentAction;
        if (intent != null && "android.net.conn.CONNECTIVITY_CHANGE".equals(intentAction = intent.getAction())) {
            this.mDownloadCenter.onNetConnectChanged();
        }
    }
}

