/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.processprotecter;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import com.yy.base.logger.MLog;
import com.yy.mobile.backgroundprocess.RemoteBackgroundProcess;
import com.yy.mobile.backgroundprocess.Util.ReflectionHelper;
import com.yy.mobile.backgroundprocess.processprotecter.ForegroundAssistService;

public class ServiceForegroundHelper {
    private static final String TAG = "ServiceForgroundUtil";
    private final int mPid = Process.myPid();
    private Service mTargetService;
    private AssistServiceConnection mConnection;

    public ServiceForegroundHelper(Service targetService) {
        this.mTargetService = targetService;
    }

    public void startForeground(Class<? extends ForegroundAssistService> assistServiceCls) {
        if (null == this.mTargetService) {
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            Notification notification = this.generateNotification(0);
            if (notification != null) {
                this.mTargetService.startForeground(this.mPid, notification);
            }
            return;
        }
        if (null == assistServiceCls) {
            return;
        }
        if (null == this.mConnection) {
            this.mConnection = new AssistServiceConnection();
        }
        this.mTargetService.bindService(new Intent((Context)this.mTargetService, assistServiceCls), (ServiceConnection)this.mConnection, 1);
    }

    public void stopForeground() {
        if (this.mTargetService != null) {
            this.mTargetService.stopForeground(true);
        }
    }

    public static void clearForegroundStatus(Service service) {
        if (service != null) {
            service.stopForeground(true);
        }
    }

    private Notification generateNotification(int iconId) {
        try {
            Intent notificationIntent = new Intent((Context)this.mTargetService, RemoteBackgroundProcess.class);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mTargetService, (int)0, (Intent)notificationIntent, (int)0x8000000);
            Notification.Builder builder = new Notification.Builder((Context)this.mTargetService);
            if (Build.VERSION.SDK_INT >= 16) {
                Notification notification = builder.setSmallIcon(iconId).setContentIntent(pendingIntent).build();
                this.setReflectField(notification, "priority", -2);
                return notification;
            }
            Notification notification = builder.setSmallIcon(iconId).setContentIntent(pendingIntent).getNotification();
            this.setReflectField(notification, "priority", -2);
            return notification;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setReflectField(Object obj, String field, Object value) {
        ReflectionHelper.setReflectField(obj, field, value);
    }

    private class AssistServiceConnection
    implements ServiceConnection {
        private AssistServiceConnection() {
        }

        public void onServiceDisconnected(ComponentName name) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)ServiceForegroundHelper.TAG, (String)"onServiceDisconnected", (Object[])new Object[0]);
            }
        }

        public void onServiceConnected(ComponentName name, IBinder binder) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)ServiceForegroundHelper.TAG, (String)"onServiceConnected", (Object[])new Object[0]);
            }
            int iconId = 10211211;
            ForegroundAssistService assistService = ((ForegroundAssistService.LocalBinder)binder).getService();
            Notification notification = ServiceForegroundHelper.this.generateNotification(iconId);
            if (notification != null) {
                assistService.startForeground(ServiceForegroundHelper.this.mPid, notification);
            }
            if ((notification = ServiceForegroundHelper.this.generateNotification(iconId)) != null) {
                ServiceForegroundHelper.this.mTargetService.startForeground(ServiceForegroundHelper.this.mPid, notification);
            }
            assistService.stopForeground(true);
            ServiceForegroundHelper.this.mTargetService.unbindService((ServiceConnection)ServiceForegroundHelper.this.mConnection);
            ServiceForegroundHelper.this.mConnection = null;
        }
    }
}

