/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.crash;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.ConstDef;
import com.yy.base.env.IApplicationRoute;
import com.yy.base.env.RuntimeContext;
import com.yy.base.fdutils.FdsController;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hago.xlog.IFlushCallback;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hago.xlog.LogBlocker;
import com.yy.sdk.crashreport.CrashReport;
import com.yy.sdk.crashreport.ILog;
import com.yy.sdk.crashreport.anr.ANRDetector;
import com.yy.yylite.crash.CrashHandler;
import com.yy.yylite.crash.CrashSDKLogAdapter;
import com.yy.yylite.crash.CrashUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public enum CrashSdkHelper {
    INSTANCE;

    private static final String TAG = "CrashSdkHelper";
    public static String CRASH_URL;
    public static String ANR_URL;
    public static String FEEDBACK_URL;
    public static String DAU_URL;
    private static final long DELAY_INIT_TIME = 5000L;
    public static final String FOREGROUND = "foreground";
    private boolean sIsCrashing = false;
    private Context mContext;
    private String mAppId;
    private int mAnrCheckInterval = -1;
    private long mUid;
    private String mHdid;
    private final Map<String, String> mExtendInfo = new HashMap<String, String>();
    private static volatile boolean hadInit;
    private ICrashCallBack mCallBack;
    private static volatile boolean mImmediately;
    private static LogBlocker mLogBlocker;
    private static String sSecurityHardeningMd5;
    private Runnable mResetCrashFlagCommand;
    private Runnable mInitSdkRunnable = new Runnable(){

        @Override
        public void run() {
            MLog.info((Object)CrashSdkHelper.TAG, (String)"init runnable to init crash sdk", (Object[])new Object[0]);
            CrashSdkHelper.this.initCrashSdk();
        }
    };
    private CrashReport.CrashCallback mCrashCallback = new CrashReport.CrashCallback(){

        public void preCrashCallback(boolean isNativeCrash, String dumpFile, String dumpSymbolFile, String logFile) {
            String crashInfo;
            MLog.info((Object)CrashSdkHelper.TAG, (String)"preCrashCallback isNativeCrash: %s  dumpFile: %s logFile: %s", (Object[])new Object[]{isNativeCrash, dumpFile, logFile});
            CrashSdkHelper.this.sIsCrashing = true;
            if (CrashSdkHelper.this.mCallBack != null) {
                CrashSdkHelper.this.mCallBack.crashCallback("", isNativeCrash, dumpFile);
            }
            if (!isNativeCrash && !TextUtils.isEmpty((CharSequence)(crashInfo = CrashSdkHelper.this.getCrashInfo(dumpFile)))) {
                MLog.error((Object)"get crash: ", (String)crashInfo, (Object[])new Object[0]);
            }
            CrashSdkHelper.this.appendInfoBeforeCrashOrAnrUpload(false);
            CrashSdkHelper.this.updateCrashOrAnrUserFile(false);
        }

        public void crashCallback(String crashId, boolean isNativeCrash, String dumpFile, String dumpSymbolFile, String logFile) {
            RuntimeContext.onCrash((String)crashId, (boolean)isNativeCrash);
            MLog.info((Object)CrashSdkHelper.TAG, (String)"CrashCallback crashId: %s, isNativeCrash: %s, dumpFile: %s", (Object[])new Object[]{crashId, isNativeCrash, dumpFile});
            if (SettingFlags.getBoolean((String)"crashcfd", (boolean)false)) {
                CrashSdkHelper.this.writeFDList();
            }
        }

        public void afterCrashCallback(String crashId, boolean isNativeCrash, String dumpFile, String dumpSymbolFile, String logFile) {
            MLog.info((Object)CrashSdkHelper.TAG, (String)"afterCrashCallback", (Object[])new Object[0]);
            if (CrashSdkHelper.this.mResetCrashFlagCommand == null) {
                CrashSdkHelper.this.mResetCrashFlagCommand = new Runnable(){

                    @Override
                    public void run() {
                        if (CrashSdkHelper.this.sIsCrashing) {
                            CrashSdkHelper.this.sIsCrashing = false;
                        }
                    }
                };
            } else {
                YYTaskExecutor.removeTask((Runnable)CrashSdkHelper.this.mResetCrashFlagCommand);
            }
            YYTaskExecutor.execute((Runnable)CrashSdkHelper.this.mResetCrashFlagCommand, (long)5000L);
        }
    };

    public void testJavaCrash() {
        if (hadInit) {
            CrashReport.testJavaCrash();
        }
    }

    public void testNativeCrash() {
        if (hadInit) {
            CrashReport.testNativeCrash();
        }
    }

    public ICrashCallBack getCallBack() {
        return this.mCallBack;
    }

    public void initCrashSdk(@NonNull Context context, @NonNull String appId, @Nullable long uid, boolean immediately, String hdid, int anrCheckInterval) {
        this.mContext = context;
        this.mAppId = appId;
        this.mHdid = hdid;
        this.mAnrCheckInterval = anrCheckInterval;
        if (uid > 0L) {
            this.mUid = uid;
        }
        MLog.info((Object)TAG, (String)"initCrashSdk appId: %s, uid: %s, immediately: %s", (Object[])new Object[]{appId, uid, immediately});
        mImmediately = immediately;
        YYTaskExecutor.removeTask((Runnable)this.mInitSdkRunnable);
        if (immediately) {
            YYTaskExecutor.execute((Runnable)this.mInitSdkRunnable);
        } else {
            YYTaskExecutor.execute((Runnable)this.mInitSdkRunnable, (long)5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCrashSdk() {
        MLog.info((Object)TAG, (String)"initCrashSdk appId: %s, hadInit: %s, mExtendInfo: %s", (Object[])new Object[]{this.mAppId, hadInit, this.mExtendInfo});
        if (this.mContext == null) {
            MLog.error((Object)TAG, (String)"init crash sdk context is null, please call initCrashSdk(@NonNull Context context, @NonNull String appId, @Nullable long uid)", (Object[])new Object[0]);
            return;
        }
        if (hadInit) {
            return;
        }
        this.getSecurityHardeningMd5();
        CrashSdkHelper crashSdkHelper = this;
        synchronized (crashSdkHelper) {
            if (hadInit) {
                return;
            }
            try {
                Thread.setDefaultUncaughtExceptionHandler(new CrashHandler(Thread.getDefaultUncaughtExceptionHandler(), mImmediately));
                this.mExtendInfo.putAll(CrashUtils.getCrashSdkReportExtendInfo());
                this.mExtendInfo.put("uid", String.valueOf(this.mUid));
                this.mExtendInfo.put("proc_name", IApplicationRoute.getProcessNameFromProc((Application)((Application)this.mContext)) + "");
                MLog.info((Object)TAG, (String)"getCrashSdkReportExtendInfo mExtendInfo: %s", (Object[])new Object[]{this.mExtendInfo});
                CrashSDKLogAdapter crashSDKLogAdapter = null;
                if (RuntimeContext.sIsMainProcess) {
                    crashSDKLogAdapter = new CrashSDKLogAdapter();
                }
                CrashReport.CrashReportBuilder crashReportBuilder = new CrashReport.CrashReportBuilder();
                crashReportBuilder.setContext(this.mContext);
                crashReportBuilder.setAppId("HagoPartyNt-android");
                crashReportBuilder.setAppMarket(AppMetaDataUtil.getChannelID((Context)this.mContext));
                crashReportBuilder.setGUid(this.mHdid);
                crashReportBuilder.setLogger((ILog)crashSDKLogAdapter);
                crashReportBuilder.setCrashUrl(CRASH_URL);
                crashReportBuilder.setAnrUrl(ANR_URL);
                crashReportBuilder.setDauUrl(DAU_URL);
                crashReportBuilder.setFeedbackUrl(FEEDBACK_URL);
                CrashReport.init((CrashReport.CrashReportBuilder)crashReportBuilder);
                if (this.mAnrCheckInterval > 100) {
                    CrashReport.startANRDetecting((Context)this.mContext, (long)this.mAnrCheckInterval);
                } else {
                    CrashReport.startANRDetecting((Context)this.mContext);
                }
                CrashReport.setANRListener((ANRDetector.ANRListener)new ANRDetector.ANRListener(){

                    public void onANRDetected(ActivityManager.ProcessErrorStateInfo errorStateInfo) {
                        CrashSdkHelper.this.appendInfoBeforeCrashOrAnrUpload(true);
                        if (!CrashSdkHelper.this.sIsCrashing) {
                            try {
                                if (SettingFlags.getBoolean((String)"anruploadlogs", (boolean)true)) {
                                    CrashSdkHelper.this.updateCrashOrAnrUserFile(true);
                                }
                            }
                            catch (Throwable e) {
                                MLog.error((Object)CrashSdkHelper.TAG, (Throwable)e);
                            }
                        }
                    }
                });
                CrashReport.setExtInfo(this.mExtendInfo);
                CrashReport.setUid((long)this.mUid);
                CrashReport.setCrashCallback((CrashReport.CrashCallback)this.mCrashCallback);
                hadInit = true;
                YYTaskExecutor.removeTask((Runnable)this.mInitSdkRunnable);
            }
            catch (Throwable ex) {
                MLog.error((Object)TAG, (Throwable)ex);
            }
        }
    }

    public void setUid(long uid, String hdid) {
        MLog.info((Object)TAG, (String)"setUid: %s", (Object[])new Object[]{uid});
        this.mUid = uid;
        this.mHdid = hdid;
        if (hadInit) {
            this.mExtendInfo.put("uid", String.valueOf(this.mUid));
            this.mExtendInfo.put("hdid", String.valueOf(hdid));
            CrashReport.setExtInfo(this.mExtendInfo);
            CrashReport.setUid((long)uid);
        }
    }

    public String getExtend(String key, String defaultValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        String result = this.mExtendInfo.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public void addExtend(String key, String value) {
        MLog.info((Object)TAG, (String)"addExtend key: %s, value: %s", (Object[])new Object[]{key, value});
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)value)) {
            this.mExtendInfo.remove(key);
        } else {
            this.mExtendInfo.put(key, value);
        }
        if (hadInit) {
            CrashReport.setExtInfo(this.mExtendInfo);
        }
    }

    public boolean isHadInit() {
        return hadInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCrashInfo(String dumpFile) {
        if (TextUtils.isEmpty((CharSequence)dumpFile)) {
            return null;
        }
        File file = new File(dumpFile);
        FileInputStream inputStream = null;
        try {
            if (file.exists()) {
                int len;
                inputStream = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                StringBuilder stringBuilder = new StringBuilder();
                while ((len = inputStream.read(bytes)) != -1) {
                    stringBuilder.append(new String(bytes, 0, len));
                }
                inputStream.close();
                String string = stringBuilder.toString();
                return string;
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"getCrashInfo e: %s", (Object[])new Object[]{e});
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void appendInfoBeforeCrashOrAnrUpload(boolean isAnr) {
        boolean isInChannel;
        String roomId;
        String gameid = RuntimeContext.getCurPlayingGame();
        if (StringUtils.isNotEmpty((String)gameid)) {
            this.addExtend("GameId", gameid);
        }
        if (StringUtils.isNotEmpty((String)(roomId = RuntimeContext.getVoiceRoomId()))) {
            this.addExtend("RoomId", roomId);
            this.addExtend("cplugin", RuntimeContext.getChannelPluginId());
        }
        if (isAnr && this.sIsCrashing) {
            this.addExtend("isCrashing", "1");
        }
        if (SettingFlags.containKey((String)"key_alpha_video_count")) {
            this.addExtend("alphaVideo", "" + SettingFlags.getIntValue((String)"key_alpha_video_count"));
            SettingFlags.removeKey((String)"key_alpha_video_count");
            SettingFlags.increase((String)"key_alpha_video_crash_count");
        }
        this.addExtend("cpuNum", String.valueOf(HardwareUtils.getCpuCoreCount()));
        this.addExtend("cpuArch", HardwareUtils.getCpuArch());
        this.addExtend("screenWidth", String.valueOf(ResolutionUtils.getScreenWidth()));
        this.addExtend("screenHeight", String.valueOf(ResolutionUtils.getScreenHeight()));
        this.addExtend("phoneType", String.valueOf(RuntimeContext.isPhoneSuperLow() ? 10 : RuntimeContext.getPhoneType()));
        boolean isCurChannelWin = StringUtils.equal((String)RuntimeContext.sCurWin, (String)"ChannelWindow");
        boolean bl = isInChannel = RuntimeContext.getCurMainChannel() != null;
        if (isCurChannelWin) {
            if (RuntimeContext.sIsForeground) {
                this.addExtend("minichannel", "1");
            } else {
                this.addExtend("minichannel", "2");
            }
        } else if (isInChannel) {
            if (RuntimeContext.sIsForeground) {
                this.addExtend("minichannel", "3");
            } else {
                this.addExtend("minichannel", "4");
            }
        }
        this.addRuntimeLength("runtime", "runtimeGap", SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime);
        this.addRuntimeLength("runtimeFore", "runtimeForeGap", RuntimeContext.getForeGroundRunTime());
        if (!this.mExtendInfo.containsKey(FOREGROUND)) {
            this.addExtend(FOREGROUND, RuntimeContext.sIsForeground ? "1" : "0");
        }
        if (RuntimeContext.isStartAtCoverInstalled()) {
            this.addExtend("lastVersion", RuntimeContext.getLastAppVersion());
        }
        this.addSecurityHardeningMd5ToCrashInfoExtend();
    }

    private void addRuntimeLength(String timeTag, String timeGapTag, long runTimeLength) {
        this.addExtend(timeTag, String.valueOf(runTimeLength));
        if (runTimeLength <= 30000L) {
            this.addExtend(timeGapTag, "30sec");
        } else if (runTimeLength <= 60000L) {
            this.addExtend(timeGapTag, "1min");
        } else if (runTimeLength <= 300000L) {
            this.addExtend(timeGapTag, "5min");
        } else if (runTimeLength <= 600000L) {
            this.addExtend(timeGapTag, "10min");
        } else if (runTimeLength <= 1200000L) {
            this.addExtend(timeGapTag, "20min");
        } else if (runTimeLength <= 1800000L) {
            this.addExtend(timeGapTag, "30min");
        } else if (runTimeLength <= 3600000L) {
            this.addExtend(timeGapTag, "60min");
        } else if (runTimeLength <= 5400000L) {
            this.addExtend(timeGapTag, "90min");
        } else if (runTimeLength <= 0x6DDD00L) {
            this.addExtend(timeGapTag, "120min");
        } else if (runTimeLength <= 10800000L) {
            this.addExtend(timeGapTag, "180min");
        } else {
            this.addExtend(timeGapTag, "above180min");
        }
    }

    private void updateCrashOrAnrUserFile(boolean anr) {
        ArrayList<String> mCrashFile = null;
        try {
            boolean needBlocker = KLogUtils.flush((IFlushCallback)new IFlushCallback(){

                public void onFlush(boolean finish) {
                    if (mLogBlocker != null) {
                        mLogBlocker.unblock();
                    }
                }
            }, (boolean)true);
            if (needBlocker) {
                mLogBlocker = new LogBlocker();
                mLogBlocker.preBlock();
                mLogBlocker.waitForUnblock();
            }
            mCrashFile = KLogUtils.getNewFileToCrash();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (mCrashFile == null) {
            mCrashFile = new ArrayList<String>();
        }
        if (!anr || this.sIsCrashing) {
            String logRootDir = FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath();
            String exceptionTxt = logRootDir + File.separator + "uncaught_exception.txt";
            mCrashFile.add(exceptionTxt);
        }
        MLog.info((Object)TAG, (String)"preCrashCallback logFile: %s", (Object[])new Object[]{mCrashFile});
        CrashReport.setUserLogList(mCrashFile);
    }

    private void writeFDList() {
        final FdsController fdsController = new FdsController();
        FdsController.getFilesNumber((FdsController.CallBack)new FdsController.CallBack<Integer>(){

            public void onSuccess(Integer data) {
                MLog.error((Object)"fdList", (String)"fd file count = %s", (Object[])new Object[]{data});
                try {
                    FdsController.getFilesDetailInfo((FdsController.CallBack)new FdsController.CallBack<HashMap<String, Integer>>(){

                        public void onSuccess(HashMap<String, Integer> data) {
                            for (Map.Entry<String, Integer> entry : data.entrySet()) {
                                MLog.error((Object)"fdList", (String)"fdname = %s , fdcount = %d", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                            }
                        }
                    });
                }
                catch (Exception e) {
                    MLog.error((Object)CrashSdkHelper.TAG, (Throwable)e);
                }
            }
        });
    }

    public void setCrashCallBack(ICrashCallBack crashCallBack) {
        this.mCallBack = crashCallBack;
    }

    private void getSecurityHardeningMd5() {
        YYTaskExecutor.execute(() -> {
            sSecurityHardeningMd5 = IApplicationRoute.getLibraryNameMd5((String)"yyshell");
        }, (long)1500L);
    }

    private void addSecurityHardeningMd5ToCrashInfoExtend() {
        if (StringUtils.equalsIgnoreCase((String)sSecurityHardeningMd5, (String)"none")) {
            sSecurityHardeningMd5 = IApplicationRoute.getLibraryNameMd5((String)"yyshell");
        }
        this.addExtend("secu_hard", sSecurityHardeningMd5);
    }

    static {
        CRASH_URL = "https://crash-reporting.duowan.com/crash/reporting";
        ANR_URL = "https://crash-reporting.duowan.com/anr/reporting";
        FEEDBACK_URL = "https://crash-reporting.duowan.com/feedback/reporting";
        DAU_URL = "https://crash-reporting.duowan.com/dau/reporting";
        hadInit = false;
        mImmediately = false;
        sSecurityHardeningMd5 = "none";
    }

    public static interface ICrashCallBack {
        public void crashCallback(String var1, boolean var2, String var3);

        public void report(String var1);
    }
}

