/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.crash;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.yy.base.env.ConstDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.fdutils.FdsController;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ThrowUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.yylite.crash.CrashSdkHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "CrashHandler";
    private Thread.UncaughtExceptionHandler sDefaultHandler;
    private volatile boolean mImmediately = false;

    public CrashHandler(Thread.UncaughtExceptionHandler sDefaultHandler, boolean immediately) {
        this.sDefaultHandler = sDefaultHandler;
        this.mImmediately = immediately;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        MLog.error((Object)TAG, (String)"uncaughtException", (Object[])new Object[0]);
        if (!CrashSdkHelper.INSTANCE.isHadInit()) {
            CrashSdkHelper.INSTANCE.initCrashSdk();
            ThrowUtils.throwException((Throwable)ex);
        }
        try {
            String crashData = this.collectStackTrace(ex);
            this.writeTraceToLog(crashData, ex);
            if (ex instanceof OutOfMemoryError && CrashSdkHelper.INSTANCE.getCallBack() != null) {
                try {
                    CrashSdkHelper.INSTANCE.getCallBack().report("OOM");
                }
                catch (Throwable e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
            if (RuntimeContext.sIsDebuggable) {
                Thread.sleep(1500L);
            } else {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        if (this.sDefaultHandler != null) {
            this.sDefaultHandler.uncaughtException(thread, ex);
        }
    }

    public String collectStackTrace(Throwable th) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        Throwable cause = th;
        if (cause != null) {
            cause.printStackTrace(printWriter);
        }
        String stackTrace = ((Object)result).toString();
        printWriter.close();
        return stackTrace.trim();
    }

    private void writeTraceToLog(String traces, Throwable ex) {
        String time = "";
        try {
            Calendar logCal = Calendar.getInstance();
            logCal.setTimeInMillis(System.currentTimeMillis());
            time = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd kk:mm:ss.SSS").format(logCal.getTime());
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)traces, (Object[])new Object[0]);
        }
        if (time == null) {
            time = "";
        }
        try {
            String dir = FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath();
            File unCatchFile = new File(dir, "uncaught_exception.txt");
            if (unCatchFile.exists() && unCatchFile.length() > 0x200000L) {
                try {
                    unCatchFile.delete();
                    unCatchFile = new File(dir, "uncaught_exception.txt");
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)(" delete" + e.toString()), (Object[])new Object[0]);
                }
            }
            YYFileUtils.writeBytesToFileForCrashWays((File)unCatchFile, (byte[])("\n\n" + time + " " + traces).getBytes(), (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (this.mImmediately) {
            File unCatchFile = new File(FileStorageUtils.getInstance().getExternalCacheDir("crash_file"), "uncaught_exception.txt");
            if (unCatchFile.exists() && unCatchFile.length() > 0x200000L) {
                try {
                    unCatchFile.delete();
                    unCatchFile = new File(FileStorageUtils.getInstance().getExternalCacheDir("crash_file"), "uncaught_exception.txt");
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)(" delete" + e.toString()), (Object[])new Object[0]);
                }
            }
            try {
                YYFileUtils.writeBytesToFileForCrashWays((File)unCatchFile, (byte[])("\n\n" + time + " " + traces).getBytes(), (boolean)true, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeFDList() {
        try {
            FdsController fdsController = new FdsController();
            FdsController.getFilesDetailInfo((FdsController.CallBack)new FdsController.CallBack<HashMap<String, Integer>>(){

                public void onSuccess(HashMap<String, Integer> data) {
                    for (Map.Entry<String, Integer> entry : data.entrySet()) {
                        MLog.error((Object)"fdList", (String)"fdname = %s , fdcount = %d", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                    }
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public static File getCacheDirectory(Context context, String type) {
        File appCacheDir = CrashHandler.getExternalCacheDirectory(context, type);
        if (appCacheDir == null) {
            appCacheDir = CrashHandler.getInternalCacheDirectory(context, type);
        }
        if (appCacheDir == null) {
            MLog.info((Object)"getCacheDirectory", (String)"getCacheDirectory fail ,the reason is mobile phone unknown exception !", (Object[])new Object[0]);
        } else if (!appCacheDir.exists() && !appCacheDir.mkdirs()) {
            MLog.info((Object)"getCacheDirectory", (String)"getCacheDirectory fail ,the reason is make directory fail !", (Object[])new Object[0]);
        }
        return appCacheDir;
    }

    public static File getExternalCacheDirectory(Context context, String type) {
        File appCacheDir = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            appCacheDir = TextUtils.isEmpty((CharSequence)type) ? context.getExternalCacheDir() : context.getExternalFilesDir(type);
            if (appCacheDir == null && FileStorageUtils.isStoragePermissionGranted((Context)context)) {
                appCacheDir = new File(Environment.getExternalStorageDirectory(), "Android/data/" + context.getPackageName() + "/cache/" + type);
            }
            if (appCacheDir == null) {
                MLog.info((Object)"getExternalDirectory", (String)"getExternalDirectory fail ,the reason is sdCard unknown exception !", (Object[])new Object[0]);
            } else if (!appCacheDir.exists() && !appCacheDir.mkdirs()) {
                MLog.info((Object)"getExternalDirectory", (String)"getExternalDirectory fail ,the reason is make directory fail !", (Object[])new Object[0]);
            }
        } else {
            MLog.info((Object)"getExternalDirectory", (String)"getExternalDirectory fail ,the reason is sdCard nonexistence or sdCard mount fail !", (Object[])new Object[0]);
        }
        return appCacheDir;
    }

    public static File getInternalCacheDirectory(Context context, String type) {
        File appCacheDir = null;
        appCacheDir = TextUtils.isEmpty((CharSequence)type) ? new File(FileStorageUtils.getInstance().getInternalCacheRootDir()) : new File(FileStorageUtils.getInstance().getInternalFileRootDir(), type);
        if (!appCacheDir.exists() && !appCacheDir.mkdirs()) {
            MLog.info((Object)"getInternalDirectory", (String)"getInternalDirectory fail ,the reason is make directory fail !", (Object[])new Object[0]);
        }
        return appCacheDir;
    }
}

