/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.commonbase.hiido;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoStatisInit;
import java.util.Random;

public class HiidoUtils {
    private static boolean hasUpdateHiid = false;

    public static String getDeviceId() {
        return HiidoUtils.getHdid();
    }

    public static String getHiidoAppkey() {
        return HiidoStatisInit.getHiidoAppkey();
    }

    public static String getHdid() {
        final String hdid = SettingFlags.getStringValue((String)"hyhdid");
        if (StringUtils.isNotEmpty((String)hdid)) {
            if (!hasUpdateHiid) {
                hasUpdateHiid = true;
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        String newHiid = HiidoSDK.instance().getHdid(RuntimeContext.sApplicationContext);
                        if (!StringUtils.equal((String)hdid, (String)newHiid)) {
                            SettingFlags.setStringValue((String)"hyhdid", (String)newHiid);
                            if (RuntimeContext.sIsDebuggable) {
                                throw new RuntimeException("hdid changed old:" + hdid + ", new:" + newHiid);
                            }
                            String intOne = "ifield";
                            String strOne = "sfield";
                            String strTwo = "sfieldtwo";
                            String strThree = "sfieldthree";
                            StatisContent statContent = new StatisContent();
                            statContent.put("act", "hagoperf");
                            statContent.put("ifield", HardwareUtils.isSimulator() ? 1 : 0);
                            statContent.put("sfield", hdid);
                            statContent.put("sfieldtwo", newHiid);
                            statContent.put("sfieldthree", NetworkUtils.getMac((Context)RuntimeContext.sApplicationContext));
                            statContent.put("perftype", "hdid");
                            HiidoStatis.reportContent(statContent);
                        }
                    }
                };
                YYTaskExecutor.getDefaultIdleExecutor().execute(update, 20000L);
            }
            return hdid == null ? "" : hdid;
        }
        String newhdid = HiidoSDK.instance().getHdid(RuntimeContext.sApplicationContext);
        if (StringUtils.isNotEmpty((String)newhdid)) {
            SettingFlags.setStringValue((String)"hyhdid", (String)newhdid);
        }
        return newhdid == null ? "" : newhdid;
    }

    public static String getSessionId(long inTime, long topSid) {
        String time = String.valueOf(inTime);
        String deviceId = HiidoUtils.getDeviceId();
        int randomInt = new Random().nextInt(9999);
        String randomString = String.valueOf(randomInt);
        return MD5Utils.getMD5String((String)(time + deviceId + topSid + randomString));
    }

    public static int getHiidoNetwork(int state) {
        if (state == 2) {
            return 1;
        }
        if (state == 3) {
            return 2;
        }
        if (state == 4) {
            return 4;
        }
        if (state == 1) {
            return 3;
        }
        return 0;
    }
}

