/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.commonbase.hiido;

import android.text.TextUtils;
import android.util.Pair;
import com.yy.base.utils.DontProguardClass;
import java.util.HashMap;
import java.util.Map;

@DontProguardClass
public class HiidoEvent {
    public static final String KEY_FUNCTION_ID = "function_id";
    static final double INVALID_EVALUE = -1.0;
    private long uid = 0L;
    private String eventId = "";
    private String label = "";
    private double evalue = -1.0;
    private Map<String, String> eventProperty;
    private HiidoEvent next;
    private static final Object sPoolSync = new Object();
    private static HiidoEvent sPool;
    private static int sPoolSize;
    private static final int MAX_POOL_SIZE = 50;

    private HiidoEvent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HiidoEvent obtain() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                HiidoEvent m = sPool;
                sPool = m.next;
                m.next = null;
                --sPoolSize;
                HiidoEvent.clear(m);
                return m;
            }
        }
        return new HiidoEvent();
    }

    @SafeVarargs
    public static Map<String, String> map(Pair<String, String> ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keyValues != null) {
            for (Pair<String, String> pair : keyValues) {
                if (TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) continue;
                map.put((String)pair.first, (String)pair.second);
            }
        }
        return map;
    }

    public HiidoEvent uid(long uid) {
        this.uid = uid;
        return this;
    }

    public HiidoEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    public HiidoEvent label(String label) {
        this.label = label;
        return this;
    }

    public HiidoEvent evalue(double evalue) {
        this.evalue = evalue;
        return this;
    }

    public HiidoEvent put(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return this;
        }
        if (this.eventProperty == null) {
            this.eventProperty = new HashMap<String, String>();
        }
        this.eventProperty.put(key, value);
        return this;
    }

    public HiidoEvent putMap(Map<String, String> eventMap) {
        if (eventMap == null || eventMap.isEmpty()) {
            return this;
        }
        if (this.eventProperty == null) {
            this.eventProperty = new HashMap<String, String>();
        }
        this.eventProperty.putAll(eventMap);
        return this;
    }

    public long getUid() {
        return this.uid;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getLabel() {
        return this.label;
    }

    public double getEvalue() {
        return this.evalue;
    }

    public Map<String, String> getEventProperty() {
        return this.eventProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle() {
        HiidoEvent.clear(this);
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 50) {
                this.next = sPool;
                sPool = this;
                ++sPoolSize;
            }
        }
    }

    private static void clear(HiidoEvent event) {
        if (event != null) {
            event.uid = 0L;
            event.eventId = "";
            event.label = "";
            event.evalue = -1.0;
            event.eventProperty = null;
        }
    }

    public String toString() {
        return "HiidoEvent{uid=" + this.uid + ", eventId='" + this.eventId + '\'' + ", label='" + this.label + '\'' + ", evalue=" + this.evalue + ", eventProperty=" + this.eventProperty + '}';
    }

    static {
        sPoolSize = 0;
    }
}

