/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v6;

import androidx.annotation.MainThread;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.Callback;
import com.yy.appbase.common.DataFetchCallback;
import com.yy.appbase.common.RequestResult;
import com.yy.appbase.common.RequestSuccess;
import com.yy.appbase.recommend.bean.Tab;
import com.yy.appbase.recommend.bean.TopTab;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.service.IDeepLinkChannelService;
import com.yy.hiyo.channel.module.recommend.base.ITopTabRepository;
import com.yy.hiyo.channel.module.recommend.v2.data.ChannelListDiskCacheManager;
import com.yy.hiyo.channel.module.recommend.v2.data.DataManager;
import com.yy.hiyo.channel.module.recommend.v3.base.IPartyTabView;
import com.yy.hiyo.channel.module.recommend.v3.ui.PartyTabView;
import com.yy.hiyo.channel.module.recommend.v6.TopTabRepository;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u001a\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u000e2\u0006\u0010\"\u001a\u00020#J\u001a\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r0%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\bH\u0002J\u000e\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020#J\u0006\u0010*\u001a\u00020\u0011J\u001e\u0010+\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/yy/hiyo/channel/module/recommend/v6/TopTabRepository;", "Lcom/yy/hiyo/channel/module/recommend/base/ITopTabRepository;", "()V", "FETCH_SERVER_DELAY", "", "TAG", "", "hasDataFetched", "", "loading", "mLastRequestDeeplink", "topTabsLiveData", "Landroidx/lifecycle/MutableLiveData;", "Lcom/yy/appbase/common/RequestResult;", "", "Lcom/yy/appbase/recommend/bean/TopTab;", "clearTabViewCache", "", "clearTopTabsData", "createTopTabViewByType", "Lcom/yy/hiyo/channel/module/recommend/v3/base/IPartyTabView;", "mvpContext", "Lcom/yy/hiyo/mvp/base/IMvpContext;", "topTab", "createTopTabViews", "topTabs", "fetchFromCache", "fetchFromServer", "getTabByGid", "Lcom/yy/appbase/recommend/bean/Tab;", "gid", "getTabById", "tabId", "getTabsByTopType", "topType", "", "getTopTabs", "Landroidx/lifecycle/LiveData;", "handleRefreshData", "checkLoading", "isTabExist", "tabType", "refreshData", "updateTabByTopType", "tabs", "channellist_debug"})
public final class TopTabRepository
implements ITopTabRepository {
    private static final String TAG = "TopTabFactory";
    private static final long FETCH_SERVER_DELAY = 3000L;
    private static final MutableLiveData<RequestResult<List<TopTab>>> topTabsLiveData;
    private static boolean hasDataFetched;
    private static boolean loading;
    private static volatile String mLastRequestDeeplink;
    public static final TopTabRepository INSTANCE;

    @NotNull
    public LiveData<RequestResult<List<TopTab>>> getTopTabs() {
        long startAt = System.currentTimeMillis();
        if (!hasDataFetched) {
            int priority$iv = 10;
            long delay$iv = 0L;
            boolean $i$f$postWork = false;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                public final void run() {
                    boolean bl = false;
                    boolean cacheExist = ChannelListDiskCacheManager.INSTANCE.isCacheExist();
                    long delay$iv = 0L;
                    boolean $i$f$postUi = false;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(cacheExist){
                        final /* synthetic */ boolean $cacheExist$inlined;
                        {
                            this.$cacheExist$inlined = bl;
                        }

                        public final void run() {
                            boolean bl = false;
                            if (this.$cacheExist$inlined) {
                                TopTabRepository.access$fetchFromCache(TopTabRepository.INSTANCE);
                            } else {
                                TopTabRepository.access$fetchFromServer(TopTabRepository.INSTANCE);
                            }
                        }
                    }, (long)delay$iv);
                }
            }, (long)delay$iv, (int)priority$iv);
        }
        MLog.debug((Object)TAG, (String)("getTopTabs cost " + (System.currentTimeMillis() - startAt) + " ms"), (Object[])new Object[0]);
        return (LiveData)topTabsLiveData;
    }

    private final void fetchFromCache() {
        YYTaskExecutor.execute((Runnable)fetchFromCache.1.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<Tab> getTabsByTopType(int topType) {
        Object v4;
        Object object;
        block2: {
            Object object2 = topTabsLiveData.getValue();
            if (!(object2 instanceof RequestSuccess)) {
                object2 = null;
            }
            RequestSuccess requestSuccess = (RequestSuccess)object2;
            object = requestSuccess;
            if (requestSuccess == null) return null;
            List list = (List)object.getData();
            object = list;
            if (list == null) return null;
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                TopTab it = (TopTab)t;
                boolean bl3 = false;
                if (!(it.getType() == topType)) continue;
                v4 = t;
                break block2;
            }
            v4 = null;
        }
        TopTab topTab = v4;
        object = topTab;
        if (topTab == null) return null;
        List list = object.getTabs();
        return list;
    }

    @Nullable
    public final Tab getTabById(long tabId) {
        Object object;
        Object object2 = topTabsLiveData.getValue();
        if (!(object2 instanceof RequestSuccess)) {
            object2 = null;
        }
        if ((object = (RequestSuccess)object2) != null && (object = (List)object.getData()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TopTab it = (TopTab)element$iv;
                boolean bl = false;
                List list = it.getTabs();
                if (list != null) {
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Tab tab = (Tab)element$iv2;
                        boolean bl2 = false;
                        if (tab.getId() != tabId) continue;
                        return tab;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public final Tab getTabByGid(@NotNull String gid) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        Object object2 = topTabsLiveData.getValue();
        if (!(object2 instanceof RequestSuccess)) {
            object2 = null;
        }
        if ((object = (RequestSuccess)object2) != null && (object = (List)object.getData()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TopTab it = (TopTab)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = it.getTabs();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Tab tab = (Tab)element$iv2;
                    boolean bl2 = false;
                    if (!tab.getGameIds().contains(gid)) continue;
                    return tab;
                }
            }
        }
        return null;
    }

    @NotNull
    public final List<IPartyTabView> createTopTabViews(@NotNull IMvpContext mvpContext, @NotNull List<TopTab> topTabs) {
        Intrinsics.checkParameterIsNotNull((Object)mvpContext, (String)"mvpContext");
        Intrinsics.checkParameterIsNotNull(topTabs, (String)"topTabs");
        boolean bl = false;
        List tabViews = new ArrayList();
        Iterable $this$forEach$iv = topTabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TopTab it = (TopTab)element$iv;
            boolean bl2 = false;
            IPartyTabView iPartyTabView = INSTANCE.createTopTabViewByType(mvpContext, it);
            boolean bl3 = false;
            boolean bl4 = false;
            IPartyTabView $this$apply = iPartyTabView;
            boolean bl5 = false;
            tabViews.add($this$apply);
        }
        return tabViews;
    }

    private final void handleRefreshData(boolean checkLoading) {
        if (loading && checkLoading) {
            MLog.debug((Object)TAG, (String)"handleRefreshData ignore, is loading", (Object[])new Object[0]);
            return;
        }
        loading = true;
        MLog.debug((Object)TAG, (String)"refreshData", (Object[])new Object[0]);
        boolean $i$f$serviceOf = false;
        boolean $i$f$provideService = false;
        IService iService = ServiceManagerProxy.getService(IDeepLinkChannelService.class);
        if (iService == null) {
            Intrinsics.throwNpe();
        }
        mLastRequestDeeplink = ((IDeepLinkChannelService)iService).getRawDeeplink();
        DataManager.fetchAllTopTabs$default(DataManager.INSTANCE, (DataFetchCallback)new DataFetchCallback<List<? extends TopTab>>(){

            public void onSuccess(@Nullable List<TopTab> data) {
                block0: {
                    TopTabRepository.access$setLoading$p(TopTabRepository.INSTANCE, false);
                    MLog.debug((Object)"TopTabFactory", (String)"refreshData success", (Object[])new Object[0]);
                    List<TopTab> list = data;
                    if (list == null) break block0;
                    List<TopTab> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<TopTab> it = list2;
                    boolean bl3 = false;
                    TopTabRepository.access$getTopTabsLiveData$p(TopTabRepository.INSTANCE).setValue((Object)RequestResult.Companion.onSuccess(it));
                    TopTabRepository.access$setHasDataFetched$p(TopTabRepository.INSTANCE, true);
                    MLog.debug((Object)"TopTabFactory", (String)String.valueOf(it), (Object[])new Object[0]);
                    YYTaskExecutor.execute((Runnable)new Runnable(it){
                        final /* synthetic */ List $it;

                        public final void run() {
                            ChannelListDiskCacheManager.INSTANCE.saveTopTabs(this.$it);
                        }
                        {
                            this.$it = list;
                        }
                    });
                }
            }

            public void onFailure(long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                TopTabRepository.access$setLoading$p(TopTabRepository.INSTANCE, false);
            }
        }, false, 2, null);
    }

    public final void refreshData() {
        this.handleRefreshData(true);
    }

    @MainThread
    public final void updateTabByTopType(int topType, @NotNull List<Tab> tabs) {
        Object object;
        Intrinsics.checkParameterIsNotNull(tabs, (String)"tabs");
        RequestResult topTaps = (RequestResult)topTabsLiveData.getValue();
        Object object2 = topTabsLiveData.getValue();
        if (!(object2 instanceof RequestSuccess)) {
            object2 = null;
        }
        if ((object = (RequestSuccess)object2) != null && (object = (List)object.getData()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TopTab it = (TopTab)element$iv;
                boolean bl = false;
                if (topType != it.getType()) continue;
                it.setTabs(tabs);
                topTabsLiveData.setValue((Object)topTaps);
            }
        }
    }

    public final void clearTopTabsData() {
        topTabsLiveData.setValue(null);
    }

    public final void clearTabViewCache() {
    }

    public final boolean isTabExist(int tabType) {
        Object object;
        Object object2 = topTabsLiveData.getValue();
        if (!(object2 instanceof RequestSuccess)) {
            object2 = null;
        }
        if ((object = (RequestSuccess)object2) != null && (object = (List)object.getData()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TopTab it = (TopTab)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = it.getTabs();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Tab tab = (Tab)element$iv2;
                    boolean bl2 = false;
                    if (tab.getType() != tabType) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final void fetchFromServer() {
        if (loading) {
            return;
        }
        loading = true;
        boolean $i$f$serviceOf = false;
        boolean $i$f$provideService = false;
        IService iService = ServiceManagerProxy.getService(IDeepLinkChannelService.class);
        if (iService == null) {
            Intrinsics.throwNpe();
        }
        mLastRequestDeeplink = ((IDeepLinkChannelService)iService).getRawDeeplink();
        DataManager.fetchAllTopTabs$default(DataManager.INSTANCE, (DataFetchCallback)new DataFetchCallback<List<? extends TopTab>>(){

            public void onSuccess(@Nullable List<TopTab> data) {
                block1: {
                    TopTabRepository.access$setLoading$p(TopTabRepository.INSTANCE, false);
                    MLog.debug((Object)"TopTabFactory", (String)("fetchFromServer " + data), (Object[])new Object[0]);
                    List<TopTab> list = data;
                    if (list == null) break block1;
                    List<TopTab> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<TopTab> it = list2;
                    boolean bl3 = false;
                    if (!TopTabRepository.access$getHasDataFetched$p(TopTabRepository.INSTANCE)) {
                        TopTabRepository.access$setHasDataFetched$p(TopTabRepository.INSTANCE, true);
                        TopTabRepository.access$getTopTabsLiveData$p(TopTabRepository.INSTANCE).setValue((Object)RequestResult.Companion.onSuccess(it));
                    }
                    MLog.debug((Object)"TopTabFactory", (String)String.valueOf(it), (Object[])new Object[0]);
                    YYTaskExecutor.execute((Runnable)new Runnable(it){
                        final /* synthetic */ List $it;

                        public final void run() {
                            ChannelListDiskCacheManager.INSTANCE.saveTopTabs(this.$it);
                        }
                        {
                            this.$it = list;
                        }
                    }, (long)3000L);
                }
            }

            public void onFailure(long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                TopTabRepository.access$setLoading$p(TopTabRepository.INSTANCE, false);
                if (!TopTabRepository.access$getHasDataFetched$p(TopTabRepository.INSTANCE)) {
                    TopTabRepository.access$getTopTabsLiveData$p(TopTabRepository.INSTANCE).setValue((Object)RequestResult.Companion.onFailure(code, msg));
                    TopTabRepository.access$setHasDataFetched$p(TopTabRepository.INSTANCE, true);
                }
            }
        }, false, 2, null);
    }

    private final IPartyTabView createTopTabViewByType(IMvpContext mvpContext, TopTab topTab) {
        return new PartyTabView(mvpContext, topTab, false, false, 12, null);
    }

    private TopTabRepository() {
    }

    static {
        block0: {
            TopTabRepository topTabRepository;
            INSTANCE = topTabRepository = new TopTabRepository();
            topTabsLiveData = new MutableLiveData();
            Function1 action$iv = 1.INSTANCE;
            boolean $i$f$serviceOf = false;
            boolean $i$f$observeService = false;
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null) break block0;
            iServiceManager.observeService(IDeepLinkChannelService.class, new Callback<T>(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = function1;
                }

                public final void onResponse(T it) {
                    T t = it;
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                    this.$action.invoke(t);
                }
            });
        }
    }

    public static final /* synthetic */ void access$fetchFromCache(TopTabRepository $this) {
        $this.fetchFromCache();
    }

    public static final /* synthetic */ void access$fetchFromServer(TopTabRepository $this) {
        $this.fetchFromServer();
    }

    public static final /* synthetic */ boolean access$getHasDataFetched$p(TopTabRepository $this) {
        TopTabRepository topTabRepository = $this;
        return hasDataFetched;
    }

    public static final /* synthetic */ void access$setHasDataFetched$p(TopTabRepository $this, boolean bl) {
        TopTabRepository topTabRepository = $this;
        hasDataFetched = bl;
    }

    public static final /* synthetic */ MutableLiveData access$getTopTabsLiveData$p(TopTabRepository $this) {
        TopTabRepository topTabRepository = $this;
        return topTabsLiveData;
    }

    public static final /* synthetic */ boolean access$getLoading$p(TopTabRepository $this) {
        TopTabRepository topTabRepository = $this;
        return loading;
    }

    public static final /* synthetic */ void access$setLoading$p(TopTabRepository $this, boolean bl) {
        TopTabRepository topTabRepository = $this;
        loading = bl;
    }

    public static final /* synthetic */ String access$getMLastRequestDeeplink$p(TopTabRepository $this) {
        TopTabRepository topTabRepository = $this;
        return mLastRequestDeeplink;
    }

    public static final /* synthetic */ void access$setMLastRequestDeeplink$p(TopTabRepository $this, String string2) {
        TopTabRepository topTabRepository = $this;
        mLastRequestDeeplink = string2;
    }
}

