/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.adapter;

import android.content.Context;
import android.graphics.Color;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.module.recommend.R;
import com.yy.hiyo.channel.module.recommend.miniradio.MiniRadioTrack;
import com.yy.hiyo.channel.module.recommend.v1.bean.QuickJoinBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;
import java.util.ArrayList;
import java.util.List;

public class RoomListQuickJoinAdapter
extends RecyclerView.Adapter<CustomerViewHolder> {
    private List<QuickJoinBean> mDatas = new ArrayList<QuickJoinBean>();

    public void update(List<QuickJoinBean> mTempData) {
        this.mDatas.clear();
        this.mDatas.addAll(mTempData);
        this.notifyDataSetChanged();
    }

    @NonNull
    public CustomerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_quick_join_list_item_channel, parent, false);
        return new CustomerViewHolder(view);
    }

    public void onBindViewHolder(final @NonNull CustomerViewHolder holder, int position) {
        final QuickJoinBean quickJoinBean = this.mDatas.get(position);
        if (quickJoinBean.getData() == null) {
            holder.mNameView.setText(R.string.title_quick_join_mini_radio);
            if (TextUtils.isEmpty((CharSequence)quickJoinBean.getIconUrl())) {
                holder.mHeadView.setImageResource(R.drawable.icon_quick_join_chat_room);
            } else {
                ImageLoader.loadImage((ImageView)holder.mHeadView, (String)quickJoinBean.getIconUrl(), (int)R.drawable.icon_quick_join_chat_room);
            }
            MiniRadioTrack.INSTANCE.reportEnterShow();
        } else {
            ImageLoader.loadImage((ImageView)holder.mHeadView, (String)quickJoinBean.getData().getIconUrl(), (int)-1);
            holder.mNameView.setText((CharSequence)quickJoinBean.getData().getGname());
        }
        if (this.needDownLoadShow(quickJoinBean)) {
            holder.mDownloadView.setVisibility(0);
            this.initDownLoadView(holder.mDownloadView);
            holder.mDownloadView.setMarkBackground(this.getBgColor());
            holder.mDownloadView.setGameInfo(quickJoinBean.getData());
        } else {
            holder.mDownloadView.setVisibility(8);
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                    return;
                }
                if (RoomListQuickJoinAdapter.this.needDownLoadShow(quickJoinBean)) {
                    if (holder.mDownloadView == null || !holder.mDownloadView.isDownloading()) {
                        RoomListQuickJoinAdapter.this.quickJoinEnterRoom(quickJoinBean.getData());
                    } else if (holder.mDownloadView != null) {
                        holder.mDownloadView.pause();
                    } else {
                        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.no_download_tips), (int)0);
                    }
                } else if (quickJoinBean.type == 1001) {
                    ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).exitRoom();
                    MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_MINIRADIO_CHANNEL);
                    MiniRadioTrack.INSTANCE.reportEnterClick();
                } else {
                    RoomListQuickJoinAdapter.this.quickJoinEnterRoom(quickJoinBean.getData());
                }
            }
        });
    }

    private void quickJoinEnterRoom(GameInfo gameInfo) {
        Message message = new Message();
        message.what = BaseMsgDef.SHOW_ROOM_GAME_MATCH_PAGE;
        message.obj = gameInfo;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    private boolean isNewVoiceGameMatch() {
        return true;
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public void initDownLoadView(GameDownloadingView mDownloadView) {
        int width = ResolutionUtils.dip2Px((float)52.0f);
        mDownloadView.setType(1);
        mDownloadView.setProgressBarWidth(width);
        mDownloadView.setDefaultProgressBarWidth(width);
        mDownloadView.setDefaultLightWidth(ResolutionUtils.dip2Px((float)52.0f));
        mDownloadView.setBorderRadius(10);
        mDownloadView.setProgressShow(false);
    }

    private int getBgColor() {
        return Color.parseColor((String)"#4d000000");
    }

    private boolean isDownLoadGame(GameInfo gameInfo) {
        return gameInfo.getGameMode() == 8 && gameInfo.getGameType() == 3;
    }

    public boolean needDownLoadShow(QuickJoinBean quickJoinBean) {
        return quickJoinBean.getData() != null && quickJoinBean.getData().getGid() != null && this.isDownLoadGame(quickJoinBean.getData());
    }

    static class CustomerViewHolder
    extends RecyclerView.ViewHolder {
        private RoundConerImageView mHeadView;
        private YYTextView mNameView;
        private GameDownloadingView mDownloadView;

        CustomerViewHolder(View itemView) {
            super(itemView);
            this.mHeadView = (RoundConerImageView)itemView.findViewById(R.id.iv_plugin);
            this.mNameView = (YYTextView)itemView.findViewById(R.id.tv_game_name);
            this.mDownloadView = (GameDownloadingView)itemView.findViewById(R.id.game_download_view);
        }
    }
}

