/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.BitmapUtils;
import com.yy.hiyo.channel.module.recommend.R;

public class RoomTagRelativeLayout
extends YYRelativeLayout {
    private Paint mPaint;
    private Path mPath;
    private int mBackgroundColor;
    private int mWidth;
    private int mHeight;

    public RoomTagRelativeLayout(Context context) {
        this(context, null);
    }

    public RoomTagRelativeLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoomTagRelativeLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TrapezoidLinearLayout);
        this.mBackgroundColor = ta.getColor(R.styleable.TrapezoidLinearLayout_srb_backgroundColor, -1);
        ta.recycle();
        this.mPaint = new Paint(1);
        this.mPath = new Path();
        this.mPaint.setColor(this.mBackgroundColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void dispatchDraw(Canvas canvas) {
        Bitmap newBitmap = this.drawableToBitmap((GradientDrawable)this.getResources().getDrawable(R.drawable.shape_room_card_list_item), this.mBackgroundColor);
        Rect mSrcRect = new Rect(0, 0, this.mWidth, this.mHeight);
        Rect mDesRect = new Rect(0, 0, this.mWidth, this.mHeight);
        canvas.drawBitmap(newBitmap, mSrcRect, mDesRect, this.mPaint);
        canvas.drawPath(this.mPath, this.mPaint);
        super.dispatchDraw(canvas);
    }

    private Bitmap drawableToBitmap(GradientDrawable drawable2, int color2) {
        drawable2.setColor(color2);
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapUtils.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, this.mWidth, this.mHeight);
        drawable2.draw(canvas);
        return bitmap;
    }

    public void setmBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
    }
}

