/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.mvp;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.module.recommend.v1.mvp.RoomListMoreMvp;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import java.util.ArrayList;
import java.util.List;
import net.ihago.room.api.rrec.GetGangupRoomListReq;
import net.ihago.room.api.rrec.GetGangupRoomListRes;
import net.ihago.room.api.rrec.GetKTVChannelListReq;
import net.ihago.room.api.rrec.GetKTVChannelListResp;
import net.ihago.room.api.rrec.GetNearbyChannelListReq;
import net.ihago.room.api.rrec.GetNearbyChannelListResp;
import net.ihago.room.api.rrec.GetOpChannelListReq;
import net.ihago.room.api.rrec.GetOpChannelListResp;
import net.ihago.room.api.rrec.RoomTabItem;

public class RoomListMoreModel
implements RoomListMoreMvp.IModel {
    private UserInfoKS mUserInfoBean;
    private static final String TAG = "RoomListMoreModel";
    private int nearbyOffet;
    private int nearbyLimit = 20;
    private List<RoomTabItem> mNearbyRooms = new ArrayList<RoomTabItem>();
    private long cardId;
    private List<String> mOpearRoomIds = new ArrayList<String>();
    private int ktvLimit = 20;
    private List<RoomTabItem> mKtvRooms = new ArrayList<RoomTabItem>();
    private int gangUpLimit = 20;
    private int gangUpOffet = 0;

    public RoomListMoreModel(long cardId, List<String> mOpearRoomIds) {
        this.cardId = cardId;
        this.mOpearRoomIds.clear();
        if (mOpearRoomIds != null && mOpearRoomIds.size() > 0) {
            this.mOpearRoomIds.addAll(mOpearRoomIds);
        }
        this.mUserInfoBean = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                RoomListMoreModel.this.mUserInfoBean = userInfoKSList.get(0);
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    @Override
    public void getMoreNearbyRooms(final boolean isRefresh, final RoomListMoreMvp.CallBack<List<RoomTabItem>, Boolean> callBack) {
        double lat = 0.0;
        double lng = 0.0;
        try {
            String[] locationArray;
            String strlod;
            String location = "";
            if (this.mUserInfoBean != null) {
                location = this.mUserInfoBean.locationTude;
            }
            if (!TextUtils.isEmpty((CharSequence)location)) {
                String[] locationStr = location.split("_");
                if (locationStr.length == 2) {
                    lat = Float.valueOf(locationStr[1]).floatValue();
                    lng = Float.valueOf(locationStr[0]).floatValue();
                }
            } else {
                LocationInfo locationInfo2 = LocationHelper.getLocationInfo((boolean)false);
                if (locationInfo2 != null) {
                    lng = (float)locationInfo2.getLongitude();
                    lat = (float)locationInfo2.getLatitude();
                }
            }
            if (RuntimeContext.sIsDebuggable && !TextUtils.isEmpty((CharSequence)(strlod = SettingFlags.getStringValue((String)"wemeet_lgd_lat", (String)""))) && (locationArray = strlod.split(",")).length == 2) {
                try {
                    lng = Double.valueOf(locationArray[0]);
                    lat = Double.valueOf(locationArray[1]);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"\u89e3\u6790\u7ecf\u7eac\u5ea6 error1", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"\u89e3\u6790\u7ecf\u7eac\u5ea6 error2", (Object[])new Object[0]);
        }
        this.nearbyOffet = isRefresh ? 0 : this.mNearbyRooms.size();
        MLog.info((Object)TAG, (String)("getMoreNearbyRooms start lng:" + lng + " lat:" + lat), (Object[])new Object[0]);
        GetNearbyChannelListReq getNearbyRoomListReq = new GetNearbyChannelListReq.Builder().lat(Double.valueOf(lat)).lng(Double.valueOf(lng)).offset(Long.valueOf(this.nearbyOffet)).limit(Long.valueOf(this.nearbyLimit)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)getNearbyRoomListReq, (IProtoCallback)new SimpleProtoCallback<GetNearbyChannelListResp>(){

            public void onResponse(@NonNull GetNearbyChannelListResp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                List roomList = message.rooms;
                if (roomList != null) {
                    MLog.info((Object)RoomListMoreModel.TAG, (String)("getMoreNearbyRooms onResponseisRefresh:" + isRefresh + " dataSize:" + roomList.size()), (Object[])new Object[0]);
                    if (isRefresh) {
                        RoomListMoreModel.this.mNearbyRooms.clear();
                        RoomListMoreModel.this.mNearbyRooms.addAll(roomList);
                    } else {
                        RoomListMoreModel.this.mNearbyRooms.addAll(roomList);
                    }
                    boolean haseMore = message.has_more;
                    callBack.onResponse(RoomListMoreModel.this.mNearbyRooms, haseMore);
                }
            }

            public void onError(final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onError();
                        MLog.info((Object)RoomListMoreModel.TAG, (String)("getMoreNearbyRooms onErrorreason:" + reason + " code:" + code), (Object[])new Object[0]);
                    }
                });
                super.onError(reason, code);
            }
        });
    }

    @Override
    public void getMoreOpearRooms(boolean isRefresh, final RoomListMoreMvp.CallBack<List<RoomTabItem>, Boolean> callBack) {
        MLog.info((Object)TAG, (String)"getMoreOpearRooms start", (Object[])new Object[0]);
        GetOpChannelListReq getOpRoomListReq = new GetOpChannelListReq.Builder().card_id(Long.valueOf(this.cardId)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)getOpRoomListReq, (IProtoCallback)new SimpleProtoCallback<GetOpChannelListResp>(){

            public void onResponse(@NonNull GetOpChannelListResp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                List mRoomList = message.rooms;
                if (mRoomList != null) {
                    MLog.info((Object)RoomListMoreModel.TAG, (String)("getMoreOpearRooms onResponse dataSize:" + mRoomList.size()), (Object[])new Object[0]);
                    callBack.onResponse(mRoomList, false);
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)RoomListMoreModel.TAG, (String)("getMoreNearbyRooms onError reason:" + reason + " code:" + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onError();
                    }
                });
                super.onError(reason, code);
            }
        });
    }

    @Override
    public void getMoreKtvRooms(final boolean isRefresh, final RoomListMoreMvp.CallBack<List<RoomTabItem>, Boolean> callBack) {
        MLog.info((Object)TAG, (String)"getMoreKtvRooms start", (Object[])new Object[0]);
        int ktvOffset = isRefresh ? 0 : this.mKtvRooms.size();
        GetKTVChannelListReq getKTVRoomListReq = new GetKTVChannelListReq.Builder().limit(Long.valueOf(this.ktvLimit)).offset(Long.valueOf(ktvOffset)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)getKTVRoomListReq, (IProtoCallback)new SimpleProtoCallback<GetKTVChannelListResp>(){

            public void onResponse(@NonNull GetKTVChannelListResp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                List mRoomList = message.rooms;
                if (mRoomList != null) {
                    MLog.info((Object)RoomListMoreModel.TAG, (String)("getMoreKtvRooms isRefresh:" + isRefresh + " dataSize:" + mRoomList.size()), (Object[])new Object[0]);
                    if (isRefresh) {
                        RoomListMoreModel.this.mKtvRooms.clear();
                        RoomListMoreModel.this.mKtvRooms.addAll(mRoomList);
                    } else {
                        RoomListMoreModel.this.mKtvRooms.addAll(mRoomList);
                    }
                    boolean hasMore = message.has_more;
                    callBack.onResponse(RoomListMoreModel.this.mKtvRooms, hasMore);
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)RoomListMoreModel.TAG, (String)("getMoreKtvRooms onError reason:" + reason + " code:" + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onError();
                    }
                });
                super.onError(reason, code);
            }
        });
    }

    @Override
    public void getMoreGangUpRooms(boolean isRefresh, final RoomListMoreMvp.CallBack<List<RoomTabItem>, Boolean> callBack) {
        GetGangupRoomListReq getGangupRoomListReq = new GetGangupRoomListReq.Builder().limit(Long.valueOf(this.gangUpLimit)).offset(Long.valueOf(this.gangUpOffet)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)getGangupRoomListReq, (IProtoCallback)new SimpleProtoCallback<GetGangupRoomListRes>(){

            public void onResponse(@NonNull GetGangupRoomListRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    boolean haseMore = message.has_more;
                    List mList = message.rooms;
                    callBack.onResponse(mList, haseMore);
                } else {
                    MLog.info((Object)RoomListMoreModel.TAG, (String)"GetWeekContributions errorCode:%s, errorInfo:%s", (Object[])new Object[]{message.result.errcode, message.result.errmsg});
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)RoomListMoreModel.TAG, (String)"GetWeekContributions errorCode:%s, errorInfo:%s", (Object[])new Object[]{code, reason});
                super.onError(reason, code);
            }
        });
    }
}

