/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.mvp;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.channel.module.recommend.base.IRoomListModel;
import com.yy.hiyo.channel.module.recommend.base.bean.RoomCreatePermitBean;
import com.yy.hiyo.channel.module.recommend.base.bean.RoomListItemBean;
import com.yy.hiyo.channel.module.recommend.v1.bean.RoomAllDataBean;
import com.yy.hiyo.channel.module.recommend.v1.bean.RoomListRank;
import com.yy.hiyo.channel.module.recommend.v1.bean.RoomReminderListItemBean;
import com.yy.hiyo.channel.module.recommend.v1.mvp.RoomListMvp;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.location.ILocationChangedListener;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import com.yy.yylite.commonbase.hiido.MetricStatisTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ihago.money.api.appconfigcenter.GetRoomBannersConfigReq;
import net.ihago.money.api.appconfigcenter.GetRoomBannersConfigRsp;
import net.ihago.money.api.appconfigcenter.RoomBanner;
import net.ihago.money.api.charm.GetEnterRankInfoReq;
import net.ihago.money.api.charm.GetEnterRankInfoRes;
import net.ihago.room.api.rrec.AlgorithmRecomV2Req;
import net.ihago.room.api.rrec.AlgorithmRecomV2Rsp;
import net.ihago.room.api.rrec.AlgorithmUser;
import net.ihago.room.api.rrec.EFrontpageTab;
import net.ihago.room.api.rrec.FrontpageConfig;
import net.ihago.room.api.rrec.GetChannelsReq;
import net.ihago.room.api.rrec.GetChannelsRes;
import net.ihago.room.api.rrec.GetFrontPageMoreV2Req;
import net.ihago.room.api.rrec.GetFrontPageMoreV2Resp;
import net.ihago.room.api.rrec.GetGangupRoomPanelReq;
import net.ihago.room.api.rrec.GetGangupRoomPanelRes;
import net.ihago.room.api.rrec.GetKTVChannelPanelReq;
import net.ihago.room.api.rrec.GetKTVChannelPanelResp;
import net.ihago.room.api.rrec.GetNearbyChannelPanelReq;
import net.ihago.room.api.rrec.GetNearbyChannelPanelResp;
import net.ihago.room.api.rrec.GetOpChannelPanelReq;
import net.ihago.room.api.rrec.GetOpChannelPanelResp;
import net.ihago.room.api.rrec.InitChannelsReq;
import net.ihago.room.api.rrec.InitChannelsRes;
import net.ihago.room.api.rrec.OpCard;
import net.ihago.room.api.rrec.RoomTabItem;
import net.ihago.room.api.rrec.TabPoz;
import net.ihago.room.srv.follow.NoticeChannelInfo;
import net.ihago.room.srv.follow.PullNoticeChannelListReq;
import net.ihago.room.srv.follow.PullNoticeChannelListRes;
import net.ihago.room.srv.follow.User;

public class RoomListModel
implements RoomListMvp.IModel,
ILocationChangedListener {
    private static final String TAG = "RoomListModel";
    private static final int limit = 20;
    private String cursor = "";
    private String[] urls = null;
    private List<RoomListItemBean> mDatas;
    public static RoomCreatePermitBean mCreatePErmitBean;
    private long mPageSize;
    private List<String> mRids = new ArrayList<String>();
    private List<String> mAlgorithm = new ArrayList<String>();
    private int index;
    private String context = "";
    private boolean isAlgorithmOK = true;
    private String requestMethod;
    private Uri deepLinkUri;
    private UserInfoKS mUserInfoBean;
    private List<TabPoz> mFrontPageList = new ArrayList<TabPoz>();
    private boolean haseNext;
    private List<OpCard> mOpCards;
    private RoomListMvp.IModel.CallBackMoreRoom<RoomAllDataBean> mMoreOtherRoomCallBack;
    private List<Integer> mOtherTypeList = new ArrayList<Integer>();
    float longitude = 0.0f;
    float latitude = 0.0f;

    public RoomListModel() {
        this.mDatas = new ArrayList<RoomListItemBean>();
        this.mFrontPageList = new ArrayList<TabPoz>();
        LocationHelper.addLocationListener((ILocationChangedListener)this);
        this.mUserInfoBean = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                RoomListModel.this.mUserInfoBean = userInfoKSList.get(0);
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    private int getChannelIndex(String curChannel) {
        if (StringUtils.isEmpty((String)curChannel)) {
            return -1;
        }
        for (int i2 = 0; i2 < this.mDatas.size(); ++i2) {
            RoomListItemBean item = this.mDatas.get(i2);
            if (EFrontpageTab.ERoomList.getValue() != item.type || !curChannel.equals(item.roomTabItem.id)) continue;
            return i2;
        }
        return -1;
    }

    public String getNextChannel(String curChannel) {
        int curIndex = this.getChannelIndex(curChannel);
        for (int i2 = curIndex + 1; i2 < this.mDatas.size(); ++i2) {
            RoomListItemBean item = this.mDatas.get(i2);
            if (EFrontpageTab.ERoomList.getValue() != item.type) continue;
            return item.roomTabItem.id;
        }
        return "";
    }

    public String getPrevChannel(String curChannel) {
        int curIndex = this.getChannelIndex(curChannel);
        if (-1 == curIndex) {
            curIndex = this.mDatas.size();
        }
        for (int i2 = curIndex - 1; i2 >= 0; --i2) {
            RoomListItemBean item = this.mDatas.get(i2);
            if (EFrontpageTab.ERoomList.getValue() != item.type) continue;
            return item.roomTabItem.id;
        }
        return "";
    }

    boolean needLoadMoreForSwitch(String channel, int atLeastCnt, boolean next) {
        if (StringUtils.isEmpty((String)channel)) {
            return true;
        }
        int checkedCnt = 0;
        if (next) {
            for (int i2 = this.mDatas.size() - 1; i2 >= 0; --i2) {
                String id2;
                RoomListItemBean item = this.mDatas.get(i2);
                if (EFrontpageTab.ERoomList.getValue() != item.type || TextUtils.isEmpty((CharSequence)(id2 = item.roomTabItem.id))) continue;
                if (id2.equals(channel)) {
                    return true;
                }
                if (++checkedCnt < atLeastCnt) continue;
                return false;
            }
        } else {
            for (int i3 = 0; i3 < this.mDatas.size(); ++i3) {
                String id3;
                RoomListItemBean item = this.mDatas.get(i3);
                if (EFrontpageTab.ERoomList.getValue() != item.type || TextUtils.isEmpty((CharSequence)(id3 = item.roomTabItem.id))) continue;
                if (id3.equals(channel)) {
                    return true;
                }
                if (++checkedCnt < atLeastCnt) continue;
                return false;
            }
        }
        return true;
    }

    public void setDeepLinkUri(Uri deepLinkUri) {
        MLog.info((Object)TAG, (String)"setDeepLinkUri %s", (Object[])new Object[]{deepLinkUri});
        this.deepLinkUri = deepLinkUri;
    }

    @Override
    public void getRecommendChatRoom(IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback, boolean isRefresh) {
        boolean useDeepLink;
        boolean bl = useDeepLink = this.deepLinkUri != null;
        if (!useDeepLink && this.isAlgorithmOK) {
            this.algorithmRecom(callback, isRefresh);
        } else if (isRefresh) {
            if (useDeepLink) {
                this.getChannelListFirstByDeepLink(this.deepLinkUri, callback, true);
            } else {
                this.getChannelListFirst(callback);
            }
        } else {
            this.getChannelByRids(callback);
        }
    }

    @Override
    public String[] getRecommendChatRoom() {
        if (this.urls == null || this.urls.length == 0) {
            if (this.urls == null) {
                MLog.info((Object)TAG, (String)"RoomUrl is null", (Object[])new Object[0]);
            } else {
                MLog.info((Object)TAG, (String)"RoomUrl size is 0", (Object[])new Object[0]);
            }
            return null;
        }
        MLog.info((Object)TAG, (String)("RoomUrl size is " + this.urls.length), (Object[])new Object[0]);
        return this.urls;
    }

    @Override
    public RoomCreatePermitBean getCreateRoomPetmitBean() {
        return mCreatePErmitBean;
    }

    @Override
    public void getCreateRoomPermitReq(final RoomListMvp.IModel.CallBackNew<RoomCreatePermitBean> callBack) {
        MLog.info((Object)TAG, (String)"GetCreateRoomPermitReq Start", (Object[])new Object[0]);
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getControlConfig(new IChannelCenterService.IGetControlConfigCallBack(){

            public void onSuccess(MyChannelControlConfig controlConfig) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)RoomListModel.TAG, (String)"get channel config onSuccess: %s", (Object[])new Object[]{controlConfig});
                }
                if (callBack != null) {
                    if (controlConfig == null) {
                        callBack.onError();
                        return;
                    }
                    RoomListModel.this.handleCreateChannelPermit(controlConfig.canCreateChannel, controlConfig.channelId, callBack);
                }
            }

            public void onError(int errorCode, String errorTips, Exception e) {
                MLog.error((Object)RoomListModel.TAG, (String)"get channel config onError errorCode: %s , error: %s", (Object[])new Object[]{errorCode, e});
                if (callBack != null) {
                    callBack.onError();
                }
            }
        });
    }

    public void getChannelListFirstByDeepLink(@NonNull Uri deepLinkUri, IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback, boolean isList) {
        MLog.info((Object)TAG, (String)"getRoomListFirstByDeepLink %s", (Object[])new Object[]{deepLinkUri});
        String region = this.countryCode();
        int age = SettingFlags.getIntValue((String)"key_myself_age", (int)-1);
        int sex = SettingFlags.getIntValue((String)"key_myself_sex", (int)-1);
        Map contextMap = URLUtils.getParams((Uri)deepLinkUri);
        contextMap.put("qudao", "deeplink");
        String authority = deepLinkUri.getAuthority();
        String path2 = deepLinkUri.getPath();
        boolean isJoinRoom = StringUtils.equalsIgnoreCase((String)"voiceRoom", (String)authority) && StringUtils.equalsIgnoreCase((String)"/room", (String)path2);
        InitChannelsReq initRoomsReq = new InitChannelsReq.Builder().region(StringUtils.ensureNotNull((String)region)).age(Integer.valueOf(age)).sex(Integer.valueOf(sex)).context(contextMap).join(Boolean.valueOf(!isList)).channel(AccountUtil.getLoginChannel()).build();
        this.getChannelListFirst(initRoomsReq, callback);
    }

    @Override
    public void getChannelListFirst(IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callback.requestResult((Object)false);
            return;
        }
        MLog.info((Object)TAG, (String)"getRoomListFirst Start ", (Object[])new Object[0]);
        InitChannelsReq initRoomsReq = new InitChannelsReq.Builder().channel(AccountUtil.getLoginChannel()).build();
        this.getChannelListFirst(initRoomsReq, callback);
    }

    @Override
    public void getChannelListFirst(InitChannelsReq initRoomsReq, final IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback) {
        final MetricStatisTask statisTask = new MetricStatisTask("hyroomlist/normal");
        ProtoManager.getInstance().sendRpc((AndroidMessage)initRoomsReq, (IProtoCallback)new SimpleProtoCallback<InitChannelsRes>("RoomListModel getRoomListFirst"){

            public void onResponse(@Nullable InitChannelsRes message) {
                super.onResponse((AndroidMessage)message);
                RoomListModel.this.handleFirstRoomListRequest(message, (IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean>)callback);
                statisTask.finish(0L);
            }

            public void onResponse(@NonNull InitChannelsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    statisTask.finish(0L);
                    RoomListModel.this.handleFirstRoomListRequest(message, (IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean>)callback);
                } else {
                    statisTask.finish(code);
                    MLog.info((Object)RoomListModel.TAG, (String)("RoomListRequest errorCode And Message " + code + " , " + msg), (Object[])new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                RoomListModel.this.getOtherRoomListData();
                super.onError(reason, code);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.requestResult((Object)false);
                    }
                });
                statisTask.finish((long)code);
            }
        });
    }

    @Override
    public void getChannelByRids(final IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callback.requestResult((Object)false);
            return;
        }
        MLog.info((Object)TAG, (String)"getRoomsByRids Start ", (Object[])new Object[0]);
        final MetricStatisTask statisTask = new MetricStatisTask("hyroomlist/loadmore");
        List<String> mRequestRids = this.getRidsByIndex();
        GetChannelsReq getRoomsReq = new GetChannelsReq.Builder().rids(mRequestRids).channel(AccountUtil.getLoginChannel()).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getRoomsReq, (IProtoCallback)new SimpleProtoCallback<GetChannelsRes>("RoomListModel getRoomsByRids"){

            public void onResponse(@Nullable GetChannelsRes message) {
                super.onResponse((AndroidMessage)message);
                RoomListModel.this.handleLoadMoreRoomListRequest(message, (IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean>)callback);
                statisTask.finish(0L);
            }

            public void onResponse(@NonNull GetChannelsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    statisTask.finish(0L);
                    RoomListModel.this.handleLoadMoreRoomListRequest(message, (IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean>)callback);
                } else {
                    statisTask.finish(code);
                    MLog.info((Object)RoomListModel.TAG, (String)("handleLoadMoreRoomListRequest errorCode and error " + code + " , " + msg), (Object[])new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.requestResult((Object)false);
                    }
                });
                statisTask.finish((long)code);
            }
        });
    }

    @Override
    public void algorithmRecom(final IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback, final boolean isRefresh) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callback.requestResult((Object)false);
            return;
        }
        MLog.info((Object)TAG, (String)"AlgorithmRecom Start ", (Object[])new Object[0]);
        long currentTime = System.currentTimeMillis();
        int offset = 0;
        if (!isRefresh) {
            offset = this.mDatas.size();
        }
        final MetricStatisTask statisTask = new MetricStatisTask("hyroomlist/algorithm");
        AlgorithmRecomV2Req algorithmRecomReq = new AlgorithmRecomV2Req.Builder().context(this.context).ts(Long.valueOf(currentTime)).user(this.getAlgorithmUser()).num(Integer.valueOf(20)).offset(Integer.valueOf(offset)).app_version(this.getAppVer()).channel(AccountUtil.getLoginChannel()).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)algorithmRecomReq, (IProtoCallback)new SimpleProtoCallback<AlgorithmRecomV2Rsp>("RoomListModel AlgorithmRecom"){

            public void onResponse(@NonNull AlgorithmRecomV2Rsp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                RoomListModel.this.handleAlgorithmRoomListRequest(message, (IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean>)callback, isRefresh);
                statisTask.finish(0L);
            }

            public void onResponse(@Nullable AlgorithmRecomV2Rsp message) {
                super.onResponse((AndroidMessage)message);
                RoomListModel.this.handleAlgorithmRoomListRequest(message, (IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean>)callback, isRefresh);
                statisTask.finish(0L);
            }

            public void onError(String reason, int code) {
                RoomListModel.this.getOtherRoomListData();
                super.onError(reason, code);
                MLog.info((Object)RoomListModel.TAG, (String)("AlgorithmRecom onError reason\uff1a" + reason + " code:" + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.requestResult((Object)false);
                    }
                });
                statisTask.finish((long)code);
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)RoomListModel.TAG, (String)("AlgorithmRecom retryWhenError reason\uff1a" + reason + " code:" + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.requestResult((Object)false);
                    }
                });
                statisTask.finish((long)code);
                return super.retryWhenError(canRetry, reason, code);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.requestResult((Object)false);
                    }
                });
                statisTask.finish(-1L);
                MLog.info((Object)RoomListModel.TAG, (String)"AlgorithmRecom retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }
        });
    }

    @Override
    public void getOtherRoomListData() {
        MLog.info((Object)TAG, (String)"getOtherRoomListData start", (Object[])new Object[0]);
        GetRoomBannersConfigReq getRoomBannersConfigReq = this.getBannerRequest();
        PullNoticeChannelListReq pullNoticeListReq = this.getReminderRoom();
        GetNearbyChannelPanelReq getNearbyRoomPanelReq = this.getNearByRoomRequest();
        GetOpChannelPanelReq getOpRoomPanelReq = this.getOperateRoomRequest();
        GetKTVChannelPanelReq getKTVRoomPanelReq = this.getKtvRoomRequest();
        GetEnterRankInfoReq getEnterRankInfoReq = this.getGetEnterRankInfoReq();
        GetGangupRoomPanelReq getGangupRoomPanelReq = new GetGangupRoomPanelReq.Builder().build();
        GetFrontPageMoreV2Req getFrontPageMoreReq = new GetFrontPageMoreV2Req.Builder().banner(getRoomBannersConfigReq).follow(pullNoticeListReq).nearby(getNearbyRoomPanelReq).operate(getOpRoomPanelReq).ktv(getKTVRoomPanelReq).rank(getEnterRankInfoReq).gang_up(getGangupRoomPanelReq).build();
        final MetricStatisTask statisTask = new MetricStatisTask("hyroomlist/other");
        ProtoManager.getInstance().sendHttp((AndroidMessage)getFrontPageMoreReq, (IProtoCallback)new SimpleProtoCallback<GetFrontPageMoreV2Resp>(){

            public void onResponse(@Nullable GetFrontPageMoreV2Resp message) {
                super.onResponse((AndroidMessage)message);
            }

            public void onResponse(@NonNull GetFrontPageMoreV2Resp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    statisTask.finish(0L);
                    RoomListModel.this.handleOtherResponse(message);
                } else {
                    statisTask.finish(code);
                    MLog.info((Object)RoomListModel.TAG, (String)("getOtherRoomListData message errorCode and errorMessage:" + code), (Object[])new Object[0]);
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)RoomListModel.TAG, (String)("errorCode" + code + "error Reason " + reason), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (RoomListModel.this.mMoreOtherRoomCallBack != null) {
                            RoomListModel.this.mMoreOtherRoomCallBack.onError();
                        }
                    }
                });
                super.onError(reason, code);
                statisTask.finish((long)code);
            }
        });
    }

    private void handleOtherResponse(GetFrontPageMoreV2Resp message) {
        if (message != null) {
            MLog.info((Object)TAG, (String)"getOtherRoomListData Response", (Object[])new Object[0]);
            FrontpageConfig frontPageConfig = message.config;
            PullNoticeChannelListRes reminder = message.follow;
            GetRoomBannersConfigRsp getRoomBannersConfigRsp = message.banner;
            GetNearbyChannelPanelResp getNearbyRoomPanelResp = message.nearby;
            GetOpChannelPanelResp getOpRoomPanelResp = message.operate;
            GetKTVChannelPanelResp getKTVRoomPanelResp = message.ktv;
            GetEnterRankInfoRes getEnterRankInfoRes = message.rank;
            GetGangupRoomPanelRes getGangupRoomPanelRes = message.gang_up;
            String token = reminder.token;
            List noticeUserInfos = reminder.list;
            if (noticeUserInfos != null && noticeUserInfos.size() > 8) {
                noticeUserInfos = noticeUserInfos.subList(0, 9);
            }
            List<RoomReminderListItemBean> reminderList = this.requestPageUserDetails(noticeUserInfos, token);
            List banner = getRoomBannersConfigRsp.banners;
            List mKtvRoom = getKTVRoomPanelResp.rooms;
            List mNearbyRoom = getNearbyRoomPanelResp.rooms;
            List mCharmRanks = getEnterRankInfoRes.charm_ranks;
            List mContributionRanks = getEnterRankInfoRes.contribution_ranks;
            List mGangUpRooms = getGangupRoomPanelRes.rooms;
            boolean isGangUpHasMore = getGangupRoomPanelRes.has_more;
            boolean isHavektvMore = getKTVRoomPanelResp.has_more;
            boolean isHaveNearbyRoom = getNearbyRoomPanelResp.has_more;
            boolean isSendReceiveGift = getEnterRankInfoRes.send_revice_gift;
            RoomListRank roomListRank = new RoomListRank();
            roomListRank.setCharmRanks(mCharmRanks);
            roomListRank.setContributionRanks(mContributionRanks);
            roomListRank.setSendReviceGift(isSendReceiveGift);
            this.clearOtherRoomData();
            this.mOpCards = getOpRoomPanelResp.cards;
            this.handleFrontpageConfig(frontPageConfig, this.mOpCards);
            if (this.mOpCards.size() == 0) {
                this.removeNoOpearData(EFrontpageTab.ERoomOperate.getValue());
            }
            if (mKtvRoom.size() == 0) {
                this.removeNoOpearData(EFrontpageTab.ERoomKTV.getValue());
            }
            if (mNearbyRoom.size() == 0) {
                this.removeNoOpearData(EFrontpageTab.ERoomNearby.getValue());
            }
            if (mGangUpRooms.size() == 0) {
                this.removeNoOpearData(EFrontpageTab.EGangup.getValue());
            }
            this.removeOtherTypeData();
            ArrayList<OpCard> tempOpcards = new ArrayList<OpCard>();
            tempOpcards.addAll(this.mOpCards);
            this.addFrontPageConfigtoData(tempOpcards);
            MLog.info((Object)TAG, (String)("getOtherRoomListData reminderList size: " + reminderList.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData banner size: " + banner.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData mKtvRoom size: " + mKtvRoom.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData mNearbyRoom size:" + mNearbyRoom.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData mOpCards Size: " + this.mOpCards.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData mCharmRanks size: " + mCharmRanks.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData mContributionRanks size: " + mContributionRanks.size()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData isHavektvMore: " + isHavektvMore), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData isHaveNearbyRoom: " + isHaveNearbyRoom), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("getOtherRoomListData isSendReceiveGift: " + isSendReceiveGift), (Object[])new Object[0]);
            List logTab = frontPageConfig.tab_in_room;
            for (int i2 = 0; i2 < logTab.size(); ++i2) {
                TabPoz tabPoz = (TabPoz)logTab.get(i2);
                MLog.info((Object)TAG, (String)("getOtherRoomListData mTab: " + tabPoz.tab + " mPoz: " + tabPoz.poz), (Object[])new Object[0]);
            }
            Map<Long, OpCard> opearMap = this.getOpearRoomMap(this.mOpCards);
            RoomAllDataBean roomAllDateBean = new RoomAllDataBean();
            roomAllDateBean.setReminderList(reminderList);
            roomAllDateBean.setBanner(banner);
            roomAllDateBean.setmKtvRoom(mKtvRoom);
            roomAllDateBean.setmNearbyRoom(mNearbyRoom);
            roomAllDateBean.setRoomListRank(roomListRank);
            roomAllDateBean.setGangUpRoom(mGangUpRooms);
            roomAllDateBean.setHasGangMore(isGangUpHasMore);
            roomAllDateBean.setHavektvMore(isHavektvMore);
            roomAllDateBean.setHaveNearbyRoom(isHaveNearbyRoom);
            roomAllDateBean.setOpearMap(opearMap);
            roomAllDateBean.setmDatas(this.mDatas);
            roomAllDateBean.setHasNext(this.haseNext);
            if (this.mMoreOtherRoomCallBack != null) {
                this.mMoreOtherRoomCallBack.onResponse(roomAllDateBean);
            }
        } else {
            MLog.info((Object)TAG, (String)"getOtherRoomListData message is null ", (Object[])new Object[0]);
        }
    }

    private void clearOtherRoomData() {
        this.mOtherTypeList.clear();
        this.mFrontPageList.clear();
        Iterator<RoomListItemBean> iter = this.mDatas.iterator();
        while (iter.hasNext()) {
            RoomListItemBean s = iter.next();
            if (!this.isDelete(s.type)) continue;
            iter.remove();
        }
    }

    private boolean isDelete(int type) {
        return type == EFrontpageTab.EFollow.getValue() || type == EFrontpageTab.EBanner.getValue() || type == EFrontpageTab.EQuitJoin.getValue() || type == EFrontpageTab.ERoomNearby.getValue() || type == EFrontpageTab.ERoomOperate.getValue() || type == EFrontpageTab.ERoomKTV.getValue() || type == EFrontpageTab.ECharmRank.getValue();
    }

    private void removeNoOpearData(int type) {
        Iterator<TabPoz> iterator = this.mFrontPageList.iterator();
        while (iterator.hasNext()) {
            TabPoz tabPoz = iterator.next();
            if (tabPoz.tab != type) continue;
            iterator.remove();
        }
    }

    private void removeOtherTypeData() {
        for (TabPoz tabPoz : this.mFrontPageList) {
            if (tabPoz.tab > 0 && tabPoz.tab <= EFrontpageTab.ECharmRank.getValue()) continue;
            this.mFrontPageList.remove(tabPoz);
        }
    }

    private Map<Long, OpCard> getOpearRoomMap(List<OpCard> mList) {
        HashMap<Long, OpCard> opearMap = new HashMap<Long, OpCard>();
        for (int i2 = 0; i2 < mList.size(); ++i2) {
            OpCard opCard = mList.get(i2);
            opearMap.put(opCard.card_id, opCard);
        }
        return opearMap;
    }

    private List<RoomReminderListItemBean> requestPageUserDetails(List<NoticeChannelInfo> noticeUserList, String token) {
        ArrayList<RoomReminderListItemBean> reminderList = new ArrayList<RoomReminderListItemBean>();
        if (noticeUserList != null && noticeUserList.size() > 0) {
            for (int i2 = 0; i2 < noticeUserList.size(); ++i2) {
                NoticeChannelInfo noticeUserInfo = noticeUserList.get(i2);
                RoomReminderListItemBean roomReminderListItemBean = new RoomReminderListItemBean();
                roomReminderListItemBean.noticeUserInfo = noticeUserInfo;
                roomReminderListItemBean.token = token;
                reminderList.add(roomReminderListItemBean);
            }
        }
        return reminderList;
    }

    public void setMoreOtherRoomCallBack(RoomListMvp.IModel.CallBackMoreRoom<RoomAllDataBean> mMoreOtherRoomCallBack) {
        this.mMoreOtherRoomCallBack = mMoreOtherRoomCallBack;
    }

    private void handleFrontpageConfig(FrontpageConfig frontpageConfig, List<OpCard> mOpearCards) {
        List getTempList = frontpageConfig.tab_in_room;
        this.handleFrontpageConfig(getTempList, mOpearCards);
    }

    private void handleFrontpageConfig(List<TabPoz> getTempList, List<OpCard> mOpearCards) {
        TabPoz tabPoz;
        int i2;
        if (getTempList == null || getTempList.size() == 0) {
            return;
        }
        boolean isHaveKtv = false;
        boolean isHaveNearby = false;
        boolean isHaveOpear = false;
        for (i2 = 0; i2 < getTempList.size(); ++i2) {
            tabPoz = getTempList.get(i2);
            if (tabPoz.tab.intValue() == EFrontpageTab.ERoomNearby.getValue()) {
                isHaveNearby = true;
            }
            if (tabPoz.tab.intValue() == EFrontpageTab.ERoomKTV.getValue()) {
                isHaveKtv = true;
            }
            if (tabPoz.tab.intValue() != EFrontpageTab.ERoomOperate.getValue()) continue;
            isHaveOpear = true;
        }
        this.mFrontPageList.addAll(getTempList);
        if (!isHaveNearby) {
            TabPoz tabPoz2 = new TabPoz.Builder().poz(Integer.valueOf(4)).tab(Integer.valueOf(EFrontpageTab.ERoomNearby.getValue())).build();
            this.mFrontPageList.add(tabPoz2);
        }
        if (!isHaveOpear) {
            for (i2 = 0; i2 < mOpearCards.size(); ++i2) {
                tabPoz = new TabPoz.Builder().poz(Integer.valueOf(8)).tab(Integer.valueOf(EFrontpageTab.ERoomNearby.getValue())).build();
                this.mFrontPageList.add(tabPoz);
            }
        }
        if (!isHaveKtv) {
            TabPoz tabPoz3 = new TabPoz.Builder().poz(Integer.valueOf(14)).tab(Integer.valueOf(EFrontpageTab.ERoomKTV.getValue())).build();
            this.mFrontPageList.add(tabPoz3);
        }
    }

    private void addFrontPageConfigtoData(List<OpCard> mOpCards) {
        ArrayList<TabPoz> tempList = new ArrayList<TabPoz>();
        if (this.mFrontPageList != null && this.mDatas != null) {
            for (int i2 = 0; i2 < this.mFrontPageList.size(); ++i2) {
                TabPoz tabPoz = this.mFrontPageList.get(i2);
                MLog.info((Object)"addFrontPageConfigtoData", (String)("Tab" + tabPoz.tab + ",Position" + tabPoz.poz), (Object[])new Object[0]);
                if (tabPoz.tab.intValue() == EFrontpageTab.ENone.getValue()) continue;
                RoomListItemBean roomListItemBean = new RoomListItemBean(tabPoz.tab.intValue());
                if (tabPoz.tab.intValue() == EFrontpageTab.ERoomOperate.getValue()) {
                    OpCard card = this.findOpCard(tabPoz.poz, mOpCards);
                    if (card == null) {
                        roomListItemBean.setOperRoomCardId(Long.valueOf(0L));
                    } else {
                        roomListItemBean.setOperRoomCardId(card.card_id);
                    }
                }
                if (tabPoz.poz > this.mDatas.size() - 1) {
                    tempList.add(tabPoz);
                    continue;
                }
                int insertIndex = tabPoz.poz % 2 == 0 && this.mOtherTypeList.size() % 2 == 1 ? tabPoz.poz + 1 : (tabPoz.poz % 2 == 1 && this.mOtherTypeList.size() % 2 == 0 ? tabPoz.poz + 1 : tabPoz.poz);
                this.mOtherTypeList.add(new Integer(0));
                this.mDatas.add(insertIndex, roomListItemBean);
            }
            this.mFrontPageList.clear();
            if (this.haseNext) {
                this.mFrontPageList.addAll(tempList);
            } else {
                this.ifNoMoreRoomListAdd(tempList, mOpCards);
            }
        }
    }

    private void ifNoMoreRoomListAdd(List<TabPoz> tempList, List<OpCard> mOpCards) {
        for (int i2 = 0; i2 < tempList.size(); ++i2) {
            TabPoz tabPoz = tempList.get(i2);
            RoomListItemBean roomListItemBean = new RoomListItemBean(tabPoz.tab.intValue());
            if (tabPoz.tab.intValue() == EFrontpageTab.ERoomOperate.getValue()) {
                OpCard card = this.findOpCard(tabPoz.poz, mOpCards);
                if (card == null) {
                    roomListItemBean.setOperRoomCardId(Long.valueOf(0L));
                } else {
                    roomListItemBean.setOperRoomCardId(card.card_id);
                }
            }
            this.mOtherTypeList.add(new Integer(0));
            this.mDatas.add(roomListItemBean);
        }
    }

    private OpCard findOpCard(int position, List<OpCard> mOpCards) {
        OpCard opCard = null;
        if (mOpCards != null) {
            for (int i2 = 0; i2 < mOpCards.size(); ++i2) {
                OpCard card = mOpCards.get(i2);
                if (card.pos != (long)position) continue;
                opCard = card;
                mOpCards.remove(opCard);
                return opCard;
            }
            return opCard;
        }
        return opCard;
    }

    private GetKTVChannelPanelReq getKtvRoomRequest() {
        GetKTVChannelPanelReq getKTVRoomListReq = new GetKTVChannelPanelReq.Builder().build();
        return getKTVRoomListReq;
    }

    private GetOpChannelPanelReq getOperateRoomRequest() {
        GetOpChannelPanelReq getOpRoomPanelReq = new GetOpChannelPanelReq.Builder().build();
        return getOpRoomPanelReq;
    }

    private GetNearbyChannelPanelReq getNearByRoomRequest() {
        try {
            String[] locationArray;
            String strlod;
            String location = "";
            if (this.mUserInfoBean != null) {
                location = this.mUserInfoBean.locationTude;
            }
            if (!TextUtils.isEmpty((CharSequence)location)) {
                String[] locationStr = location.split("_");
                if (locationStr.length == 2) {
                    this.longitude = Float.valueOf(locationStr[0]).floatValue();
                    this.latitude = Float.valueOf(locationStr[1]).floatValue();
                }
            } else {
                LocationInfo locationInfo2 = LocationHelper.getLocationInfo((boolean)false);
                if (locationInfo2 != null) {
                    this.longitude = (float)locationInfo2.getLongitude();
                    this.latitude = (float)locationInfo2.getLatitude();
                }
            }
            if (RuntimeContext.sIsDebuggable && !TextUtils.isEmpty((CharSequence)(strlod = SettingFlags.getStringValue((String)"wemeet_lgd_lat", (String)""))) && (locationArray = strlod.split(",")).length == 2) {
                try {
                    this.longitude = Float.valueOf(locationArray[0]).floatValue();
                    this.latitude = Float.valueOf(locationArray[1]).floatValue();
                }
                catch (Exception e) {
                    MLog.error((Object)"GetNearbyRoomPanelReq", (String)"Error", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            MLog.info((Object)"GetNearbyRoomPanelReq", (String)"getLocationError", (Object[])new Object[0]);
        }
        MLog.info((Object)"GetNearbyRoomPanelReq", (String)("longitude:" + this.longitude + ",latitude:" + this.latitude), (Object[])new Object[0]);
        GetNearbyChannelPanelReq getNearbyRoomPanelReq = new GetNearbyChannelPanelReq.Builder().lat(Double.valueOf(this.latitude)).lng(Double.valueOf(this.longitude)).build();
        return getNearbyRoomPanelReq;
    }

    private GetRoomBannersConfigReq getBannerRequest() {
        GetRoomBannersConfigReq req = new GetRoomBannersConfigReq.Builder().build();
        return req;
    }

    private PullNoticeChannelListReq getReminderRoom() {
        PullNoticeChannelListReq req = new PullNoticeChannelListReq.Builder().user(this.getUser()).build();
        return req;
    }

    private User getUser() {
        long uid = AccountUtil.getUid();
        String hid = HiidoUtils.getHdid();
        String os = "android";
        String lan = this.languageCode();
        String region = this.countryCode();
        int age = SettingFlags.getIntValue((String)"key_myself_age", (int)-1);
        int sex = SettingFlags.getIntValue((String)"key_myself_sex", (int)-1);
        User user = new User.Builder().uid(Long.valueOf(uid)).hdid(hid).os(os).lan(lan).region(region).age(Integer.valueOf(age)).sex(Integer.valueOf(sex)).build();
        return user;
    }

    @Override
    public void getRoomBanner(final IRoomListModel.Callback<List<RoomBanner>, Boolean, Boolean> callBack) {
        GetRoomBannersConfigReq req = new GetRoomBannersConfigReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetRoomBannersConfigRsp>(){

            public void onResponse(@Nullable GetRoomBannersConfigRsp message) {
                if (message == null) {
                    MLog.info((Object)"FTVoiceRoomBanner", (String)"getRoomBanner\u4e3a\u7a7a", (Object[])new Object[0]);
                    return;
                }
                if (message.getResultValue() == 0) {
                    MLog.info((Object)"FTVoiceRoomBanner", (String)"getRoomBanner\u6210\u529f", (Object[])new Object[0]);
                    if (callBack != null) {
                        callBack.onResponse((Object)message.banners, (Object)false);
                    }
                } else {
                    FeatureLog.e((String)"FTVoiceRoomBanner", (String)"getRoomBanner\u5931\u8d25\uff0c\u9519\u8bef\u7801:%s", (Object[])new Object[]{message.getResultValue()});
                }
                if (callBack != null) {
                    callBack.requestResult((Object)true);
                }
                super.onResponse((AndroidMessage)message);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)"FTVoiceRoomBanner", (String)"getRoomBanner\u8d85\u65f6", (Object[])new Object[0]);
                if (callBack != null) {
                    callBack.requestResult((Object)false);
                }
                return super.retryWhenTimeout(canRetry);
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)"FTVoiceRoomBanner", (String)"getRoomBanner:error:%s", (Object[])new Object[]{reason});
                if (callBack != null) {
                    callBack.requestResult((Object)false);
                }
                return super.retryWhenError(canRetry, reason, code);
            }

            public void onError(String reason, int code) {
                MLog.info((Object)"FTVoiceRoomBanner", (String)"getRoomBanner:error:%s, code:%s", (Object[])new Object[]{reason, code});
                if (callBack != null) {
                    callBack.requestResult((Object)false);
                }
                super.onError(reason, code);
            }
        });
    }

    @Override
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public void clearData() {
        this.cursor = "";
        this.urls = null;
        this.mDatas.clear();
        this.mPageSize = 0L;
        this.mRids.clear();
        this.index = 0;
        this.mAlgorithm.clear();
        this.index = 0;
        this.context = "";
        this.isAlgorithmOK = true;
    }

    private void handleFirstRoomListRequest(InitChannelsRes message, IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback) {
        this.index = 0;
        if (message != null) {
            List roomsList = message.rooms;
            if (roomsList != null && roomsList.size() > 0) {
                MLog.info((Object)TAG, (String)("FirstRoomListRequest size " + roomsList.size()), (Object[])new Object[0]);
                List<RoomListItemBean> tempRoomList = this.getCustomerRoomBean(roomsList, "");
                this.mDatas.clear();
                this.mDatas.addAll(tempRoomList);
                List mTempList = message.rids;
                this.mRids.clear();
                this.mRids.addAll(mTempList);
                this.mPageSize = message.page_size;
                this.haseNext = this.mRids != null && this.mRids.size() != 0;
                this.getOtherRoomListData();
            } else {
                MLog.info((Object)TAG, (String)"RoomListRequest size 0", (Object[])new Object[0]);
                this.getOtherRoomListData();
            }
        } else {
            MLog.info((Object)TAG, (String)"RoomListRequest message null 0", (Object[])new Object[0]);
            this.getOtherRoomListData();
        }
    }

    public boolean hasNext() {
        return this.haseNext;
    }

    private void handleAlgorithmRoomListRequest(AlgorithmRecomV2Rsp message, IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback, boolean isRefresh) {
        if (message != null) {
            this.isAlgorithmOK = message.is_ok;
            MLog.info((Object)TAG, (String)("AlgorithmRecom isAlgorithmOK " + this.isAlgorithmOK), (Object[])new Object[0]);
            List roomsList = message.rooms;
            if (!this.isAlgorithmOK) {
                if (isRefresh) {
                    MLog.info((Object)TAG, (String)"AlgorithmRecom isNewRequest ", (Object[])new Object[0]);
                    this.getChannelListFirst(callback);
                    this.requestMethod = "FirstRoomListRequest";
                } else {
                    callback.requestResult((Object)false);
                }
                return;
            }
            this.requestMethod = "AlgorithmRequest";
            String token = message.token;
            this.context = message.context;
            if (roomsList != null && roomsList.size() > 0) {
                MLog.info((Object)TAG, (String)("AlgorithmRecom size " + roomsList.size()), (Object[])new Object[0]);
                if (isRefresh) {
                    this.mAlgorithm.clear();
                }
                List<RoomListItemBean> tempRoomList = this.getCustomerRoomBean(roomsList, token);
                if (isRefresh) {
                    this.mDatas.clear();
                    this.mDatas.addAll(tempRoomList);
                } else {
                    this.mDatas.addAll(tempRoomList);
                }
                this.haseNext = roomsList.size() >= 20;
                if (isRefresh) {
                    this.getOtherRoomListData();
                } else {
                    ArrayList<OpCard> tempOpcards = new ArrayList<OpCard>();
                    if (this.mOpCards == null) {
                        this.mOpCards = new ArrayList<OpCard>();
                    }
                    tempOpcards.addAll(this.mOpCards);
                    this.addFrontPageConfigtoData(tempOpcards);
                    callback.onResponse(this.mDatas, (Object)this.haseNext);
                }
            } else {
                if (isRefresh) {
                    this.getOtherRoomListData();
                } else {
                    callback.requestResult((Object)false);
                }
                MLog.info((Object)TAG, (String)"RoomListRequest size 0", (Object[])new Object[0]);
            }
        } else {
            MLog.info((Object)TAG, (String)"RoomListRequest message null 0", (Object[])new Object[0]);
            if (isRefresh) {
                this.getOtherRoomListData();
            } else {
                callback.requestResult((Object)false);
            }
        }
    }

    private GetEnterRankInfoReq getGetEnterRankInfoReq() {
        GetEnterRankInfoReq getEnterRankInfoReq = new GetEnterRankInfoReq.Builder().uid(Long.valueOf(AccountUtil.getUid())).build();
        return getEnterRankInfoReq;
    }

    private void handleLoadMoreRoomListRequest(GetChannelsRes message, IRoomListModel.Callback<List<RoomListItemBean>, Boolean, Boolean> callback) {
        ++this.index;
        if (message != null) {
            List roomsList = message.rooms;
            if (roomsList != null && roomsList.size() > 0) {
                MLog.info((Object)TAG, (String)("handleLoadMoreRoomListRequest size " + roomsList.size()), (Object[])new Object[0]);
                List<RoomListItemBean> tempRoomList = this.getCustomerRoomBean(roomsList, null);
                this.mDatas.addAll(tempRoomList);
                float allIndex = (long)this.mRids.size() / this.mPageSize;
                this.haseNext = !((float)this.index >= allIndex);
                ArrayList<OpCard> tempOpcards = new ArrayList<OpCard>();
                if (this.mOpCards == null) {
                    this.mOpCards = new ArrayList<OpCard>();
                }
                tempOpcards.addAll(this.mOpCards);
                this.addFrontPageConfigtoData(this.mOpCards);
                callback.onResponse(this.mDatas, (Object)this.haseNext);
            } else {
                MLog.info((Object)TAG, (String)"handleLoadMoreRoomListRequest size 0", (Object[])new Object[0]);
                callback.requestResult((Object)false);
            }
        } else {
            MLog.info((Object)TAG, (String)"handleLoadMoreRoomListRequest message null 0", (Object[])new Object[0]);
            callback.requestResult((Object)false);
        }
    }

    private void handleCreateChannelPermit(boolean canCreateChannel, String channelId, RoomListMvp.IModel.CallBackNew<RoomCreatePermitBean> callBack) {
        RoomCreatePermitBean bean = new RoomCreatePermitBean();
        bean.setPermit(canCreateChannel);
        bean.setRoomid(channelId);
        MLog.info((Object)TAG, (String)("GetCreateRoomPermitReq message resultpermit:" + canCreateChannel + " roomId:" + channelId), (Object[])new Object[0]);
        mCreatePErmitBean = bean;
        callBack.onResponse(bean);
    }

    private List<RoomListItemBean> getCustomerRoomBean(List<RoomTabItem> roomsList, String token) {
        ArrayList<RoomListItemBean> tempRoomList = new ArrayList<RoomListItemBean>();
        for (int i2 = 0; i2 < roomsList.size(); ++i2) {
            RoomTabItem roomTabItem = roomsList.get(i2);
            RoomListItemBean customerRoomBean = new RoomListItemBean(roomTabItem, token);
            customerRoomBean.type = EFrontpageTab.ERoomList.getValue();
            tempRoomList.add(customerRoomBean);
            this.mAlgorithm.add(roomTabItem.id);
        }
        return tempRoomList;
    }

    private List<String> getRidsByIndex() {
        String index;
        int realIndex;
        ArrayList<String> reqRidList = new ArrayList<String>();
        long start = (long)this.index * this.mPageSize;
        long end = start + this.mPageSize;
        if (end > (long)this.mRids.size()) {
            end = this.mRids.size();
        }
        for (long i2 = start; i2 < end && (realIndex = Integer.valueOf(index = String.valueOf(i2)).intValue()) < this.mRids.size(); ++i2) {
            String rid = this.mRids.get(realIndex);
            reqRidList.add(rid);
        }
        return reqRidList;
    }

    private AlgorithmUser getAlgorithmUser() {
        long uid = AccountUtil.getUid();
        String hid = HiidoUtils.getHdid();
        String os = "android";
        String lan = this.languageCode();
        String region = this.countryCode();
        int age = SettingFlags.getIntValue((String)"key_myself_age", (int)-1);
        int sex = SettingFlags.getIntValue((String)"key_myself_sex", (int)-1);
        AlgorithmUser algorithmUser = new AlgorithmUser.Builder().uid(Long.valueOf(uid)).hdid(hid).os(os).lan(lan).region(region).age(Integer.valueOf(age)).sex(Integer.valueOf(sex)).build();
        return algorithmUser;
    }

    private String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }

    private String languageCode() {
        String code = SystemUtils.getLang();
        if (code == null) {
            return "";
        }
        return code.toLowerCase();
    }

    public String getAppVer() {
        String appVer = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getVersionCodeWithoutSnapshot();
        return appVer;
    }

    public void onLocationFailed(int errorCode, String errorMsg) {
    }

    public void onLocationChanged(LocationInfo info, boolean isCache) {
        if (info != null && info.getLatitude() != 0.0 && info.getLongitude() != 0.0 && this.longitude == 0.0f && this.latitude == 0.0f) {
            this.longitude = (float)info.getLongitude();
            this.latitude = (float)info.getLatitude();
            this.getOtherRoomListData();
        }
    }
}

