/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.adapter;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.utils.AnimatorUtils;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.rclayout.RCLinearLayout;
import com.yy.appbase.unifyconfig.config.VoiceRoomTagConfigData;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.module.recommend.R;
import com.yy.hiyo.channel.module.recommend.base.channelhiido.RoomListReportEventBean;
import com.yy.hiyo.channel.module.recommend.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.recommend.v1.adapter.IRoomListAdapterCallBack;
import com.yy.hiyo.channel.module.recommend.v1.bean.RoomReminderListItemBean;
import com.yy.hiyo.channel.module.recommend.v1.listener.OnReminderItemClickListener;
import com.yy.hiyo.channel.module.recommend.v1.listener.OnReminderMoreClickListener;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.ihago.room.srv.follow.NoticeChannelInfo;

public class RoomReminderListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_MOER_REMINDER = 1;
    public static final int TYPE_SIMPLE = 2;
    public static final int MAX_LIST_SIZE = 8;
    public static final int LIMIT_SIMPLE_LIST_SIZE = 2;
    private TimeInterpolator interpolator;
    private OnReminderItemClickListener mItemListener;
    private OnReminderMoreClickListener mMoreListener;
    private List<RoomReminderListItemBean> mDatas = new ArrayList<RoomReminderListItemBean>();
    private IRoomListAdapterCallBack mCallBack;
    private LinkedHashMap<String, VoiceRoomTagConfigData> mTagsMap;

    public void updateData(List<RoomReminderListItemBean> data) {
        this.mDatas.clear();
        this.mDatas.addAll(data);
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new SimpleReminderViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_voice_room_reminder_list_simple_item_channel, parent, false));
        }
        return new ReminderViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_voice_room_reminder_list_simple_item_channel, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof MoreItemViewHolder) {
            this.addClickCardAnimation(((MoreItemViewHolder)holder).itemView);
            ((MoreItemViewHolder)holder).itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RoomReminderListAdapter.this.mMoreListener != null) {
                        RoomReminderListAdapter.this.mMoreListener.onMoreClick(v);
                    }
                }
            });
        } else if (holder instanceof ReminderViewHolder) {
            this.processReminderViewHolder((ReminderViewHolder)holder, position);
        }
    }

    private void processReminderViewHolder(ReminderViewHolder holder, final int position) {
        final RoomReminderListItemBean roomReminderListItemBean = this.mDatas.get(position);
        if (roomReminderListItemBean.noticeUserInfo != null) {
            String gid = roomReminderListItemBean.noticeUserInfo.plugin_id;
            RoomListReportEventBean baseRoomEventListBean = this.getRoomListReportEventBean(roomReminderListItemBean.noticeUserInfo.channel_id, roomReminderListItemBean.token, position, "2", "", String.valueOf(position), gid);
            RoomTrack.INSTANCE.addRoomAttentionItemReport(String.valueOf(position), baseRoomEventListBean);
            holder.itemView.setTag((Object)baseRoomEventListBean);
        }
        holder.updateItemWidth();
        if (roomReminderListItemBean.noticeUserInfo != null) {
            holder.setTagOrGame(roomReminderListItemBean.noticeUserInfo);
            holder.setNickName(roomReminderListItemBean.noticeUserInfo.nick);
            holder.loadAvatar(roomReminderListItemBean.noticeUserInfo.avatar, roomReminderListItemBean.noticeUserInfo.gender);
        }
        this.addClickCardAnimation(holder.itemView);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RoomReminderListAdapter.this.mItemListener != null && roomReminderListItemBean != null && roomReminderListItemBean.noticeUserInfo != null) {
                    RoomReminderListAdapter.this.mItemListener.onReminderItemClick(v, String.valueOf(roomReminderListItemBean.noticeUserInfo.uid), roomReminderListItemBean.noticeUserInfo.channel_id, position, roomReminderListItemBean.token);
                }
            }
        });
    }

    public int getItemViewType(int position) {
        if (this.mDatas.size() <= 2) {
            return 2;
        }
        return 0;
    }

    public void setOnReminderItemClickListener(OnReminderItemClickListener listener2) {
        this.mItemListener = listener2;
    }

    public void setOnReminderMoreClickListener(OnReminderMoreClickListener listener2) {
        this.mMoreListener = listener2;
    }

    public int getItemCount() {
        if (this.mDatas.size() > 8) {
            return 9;
        }
        return this.mDatas.size();
    }

    protected void addClickCardAnimation(View view) {
        if (!AnimatorUtils.canAnimation()) {
            return;
        }
        if (view == null) {
            return;
        }
        if (this.interpolator == null) {
            this.interpolator = new AccelerateDecelerateInterpolator();
        }
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        RoomReminderListAdapter.this.animationDown(v);
                        break;
                    }
                    case 1: 
                    case 3: {
                        RoomReminderListAdapter.this.animationUp(v);
                        break;
                    }
                }
                return false;
            }
        });
    }

    private void animationDown(View view) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.9f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.9f});
        scaleX.setInterpolator(this.interpolator);
        scaleY.setInterpolator(this.interpolator);
        scaleX.setDuration(60L);
        scaleY.setDuration(60L);
        scaleX.start();
        scaleY.start();
    }

    private void animationUp(View view) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        float x = view.getScaleX();
        float y = view.getScaleY();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{x, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{y, 1.0f});
        scaleX.setInterpolator(this.interpolator);
        scaleY.setInterpolator(this.interpolator);
        scaleX.setDuration(100L);
        scaleY.setDuration(100L);
        scaleX.start();
        scaleY.start();
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        RoomListReportEventBean roomListReportEventBean;
        super.onViewAttachedToWindow(holder);
        if (holder instanceof ReminderViewHolder && (roomListReportEventBean = (RoomListReportEventBean)holder.itemView.getTag()) != null) {
            RoomTrack.INSTANCE.onRoomAttentionItemReport(roomListReportEventBean.getTag());
        }
    }

    public void setCallBack(IRoomListAdapterCallBack mCallBack) {
        this.mCallBack = mCallBack;
    }

    public void setTagsMap(LinkedHashMap<String, VoiceRoomTagConfigData> mTagsMap) {
        this.mTagsMap = mTagsMap;
    }

    private RoomListReportEventBean getRoomListReportEventBean(String roomId, String token, int position, String modelId, String roomModel, String tag, String gid) {
        return new RoomListReportEventBean.RoomListReportEventBeanBuilder().setRoomId(roomId).setToken(token).setPositionId(String.valueOf(position)).setModelId(modelId).setRoomModel(roomModel).setTag(tag).setPageLevelId("1").setGid(gid).build();
    }

    class MoreItemViewHolder
    extends RecyclerView.ViewHolder {
        public View itemView;

        public MoreItemViewHolder(View itemView) {
            super(itemView);
            this.itemView = itemView;
        }
    }

    class SimpleReminderViewHolder
    extends ReminderViewHolder {
        public SimpleReminderViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void updateItemWidth() {
        }
    }

    class ReminderViewHolder
    extends RecyclerView.ViewHolder {
        protected RCLinearLayout mItemRoot;
        protected TextView mTvNickName;
        protected RecycleImageView mAvatar;
        protected CircleImageView mIvGameView;
        protected RecycleImageView mIvTagView;
        protected YYTextView mTvRoomTag;

        public ReminderViewHolder(View itemView) {
            super(itemView);
            this.mItemRoot = (RCLinearLayout)itemView.findViewById(R.id.root_reminder_item);
            this.mIvGameView = (CircleImageView)itemView.findViewById(R.id.iv_game_view);
            this.mIvTagView = (RecycleImageView)itemView.findViewById(R.id.iv_room_tag);
            this.mTvRoomTag = (YYTextView)itemView.findViewById(R.id.tv_room_tag);
            this.mTvNickName = (TextView)itemView.findViewById(R.id.tv_reminder_item_name);
            this.mAvatar = (RecycleImageView)itemView.findViewById(R.id.iv_reminder_item_avatar);
        }

        public void loadAvatar(String url, int sex) {
            ImageLoader.loadImage((ImageView)this.mAvatar, (String)(url + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)sex));
        }

        public void setNickName(String nickname) {
            this.mTvNickName.setText((CharSequence)nickname);
        }

        public void updateItemWidth() {
        }

        public void setTagOrGame(NoticeChannelInfo noticeUserInfo) {
            List tagList;
            int tagId = 0;
            String tagName = "";
            if (noticeUserInfo.tags.size() > 0 && (tagList = noticeUserInfo.tags) != null && tagList.size() > 0) {
                tagId = (Integer)tagList.get(0);
            }
            VoiceRoomTagConfigData mTagModel = null;
            if (RoomReminderListAdapter.this.mTagsMap != null) {
                mTagModel = (VoiceRoomTagConfigData)RoomReminderListAdapter.this.mTagsMap.get(String.valueOf(tagId));
                if (mTagModel != null) {
                    String strColor = mTagModel.getTagcolor();
                    if (!TextUtils.isEmpty((CharSequence)strColor)) {
                        try {
                            int color2 = ColorUtils.getCardBgColor((String)strColor, (String)"#5b66fe");
                            String mParentColor = "#33" + strColor.substring(1, strColor.length());
                            this.mItemRoot.setBackgroundColor(Color.parseColor((String)mParentColor));
                            this.mTvRoomTag.setTextColor(color2);
                        }
                        catch (Exception e) {
                            MLog.info((Object)"AttentionTagNameAndColor", (String)(mTagModel.getTagname() + ",\u989c\u8272\u89e3\u6790\u5931\u8d25"), (Object[])new Object[0]);
                            this.mItemRoot.setBackgroundColor(ColorUtils.parseColor((String)"#33FC5060"));
                            this.mTvRoomTag.setTextColor(ColorUtils.parseColor((String)"#FF5767"));
                        }
                    } else {
                        this.setDefaultTagColor();
                    }
                    if (!TextUtils.isEmpty((CharSequence)mTagModel.getTagname())) {
                        tagName = mTagModel.getTagname();
                    }
                } else {
                    this.setDefaultTagColor();
                    tagName = "Chat";
                }
            } else {
                this.setDefaultTagColor();
                tagName = "Chat";
            }
            if (RoomReminderListAdapter.this.mCallBack != null && !TextUtils.isEmpty((CharSequence)noticeUserInfo.plugin_id)) {
                GameInfo mGameInfo = RoomReminderListAdapter.this.mCallBack.getGameById(noticeUserInfo.plugin_id);
                if (mGameInfo != null) {
                    this.showGame(mGameInfo);
                } else {
                    this.showTag(tagName, mTagModel);
                }
            } else {
                this.showTag(tagName, mTagModel);
            }
        }

        private void setDefaultTagColor() {
            try {
                String strDefaultColor = "#5b66fe";
                int color2 = Color.parseColor((String)strDefaultColor);
                String mParentBg = "#33" + strDefaultColor.substring(1, strDefaultColor.length());
                this.mTvRoomTag.setTextColor(color2);
                this.mItemRoot.setBackgroundColor(Color.parseColor((String)mParentBg));
            }
            catch (Exception e) {
                MLog.error((Object)"AttentionTagNameAndColor", (String)"setDefaultTagColor error", (Object[])new Object[0]);
            }
        }

        private void showGame(GameInfo gameInfo) {
            this.mTvRoomTag.setText((CharSequence)gameInfo.getGname());
            this.mIvTagView.setVisibility(8);
            this.mIvGameView.setVisibility(0);
            ImageLoader.loadImage((ImageView)this.mIvGameView, (String)gameInfo.getIconUrl(), (int)-1);
        }

        private void showTag(String tagName, VoiceRoomTagConfigData roomTagConfigData) {
            this.mIvGameView.setVisibility(8);
            this.mTvRoomTag.setVisibility(0);
            this.mIvTagView.setVisibility(0);
            this.mTvRoomTag.setText((CharSequence)tagName);
            if (roomTagConfigData != null && !TextUtils.isEmpty((CharSequence)roomTagConfigData.getTagicon())) {
                ImageLoader.loadImage((ImageView)this.mIvTagView, (String)roomTagConfigData.getTagicon(), (int)-1);
            } else {
                ImageLoader.loadImageResource((int)R.drawable.icon_default_tag, (ImageView)this.mIvTagView, (ImageConfig)ImageConfig.defaultImageConfig());
            }
        }
    }
}

