/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.adapter;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import biz.PluginType;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.AnimatorUtils;
import com.yy.appbase.ui.widget.bubble.BubbleLinearLayout;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.rclayout.RCLinearLayout;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.VoiceRoomTagConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomTagConfigData;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.RoomlistEventBean;
import com.yy.hiyo.channel.module.recommend.R;
import com.yy.hiyo.channel.module.recommend.base.channelhiido.RoomListReportEventBean;
import com.yy.hiyo.channel.module.recommend.channelhiido.RoomTrack;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.MatchSuccessAvatarView;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.ihago.room.api.rrec.EFrontpageTab;
import net.ihago.room.api.rrec.RLabel;
import net.ihago.room.api.rrec.RoomTabItem;
import org.json.JSONException;
import org.json.JSONObject;

public class RoomListMoreAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = "RoomListMoreAdapter";
    private List<RoomTabItem> mDatas = new ArrayList<RoomTabItem>();
    private LinkedHashMap<String, VoiceRoomTagConfigData> mTagsMap;
    private int type;
    private TimeInterpolator interpolator;
    private GameInfoCallBack mCallBack;
    private Context mContext;
    private long cardId;

    public RoomListMoreAdapter(int type, long cardId, Context context) {
        this.type = type;
        this.mContext = context;
        this.cardId = cardId;
        this.initTagList();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        CustomerViewHolder viewHolder = this.type == EFrontpageTab.ERoomOperate.getValue() ? new CustomerViewHolder(inflater.inflate(R.layout.layout_voice_room_list_item_channel, parent, false)) : (this.type == EFrontpageTab.ERoomKTV.getValue() ? new CustomerViewHolder(inflater.inflate(R.layout.layout_voice_room_list_item_channel, parent, false)) : (this.type == EFrontpageTab.ERoomNearby.getValue() ? new CustomerViewHolder(inflater.inflate(R.layout.layout_voice_room_list_item_channel, parent, false)) : new CustomerViewHolder(inflater.inflate(R.layout.layout_voice_room_list_item_channel, parent, false))));
        return viewHolder;
    }

    public void initTagList() {
        if (null == this.mTagsMap) {
            AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.VOICE_ROOM_TAGS);
            if (null != config && config instanceof VoiceRoomTagConfig) {
                this.mTagsMap = ((VoiceRoomTagConfig)config).getmTagsMap();
            } else {
                VoiceRoomTagConfig localConfig = new VoiceRoomTagConfig();
                localConfig.getLocalTagsMap(new VoiceRoomTagConfig.TagCallBack(){

                    public void onResult(LinkedHashMap<String, VoiceRoomTagConfigData> dataLinkedHashMap) {
                        RoomListMoreAdapter.this.mTagsMap = dataLinkedHashMap;
                    }
                });
            }
        }
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof CustomerViewHolder) {
            this.processKtvAndOpearRoom((CustomerViewHolder)holder, position);
        }
    }

    private void processKtvAndOpearRoom(CustomerViewHolder viewHolder, int position) {
        final RoomTabItem mItem = this.mDatas.get(position);
        String modelId = "";
        if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            modelId = "6";
        } else if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            modelId = "7_" + this.cardId;
        } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            modelId = "5";
        }
        int roomModel = 9;
        if (mItem.getLabelValue() == RLabel.HotLabel.getValue()) {
            roomModel = RLabel.HotLabel.getValue();
        } else if (mItem.getLabelValue() == RLabel.OfficialLabel.getValue()) {
            roomModel = RLabel.OfficialLabel.getValue();
        }
        final RoomListReportEventBean eventListBean = this.getRoomListReportEventBean(mItem.id, "", position, modelId, String.valueOf(roomModel), mItem.id, mItem.gameid);
        if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            RoomTrack.INSTANCE.addKtvRoomListReport(eventListBean.getTag(), eventListBean);
        } else if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            RoomTrack.INSTANCE.addOpearRoomListReport(eventListBean.getTag(), eventListBean);
        } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            RoomTrack.INSTANCE.addNearbyRoomListReport(eventListBean.getTag(), eventListBean);
        }
        viewHolder.itemView.setTag((Object)eventListBean);
        String loadUrl = mItem.url + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)75.0f), (int)ResolutionUtils.dip2Px((float)75.0f), (boolean)true);
        if (mItem.plugin_type.intValue() != PluginType.PT_BASE.getValue()) {
            viewHolder.mMatchSuccessAvatarView.setVisibility(8);
            viewHolder.mHeadView.setVisibility(0);
            ImageLoader.loadImage((ImageView)viewHolder.mHeadView, (String)loadUrl, (int)R.drawable.icon_avatar_default_female);
        } else {
            viewHolder.mMatchSuccessAvatarView.setVisibility(0);
            viewHolder.mHeadView.setVisibility(8);
            ArrayList<String> mAvters = new ArrayList<String>();
            if (mItem.avartars != null) {
                mAvters.addAll(mItem.avartars);
            }
            mAvters.add(0, loadUrl);
            viewHolder.mMatchSuccessAvatarView.setAvatarSpace(-ResolutionUtils.dip2Px((float)30.0f));
            viewHolder.mMatchSuccessAvatarView.setStringData(mAvters);
        }
        String strTitle = "";
        if (this.type == EFrontpageTab.ERoomOperate.getValue() || this.type == EFrontpageTab.ERoomNearby.getValue()) {
            strTitle = mItem.name;
        } else {
            String strSong = mItem.song;
            if (TextUtils.isEmpty((CharSequence)strSong)) {
                strSong = ResourceUtils.getString((int)R.string.title_room_ktv_choose_music);
            }
            strTitle = strSong;
        }
        String tagName = "";
        int tagId = 0;
        if (mItem.tag_ids.size() > 0) {
            List tagList = mItem.tag_ids;
            if (tagList != null && tagList.size() > 0) {
                tagId = (Integer)tagList.get(0);
            }
        } else {
            tagId = this.getTagId(mItem.tags);
        }
        String strGameId = mItem.gameid;
        viewHolder.mCountView.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            StringBuilder stringBuilder = new StringBuilder();
            long distance = mItem.dist;
            String strDistance = "";
            if (distance > 1000L) {
                double doubleDistance = Double.valueOf(distance) / Double.valueOf(1000.0);
                DecimalFormat df = new DecimalFormat("0.0");
                strDistance = df.format(doubleDistance) + ResourceUtils.getString((int)R.string.title_km);
            } else {
                strDistance = stringBuilder.append(mItem.dist).append(ResourceUtils.getString((int)R.string.tips_m)).toString();
            }
            viewHolder.mCountView.setText((CharSequence)strDistance);
            viewHolder.mMemberImage.setImageResource(R.drawable.icon_nearby_location);
        } else {
            String strCount = String.valueOf(mItem.player_num);
            viewHolder.mCountView.setText((CharSequence)strCount);
        }
        viewHolder.mTitleView.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(strTitle));
        viewHolder.mRlParent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (mItem.label == RLabel.RedPacket) {
                    if (mItem.is_rand_rp.booleanValue()) {
                        RoomTrack.INSTANCE.reportRecommendPacketLabelClick(mItem.id);
                    } else {
                        RoomTrack.INSTANCE.reportPacketLabelClick(mItem.id);
                    }
                }
                RoomlistEventBean eventBean = new RoomlistEventBean();
                eventBean.setColumn(eventListBean.getColumn());
                eventBean.setRow(eventListBean.getRow());
                eventBean.setPositionId(eventListBean.getPositionId());
                eventBean.setToken(eventListBean.getToken());
                eventBean.setModelId(eventListBean.getModelId());
                eventBean.setRoomModel(eventListBean.getRoomModel());
                eventBean.setPageLevelId(eventListBean.getPageLevelId());
                int entryChannelType = 0;
                if (RoomListMoreAdapter.this.type == EFrontpageTab.ERoomNearby.getValue()) {
                    entryChannelType = 15;
                } else if (RoomListMoreAdapter.this.type == EFrontpageTab.ERoomOperate.getValue()) {
                    entryChannelType = 17;
                } else if (RoomListMoreAdapter.this.type == EFrontpageTab.ERoomKTV.getValue()) {
                    entryChannelType = 16;
                }
                EnterParam param = EnterParam.of((String)mItem.id).entry(entryChannelType).putExtra("ROOM_LIST_EVENT", (Object)eventBean).putExtra("GIFT_TOKEN", (Object)eventListBean.getToken()).putExtra("IS_GUIDE_ENTER", (Object)true).build();
                ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param);
            }
        });
        VoiceRoomTagConfigData mTagModel = null;
        if (this.mTagsMap != null) {
            mTagModel = this.mTagsMap.get(String.valueOf(tagId));
            if (mTagModel != null) {
                String strColor = mTagModel.getTagcolor();
                if (!TextUtils.isEmpty((CharSequence)strColor)) {
                    try {
                        int color2 = ColorUtils.getCardBgColor((String)strColor, (String)"#5b66fe");
                        MLog.info((Object)TAG, (String)("tagName,tagColor,itemColor,itemBgColor,position " + tagName + "," + strColor + "," + mTagModel.getItemcolor() + "," + mTagModel.getItembgcolor() + "," + position), (Object[])new Object[0]);
                        viewHolder.mRoomNameBg.setFillColor(color2);
                        viewHolder.mRoomNameBg.setArrowHeight((float)ResolutionUtils.dip2Px((float)4.0f));
                        viewHolder.mRoomNameBg.setBorderColor(color2);
                        String mParentColor = "#1A" + strColor.substring(1, strColor.length());
                        String mTagColor = "#33" + strColor.substring(1, strColor.length());
                        MLog.info((Object)"TagNameAndColor", (String)(mTagModel.getTagname() + "," + mParentColor), (Object[])new Object[0]);
                        viewHolder.tvBg.setBackground((Drawable)DrawableUtil.getRoundDrawable((int)10, (int)Color.parseColor((String)mParentColor)));
                        viewHolder.mRoomTagLayout.setBackgroundColor(Color.parseColor((String)mTagColor));
                        viewHolder.mTagView.setTextColor(color2);
                    }
                    catch (Exception e) {
                        MLog.info((Object)"TagNameAndColor", (String)(mTagModel.getTagname() + ",\u989c\u8272\u89e3\u6790\u5931\u8d25"), (Object[])new Object[0]);
                        viewHolder.tvBg.setBackground((Drawable)DrawableUtil.getRoundDrawable((int)10, (int)Color.parseColor((String)"#1AFC5060")));
                        viewHolder.mRoomTagLayout.setBackgroundColor(ColorUtils.parseColor((String)"#33FC5060"));
                        viewHolder.mTagView.setTextColor(ColorUtils.parseColor((String)"#FF5767"));
                    }
                } else {
                    this.setDefaultTagColor(viewHolder);
                }
                if (!TextUtils.isEmpty((CharSequence)mTagModel.getTagname())) {
                    tagName = mTagModel.getTagname();
                }
            } else {
                this.setDefaultTagColor(viewHolder);
                tagName = "Chat";
            }
        } else {
            tagName = "Chat";
            this.setDefaultTagColor(viewHolder);
        }
        if (this.mCallBack != null && !TextUtils.isEmpty((CharSequence)strGameId)) {
            GameInfo mGameInfo = this.mCallBack.getGameById(strGameId);
            if (mGameInfo != null) {
                this.showGame(mGameInfo, viewHolder);
            } else {
                this.showTag(tagName, viewHolder, mTagModel);
            }
        } else {
            this.showTag(tagName, viewHolder, mTagModel);
        }
        if (mItem.label == RLabel.HotLabel) {
            viewHolder.mRightBottomView.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_room_list_hot));
            viewHolder.mRightBottomView.setVisibility(0);
        } else if (mItem.label == RLabel.OfficialLabel) {
            viewHolder.mRightBottomView.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_room_list_offical));
            viewHolder.mRightBottomView.setVisibility(0);
        } else if (mItem.label == RLabel.NoneLabel) {
            viewHolder.mRightBottomView.setVisibility(8);
        } else if (mItem.label == RLabel.RedPacket) {
            if (mItem.is_rand_rp.booleanValue()) {
                RoomTrack.INSTANCE.reportRecommendPacketLabelShow(mItem.id);
            } else {
                RoomTrack.INSTANCE.reportPacketLabelShow(mItem.id);
            }
            viewHolder.mRightBottomView.setVisibility(0);
            if ("ae".equalsIgnoreCase(AccountUtil.registerCountry()) || "id".equalsIgnoreCase(AccountUtil.registerCountry())) {
                viewHolder.mRightBottomView.setImageResource(R.drawable.icon_room_list_gree_pager);
            } else {
                viewHolder.mRightBottomView.setImageResource(R.drawable.icon_room_red_tag);
            }
        }
        this.addClickCardAnimation((View)viewHolder.mRlParent);
    }

    protected void addClickCardAnimation(View view) {
        if (!AnimatorUtils.canAnimation()) {
            return;
        }
        if (view == null) {
            return;
        }
        if (this.interpolator == null) {
            this.interpolator = new AccelerateDecelerateInterpolator();
        }
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        RoomListMoreAdapter.this.animationDown(v);
                        break;
                    }
                    case 1: 
                    case 3: {
                        RoomListMoreAdapter.this.animationUp(v);
                        break;
                    }
                }
                return false;
            }
        });
    }

    private int getTagId(List<String> jsons) {
        if (jsons == null || jsons.size() == 0) {
            return 1001;
        }
        String strJson = jsons.get(0);
        if (TextUtils.isEmpty((CharSequence)strJson)) {
            return 1001;
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)strJson);
            int tagId = jsonObject.optInt("tagId");
            return tagId;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 1001;
        }
    }

    private void animationDown(View view) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.9f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.9f});
        scaleX.setInterpolator(this.interpolator);
        scaleY.setInterpolator(this.interpolator);
        scaleX.setDuration(60L);
        scaleY.setDuration(60L);
        scaleX.start();
        scaleY.start();
    }

    private void animationUp(View view) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        float x = view.getScaleX();
        float y = view.getScaleY();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{x, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{y, 1.0f});
        scaleX.setInterpolator(this.interpolator);
        scaleY.setInterpolator(this.interpolator);
        scaleX.setDuration(100L);
        scaleY.setDuration(100L);
        scaleX.start();
        scaleY.start();
    }

    private void setDefaultTagColor(CustomerViewHolder viewHolder) {
        try {
            String strDefaultColor = "#5b66fe";
            int color2 = Color.parseColor((String)strDefaultColor);
            String mParentColor = "#1A" + strDefaultColor.substring(1, strDefaultColor.length());
            String mTagColor = "#33" + strDefaultColor.substring(1, strDefaultColor.length());
            viewHolder.mRoomNameBg.setFillColor(color2);
            viewHolder.mRoomNameBg.setArrowHeight((float)ResolutionUtils.dip2Px((float)4.0f));
            viewHolder.mRoomNameBg.setBorderColor(color2);
            viewHolder.mTagView.setTextColor(color2);
            viewHolder.tvBg.setBackground((Drawable)DrawableUtil.getRoundDrawable((int)10, (int)Color.parseColor((String)mParentColor)));
            viewHolder.mRoomTagLayout.setBackgroundColor(Color.parseColor((String)mTagColor));
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"parse default color error", (Object[])new Object[0]);
        }
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        if (holder.itemView != null && holder.itemView.getTag() != null && holder.itemView.getTag() instanceof RoomListReportEventBean) {
            RoomListReportEventBean roomListReportEventBean = (RoomListReportEventBean)holder.itemView.getTag();
            if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
                RoomTrack.INSTANCE.onKtvRoomListReport(roomListReportEventBean.getTag());
            } else if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
                RoomTrack.INSTANCE.onOpearRoomListReport(roomListReportEventBean.getTag());
            } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
                RoomTrack.INSTANCE.onNearbyRoomListReport(roomListReportEventBean.getTag());
            }
        }
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public int getItemViewType(int position) {
        return this.type;
    }

    public void setCallBack(GameInfoCallBack mCallBack) {
        this.mCallBack = mCallBack;
    }

    private void showGame(GameInfo gameInfo, CustomerViewHolder viewHolder) {
        viewHolder.mTagView.setText((CharSequence)gameInfo.getGname());
        viewHolder.mTagIcon.setVisibility(8);
        viewHolder.mGameView.setVisibility(0);
        ImageLoader.loadImage((ImageView)viewHolder.mGameView, (String)gameInfo.getIconUrl(), (int)-1);
    }

    private void showTag(String tagName, CustomerViewHolder viewHolder, VoiceRoomTagConfigData roomTagConfigData) {
        viewHolder.mGameView.setVisibility(8);
        viewHolder.mTagView.setVisibility(0);
        viewHolder.mTagIcon.setVisibility(0);
        viewHolder.mTagView.setText((CharSequence)tagName);
        if (roomTagConfigData != null && !TextUtils.isEmpty((CharSequence)roomTagConfigData.getTagicon())) {
            ImageLoader.loadImage((ImageView)viewHolder.mTagIcon, (String)roomTagConfigData.getTagicon(), (int)-1);
        } else {
            ImageLoader.loadImageResource((int)R.drawable.icon_default_tag, (ImageView)viewHolder.mTagIcon, (ImageConfig)ImageConfig.defaultImageConfig());
        }
    }

    public void updateData(List<RoomTabItem> mList) {
        this.mDatas.clear();
        this.mDatas.addAll(mList);
        this.notifyDataSetChanged();
    }

    private RoomListReportEventBean getRoomListReportEventBean(String roomId, String token, int position, String modelId, String roomModel, String tag, String gid) {
        return new RoomListReportEventBean.RoomListReportEventBeanBuilder().setRoomId(roomId).setToken(token).setPositionId(String.valueOf(position)).setModelId(modelId).setRoomModel(roomModel).setTag(tag).setPageLevelId("2").setGid(gid).build();
    }

    public static interface GameInfoCallBack {
        public GameInfo getGameById(String var1);
    }

    public static class CustomerViewHolder
    extends RecyclerView.ViewHolder {
        private CircleImageView mHeadView;
        private YYTextView mTitleView;
        private YYTextView mTagView;
        private RecycleImageView mTagIcon;
        private YYTextView mCountView;
        private YYRelativeLayout mRlParent;
        private BubbleLinearLayout mRoomNameBg;
        private RCLinearLayout mRoomTagLayout;
        private CircleImageView mGameView;
        private RecycleImageView mRightBottomView;
        private YYLinearLayout tvBg;
        private MatchSuccessAvatarView mMatchSuccessAvatarView;
        private YYImageView mMemberImage;
        private RoomListReportEventBean bean;

        public RoomListReportEventBean getBean() {
            return this.bean;
        }

        public void setBean(RoomListReportEventBean bean) {
            this.bean = bean;
        }

        public CustomerViewHolder(View itemView) {
            super(itemView);
            this.mHeadView = (CircleImageView)itemView.findViewById(R.id.chat_room_head);
            this.mTitleView = (YYTextView)itemView.findViewById(R.id.chat_room_title);
            this.mTagView = (YYTextView)itemView.findViewById(R.id.tv_room_tag);
            this.mTagIcon = (RecycleImageView)itemView.findViewById(R.id.iv_room_tag);
            this.mGameView = (CircleImageView)itemView.findViewById(R.id.iv_game_view);
            this.mCountView = (YYTextView)itemView.findViewById(R.id.tv_people_count);
            this.mRlParent = (YYRelativeLayout)itemView.findViewById(R.id.rl_parent);
            this.mRoomNameBg = (BubbleLinearLayout)itemView.findViewById(R.id.room_name_bg);
            this.mRoomTagLayout = (RCLinearLayout)itemView.findViewById(R.id.ll_room_tag);
            this.mRightBottomView = (RecycleImageView)itemView.findViewById(R.id.iv_right_bottom_icon);
            this.tvBg = (YYLinearLayout)itemView.findViewById(R.id.tv_bg);
            this.mMatchSuccessAvatarView = (MatchSuccessAvatarView)itemView.findViewById(R.id.iv_text_channel);
            this.mMemberImage = (YYImageView)itemView.findViewById(R.id.icon_member);
        }
    }
}

