/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.miniradio.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.module.recommend.R;
import com.yy.hiyo.channel.module.recommend.miniradio.view.SoundWaveView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014*\u0001\n\u0018\u0000 >2\u00020\u0001:\u0002>?B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007J\b\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020'H\u0002J\u0014\u0010.\u001a\u00020'2\n\u0010/\u001a\u00060\"R\u00020\u0000H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0014J\u0018\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0014J(\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0014J\u0006\u00109\u001a\u00020'J\u000e\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020$J\u0006\u0010<\u001a\u00020'J\u0006\u0010=\u001a\u00020'R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\b\u0012\u00060\"R\u00020\u0000\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "handler", "com/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView$handler$1", "Lcom/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView$handler$1;", "isMiniRadioStyle", "", "lineColors", "", "linepositions", "", "mColors", "mHeight", "mMaxAmplitude", "mPaint", "Landroid/graphics/Paint;", "mWidth", "random", "Ljava/util/Random;", "running", "getRunning", "()Z", "setRunning", "(Z)V", "waveCount", "waves", "", "Lcom/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView$Wave;", "xAmplitude", "", "yAmplitude", "activityWaveCount", "", "param", "createWave", "drawLine", "canvas", "Landroid/graphics/Canvas;", "init", "initAnimator", "waveBean", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setMiniRadioStyle", "setVolume", "volume", "startAnim", "stopAnim", "Companion", "Wave", "channellist_debug"})
public final class SoundWaveView
extends View {
    private int mWidth;
    private int mHeight;
    private int mMaxAmplitude;
    private Paint mPaint;
    private Random random;
    private float yAmplitude;
    private float xAmplitude;
    private int waveCount;
    private List<Wave> waves;
    private final int[] mColors;
    private final int[] lineColors;
    private final float[] linepositions;
    private boolean running;
    private boolean isMiniRadioStyle;
    private final handler.1 handler;
    private static final int MAX_WAVE_COUNT = 15;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    private final void init() {
        this.mPaint = new Paint();
        this.random = new Random();
        this.waves = new ArrayList();
        this.running = false;
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setAntiAlias(true);
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        paint3.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.ADD));
    }

    public final void setVolume(float volume) {
        if (volume <= (float)10) {
            this.yAmplitude = 0.1f;
            this.waveCount = 5;
            this.xAmplitude = 1.2f;
        } else if (volume < (float)40) {
            this.yAmplitude = 0.5f;
            this.waveCount = 10;
            this.xAmplitude = 1.0f;
        } else if (volume < (float)60) {
            this.yAmplitude = 0.9f;
            this.waveCount = 15;
        } else {
            this.yAmplitude = 1.2f;
            this.waveCount = 20;
        }
        this.activityWaveCount(this.waveCount);
    }

    public final void setMiniRadioStyle() {
        this.isMiniRadioStyle = true;
        this.yAmplitude = 1.0f;
        this.waveCount = 8;
        this.xAmplitude = 1.5f;
        this.activityWaveCount(this.waveCount);
    }

    public final void startAnim() {
        if (!this.running) {
            this.handler.sendEmptyMessage(1);
        }
    }

    public final void stopAnim() {
        if (this.running) {
            this.running = false;
            this.waveCount = 0;
            this.activityWaveCount(this.waveCount);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mHeight = h;
        this.mWidth = w;
        this.mMaxAmplitude = h * 2 / 3;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeight = this.getMeasuredHeight();
        this.mWidth = this.getMeasuredWidth();
    }

    /*
     * WARNING - void declaration
     */
    public final void activityWaveCount(int param) {
        int size;
        int count = param;
        List<Wave> list = this.waves;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if (count > (size = list.size())) {
            count = size;
        }
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i2;
            block9: {
                block8: {
                    if (FP.empty((Collection)this.waves)) break block8;
                    List<Wave> list2 = this.waves;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (list2.size() > i2) break block9;
                }
                return;
            }
            List<Wave> list3 = this.waves;
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            list3.get((int)i2).setPlaying(i2 < count);
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createWave() {
        if (FP.empty((Collection)this.waves)) {
            this.waves = new ArrayList();
            int n = 0;
            int n2 = MAX_WAVE_COUNT;
            while (n < n2) {
                void i2;
                Wave wave = new Wave((int)i2);
                this.initAnimator(wave);
                List<Wave> list = this.waves;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                list.add(wave);
                ++i2;
            }
        } else {
            int n = MAX_WAVE_COUNT;
            for (int i2 = 0; i2 < n; ++i2) {
                Wave wave = new Wave(i2);
                this.initAnimator(wave);
                List<Wave> list = this.waves;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (i2 >= list.size()) continue;
                List<Wave> list2 = this.waves;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                list2.set(i2, wave);
            }
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (!this.running) {
            return;
        }
        this.drawLine(canvas);
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.ADD));
        List<Wave> list = this.waves;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (Wave wave : list) {
            if (!wave.getPlaying()) continue;
            wave.draw(canvas, this.mPaint);
        }
        this.postInvalidateDelayed(50L);
    }

    private final void initAnimator(Wave waveBean) {
        ValueAnimator animator2;
        ValueAnimator valueAnimator = animator2 = ValueAnimator.ofInt((int[])new int[]{0, waveBean.getMaxHeight()});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setDuration((long)waveBean.getDuration());
        animator2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(waveBean){
            final /* synthetic */ Wave $waveBean;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.$waveBean.setWaveHeight((Integer)object);
                if (this.$waveBean.getWaveHeight() > this.$waveBean.getMaxHeight() / 2) {
                    this.$waveBean.setWaveHeight(this.$waveBean.getMaxHeight() - this.$waveBean.getWaveHeight());
                }
            }
            {
                this.$waveBean = wave;
            }
        });
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, waveBean){
            final /* synthetic */ SoundWaveView this$0;
            final /* synthetic */ Wave $waveBean;

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                if (this.this$0.getRunning() && this.$waveBean.getPlaying()) {
                    this.$waveBean.respawn();
                    SoundWaveView.access$initAnimator(this.this$0, this.$waveBean);
                }
            }
            {
                this.this$0 = $outer;
                this.$waveBean = $captured_local_variable$1;
            }
        });
        animator2.start();
    }

    private final void drawLine(Canvas canvas) {
        canvas.save();
        LinearGradient shader = new LinearGradient((float)this.mWidth / 40.0f, 0.0f, (float)(this.mWidth * 39) / 40.0f, 0.0f, this.lineColors, this.linepositions, Shader.TileMode.MIRROR);
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        paint2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        paint3.setShader((Shader)shader);
        Paint paint4 = this.mPaint;
        if (paint4 == null) {
            Intrinsics.throwNpe();
        }
        paint4.setStrokeWidth(2.0f);
        float f = (float)this.mWidth / 40.0f;
        float f2 = (float)this.mHeight / 2.0f;
        float f3 = (float)(this.mWidth * 39) / 40.0f;
        float f4 = (float)this.mHeight / 2.0f;
        Paint paint5 = this.mPaint;
        if (paint5 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawLine(f, f2, f3, f4, paint5);
        Paint paint6 = this.mPaint;
        if (paint6 == null) {
            Intrinsics.throwNpe();
        }
        paint6.setXfermode((Xfermode)null);
        Paint paint7 = this.mPaint;
        if (paint7 == null) {
            Intrinsics.throwNpe();
        }
        paint7.setShader((Shader)null);
        Paint paint8 = this.mPaint;
        if (paint8 == null) {
            Intrinsics.throwNpe();
        }
        paint8.clearShadowLayer();
        canvas.restore();
    }

    @JvmOverloads
    public SoundWaveView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.yAmplitude = 0.3f;
        this.xAmplitude = 1.0f;
        this.mColors = new int[]{R.color.color_green, R.color.color_blue, R.color.color_0bd68b};
        this.lineColors = new int[]{-15658735, -1, -1, -15658735};
        this.linepositions = new float[]{0.0f, 0.1f, 0.9f, 1.0f};
        this.handler = new Handler(this){
            final /* synthetic */ SoundWaveView this$0;

            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        if (this.this$0.getRunning()) break;
                        this.this$0.setRunning(true);
                        SoundWaveView.access$createWave(this.this$0);
                        this.this$0.activityWaveCount(SoundWaveView.access$getWaveCount$p(this.this$0));
                        this.this$0.postInvalidate();
                        break;
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.init();
    }

    public /* synthetic */ SoundWaveView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SoundWaveView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SoundWaveView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        MAX_WAVE_COUNT = 15;
    }

    public static final /* synthetic */ void access$setRandom$p(SoundWaveView $this, Random random) {
        $this.random = random;
    }

    public static final /* synthetic */ void access$setMMaxAmplitude$p(SoundWaveView $this, int n) {
        $this.mMaxAmplitude = n;
    }

    public static final /* synthetic */ void access$setYAmplitude$p(SoundWaveView $this, float f) {
        $this.yAmplitude = f;
    }

    public static final /* synthetic */ void access$setXAmplitude$p(SoundWaveView $this, float f) {
        $this.xAmplitude = f;
    }

    public static final /* synthetic */ void access$setMiniRadioStyle$p(SoundWaveView $this, boolean bl) {
        $this.isMiniRadioStyle = bl;
    }

    public static final /* synthetic */ void access$initAnimator(SoundWaveView $this, Wave waveBean) {
        $this.initAnimator(waveBean);
    }

    public static final /* synthetic */ void access$createWave(SoundWaveView $this) {
        $this.createWave();
    }

    public static final /* synthetic */ int access$getWaveCount$p(SoundWaveView $this) {
        return $this.waveCount;
    }

    public static final /* synthetic */ void access$setWaveCount$p(SoundWaveView $this, int n) {
        $this.waveCount = n;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0006\u00108\u001a\u000202J\b\u00109\u001a\u00020:H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0010\"\u0004\b'\u0010\u0012R\u001a\u0010(\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\tR\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006;"}, d2={"Lcom/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView$Wave;", "", "index", "", "(Lcom/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView;I)V", "color", "getColor", "()I", "setColor", "(I)V", "duration", "getDuration", "setDuration", "mOpenClass", "", "getMOpenClass", "()D", "setMOpenClass", "(D)V", "maxHeight", "getMaxHeight", "setMaxHeight", "maxWidth", "getMaxWidth", "setMaxWidth", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "setPaint", "(Landroid/graphics/Paint;)V", "playing", "", "getPlaying", "()Z", "setPlaying", "(Z)V", "seed", "getSeed", "setSeed", "waveHeight", "getWaveHeight", "setWaveHeight", "xRelaBase", "", "getXRelaBase", "()F", "setXRelaBase", "(F)V", "_draw", "", "canvas", "Landroid/graphics/Canvas;", "draw", "equation", "param", "respawn", "toString", "", "channellist_debug"})
    public final class Wave {
        private boolean playing;
        private int maxHeight;
        private int maxWidth;
        private int color;
        private double seed;
        private double mOpenClass;
        private float xRelaBase;
        private int waveHeight;
        private int duration;
        @Nullable
        private Paint paint;

        public final boolean getPlaying() {
            return this.playing;
        }

        public final void setPlaying(boolean bl) {
            this.playing = bl;
        }

        public final int getMaxHeight() {
            return this.maxHeight;
        }

        public final void setMaxHeight(int n) {
            this.maxHeight = n;
        }

        public final int getMaxWidth() {
            return this.maxWidth;
        }

        public final void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final double getSeed() {
            return this.seed;
        }

        public final void setSeed(double d) {
            this.seed = d;
        }

        public final double getMOpenClass() {
            return this.mOpenClass;
        }

        public final void setMOpenClass(double d) {
            this.mOpenClass = d;
        }

        public final float getXRelaBase() {
            return this.xRelaBase;
        }

        public final void setXRelaBase(float f) {
            this.xRelaBase = f;
        }

        public final int getWaveHeight() {
            return this.waveHeight;
        }

        public final void setWaveHeight(int n) {
            this.waveHeight = n;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final void setDuration(int n) {
            this.duration = n;
        }

        @Nullable
        public final Paint getPaint() {
            return this.paint;
        }

        public final void setPaint(@Nullable Paint paint2) {
            this.paint = paint2;
        }

        public final void respawn() {
            this.seed = Math.random();
            if (SoundWaveView.this.mWidth / 16 > 0) {
                Random random = SoundWaveView.this.random;
                if (random == null) {
                    Intrinsics.throwNpe();
                }
                this.maxWidth = random.nextInt(SoundWaveView.this.mWidth / 16) + SoundWaveView.this.mWidth * 3 / 11;
            } else {
                this.maxWidth = ResolutionUtils.dip2Px((float)50.0f);
            }
            if (SoundWaveView.this.mMaxAmplitude / 6 > 0) {
                if (this.seed <= 0.2) {
                    Random random = SoundWaveView.this.random;
                    if (random == null) {
                        Intrinsics.throwNpe();
                    }
                    this.maxHeight = random.nextInt(SoundWaveView.this.mMaxAmplitude / 6) + SoundWaveView.this.mMaxAmplitude / 5;
                    this.mOpenClass = 2.0;
                } else if (this.seed <= 0.3) {
                    Random random = SoundWaveView.this.random;
                    if (random == null) {
                        Intrinsics.throwNpe();
                    }
                    this.maxHeight = random.nextInt(SoundWaveView.this.mMaxAmplitude / 3) + SoundWaveView.this.mMaxAmplitude / 5;
                    this.mOpenClass = 3.0;
                } else if (this.seed <= 0.7) {
                    Random random = SoundWaveView.this.random;
                    if (random == null) {
                        Intrinsics.throwNpe();
                    }
                    this.maxHeight = random.nextInt(SoundWaveView.this.mMaxAmplitude / 2) + SoundWaveView.this.mMaxAmplitude * 2 / 5;
                    this.mOpenClass = 3.0;
                } else if (this.seed <= 0.8) {
                    Random random = SoundWaveView.this.random;
                    if (random == null) {
                        Intrinsics.throwNpe();
                    }
                    this.maxHeight = random.nextInt(SoundWaveView.this.mMaxAmplitude / 3) + SoundWaveView.this.mMaxAmplitude / 5;
                    this.mOpenClass = 3.0;
                } else if (this.seed > 0.8) {
                    Random random = SoundWaveView.this.random;
                    if (random == null) {
                        Intrinsics.throwNpe();
                    }
                    this.maxHeight = random.nextInt(SoundWaveView.this.mMaxAmplitude / 6) + SoundWaveView.this.mMaxAmplitude / 5;
                    this.mOpenClass = 2.0;
                }
            } else {
                this.maxHeight = ResolutionUtils.dip2Px((float)10.0f);
                this.mOpenClass = 2.0;
            }
            Random random = SoundWaveView.this.random;
            if (random == null) {
                Intrinsics.throwNpe();
            }
            this.duration = random.nextInt(1000) + 700;
            int[] nArray = SoundWaveView.this.mColors;
            Random random2 = SoundWaveView.this.random;
            if (random2 == null) {
                Intrinsics.throwNpe();
            }
            this.color = nArray[random2.nextInt(3)];
        }

        private final double equation(double param) {
            double i2 = Math.abs(param);
            return -1.0 * (double)SoundWaveView.this.yAmplitude * Math.pow(1.0 / (1.0 + Math.pow(this.mOpenClass * i2, 2.0)), 2.0);
        }

        public final void draw(@NotNull Canvas canvas, @Nullable Paint paint2) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            this.paint = paint2;
            this._draw(canvas);
        }

        private final void _draw(Canvas canvas) {
            Path path2 = new Path();
            Path pathN = new Path();
            path2.moveTo((float)SoundWaveView.this.mWidth / 4.0f, (float)SoundWaveView.this.mHeight / 2.0f);
            pathN.moveTo((float)SoundWaveView.this.mWidth / 4.0f, (float)SoundWaveView.this.mHeight / 2.0f);
            double xBase = (double)((float)SoundWaveView.this.mWidth / this.xRelaBase) + ((double)((float)(-SoundWaveView.this.mWidth) / 6.0f) + this.seed * (double)((float)SoundWaveView.this.mWidth / 3.0f));
            double yBase = (float)SoundWaveView.this.mHeight / 2.0f;
            double x = 0.0;
            double y = 0.0;
            double xInit = 0.0;
            for (double i2 = -1.0; i2 <= 1.0; i2 += 0.02) {
                x = xBase + i2 * (double)this.maxWidth * (double)SoundWaveView.this.xAmplitude;
                double function = this.equation(i2) * (double)this.waveHeight;
                y = yBase + function;
                if (xInit > 0.0 || x > 0.0) {
                    xInit = (float)SoundWaveView.this.mWidth / 4.0f;
                }
                if (!(y > 0.1)) continue;
                path2.lineTo((float)x, (float)y);
                pathN.lineTo((float)x, (float)((double)((float)yBase) - function));
            }
            Paint paint2 = this.paint;
            if (paint2 != null) {
                paint2.setColor(SoundWaveView.this.getResources().getColor(this.color));
            }
            Paint paint3 = this.paint;
            if (paint3 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawPath(path2, paint3);
            Paint paint4 = this.paint;
            if (paint4 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawPath(pathN, paint4);
        }

        @NotNull
        public String toString() {
            return "Wave{maxHight=" + this.maxHeight + ", maxWidth=" + this.maxWidth + ", color=" + this.color + ", amplitude=" + SoundWaveView.this.yAmplitude + ", seed=" + this.seed + ", mOpenClass=" + this.mOpenClass + ", paint=" + this.paint + "}";
        }

        public Wave(int index) {
            this.xRelaBase = SoundWaveView.this.isMiniRadioStyle ? (index % 2 == 0 ? 4.0f : 1.3333334f) : 2.0f;
            SoundWaveView.this.mHeight = SoundWaveView.this.getMeasuredHeight();
            SoundWaveView.this.mWidth = SoundWaveView.this.getMeasuredWidth();
            this.respawn();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/module/recommend/miniradio/view/SoundWaveView$Companion;", "", "()V", "MAX_WAVE_COUNT", "", "channellist_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

