/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.recyclerview.widget.RecyclerView;
import biz.PluginType;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.Size;
import com.yy.appbase.ui.widget.bubble.BubbleLinearLayout;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.rclayout.RCRelativeLayout;
import com.yy.appbase.unifyconfig.config.VoiceRoomTagConfigData;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.RoomlistEventBean;
import com.yy.hiyo.channel.module.recommend.R;
import com.yy.hiyo.channel.module.recommend.base.channelhiido.RoomListReportEventBean;
import com.yy.hiyo.channel.module.recommend.channelhiido.RoomTrack;
import com.yy.hiyo.game.base.widget.MatchSuccessAvatarView;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.ihago.room.api.rrec.EFrontpageTab;
import net.ihago.room.api.rrec.RLabel;
import net.ihago.room.api.rrec.RoomTabItem;
import org.json.JSONException;
import org.json.JSONObject;

public class RoomListTogetherAdapter
extends RecyclerView.Adapter<TogetherRoomViewHolder> {
    private List<RoomTabItem> mRooms = new ArrayList<RoomTabItem>();
    private Context mContext;
    private int type = EFrontpageTab.ENone.getValue();
    private int mCountColor;
    private LinkedHashMap<String, VoiceRoomTagConfigData> mTagsMap;
    private long cardId;

    public RoomListTogetherAdapter(Context context) {
        this.mContext = context;
    }

    @NonNull
    public TogetherRoomViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        TogetherRoomViewHolder togetherRoomViewHolder = new TogetherRoomViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_room_list_enter_item_channel, parent, false));
        return togetherRoomViewHolder;
    }

    public void onBindViewHolder(@NonNull TogetherRoomViewHolder holder, int position) {
        RoomTabItem roomtabitem = this.mRooms.get(position);
        if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            this.setNearByRoomUI(roomtabitem, holder, position);
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            this.setKtvRoomUI(roomtabitem, holder, position);
        } else if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            MLog.info((Object)"RoomListTogetherAdapter", (String)"\u8fd0\u8425", (Object[])new Object[0]);
            this.setOperRoomUI(roomtabitem, holder, position);
        } else if (this.type == EFrontpageTab.EGangup.getValue()) {
            this.setGangUpRoomUI(roomtabitem, holder, position);
        }
    }

    private void setNearByRoomUI(RoomTabItem roomTabItem, TogetherRoomViewHolder viewHolder, int position) {
        int roomModel = 9;
        if (roomTabItem.getLabelValue() == RLabel.HotLabel.getValue()) {
            roomModel = RLabel.HotLabel.getValue();
        } else if (roomTabItem.getLabelValue() == RLabel.OfficialLabel.getValue()) {
            roomModel = RLabel.OfficialLabel.getValue();
        }
        final RoomListReportEventBean roomListReportEventBean = this.getRoomListReportEventBean(roomTabItem.id, "", position, "5", String.valueOf(roomModel), String.valueOf(position), roomTabItem.gameid);
        RoomTrack.INSTANCE.addNearbyRoomReport(String.valueOf(position), roomListReportEventBean);
        viewHolder.itemView.setTag((Object)roomListReportEventBean);
        String loadUrl = roomTabItem.url + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)75.0f), (int)ResolutionUtils.dip2Px((float)75.0f), (boolean)true);
        this.setHead(roomTabItem, viewHolder, loadUrl);
        viewHolder.mTvHomeName.setText((CharSequence)roomTabItem.nick_name);
        StringBuilder stringBuilder = new StringBuilder();
        long distance = roomTabItem.dist;
        String strDistance = "";
        if (distance > 1000L) {
            double doubleDistance = Double.valueOf(distance) / Double.valueOf(1000.0);
            DecimalFormat df = new DecimalFormat("0.0");
            strDistance = df.format(doubleDistance) + ResourceUtils.getString((int)R.string.title_km);
        } else {
            strDistance = stringBuilder.append(roomTabItem.dist).append(ResourceUtils.getString((int)R.string.tips_m)).toString();
        }
        viewHolder.mTvDistance.setText((CharSequence)strDistance);
        viewHolder.mTvCount.setText((CharSequence)String.valueOf(roomTabItem.player_num));
        viewHolder.mBubbleLinearLayout.setVisibility(8);
        if (LanguageUtils.isRtl()) {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfEnd);
        } else {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfBegin);
        }
        viewHolder.mLLocation.setVisibility(0);
        viewHolder.mIvbg.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_nearby_bg));
        viewHolder.mRoomCountLayout.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_item_location_count_bg));
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RoomListTogetherAdapter.this.enterRoom(roomListReportEventBean);
            }
        });
        if (position == this.getItemCount() - 1) {
            viewHolder.mTvSpace.setVisibility(0);
        } else {
            viewHolder.mTvSpace.setVisibility(8);
        }
    }

    private void setHead(RoomTabItem roomTabItem, TogetherRoomViewHolder viewHolder, String loadUrl) {
        if (roomTabItem.plugin_type.intValue() != PluginType.PT_BASE.getValue()) {
            viewHolder.mMatchSuccessAvatarView.setVisibility(8);
            viewHolder.mCircleImageView.setVisibility(0);
            ImageLoader.loadImage((ImageView)viewHolder.mCircleImageView, (String)loadUrl, (int)R.drawable.icon_avatar_default_female);
        } else {
            viewHolder.mMatchSuccessAvatarView.setVisibility(0);
            viewHolder.mCircleImageView.setVisibility(8);
            ArrayList<String> mAvters = new ArrayList<String>();
            if (roomTabItem.avartars != null) {
                mAvters.addAll(roomTabItem.avartars);
            }
            mAvters.add(0, loadUrl);
            viewHolder.mMatchSuccessAvatarView.setAvatartSize(ResolutionUtils.dip2Px((float)36.0f));
            viewHolder.mMatchSuccessAvatarView.setAvatarSpace(-ResolutionUtils.dip2Px((float)20.0f));
            viewHolder.mMatchSuccessAvatarView.setAvatarBorderSize(2);
            viewHolder.mMatchSuccessAvatarView.setStringData(mAvters);
        }
    }

    private void enterRoom(RoomListReportEventBean eventListBean) {
        RoomlistEventBean eventBean = new RoomlistEventBean();
        eventBean.setPositionId(eventListBean.getPositionId());
        eventBean.setToken(eventListBean.getToken());
        eventBean.setModelId(eventListBean.getModelId());
        eventBean.setRoomModel(eventListBean.getRoomModel());
        eventBean.setPageLevelId(eventListBean.getPageLevelId());
        int entryChannelType = 0;
        if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            entryChannelType = 15;
        } else if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            entryChannelType = 17;
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            entryChannelType = 16;
        }
        EnterParam param = EnterParam.of((String)eventListBean.getRoomId()).entry(entryChannelType).putExtra("ROOM_LIST_EVENT", (Object)eventBean).putExtra("GIFT_TOKEN", (Object)eventListBean.getToken()).build();
        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param);
    }

    private void setKtvRoomUI(RoomTabItem roomTabItem, TogetherRoomViewHolder viewHolder, int position) {
        int roomModel = 9;
        if (roomTabItem.getLabelValue() == RLabel.HotLabel.getValue()) {
            roomModel = RLabel.HotLabel.getValue();
        } else if (roomTabItem.getLabelValue() == RLabel.OfficialLabel.getValue()) {
            roomModel = RLabel.OfficialLabel.getValue();
        }
        final RoomListReportEventBean roomListReportEventBean = this.getRoomListReportEventBean(roomTabItem.id, "", position, "6", String.valueOf(roomModel), String.valueOf(position), roomTabItem.gameid);
        RoomTrack.INSTANCE.addKtvRoomReport(String.valueOf(position), roomListReportEventBean);
        viewHolder.itemView.setTag((Object)roomListReportEventBean);
        String loadUrl = roomTabItem.url + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)75.0f), (int)ResolutionUtils.dip2Px((float)75.0f), (boolean)true);
        this.setHead(roomTabItem, viewHolder, loadUrl);
        String strSong = "";
        strSong = TextUtils.isEmpty((CharSequence)roomTabItem.song) ? ResourceUtils.getString((int)R.string.title_room_ktv_choose_music) : roomTabItem.song;
        this.setName("", strSong, viewHolder, R.drawable.icon_room_list_sing);
        viewHolder.mTvCount.setText((CharSequence)String.valueOf(roomTabItem.player_num));
        viewHolder.mBubbleLinearLayout.setVisibility(0);
        if (LanguageUtils.isRtl()) {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfEnd);
        } else {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfBegin);
        }
        viewHolder.mLLocation.setVisibility(8);
        viewHolder.mIvbg.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_ktv_bg));
        viewHolder.mRoomCountLayout.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_item_ktv_count_bg));
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RoomListTogetherAdapter.this.enterRoom(roomListReportEventBean);
            }
        });
        if (position == this.getItemCount() - 1) {
            viewHolder.mTvSpace.setVisibility(0);
        } else {
            viewHolder.mTvSpace.setVisibility(8);
        }
    }

    private void setOperRoomUI(RoomTabItem roomTabItem, TogetherRoomViewHolder viewHolder, int position) {
        int roomModel = 9;
        if (roomTabItem.getLabelValue() == RLabel.HotLabel.getValue()) {
            roomModel = RLabel.HotLabel.getValue();
        } else if (roomTabItem.getLabelValue() == RLabel.OfficialLabel.getValue()) {
            roomModel = RLabel.OfficialLabel.getValue();
        }
        String modelId = "7_" + this.cardId;
        final RoomListReportEventBean roomListReportEventBean = this.getRoomListReportEventBean(roomTabItem.id, "", position, modelId, String.valueOf(roomModel), String.valueOf(position), roomTabItem.gameid);
        RoomTrack.INSTANCE.addOpearRoomReport(String.valueOf(position), roomListReportEventBean);
        viewHolder.itemView.setTag((Object)roomListReportEventBean);
        VoiceRoomTagConfigData mTagModel = null;
        int tagId = 0;
        if (this.mTagsMap != null) {
            List tagIds = roomTabItem.tag_ids;
            tagId = tagIds != null && tagIds.size() > 0 ? ((Integer)tagIds.get(0)).intValue() : this.getTagId(roomTabItem.tags);
            mTagModel = this.mTagsMap.get(String.valueOf(tagId));
        } else {
            MLog.info((Object)"RoomListTogetherAdapter", (String)"mTagMap is null", (Object[])new Object[0]);
        }
        String loadUrl = roomTabItem.url + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)75.0f), (int)ResolutionUtils.dip2Px((float)75.0f), (boolean)true);
        this.setHead(roomTabItem, viewHolder, loadUrl);
        if (mTagModel != null) {
            this.setName(mTagModel.getTagicon(), roomTabItem.name, viewHolder, R.drawable.icon_room_operation);
            MLog.info((Object)"RoomListTogetherAdapter", (String)mTagModel.getTagicon(), (Object[])new Object[0]);
        } else {
            this.setName("", roomTabItem.name, viewHolder, R.drawable.icon_room_operation);
            MLog.info((Object)"RoomListTogetherAdapter", (String)"mTagModel is null", (Object[])new Object[0]);
        }
        viewHolder.mTvCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        viewHolder.mTvCount.setText((CharSequence)String.valueOf(roomTabItem.player_num));
        viewHolder.mBubbleLinearLayout.setVisibility(0);
        if (LanguageUtils.isRtl()) {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfEnd);
        } else {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfBegin);
        }
        viewHolder.mLLocation.setVisibility(8);
        viewHolder.mIvbg.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_opear_bg));
        Drawable drawable2 = this.tintDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_item_operation_count_bg), this.mCountColor);
        viewHolder.mRoomCountLayout.setBackgroundDrawable(drawable2);
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RoomListTogetherAdapter.this.enterRoom(roomListReportEventBean);
            }
        });
        if (position == this.getItemCount() - 1) {
            viewHolder.mTvSpace.setVisibility(0);
        } else {
            viewHolder.mTvSpace.setVisibility(8);
        }
    }

    private int getTagId(List<String> jsons) {
        if (jsons == null || jsons.size() == 0) {
            return 1001;
        }
        String strJson = jsons.get(0);
        if (TextUtils.isEmpty((CharSequence)strJson)) {
            return 1001;
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)strJson);
            int tagId = jsonObject.optInt("tagId");
            return tagId;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 1001;
        }
    }

    private void setGangUpRoomUI(RoomTabItem roomTabItem, TogetherRoomViewHolder viewHolder, int position) {
        int roomModel = 9;
        if (roomTabItem.getLabelValue() == RLabel.HotLabel.getValue()) {
            roomModel = RLabel.HotLabel.getValue();
        } else if (roomTabItem.getLabelValue() == RLabel.OfficialLabel.getValue()) {
            roomModel = RLabel.OfficialLabel.getValue();
        }
        String modelId = "7_" + this.cardId;
        final RoomListReportEventBean roomListReportEventBean = this.getRoomListReportEventBean(roomTabItem.id, "", position, modelId, String.valueOf(roomModel), String.valueOf(position), roomTabItem.gameid);
        RoomTrack.INSTANCE.addOpearRoomReport(String.valueOf(position), roomListReportEventBean);
        viewHolder.itemView.setTag((Object)roomListReportEventBean);
        VoiceRoomTagConfigData mTagModel = null;
        int tagId = 0;
        if (this.mTagsMap != null) {
            List tagIds = roomTabItem.tag_ids;
            tagId = tagIds != null && tagIds.size() > 0 ? ((Integer)tagIds.get(0)).intValue() : this.getTagId(roomTabItem.tags);
            mTagModel = this.mTagsMap.get(String.valueOf(tagId));
        } else {
            MLog.info((Object)"RoomListTogetherAdapter", (String)"mTagMap is null", (Object[])new Object[0]);
        }
        String loadUrl = roomTabItem.url + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)75.0f), (int)ResolutionUtils.dip2Px((float)75.0f), (boolean)true);
        ImageLoader.loadImage((ImageView)viewHolder.mCircleImageView, (String)loadUrl, (int)R.drawable.icon_avatar_default_female);
        if (mTagModel != null) {
            this.setName(mTagModel.getTagicon(), roomTabItem.name, viewHolder, R.drawable.icon_gang_up);
            MLog.info((Object)"RoomListTogetherAdapter", (String)mTagModel.getTagicon(), (Object[])new Object[0]);
        } else {
            this.setName("", roomTabItem.name, viewHolder, R.drawable.icon_gang_up);
            MLog.info((Object)"RoomListTogetherAdapter", (String)"mTagModel is null", (Object[])new Object[0]);
        }
        viewHolder.mTvCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        viewHolder.mTvCount.setText((CharSequence)String.valueOf(roomTabItem.player_num));
        viewHolder.mBubbleLinearLayout.setVisibility(0);
        if (LanguageUtils.isRtl()) {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfEnd);
        } else {
            viewHolder.mBubbleLinearLayout.setArrowPosPolicy(BubbleStyle.ArrowPosPolicy.SelfBegin);
        }
        viewHolder.mLLocation.setVisibility(8);
        viewHolder.mIvbg.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_gang_up_bg));
        Drawable drawable2 = this.tintDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_room_list_item_operation_count_bg), this.mCountColor);
        viewHolder.mRoomCountLayout.setBackgroundDrawable(drawable2);
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RoomListTogetherAdapter.this.enterRoom(roomListReportEventBean);
            }
        });
        if (position == this.getItemCount() - 1) {
            viewHolder.mTvSpace.setVisibility(0);
        } else {
            viewHolder.mTvSpace.setVisibility(8);
        }
    }

    public int getItemCount() {
        if (this.mRooms == null || this.mRooms.size() == 0) {
            return 0;
        }
        return this.mRooms.size();
    }

    public void onViewDetachedFromWindow(@NonNull TogetherRoomViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            RoomListReportEventBean eventBean = (RoomListReportEventBean)holder.itemView.getTag();
            RoomTrack.INSTANCE.onNearbyRoomReport(eventBean.getTag());
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            RoomListReportEventBean eventBean = (RoomListReportEventBean)holder.itemView.getTag();
            RoomTrack.INSTANCE.onKtvRoomReport(eventBean.getTag());
        } else if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            RoomListReportEventBean eventBean = (RoomListReportEventBean)holder.itemView.getTag();
            RoomTrack.INSTANCE.onOpearReport(eventBean.getTag());
        }
    }

    public void setRooms(List<RoomTabItem> mRooms, int type, int color2, LinkedHashMap<String, VoiceRoomTagConfigData> mTagsMap) {
        this.mRooms = mRooms;
        this.type = type;
        this.mCountColor = color2;
        if (mTagsMap == null) {
            MLog.info((Object)"getOtherRoomListData", (String)"mTagsMap is null", (Object[])new Object[0]);
        } else {
            MLog.info((Object)"getOtherRoomListData", (String)("mTagsMap is size" + mTagsMap.size()), (Object[])new Object[0]);
        }
        this.mTagsMap = mTagsMap;
    }

    public Drawable tintDrawable(@NonNull Drawable drawable2, int color2) {
        Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)color2);
        return wrappedDrawable;
    }

    private RoomListReportEventBean getRoomListReportEventBean(String roomId, String token, int position, String modelId, String roomModel, String tag, String gid) {
        return new RoomListReportEventBean.RoomListReportEventBeanBuilder().setRoomId(roomId).setToken(token).setPositionId(String.valueOf(position)).setModelId(modelId).setRoomModel(roomModel).setTag(tag).setPageLevelId("1").setGid(gid).build();
    }

    public void setCardId(long cardId) {
        this.cardId = cardId;
    }

    private void setName(String icon, String txt, TogetherRoomViewHolder viewHolder, int drawableResource) {
        if (!TextUtils.isEmpty((CharSequence)icon)) {
            ChainSpan.of().image(icon, ResolutionUtils.dip2Px((float)15.0f), ResolutionUtils.dip2Px((float)15.0f)).space().append((CharSequence)txt).onFinish(data -> {
                if (viewHolder.mTvRoomName != null) {
                    viewHolder.mTvRoomName.setText((CharSequence)data);
                }
            }).build();
        } else {
            ChainSpan.of().append(drawableResource, Size.of((int)ResolutionUtils.dip2Px((float)15.0f), (int)ResolutionUtils.dip2Px((float)15.0f))).space().space().append((CharSequence)txt).onFinish(data -> {
                if (viewHolder.mTvRoomName != null) {
                    viewHolder.mTvRoomName.setText((CharSequence)data);
                }
            }).build();
        }
    }

    static class TogetherRoomViewHolder
    extends RecyclerView.ViewHolder {
        private CircleImageView mCircleImageView;
        private YYTextView mTvCount;
        private BubbleLinearLayout mBubbleLinearLayout;
        private YYLinearLayout mLLocation;
        private YYTextView mTvRoomName;
        private YYTextView mTvHomeName;
        private YYTextView mTvDistance;
        private RCRelativeLayout rlMoreParent;
        private YYLinearLayout mRoomCountLayout;
        private YYTextView mTvSpace;
        private YYImageView mIvbg;
        private MatchSuccessAvatarView mMatchSuccessAvatarView;

        public TogetherRoomViewHolder(View itemView) {
            super(itemView);
            this.mCircleImageView = (CircleImageView)itemView.findViewById(R.id.iv_home_avatar);
            this.mTvCount = (YYTextView)itemView.findViewById(R.id.tv_room_count);
            this.mBubbleLinearLayout = (BubbleLinearLayout)itemView.findViewById(R.id.room_name_bg);
            this.mLLocation = (YYLinearLayout)itemView.findViewById(R.id.ll_location);
            this.mTvRoomName = (YYTextView)itemView.findViewById(R.id.tv_room_name);
            this.mTvHomeName = (YYTextView)itemView.findViewById(R.id.tv_home_name);
            this.mTvDistance = (YYTextView)itemView.findViewById(R.id.tv_distance);
            this.rlMoreParent = (RCRelativeLayout)itemView.findViewById(R.id.rl_more_item);
            this.mRoomCountLayout = (YYLinearLayout)itemView.findViewById(R.id.tv_room_count_layout);
            this.mTvSpace = (YYTextView)itemView.findViewById(R.id.tv_space);
            this.mIvbg = (YYImageView)itemView.findViewById(R.id.iv_bg);
            this.mMatchSuccessAvatarView = (MatchSuccessAvatarView)itemView.findViewById(R.id.iv_text_channel_head);
        }
    }
}

