/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.v1;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.module.recommend.R;
import com.yy.hiyo.channel.module.recommend.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.recommend.common.ChannelRecommendListMsgDef;
import com.yy.hiyo.channel.module.recommend.v1.ChannelMoreListMsgDef;
import com.yy.hiyo.channel.module.recommend.v1.adapter.RoomListMoreAdapter;
import com.yy.hiyo.channel.module.recommend.v1.mvp.RoomListMoreMvp;
import com.yy.hiyo.channel.module.recommend.v1.widget.RoomItemDecoration;
import com.yy.hiyo.channel.module.recommend.v1.widget.RoomMoreItemDecoration;
import java.util.List;
import net.ihago.room.api.rrec.EFrontpageTab;
import net.ihago.room.api.rrec.RoomTabItem;

@Deprecated
public class RoomMoreListPage
extends YYRelativeLayout
implements RoomListMoreMvp.IView {
    private YYRelativeLayout mLayout;
    private SimpleTitleBar simpleTitsleBar;
    private SmartRefreshLayout mRefreshLayout;
    private RecyclerView mRecyclerView;
    private CommonStatusLayout mStatusLayout;
    private YYLinearLayout mJoinTopicTipLayout;
    private YYTextView mJoinTopicTipText;
    private int type;
    private RoomListMoreAdapter moreAdapter;
    private RoomListMoreMvp.IPresenter mPresenter;
    private RoomListMoreAdapter.GameInfoCallBack mCallBack;
    private String title;
    private boolean hasMore;
    private long cardId;
    private boolean supportCustom;

    public RoomMoreListPage(Context context, int type, String title, long cardId, boolean supportCustom, RoomListMoreAdapter.GameInfoCallBack callBack) {
        super(context);
        this.type = type;
        this.mCallBack = callBack;
        this.title = title;
        this.cardId = cardId;
        this.supportCustom = supportCustom;
        this.initView();
        this.initAdapter();
        this.initListener();
    }

    private void initAdapter() {
        this.moreAdapter = new RoomListMoreAdapter(this.type, this.cardId, this.getContext());
        this.moreAdapter.setCallBack(this.mCallBack);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.moreAdapter);
    }

    private void initListener() {
        this.mRefreshLayout.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                RoomMoreListPage.this.loadMore();
            }

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                RoomTrack.INSTANCE.onRoomListMoreReportAll(RoomMoreListPage.this.type, true);
                RoomMoreListPage.this.refresh();
            }
        });
    }

    private void initView() {
        ViewGroup.MarginLayoutParams layoutParams;
        RoomMoreListPage.inflate((Context)this.getContext(), (int)R.layout.layout_room_more_list_channel, (ViewGroup)this);
        this.mLayout = (YYRelativeLayout)this.findViewById(R.id.rl_item_layout);
        this.simpleTitsleBar = (SimpleTitleBar)this.findViewById(R.id.titlebar);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_list);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.common_status);
        this.mJoinTopicTipLayout = (YYLinearLayout)this.findViewById(R.id.join_topic_layout);
        this.mJoinTopicTipText = (YYTextView)this.findViewById(R.id.join_topic_tv);
        if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            layoutParams = (ViewGroup.MarginLayoutParams)this.mRecyclerView.getLayoutParams();
            layoutParams.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
            layoutParams.rightMargin = ResolutionUtils.dip2Px((float)10.0f);
            this.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new RoomMoreItemDecoration());
            this.simpleTitsleBar.setLeftTitle(this.title);
            if (this.supportCustom) {
                this.mJoinTopicTipLayout.setVisibility(0);
                this.mJoinTopicTipText.setText((CharSequence)ResourceUtils.getString((int)R.string.title_join_the_topic, (Object[])new Object[]{this.title}));
                this.mJoinTopicTipLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Message message = new Message();
                        message.what = ChannelRecommendListMsgDef.ENTER_CHANNEL_JOIN_FROM_TOPIC;
                        message.obj = RoomMoreListPage.this.cardId;
                        MsgDispatcher.getInstance().sendMessage(message);
                    }
                });
            }
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            layoutParams = (ViewGroup.MarginLayoutParams)this.mRecyclerView.getLayoutParams();
            layoutParams.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
            layoutParams.rightMargin = ResolutionUtils.dip2Px((float)10.0f);
            this.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new RoomMoreItemDecoration());
            this.simpleTitsleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_room_more_list_ktv));
        } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            layoutParams = (ViewGroup.MarginLayoutParams)this.mRecyclerView.getLayoutParams();
            layoutParams.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
            layoutParams.rightMargin = ResolutionUtils.dip2Px((float)10.0f);
            this.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new RoomMoreItemDecoration());
            this.simpleTitsleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_channel_nearby));
        } else if (this.type == EFrontpageTab.EGangup.getValue()) {
            this.simpleTitsleBar.setLeftTitle(ResourceUtils.getString((int)R.string.tips_gangup_room_list_title));
        }
        this.simpleTitsleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                Message message = new Message();
                message.what = ChannelMoreListMsgDef.CLOSE_ROOM_LIST_MORE;
                MsgDispatcher.getInstance().sendMessage(message);
            }
        });
        if (this.type == EFrontpageTab.ERoomOperate.getValue() || this.type == EFrontpageTab.ERoomKTV.getValue() || this.type == EFrontpageTab.EGangup.getValue() || this.type == EFrontpageTab.ERoomNearby.getValue()) {
            GridLayoutManager layoutManager = new GridLayoutManager(this.getContext(), 2, 1, false);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            RoomItemDecoration mItemdecoration = new RoomItemDecoration();
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)mItemdecoration);
        } else {
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
            linearLayoutManager.setOrientation(1);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        }
    }

    private void refresh() {
        if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            this.mPresenter.getMoreOpearRooms(true);
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            this.mPresenter.getMoreKtvRooms(true);
        } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            this.mPresenter.getMoreNearbyRooms(true);
        } else if (this.type == EFrontpageTab.EGangup.getValue()) {
            this.mPresenter.getMoreGangUpRooms(true);
        }
    }

    private void loadMore() {
        if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            this.mPresenter.getMoreOpearRooms(false);
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            this.mPresenter.getMoreKtvRooms(false);
        } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            this.mPresenter.getMoreNearbyRooms(false);
        } else if (this.type == EFrontpageTab.EGangup.getValue()) {
            this.mPresenter.getMoreGangUpRooms(false);
        }
    }

    @Override
    public void setRoomListMoreData(List<RoomTabItem> rooms, boolean hasMore) {
        this.moreAdapter.updateData(rooms);
        this.hasMore = hasMore;
        this.mRefreshLayout.finishLoadMore();
        this.mRefreshLayout.finishRefresh();
        if (!hasMore) {
            this.mRefreshLayout.setNoMoreData(true);
        } else {
            this.mRefreshLayout.setNoMoreData(false);
        }
        if (rooms == null || rooms.size() == 0) {
            this.mStatusLayout.showNoData();
        } else {
            this.mStatusLayout.hideAllStatus();
        }
    }

    @Override
    public void setPresenter(RoomListMoreMvp.IPresenter iPresenter) {
        this.mStatusLayout.showLoading();
        this.mPresenter = iPresenter;
    }

    @Override
    public void requestData() {
        if (this.type == EFrontpageTab.ERoomOperate.getValue()) {
            this.mPresenter.getMoreOpearRooms(true);
        } else if (this.type == EFrontpageTab.ERoomKTV.getValue()) {
            this.mPresenter.getMoreKtvRooms(true);
        } else if (this.type == EFrontpageTab.ERoomNearby.getValue()) {
            this.mPresenter.getMoreNearbyRooms(true);
        } else if (this.type == EFrontpageTab.EGangup.getValue()) {
            this.mPresenter.getMoreGangUpRooms(true);
        }
    }

    @Override
    public void setDataError() {
        this.mStatusLayout.showError();
        this.mRefreshLayout.finishLoadMore();
        this.mRefreshLayout.finishRefresh();
    }

    public void clearBg() {
        this.mLayout.setBackground(null);
    }

    public void recoverBg() {
        this.mLayout.setBackground((Drawable)new ColorDrawable(-1));
    }
}

