/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.recommend.channelhiido;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.module.recommend.base.bean.ItemPositionInfo;
import com.yy.hiyo.channel.module.recommend.base.channelhiido.RoomListReportEventBean;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ihago.room.api.rrec.EFrontpageTab;

public enum RoomTrack {
    INSTANCE;

    private static final String TAG = "RoomTrack";
    private static final String KEY_FUNCTION_ID = "function_id";
    private static final String EVENT_ID = "20028823";
    public static final String KEY_MODE = "mode_key";
    private static final String FUNCTION_VOICE_LIST_CLICK = "list_back_click";
    private static final String FUNCTION_HISTORY_CLICK = "history_click";
    private static final String FUNCTION_VOICE_ROOM_LIST_CREATE_ROOM_CLICK = "new_room_click";
    private static final String FUNCTION_VOICE_ROOM_NET_ERROR = "net_unusual_show";
    private static final String FUNCTION_VOICE_ROOM_LIST_NET_ERROR_RETRY = "net_unusual_refresh_click";
    private static final String FUNCTION_CHAT_LIST_SHOW = "chat_list_show";
    private static final String FUNCTION_QUICK_JOIN_SHOW = "quick_join_show";
    private static final String FUNCTION_GUIDE_FIN_SHOW = "guide_fin_show";
    private static final String FUNCTION_GUIDE_FIN_CLOSE = "guide_fin_close";
    private static final String FUNCTION_ROOM_CONTENT_SHOW = "room_content_show";
    private static final String FUNCTION_ROOM_BANNER_SHOW = "room_banner_show";
    private static final String FUNCTION_ROOM_BANNER_CLICK = "room_banner_click";
    private static final String FUNCTION_REPORT_POP_BLANK_CLICK = "report_pop_blank_click";
    private static final String FUNCTION_RANKING_LIST_ENTER_SHOW = "ranking_list_enter_show";
    private static final String FUNCTION_RANKING_LIST_ENTER_CLICK = "ranking_list_enter_click";
    private static final String FUNCTION_PACKET_LABEL_SHOW = "packet_label_show";
    private static final String FUNCTION_PACKET_LABEL_CLICK = "packet_label_click";
    private static final String FUNCTION_PACKET_RECOMMEND_SHOW = "packet_recommend_show";
    private static final String FUNCTION_PACKET_RECOMMEND_CLICK = "packet_recommend_click";
    private static final String FUNCTION_ROOM_LIST_MORE_CLICK = "list_more_but_click";
    private static final String FUNCTION_NEARBY_PAGE_SHOW = "nearby_people_sec_pg_show";
    private static final String FUNCTION_KTV_PAGE_SHOW = "ktv_sec_pg_show";
    private static final String FUNCTION_OPEAR_PAGE_SHOW = "revenue_sec_pg_show";
    private static final String FUNCTION_TOPBAR_DOUBLE_CLICK = "back_first_screen_click";
    private static final String FUNCTION_CHANNEL_LIST_TAB_CLICK = "channel_list_class_but_click";
    private static final String FUNCTION_TAB_GUIDE_CARD_SHOW = "tab_guide_card_show";
    private static final String FUNCTION_TAB_GUIDE_CARD_CLICK = "tab_guide_card_click";
    private static final String FUNCTION_CONTENT_CLICK = "content_click";
    private static final String KEY_ROOM_ID = "room_id";
    private static final String KEY_IF_FOLLOW_REMIND = "if_follow_remind";
    private static final String KEY_CONTENT_SHOW = "content_show";
    private static final String KEY_NUM_ID = "num_id";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_BANNER_ID = "banner_id";
    private static final String KEY_ACT_URL = "act_url";
    private static final String KEY_GID = "gid";
    private static final String KEY_GUIDE_FIN_CLOSE_TYPE = "guide_fin_close_type";
    private static final String KEY_MODEL_ID = "module_id";
    private static final String KEY_PAGE_LEVEL_ID = "page_level_id";
    private static final String KEY_USER_ROLE = "user_role";
    private static final String KEY_CHANNEL_LIST_TAB_ID = "channel_class_tab_id";
    private static final String KEY_CHANNEL_LIST_TAB_TYPE = "channel_class_type";
    private static final String KEY_REMAIN_TIME = "remain_time";
    private static final String FUNCTION_CITY_CHANNEL_ENTER_SHOW = "city_channel_enter_show";
    private static final String FUNCTION_AGG_ENTER_SHOW = "agg_enter_show";
    private static final String KEY_RADIO_MODEL = "radio_model";
    private static final String KEY_RELATION_NUM = "relation_num";
    private static final String KEY_RELATION_TYPE = "relation_type";
    private static final String FUNCTION_MODULE_CLOSE = "module_close_click";
    private static final String FUNCTION_PARTY_CARD_MODULE_SHOW = "new_user_model_show";
    private static final String FUNCTION_PARTY_CARD_CLICK = "new_user_model_click";
    private static final String KEY_TAB_CAT_ID = "tab_id";
    private static final String KEY_ITEM_HEIGHT = "room_high";
    private static final String KEY_ITEM_SHOW_HEIGHT = "room_show_high";
    private static final String FUNCTION_NATION_FILTER_CLICK = "global_live_tab_but_click";
    private static final String KEY_NATION_CODE = "global_live_tab_but_type";
    private static final String CONTENT_TYPE_ID = "content_type_id";
    private static final String GUIDE_TAG_ID = "guide_tag_id";
    private static final String KEY_DISCOVERD_GROUP_SOURCE = "discoverd_group_source";
    private static final String KEY_CHANNEL_ORDER_INDEX = "channel_order_num";
    private static final String KEY_CHANNEL_TAB_INDEX = "channel_tab_num";
    private static final String KEY_CHANNEL_RECALL_TYPE = "channel_recall_type";
    private static final String KEY_ICON_STYLE = "icon_style";
    private static final String KEY_NATION_CODE_V2 = "nation_code";
    private static final String KEY_ROW_NUM = "row_num";
    private static final String KEY_COLUMN_NUM = "column_num";
    private static final String KEY_MODULE_TYPE = "module_type";
    private static final String KEY_ROW_NUM_S = "row_num_s";
    private static final String KEY_COLUMN_NUM_S = "column_num_s";
    private Map<String, RoomListReportEventBean> map = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> attentionMap = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> ktvMap = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> opearMap = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> mNearbyMap = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> mKtvListMap = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> mOpearListMap = new ConcurrentHashMap<String, RoomListReportEventBean>();
    private Map<String, RoomListReportEventBean> mNearbyListMap = new ConcurrentHashMap<String, RoomListReportEventBean>();

    private HiidoEvent event() {
        return ChannelBaseTrack.INSTANCE.event();
    }

    private HiidoEvent event(String eventId) {
        return ChannelBaseTrack.INSTANCE.event(eventId);
    }

    public void onVoiceRoomListClickBack() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_VOICE_LIST_CLICK));
    }

    public void onVoiceRoomHistoryClick() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_HISTORY_CLICK));
    }

    public void onVoiceRoomListCreateRoomClick(int from) {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_VOICE_ROOM_LIST_CREATE_ROOM_CLICK).put("new_room_type", String.valueOf(from)));
    }

    public void onVoiceRoomListNetError() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_VOICE_ROOM_NET_ERROR));
    }

    public void onVoiceRoomListNetErrorRetry() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_VOICE_ROOM_LIST_NET_ERROR_RETRY));
    }

    public void onReminderListShow(String state) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, FUNCTION_CHAT_LIST_SHOW).put(KEY_IF_FOLLOW_REMIND, state).put(KEY_MODE, String.valueOf(2)));
    }

    public void onQuickJoinShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_QUICK_JOIN_SHOW));
    }

    public void reportRoomListGuideShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_GUIDE_FIN_SHOW));
    }

    private void reportRoomListGuideClose(int type) {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_GUIDE_FIN_CLOSE).put(KEY_GUIDE_FIN_CLOSE_TYPE, "" + type));
    }

    public void reportRoomListGuideOutsideClose() {
        this.reportRoomListGuideClose(2);
    }

    public void reportRoomListGuideTimeoutClose() {
        this.reportRoomListGuideClose(1);
    }

    public void addRoomListItemReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.map.put(roomId, item);
    }

    public void onRoomListItemReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.map.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.map.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.map.remove(key);
        }
    }

    public void addRoomAttentionItemReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.attentionMap.put(roomId, item);
    }

    public void onRoomAttentionItemReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.attentionMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.attentionMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.attentionMap.remove(key);
        }
    }

    public void addKtvRoomReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.ktvMap.put(roomId, item);
    }

    public void onKtvRoomReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.ktvMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.ktvMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.ktvMap.remove(key);
        }
    }

    public void addOpearRoomReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.opearMap.put(roomId, item);
    }

    public void onOpearReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.opearMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.opearMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.opearMap.remove(key);
        }
    }

    public void addNearbyRoomReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.mNearbyMap.put(roomId, item);
    }

    public void onNearbyRoomReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.mNearbyMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.mNearbyMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.mNearbyMap.remove(key);
        }
    }

    public void addKtvRoomListReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.mKtvListMap.put(roomId, item);
    }

    public void onKtvRoomListReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.mKtvListMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.mKtvListMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.mKtvListMap.remove(key);
        }
    }

    public void addOpearRoomListReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.mOpearListMap.put(roomId, item);
    }

    public void onOpearRoomListReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.mOpearListMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.mOpearListMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.mOpearListMap.remove(key);
        }
    }

    public void addNearbyRoomListReport(String roomId, RoomListReportEventBean item) {
        item.setTimestamp(System.currentTimeMillis());
        this.mNearbyListMap.put(roomId, item);
    }

    public void onNearbyRoomListReport(String key) {
        long timestamp = System.currentTimeMillis();
        if (this.mNearbyListMap.containsKey(key)) {
            RoomListReportEventBean reportEventBean = this.mNearbyListMap.get(key);
            if (reportEventBean != null && timestamp - reportEventBean.getTimestamp() > 1000L) {
                this.reportContentShowRoom(reportEventBean);
            }
            this.mNearbyListMap.remove(key);
        }
    }

    public void reportContentShowRoom(RoomListReportEventBean bean) {
        if (bean != null) {
            String str = bean.toString();
            String reportContent = RoomTrack.urlEncoderContent(str);
            boolean isGroupChannel = !TextUtils.equals((CharSequence)bean.getModuleType(), (CharSequence)"1") && !bean.isModule();
            HiidoEvent event = this.event().put(KEY_FUNCTION_ID, FUNCTION_ROOM_CONTENT_SHOW).put(KEY_CONTENT_SHOW, reportContent).put(KEY_ITEM_HEIGHT, bean.getItemHeight()).put(CONTENT_TYPE_ID, bean.isVideo() ? String.valueOf(bean.getContentTagId()) : "").put(GUIDE_TAG_ID, bean.isMicConnected() ? "1" : "2").put(KEY_ITEM_SHOW_HEIGHT, bean.getItemShowHeight()).put(KEY_TOKEN, bean.getToken()).put(KEY_TAB_CAT_ID, bean.getTabCatId()).put("server_module_id", bean.getServerModuleId()).put("first_level_tab", bean.getFirstLevelTab()).put("second_level_tab", bean.getSecondLevelTab()).put(KEY_ICON_STYLE, bean.getIconStyle()).put(KEY_NATION_CODE_V2, bean.getNationCode()).put(KEY_GID, bean.getGid()).put(KEY_RADIO_MODEL, bean.getRadioMode()).put("live_type", bean.getCarouselType()).put("turn_info", bean.getCoverType()).put("party_enter_source", bean.getPartyEnterSource()).put("empty_seat", String.valueOf(bean.getEmptySeat())).put("online_numbers", String.valueOf(bean.getOnlineNumbers())).put(isGroupChannel ? KEY_ROW_NUM_S : KEY_ROW_NUM, bean.getRow()).put(isGroupChannel ? KEY_COLUMN_NUM_S : KEY_COLUMN_NUM, bean.getColumn()).put(KEY_MODULE_TYPE, bean.getModuleType()).put("room_distribute_type", String.valueOf(bean.getRoomDistributeType())).put(KEY_NUM_ID, String.valueOf(bean.getPositionId()));
            if (bean.getExpandParams() != null && !bean.getExpandParams().isEmpty()) {
                for (Map.Entry entry : bean.getExpandParams().entrySet()) {
                    event.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            HiidoStatis.reportEvent((HiidoEvent)event);
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"reportContentShow content_show=%s,token=%s,tabCatId=%s,height=%s,showHeight=%s", (Object[])new Object[]{str, bean.getToken(), bean.getTabCatId(), bean.getItemHeight(), bean.getItemShowHeight()});
            }
        }
    }

    public void reportChannelGuidanceShow(String gid, String firstLevelTab, String secondLevelTab) {
        HiidoEvent event = this.event().put(KEY_FUNCTION_ID, FUNCTION_TAB_GUIDE_CARD_SHOW).put("first_level_tab", firstLevelTab).put("second_level_tab", secondLevelTab).put(KEY_GID, gid);
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public void reportChannelGuidanceClick(String gid, String firstLevelTab, String secondLevelTab) {
        HiidoEvent event = this.event().put(KEY_FUNCTION_ID, FUNCTION_TAB_GUIDE_CARD_CLICK).put("first_level_tab", firstLevelTab).put("second_level_tab", secondLevelTab).put(KEY_GID, gid);
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public static String urlEncoderContent(String token) {
        try {
            return URLEncoder.encode(token, "UTF-8");
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"urlEncoderContent e=%s", (Object[])new Object[]{e.toString()});
            return token;
        }
    }

    public void onRoomListReportAll(boolean isRefresh) {
        long timestamp = System.currentTimeMillis();
        for (Map.Entry<String, RoomListReportEventBean> entry : this.map.entrySet()) {
            if (entry.getValue() == null || timestamp - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
            this.reportContentShowRoom(entry.getValue());
        }
        long timestamp1 = System.currentTimeMillis();
        for (Map.Entry<String, RoomListReportEventBean> entry : this.attentionMap.entrySet()) {
            if (entry.getValue() == null || timestamp1 - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
            this.reportContentShowRoom(entry.getValue());
        }
        long timestamp2 = System.currentTimeMillis();
        for (Map.Entry<String, RoomListReportEventBean> entry : this.ktvMap.entrySet()) {
            if (entry.getValue() == null || timestamp2 - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
            this.reportContentShowRoom(entry.getValue());
        }
        long timestamp3 = System.currentTimeMillis();
        for (Map.Entry<String, RoomListReportEventBean> entry : this.mNearbyMap.entrySet()) {
            if (entry.getValue() == null || timestamp3 - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
            this.reportContentShowRoom(entry.getValue());
        }
        long timestamp4 = System.currentTimeMillis();
        for (Map.Entry<String, RoomListReportEventBean> entry : this.opearMap.entrySet()) {
            if (entry.getValue() == null || timestamp4 - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
            this.reportContentShowRoom(entry.getValue());
        }
        this.map.clear();
        this.attentionMap.clear();
        this.ktvMap.clear();
        this.mNearbyMap.clear();
        this.opearMap.clear();
    }

    public void onRoomListMoreReportAll(int type, boolean isRefresh) {
        long timestamp = System.currentTimeMillis();
        if (type == EFrontpageTab.ERoomKTV.getValue()) {
            for (Map.Entry<String, RoomListReportEventBean> entry : this.mKtvListMap.entrySet()) {
                if (entry.getValue() == null || timestamp - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
                this.reportContentShowRoom(entry.getValue());
            }
        } else if (type == EFrontpageTab.ERoomNearby.getValue()) {
            for (Map.Entry<String, RoomListReportEventBean> entry : this.mNearbyListMap.entrySet()) {
                if (entry.getValue() == null || timestamp - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
                this.reportContentShowRoom(entry.getValue());
            }
        } else if (type == EFrontpageTab.ERoomOperate.getValue()) {
            for (Map.Entry<String, RoomListReportEventBean> entry : this.mOpearListMap.entrySet()) {
                if (entry.getValue() == null || timestamp - entry.getValue().getTimestamp() <= 1000L && !isRefresh) continue;
                this.reportContentShowRoom(entry.getValue());
            }
        }
        this.mKtvListMap.clear();
        this.mNearbyListMap.clear();
        this.mOpearListMap.clear();
    }

    public String getPluginId(IChannel channel) {
        if (channel == null || channel.getPluginService() == null) {
            return "";
        }
        ChannelPluginData data = channel.getPluginService().getCurPluginData();
        if (data == null) {
            return "";
        }
        return data.getPluginId() == null ? "" : data.getPluginId();
    }

    public String getPluginId(String channelid) {
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelid);
        return this.getPluginId(channel);
    }

    public int getUserRole(String channelId) {
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelId);
        if (channel == null) {
            return -1;
        }
        return channel.getRoleService().getMyRoleCache();
    }

    private void report(HiidoEvent event) {
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public void reportBannerShow(String bannerId, String actUrl) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_ROOM_BANNER_SHOW).put(KEY_BANNER_ID, bannerId).put(KEY_ACT_URL, actUrl));
    }

    public void reportBannerClick(String bannerId, String actUrl) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_ROOM_BANNER_CLICK).put(KEY_BANNER_ID, bannerId).put(KEY_ACT_URL, actUrl));
    }

    public void reportPopBlankClick(String roomId) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_REPORT_POP_BLANK_CLICK).put(KEY_ROOM_ID, roomId).put(KEY_GID, this.getPluginId(roomId)).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void reportPacketLabelShow(String roomId) {
        this.report(HiidoEvent.obtain().eventId("20032603").put(KEY_MODE, RuntimeContext.useOldRoom() ? "1" : "2").put(KEY_FUNCTION_ID, FUNCTION_PACKET_LABEL_SHOW).put(KEY_ROOM_ID, roomId));
    }

    public void reportPacketLabelClick(String roomId) {
        this.report(HiidoEvent.obtain().eventId("20032603").put(KEY_MODE, RuntimeContext.useOldRoom() ? "1" : "2").put(KEY_FUNCTION_ID, FUNCTION_PACKET_LABEL_CLICK).put(KEY_ROOM_ID, roomId));
    }

    public void reportRecommendPacketLabelShow(String roomId) {
        this.report(HiidoEvent.obtain().eventId("20032603").put(KEY_MODE, RuntimeContext.useOldRoom() ? "1" : "2").put(KEY_FUNCTION_ID, FUNCTION_PACKET_RECOMMEND_SHOW).put(KEY_ROOM_ID, roomId));
    }

    public void reportRecommendPacketLabelClick(String roomId) {
        this.report(HiidoEvent.obtain().eventId("20032603").put(KEY_MODE, RuntimeContext.useOldRoom() ? "1" : "2").put(KEY_FUNCTION_ID, FUNCTION_PACKET_RECOMMEND_CLICK).put(KEY_ROOM_ID, roomId));
    }

    public void reportRoomMoreListClick(String modelId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_ROOM_LIST_MORE_CLICK).put(KEY_MODEL_ID, modelId));
    }

    public void reportNearbyPageShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_NEARBY_PAGE_SHOW));
    }

    public void reportKtvPageShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_KTV_PAGE_SHOW));
    }

    public void reportOpearPageShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_OPEAR_PAGE_SHOW));
    }

    public void reportRankingListEnterShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_RANKING_LIST_ENTER_SHOW));
    }

    public void reportRankingListEnterClick() {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_RANKING_LIST_ENTER_CLICK));
    }

    public void reportRoomListTopbarDoubleClick(int numId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_TOPBAR_DOUBLE_CLICK).put(KEY_NUM_ID, String.valueOf(numId)));
    }

    public void reportChannelListTabClick(int tabType) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_CHANNEL_LIST_TAB_CLICK).put(KEY_CHANNEL_LIST_TAB_TYPE, "" + tabType));
        if (tabType == 1) {
            this.reportChannelShow();
        } else if (tabType == 5) {
            this.reportLiveShow();
        }
    }

    public void reportChannelShow() {
        ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent(ThirdTrackEvent.PARTY_SHOW));
    }

    public void reportLiveShow() {
        ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent(ThirdTrackEvent.LIVE_SHOW));
    }

    public void reportChannelListShow(long tabId, int tabType, long remainTime) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_CHAT_LIST_SHOW).put(KEY_CHANNEL_LIST_TAB_ID, "" + tabId).put(KEY_CHANNEL_LIST_TAB_TYPE, "" + tabType).put(KEY_REMAIN_TIME, "" + remainTime).put(KEY_PAGE_LEVEL_ID, "1"));
    }

    public void reportSameCityModuleShow() {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_CITY_CHANNEL_ENTER_SHOW));
    }

    public void reportMoreListShow(String modelId) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_CHAT_LIST_SHOW).put(KEY_MODEL_ID, modelId).put(KEY_PAGE_LEVEL_ID, "2"));
    }

    public void reportAggEnterShow(int tabType, String modeId) {
        this.report(this.event().put(KEY_FUNCTION_ID, FUNCTION_AGG_ENTER_SHOW).put(KEY_CHANNEL_LIST_TAB_TYPE, "" + tabType).put(KEY_MODEL_ID, modeId));
    }

    public void reportGroupMoreClick(int tabType, String modeId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event().put(KEY_FUNCTION_ID, FUNCTION_ROOM_LIST_MORE_CLICK).put(KEY_CHANNEL_LIST_TAB_TYPE, "" + tabType).put(KEY_MODEL_ID, modeId));
    }

    public void reportFollowRemindShow(String relationNum) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "follow_model_show").put(KEY_RELATION_NUM, relationNum));
    }

    public void reportFollowRemindClick(String relationType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "follow_model_click").put(KEY_RELATION_TYPE, relationType));
    }

    public void reportModuleClose(String moduleId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, FUNCTION_MODULE_CLOSE).put(KEY_MODEL_ID, moduleId));
    }

    public void reportPartyModuleCardModuleShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, FUNCTION_PARTY_CARD_MODULE_SHOW));
    }

    public void reportPartyCardClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, FUNCTION_PARTY_CARD_CLICK));
    }

    public void reportNationFilterClick(String nation) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, FUNCTION_NATION_FILTER_CLICK).put(KEY_NATION_CODE, nation));
    }

    public void onFamilyBannerShow(String bannerSource) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "family_banner_show").put("banner_source", bannerSource));
    }

    public void onFamilyBannerClick(String bannerSource) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "family_banner_click").put("banner_source", bannerSource));
    }

    public void onMultiVideoBannerShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045047").put(KEY_FUNCTION_ID, "party_recommend_tab_show"));
    }

    public void onMultiVideoBannerClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045047").put(KEY_FUNCTION_ID, "party_recommend_tab_click"));
    }

    public void channelImGroupShow(String discoverySource) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "channel_im_group_show").put(KEY_DISCOVERD_GROUP_SOURCE, discoverySource));
    }

    public void channelImGroupItemShow(String roomId, String discoverySource, String tabIndex, String orderIndex, String recallType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, "channel_show").put(KEY_DISCOVERD_GROUP_SOURCE, discoverySource).put(KEY_CHANNEL_ORDER_INDEX, orderIndex).put(KEY_CHANNEL_TAB_INDEX, tabIndex).put(KEY_CHANNEL_RECALL_TYPE, recallType));
    }

    public void channelImGroupClick(String roomId, String discoverySource, String tabIndex, String orderIndex, String recallType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "channel_im_group_click").put(KEY_ROOM_ID, roomId).put(KEY_DISCOVERD_GROUP_SOURCE, discoverySource).put(KEY_CHANNEL_ORDER_INDEX, orderIndex).put(KEY_CHANNEL_TAB_INDEX, tabIndex).put(KEY_CHANNEL_RECALL_TYPE, recallType));
    }

    public void channelImGroupJoinClick(String roomId, String discoverySource, String tabIndex, String orderIndex, String recallType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "channel_im_group_join_click").put(KEY_ROOM_ID, roomId).put(KEY_DISCOVERD_GROUP_SOURCE, discoverySource).put(KEY_CHANNEL_ORDER_INDEX, orderIndex).put(KEY_CHANNEL_TAB_INDEX, tabIndex).put(KEY_CHANNEL_RECALL_TYPE, recallType));
    }

    public void reportQuickJoinFixentranceClick(String gid) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "quick_join_fixentrance_click").put(KEY_GID, gid));
    }

    public void reportChannelPgShow(String firstLevelTab, String secondLevelTab, String nationCode) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_pg_show").put("first_level_tab", firstLevelTab).put("second_level_tab", secondLevelTab).put(KEY_NATION_CODE_V2, TextUtils.isEmpty((CharSequence)nationCode) ? "" : nationCode));
    }

    public void reportChannelTabClick(String firstLevelTab, String secondLevelTab, String nationCode) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_tab_click").put("first_level_tab", firstLevelTab).put("second_level_tab", secondLevelTab).put(KEY_NATION_CODE_V2, TextUtils.isEmpty((CharSequence)nationCode) ? "" : nationCode));
    }

    public void reportShowTabNationList(String code) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "nation_list_show").put(KEY_NATION_CODE_V2, code));
    }

    public void reportClickNationIcon(String code) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "nation_icon_click").put(KEY_NATION_CODE_V2, code));
    }

    public void reportRoomCreateClick(String firstLevelTab) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "room_create_click").put("first_level_tab", firstLevelTab));
    }

    public void reportChannelPgMoreClick(String moduleId, String serverModuleId, String firstLevelTab, String secondLevelTab) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_pg_more_click").put(KEY_MODEL_ID, moduleId).put("server_module_id", serverModuleId).put("first_level_tab", firstLevelTab).put("second_level_tab", secondLevelTab));
    }

    public void reportNationClick(String countryCode) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_pg_nation_click").put("country_id", countryCode));
    }

    public void reportNationMoreOpenClick() {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_pg_nation_more_click"));
    }

    public void reportNationMoreCloseClick() {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_pg_nation_more_close"));
    }

    public void reportChannelImGroupThemeTabClick(String themeTabId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20023799").put(KEY_FUNCTION_ID, "channel_im_group_theme_tab_click").put("theme_tab_id", themeTabId));
    }

    public void reportChannelListRefresh(String firstLevelTab, String secondLevelTab) {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "channel_refresh").put("first_level_tab", firstLevelTab).put("second_level_tab", secondLevelTab));
    }

    public void reportVideoMatchClick(int matchType) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20045525").put(KEY_FUNCTION_ID, "multiple_matchroom_click").put("matchroom_type", String.valueOf(matchType)));
    }

    public void reportPartyMasterModuleShow() {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "talent_card_show"));
    }

    public void reportPartyMasterModuleClick() {
        HiidoStatis.reportEvent((HiidoEvent)this.event(EVENT_ID).put(KEY_FUNCTION_ID, "talent_card_click"));
    }

    public void partyGameAmongUsItemShow(String gid, int loopCount) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_two_roleplay_show").put(KEY_GID, gid).put("showNum", loopCount + ""));
    }

    public void partyGameAmongUsItemClick(String gid, int loopCount) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_twe_roleplay_click").put(KEY_GID, gid).put("showNum", loopCount + ""));
    }

    public void partyGameLudoItemShow(String gid, int loopCount) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_one_roleplay_show").put(KEY_GID, gid).put("showNum", loopCount + ""));
    }

    public void partyGameLudoItemClick(String gid, int loopCount) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_one_roleplay_click").put(KEY_GID, gid).put("showNum", loopCount + ""));
    }

    public void partyGameItemShow(boolean newStyle) {
        String style2 = null;
        style2 = newStyle ? "2" : "1";
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_room_show").put("style", style2));
    }

    public void partyGameItemHeadShow(int headCount) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_head_show").put("head_num", headCount + ""));
    }

    public void partyGameItemClick(boolean newStyle) {
        String style2 = null;
        style2 = newStyle ? "2" : "1";
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "partygame_list_room_click").put("style", style2));
    }

    public void reportMlbbGangupShow(@Nullable ItemPositionInfo positionInfo) {
        int row = positionInfo == null ? 0 : positionInfo.getRow() + 1;
        int column = positionInfo == null ? 0 : positionInfo.getColumn() + 1;
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "voice_chat_gather_card_show").put("row_id", String.valueOf(row)).put("column_id", String.valueOf(column)));
    }

    public void reportMlbbGangupClick(@Nullable ItemPositionInfo positionInfo) {
        int row = positionInfo == null ? 0 : positionInfo.getRow() + 1;
        int column = positionInfo == null ? 0 : positionInfo.getColumn() + 1;
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "voice_chat_gather_card_click").put("row_id", String.valueOf(row)).put("column_id", String.valueOf(column)));
    }

    public void reportContentClick(RoomListReportEventBean bean) {
        boolean isGroupChannel = !TextUtils.equals((CharSequence)bean.getModuleType(), (CharSequence)"1");
        HiidoEvent event = this.event().put(KEY_FUNCTION_ID, FUNCTION_CONTENT_CLICK).put("first_level_tab", bean.getFirstLevelTab()).put("second_level_tab", bean.getSecondLevelTab()).put(isGroupChannel ? KEY_ROW_NUM_S : KEY_ROW_NUM, bean.getRow()).put(isGroupChannel ? KEY_COLUMN_NUM_S : KEY_COLUMN_NUM, bean.getColumn()).put(KEY_MODULE_TYPE, bean.getModuleType());
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public void discoverBannerShow(String bannerId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "discover_channel_banner_show").put(KEY_BANNER_ID, bannerId));
    }

    public void discoverBannerClick(String bannerId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "discover_channel_banner_click").put(KEY_BANNER_ID, bannerId));
    }

    public void createGroupClick(String source) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "discover_channel_create_click").put(KEY_DISCOVERD_GROUP_SOURCE, source));
    }

    public void discoverGuideShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "channel_page_guide_show"));
    }

    public void discoverGuideClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "channel_page_guide_click").put("click_area", "1"));
    }

    public void discoverGuideDismiss() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "channel_page_guide_click").put("click_area", "2"));
    }

    public void reportDiscoverRecommendGroupShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "channel_featured_card_show").put(KEY_ROOM_ID, roomId));
    }

    public void reportDiscoverRecommendGroupClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "channel_featured_card_click").put(KEY_ROOM_ID, roomId));
    }

    public void reportDiscoverRecommendGroupJoin(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "channel_featured_card_join_click").put(KEY_ROOM_ID, roomId));
    }

    public void reportDiscoverRecommendMoreGroupShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "more_channels_button_show"));
    }

    public void reportDiscoverRecommendMoreGroupClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put(KEY_FUNCTION_ID, "more_channels_button_click"));
    }

    public void reportGangupRoomShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "party_gangup_lobby_gangup_module_show"));
    }

    public void reportGangupRoomClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(EVENT_ID).put(KEY_FUNCTION_ID, "party_gangup_lobby_gangup_play_click"));
    }

    public void reportStoryAggregateShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60129239").put(KEY_FUNCTION_ID, "group_module_show"));
    }

    public void reportNovelAggregateClick(String id2) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60129239").put(KEY_FUNCTION_ID, "group_module_click").put(KEY_MODULE_TYPE, id2));
    }
}

