/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide;

import android.content.Context;
import android.view.View;
import android.widget.RelativeLayout;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.channel.cbase.model.bean.RuleCardInfoBean;
import com.yy.hiyo.channel.cbase.widget.IGuidePageCallback;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide.GameGuidePage;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide.GameGuideUiCallbacks;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameRule;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GameGuideHandler
implements IGuidePageCallback {
    private static final String TAG = "GameGuideWindow";
    private GameGuidePage mGameGuidePage;
    private GameGuideUiCallbacks mGameGuideUiCallbacks;
    private BasePanel mBasePanel;

    public GameGuideHandler(GameGuideUiCallbacks callBacks) {
        this.mGameGuideUiCallbacks = callBacks;
    }

    public BasePanel createNewUserGuidePanel(Context context, GameInfo gameInfo, String roomId) {
        if (gameInfo == null) {
            return null;
        }
        this.mGameGuidePage = new GameGuidePage(context);
        this.mGameGuidePage.setCallback(this);
        if (!FP.empty((Collection)gameInfo.getGameRuleList())) {
            ArrayList<RuleCardInfoBean> list = new ArrayList<RuleCardInfoBean>();
            for (GameRule gameRule : gameInfo.getGameRuleList()) {
                RuleCardInfoBean ruleCardInfoBean = new RuleCardInfoBean();
                ruleCardInfoBean.setRuleImg(gameRule.getBgUrl());
                ruleCardInfoBean.setRuleTips(gameRule.getContent());
                ruleCardInfoBean.setRuleTitle(gameRule.getTitle());
                list.add(ruleCardInfoBean);
            }
            this.initGuideBG(gameInfo.getRuleBgUrl(), gameInfo.getGameBColor());
            this.initRuleCardPager(list);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033117").put("function_id", "rule_pg_show").put("room_id", roomId));
        }
        if (this.mBasePanel == null) {
            this.mBasePanel = new BasePanel(context);
            this.mBasePanel.setShowAnim(this.mBasePanel.createLeftShowAnimation());
            this.mBasePanel.setHideAnim(this.mBasePanel.createRightHideAnimation());
            this.mBasePanel.setListener((BasePanel.IPanelListener)new BasePanel.SimplePanelListener(){

                public void onPanelHide(BasePanel panel, boolean animated) {
                }
            });
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.mBasePanel.setContent((View)this.mGameGuidePage, params);
        return this.mBasePanel;
    }

    public void onClose() {
        if (this.mGameGuideUiCallbacks != null) {
            this.mGameGuideUiCallbacks.closeNewUserGuide();
        }
    }

    public void initRuleCardPager(List<RuleCardInfoBean> gameRuleData) {
        if (this.mGameGuidePage != null) {
            this.mGameGuidePage.initRuleCardPager(gameRuleData);
        }
    }

    public void initGuideBG(String bgUrl, String color2) {
        if (this.mGameGuidePage != null) {
            this.mGameGuidePage.initGuideBG(bgUrl, color2);
        }
    }

    public BasePanel getBasePanel() {
        return this.mBasePanel;
    }
}

