/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.seatview.CustomRecyclerView;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat.AssistGameSeatItemHolder;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.seat.AssistSeatUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.drakeet.multitype.MultiTypeAdapter;

public class AssistSeatViewWrapper
implements ISeatViewWrapper {
    private static final String TAG = "AssistSeatViewWrapper";
    private CustomRecyclerView mRecyclerView;
    private MultiTypeAdapter mAdapter = new MultiTypeAdapter();

    public AssistSeatViewWrapper() {
        this.mAdapter.setHasStableIds(true);
    }

    public void createView(Context context, ViewGroup parent) {
        if (this.mRecyclerView != null) {
            return;
        }
        View.inflate((Context)context, (int)R.layout.assistgame_seat_sytle1_wrapper, (ViewGroup)parent);
        this.mRecyclerView = (CustomRecyclerView)parent.findViewById(R.id.seat_list);
        this.mRecyclerView.getLayoutManager().setItemPrefetchEnabled(false);
        this.mRecyclerView.setHasFixedSize(true);
        this.mRecyclerView.setItemAnimator(null);
        this.mRecyclerView.setNestedScrollingEnabled(false);
        this.mRecyclerView.addItemDecoration(new RecyclerView.ItemDecoration(){
            int space = AssistSeatUtils.getItemSpace() / 2;

            public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                super.getItemOffsets(outRect, view, parent, state);
                outRect.left = this.space;
                outRect.right = this.space;
            }
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    public MultiTypeAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setOnLayoutChangeListener(View.OnLayoutChangeListener listener) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.addOnLayoutChangeListener(listener);
        }
    }

    public void setPresenter(SeatMvp.IPresenter presenter) {
    }

    public void stopSpeakingAnimation(int position) {
        RecyclerView.ViewHolder viewHolder;
        if (this.mRecyclerView != null && (viewHolder = this.mRecyclerView.findViewHolderForAdapterPosition(position)) instanceof AssistGameSeatItemHolder) {
            AssistGameSeatItemHolder seatItemHolder = (AssistGameSeatItemHolder)viewHolder;
            seatItemHolder.stopSpeakAnim();
        }
    }

    public void setVisibility(int visibility) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setVisibility(visibility);
        }
    }

    public int getVisibility() {
        if (this.mRecyclerView != null) {
            return this.mRecyclerView.getVisibility();
        }
        return 8;
    }

    public void updateSeats(List<SeatItem> seatItems) {
        if (this.mAdapter != null) {
            this.mAdapter.setItems(seatItems);
            this.mAdapter.notifyDataSetChanged();
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.requestLayout();
        }
    }

    public void updateSeat(int position, SeatItem data) {
        if (this.mAdapter != null) {
            this.mAdapter.notifyItemChanged(position);
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.requestLayout();
        }
    }

    public void startSpeakingAnimation(int position) {
        RecyclerView.ViewHolder viewHolder;
        if (this.mRecyclerView != null && (viewHolder = this.mRecyclerView.findViewHolderForAdapterPosition(position)) instanceof AssistGameSeatItemHolder) {
            AssistGameSeatItemHolder seatItemHolder = (AssistGameSeatItemHolder)viewHolder;
            seatItemHolder.startSpeakAnim();
        }
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        HashMap<Integer, Point> loctionMap = new HashMap<Integer, Point>();
        HashMap<Long, Point> realLoctionMap = new HashMap<Long, Point>();
        List from = this.mAdapter.getItems();
        if (this.mRecyclerView != null) {
            int i;
            int[] loction = new int[2];
            RecyclerView.LayoutManager manager = this.mRecyclerView.getLayoutManager();
            int size = manager.getChildCount();
            for (i = 0; i < size; ++i) {
                View child = manager.getChildAt(i);
                RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
                if (!(holder instanceof AssistGameSeatItemHolder) || ((AssistGameSeatItemHolder)holder).getData() == null) continue;
                CircleImageView avator = ((AssistGameSeatItemHolder)holder).getAvatar();
                ScreenWrapperUtils.INSTANCE.getViewPoint((View)avator, isAbsolute, loction);
                loctionMap.put(i, new Point(loction[0], loction[1]));
            }
            for (i = 0; i < from.size(); ++i) {
                SeatItem seatItem = (SeatItem)from.get(i);
                if (seatItem == null) continue;
                realLoctionMap.put(seatItem.uid, (Point)loctionMap.get(i));
            }
        }
        return realLoctionMap;
    }

    public View getRealSeatView() {
        return this.mRecyclerView;
    }

    public void destroy() {
        if (this.mRecyclerView != null && this.mRecyclerView.getChildCount() > 0) {
            int size = this.mRecyclerView.getChildCount();
            for (int i = 0; i < size; ++i) {
                View child = this.mRecyclerView.getChildAt(i);
                RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
                if (!(holder instanceof AssistGameSeatItemHolder)) continue;
                ((AssistGameSeatItemHolder)holder).destroy();
            }
        }
    }

    public int getSeatFaceSize() {
        return AssistSeatUtils.getAvatarSize();
    }

    public int[] getSeatViewPosition() {
        return new int[]{(int)this.mRecyclerView.getX(), (int)this.mRecyclerView.getY()};
    }

    @Nullable
    public View getItemView(int index) {
        return this.mRecyclerView.getChildAt(index);
    }
}

