/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share;

import android.content.Context;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share.GameImageSharePage;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share.ImageShareDataProvider;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share.ShareParam;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareDialogViewProvider;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.IShareTemplate;
import com.yy.hiyo.share.base.dataprovider.DataProgressListener;
import com.yy.hiyo.share.base.template.ImageShareTemplate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShareHelper
implements ISharePage,
GameImageSharePage.OnPlatformClickListener,
GameImageSharePage.OnSaveAlbumClickListener {
    private Context context;
    private IIntlShareService shareService;
    private DialogLinkManager dialogLinkManager;
    private GameImageSharePage gameImageSharePage;
    private ImageShareTemplate imageShareTemplate;
    private ImageShareDataProvider imageShareDataProvider;

    public ShareHelper(@NotNull Context context, @NotNull IIntlShareService shareService) {
        this.context = context;
        this.shareService = shareService;
        this.dialogLinkManager = new DialogLinkManager(context);
        this.imageShareTemplate = new ImageShareTemplate();
        this.imageShareDataProvider = new ImageShareDataProvider();
    }

    public void showShareDialog(GameInfo gameInfo, ShareParam param) {
        this.gameImageSharePage = new GameImageSharePage(this.context);
        List<BaseShareChannel> channelList = this.getShareChannels();
        this.gameImageSharePage.setData(channelList, gameInfo, param);
        this.gameImageSharePage.setPlatformClickListener(this);
        this.gameImageSharePage.setSaveAlbumClickListener(this);
        this.shareService.showShareCenterDialog((IShareDialogViewProvider)this.gameImageSharePage, null);
        this.imageShareDataProvider.setImageGenView(this.gameImageSharePage.getShareView());
    }

    private List<BaseShareChannel> getShareChannels() {
        if (this.shareService != null) {
            return this.shareService.getChannelsByPage((ISharePage)this);
        }
        return null;
    }

    public String getPageName() {
        return "voice_room_game_image_share";
    }

    @Override
    public void onPlatformClick(int channelId) {
        if (channelId == -1) {
            return;
        }
        if (this.shareService == null) {
            return;
        }
        if (!this.shareService.checkAppNeedInstalledOrToast(channelId)) {
            return;
        }
        this.checkDataBuildListener();
        this.imageShareDataProvider.waitDataReady(shareBundle -> {
            if (this.shareService != null) {
                this.shareService.share(channelId, shareBundle, (IShareTemplate)this.imageShareTemplate);
            }
        });
    }

    @Override
    public void onSaveAlbumClick() {
        this.checkDataBuildListener();
        this.imageShareDataProvider.waitDataReady(shareBundle -> YYTaskExecutor.execute(() -> {
            String imgPath = shareBundle.getImagePath();
            ViewImage.insertImgToAlbum((String)imgPath);
            YYTaskExecutor.postToMainThread(() -> ToastUtils.showToast((Context)this.context, (String)ResourceUtils.getString((int)R.string.saved_to_album_tips), (int)0));
        }));
    }

    private void checkDataBuildListener() {
        if (this.imageShareDataProvider.getDataBuildProgressListener() == null) {
            this.imageShareDataProvider.setDataBuildProgressListener(new DataProgressListener(){

                public void onStart() {
                    ShareHelper.this.dialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
                }

                public void onEnd() {
                    ShareHelper.this.dialogLinkManager.dismissDialog();
                }
            });
        }
    }
}

