/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share;

import android.graphics.Bitmap;
import android.view.View;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.dataprovider.DataCallback;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import java.io.File;

public class ImageShareDataProvider
extends ShareDataProvider {
    private static final String TAG = "ImageShareDataProvider";
    private static final String IMAGE_SAVE_NAME = "voice_room_game_share_image.jpg";
    private View imageGenView;

    public void setImageGenView(View imageGenView) {
        this.imageGenView = imageGenView;
        this.reset();
    }

    protected void buildImage(DataCallback<String> callback) {
        YYTaskExecutor.execute(() -> {
            if (this.imageGenView == null) {
                callback.onData(null);
                MLog.error((Object)TAG, (String)"imageGenView = null", (Object[])new Object[0]);
            } else {
                try {
                    Bitmap bmp = ViewImage.getViewBitmap((View)this.imageGenView, (Bitmap.Config)Bitmap.Config.RGB_565);
                    String dirPath = ((IIntlShareService)ServiceManagerProxy.getService(IIntlShareService.class)).getShareTmpDir();
                    String imgName = IMAGE_SAVE_NAME;
                    String expectPath = dirPath + File.separator + imgName;
                    if (YYFileUtils.isPathExist((String)expectPath)) {
                        YYFileUtils.removeFile((String)expectPath);
                    }
                    String imgPath = ViewImage.saveImgToLocal((Bitmap)bmp, (String)imgName, (String)dirPath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                    callback.onData((Object)imgPath);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)("build image error, " + e.getMessage()), (Object[])new Object[0]);
                    callback.onData(null);
                }
            }
        });
    }
}

