/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share.ShareParam;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IShareDialogViewProvider;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import java.util.List;

public class GameImageSharePage
extends YYLinearLayout
implements IShareDialogViewProvider,
View.OnClickListener {
    private static final String TAG = "GameImageSharePage";
    private LinearLayout llPlatformIconContainer;
    private RelativeLayout rlShareViewContainer;
    private RecycleImageView ivGameImage;
    private TextView tvUserName;
    private RecycleImageView ivUserAvatar;
    private TextView tvGameName;
    private OnPlatformClickListener platformClickListener;
    private OnSaveAlbumClickListener saveAlbumClickListener;

    public GameImageSharePage(Context context) {
        super(context);
        this.createView();
    }

    private void createView() {
        this.setBackgroundColor(-1);
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_game_share_page_view_channel, (ViewGroup)this);
        this.llPlatformIconContainer = (LinearLayout)this.findViewById(R.id.ll_share_platform);
        this.rlShareViewContainer = (RelativeLayout)this.findViewById(R.id.rl_share_view);
        this.ivGameImage = (RecycleImageView)this.findViewById(R.id.iv_game_image);
        this.ivUserAvatar = (RecycleImageView)this.findViewById(R.id.iv_user_avatar);
        this.tvUserName = (TextView)this.findViewById(R.id.tv_user_name);
        this.tvGameName = (TextView)this.findViewById(R.id.tv_game_name);
        FontUtils.setFontType((TextView)this.tvGameName, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
    }

    public View getContentView() {
        return this;
    }

    public View getShareImage() {
        return null;
    }

    public void setData(List<BaseShareChannel> channelList, GameInfo gameInfo, ShareParam param) {
        this.llPlatformIconContainer.removeAllViews();
        this.addShareIcon(R.id.share_save_album, R.drawable.ico_save_album);
        if (channelList != null) {
            if (channelList.size() > 3) {
                channelList = channelList.subList(0, 3);
            }
            for (BaseShareChannel channel : channelList) {
                int iconIdRes = 0;
                int iconDrawableRes = 0;
                switch (channel.getId()) {
                    case 5: {
                        iconDrawableRes = R.drawable.ico_share_facebook;
                        iconIdRes = R.id.share_platform_facebook;
                        break;
                    }
                    case 2: {
                        iconDrawableRes = R.drawable.ico_share_whatsapp;
                        iconIdRes = R.id.share_platform_whatsapp;
                        break;
                    }
                    case 3: {
                        iconDrawableRes = R.drawable.ico_share_ins;
                        iconIdRes = R.id.share_platform_instagram;
                        break;
                    }
                    case 1: {
                        iconDrawableRes = R.drawable.ico_share_line;
                        iconIdRes = R.id.share_platform_line;
                        break;
                    }
                    case 9: {
                        iconDrawableRes = R.drawable.ico_share_vk;
                        iconIdRes = R.id.share_platform_vk;
                        break;
                    }
                }
                if (iconIdRes <= 0) continue;
                this.addShareIcon(iconIdRes, iconDrawableRes);
            }
        }
        if (param != null && !FP.empty((CharSequence)param.imagePath)) {
            ImageLoader.loadImage((ImageView)this.ivGameImage, (String)param.imagePath);
        }
        if (gameInfo != null) {
            this.tvGameName.setText((CharSequence)gameInfo.getGname());
        }
        long authorUid = -1L;
        if (!FP.empty((CharSequence)param.uidString)) {
            try {
                authorUid = Long.parseLong(param.uidString);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("param parse uid error, " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (authorUid == 0L) {
            authorUid = AccountUtil.getUid();
        }
        if (authorUid > 0L) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(authorUid, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    if (userInfoKSList != null && userInfoKSList.size() > 0) {
                        UserInfoKS userInfoKS = userInfoKSList.get(0);
                        GameImageSharePage.this.tvUserName.setText((CharSequence)userInfoKS.nick);
                        String avatarUrl = userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75);
                        ImageLoader.loadImage((ImageView)GameImageSharePage.this.ivUserAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex));
                    }
                }

                public void onFail(int id2, String msg, String response) {
                }

                public int id() {
                    return 0;
                }
            });
        }
    }

    private void addShareIcon(int iconIdRes, int iconDrawableRes) {
        RecycleImageView ivIcon = new RecycleImageView(this.getContext());
        ivIcon.setId(iconIdRes);
        ivIcon.setImageDrawable(ResourceUtils.getDrawable((int)iconDrawableRes));
        ivIcon.setOnClickListener((View.OnClickListener)this);
        int iconSize = ResolutionUtils.dip2Px((float)36.0f);
        int horMargin = ResolutionUtils.dip2Px((float)10.0f);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(iconSize, iconSize);
        lp.leftMargin = horMargin;
        lp.rightMargin = horMargin;
        this.llPlatformIconContainer.addView((View)ivIcon, (ViewGroup.LayoutParams)lp);
    }

    public void setSaveAlbumClickListener(OnSaveAlbumClickListener saveAlbumClickListener) {
        this.saveAlbumClickListener = saveAlbumClickListener;
    }

    public void setPlatformClickListener(OnPlatformClickListener platformClickListener) {
        this.platformClickListener = platformClickListener;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.share_save_album) {
            if (this.saveAlbumClickListener != null) {
                this.saveAlbumClickListener.onSaveAlbumClick();
            }
        } else {
            int channelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
            if (channelId != -1 && this.platformClickListener != null) {
                this.platformClickListener.onPlatformClick(channelId);
            }
        }
    }

    public View getShareView() {
        return this.rlShareViewContainer;
    }

    public static interface OnSaveAlbumClickListener {
        public void onSaveAlbumClick();
    }

    public static interface OnPlatformClickListener {
        public void onPlatformClick(int var1);
    }
}

