/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game;

import android.content.Context;
import android.net.Uri;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.common.FacePoint;
import com.yy.hiyo.channel.component.music.musicplayer.MusicPlayerPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.IOperationStrategy;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.ILoadGameCallback;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.IRoomGameService;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IGameData;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.GamePlayPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.RoomGameContainer;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.RoomGameService;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.gold.RoomGameGold;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.GamePreparePresenter;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameAvatorLocationBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameMvp;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.mvp.base.AbsNotifyDispatchService;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.money.api.gamecoin.GameCoinNotify;
import org.json.JSONObject;

public class RoomGamePresenter
extends AbsPluginPresenter
implements INotifyDispatchService.INotifyHandler<ChannelNotify>,
LifecycleObserver,
IOperationStrategy {
    private static final String TAG = "RoomGamePresenter";
    private static final int MAX_GAME_RETRY_COUNT = 3;
    private int mGameErrorRetryCount = 0;
    private GameMvp.IPresenter mGamePresenter;
    private boolean selfExitGame = false;
    private RoomGameService mRoomGameService;
    private INotifyDispatchService.INotifyHandler<GameCoinNotify> mNotifyHandler;
    private MutableLiveData<List<GameAvatorLocationBean>> mLocationGameBeanList = new MutableLiveData();
    private MutableLiveData<Map<Long, FacePoint>> mLocationSeatList = new MutableLiveData();
    private boolean mGameReadyToRun;
    private RoomGameContainer roomGameContainer;
    private ISeatUpdateListener seatUpdateListener;
    private RoomGameGold mRoomGameGold = null;
    Observer<List<GameAvatorLocationBean>> mObserver = new Observer<List<GameAvatorLocationBean>>(){

        public void onChanged(@Nullable List<GameAvatorLocationBean> gameAvatorLocationBeans) {
            RoomGamePresenter.this.handleGameSeat(gameAvatorLocationBeans);
        }
    };
    private GameLifeWrapper gameLifecycle = new GameLifeWrapper(){

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow window) {
            super.onLoadGameFinish(context, finishType, window);
            if (finishType == 0) {
                RoomGamePresenter.this.isRunning.setValue((Object)true);
                if (this.isNotRoomGame(context.getGameInfo())) {
                    MLog.error((Object)RoomGamePresenter.TAG, (String)"onLoadGameFinish is not room game", (Object[])new Object[0]);
                    return;
                }
                RoomGamePresenter.this.mGameErrorRetryCount = 0;
                RoomGamePresenter.this.selfExitGame = false;
            }
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            Callback callback;
            if (RoomGamePresenter.this.isDestroyed()) {
                return;
            }
            RoomGamePresenter.this.isRunning.setValue((Object)false);
            super.onGameExited(context, gameExitType);
            if (this.isNotRoomGame(context.getGameInfo())) {
                MLog.error((Object)RoomGamePresenter.TAG, (String)"onGameExited is not room game", (Object[])new Object[0]);
                return;
            }
            boolean isInChessGame = RoomGamePresenter.this.getRoomData().isInChessGame();
            MLog.info((Object)RoomGamePresenter.TAG, (String)"onGameExited context %s, type %s, isDestroyed %b, selfExitGame:%b, isInChessGame:%b", (Object[])new Object[]{context, gameExitType, RoomGamePresenter.this.isDestroyed(), RoomGamePresenter.this.selfExitGame, isInChessGame});
            RoomGamePresenter.this.setSeatViewVisibility(true);
            if (!RoomGamePresenter.this.selfExitGame) {
                if (gameExitType == 13 && RoomGamePresenter.this.getRoomData().getGameInfo().isStarted()) {
                    MLog.info((Object)RoomGamePresenter.TAG, (String)"onGameExited \u6062\u590d\u6e38\u620f, mGameErrorRetryCount %s", (Object[])new Object[]{RoomGamePresenter.this.mGameErrorRetryCount});
                    RoomGamePresenter.this.mGameErrorRetryCount++;
                    if (RoomGamePresenter.this.mGameErrorRetryCount <= 3) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (RoomGamePresenter.this.isDestroyed()) {
                                    return;
                                }
                                RoomGamePresenter.this.loadGame();
                            }
                        }, (long)1000L);
                    } else {
                        MLog.error((Object)RoomGamePresenter.TAG, (String)"onGameExited \u6062\u590d\u6e38\u620f \u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570", (Object[])new Object[0]);
                        ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_FAIL");
                        RoomGamePresenter.this.resumeStateAfterExit();
                    }
                } else {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)RoomGamePresenter.TAG, (String)"onGameExited isGaming %b, getRoomData().getGameInfo().isStarted() %b, getRoomData %s", (Object[])new Object[]{((GamePlayPresenter)RoomGamePresenter.this.getPresenter(GamePlayPresenter.class)).isGaming(), RoomGamePresenter.this.getRoomData().getGameInfo().isStarted(), RoomGamePresenter.this.getRoomData()});
                    }
                    if (!RoomGamePresenter.this.getRoomData().isInChessGame() && !RoomGamePresenter.this.getRoomData().isInAssistGame()) {
                        ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_PREPARE");
                        RoomGamePresenter.this.setGameContainerVisibility(false);
                        ((SeatPresenter)RoomGamePresenter.this.getPresenter(SeatPresenter.class)).refreshSeat();
                        if (RoomGamePresenter.this.getRoomData().isPlayManager(AccountUtil.getUid())) {
                            RoomGamePresenter.this.getChannel().getPluginService().ready(true, null);
                        }
                    }
                }
            }
            if ((callback = RoomGamePresenter.this.mCurExtCallback) != null) {
                callback.onResponse((Object)true);
            }
            RoomGamePresenter.this.mCurExtCallback = null;
        }

        private boolean isNotRoomGame(GameInfo gameInfo) {
            return gameInfo == null || gameInfo.getGameMode() != 8;
        }
    };
    private Callback<Boolean> mCurExtCallback = null;
    private IPageLifeCycle mPageLifeCycle = new IPageLifeCycle(){

        public void onDetach() {
            MLog.info((Object)RoomGamePresenter.TAG, (String)"onDetach", (Object[])new Object[0]);
            RoomGamePresenter.this.exitGame(null);
        }

        public void preDestroy() {
        }

        public void onPreMinimize() {
            MLog.info((Object)RoomGamePresenter.TAG, (String)"onPreMinimize", (Object[])new Object[0]);
        }
    };

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.isRunning.setValue((Object)false);
        this.mRoomGameService = new RoomGameService(this.getChannel().getPluginService());
        this.mRoomGameService.onInit(this.getRoomData(), (AbsNotifyDispatchService<ChannelNotify>)this.getNotifyDispatcher());
        this.getNotifyDispatcher().addHandler((INotifyDispatchService.INotifyHandler)this);
        this.initGamePresenter();
        this.initPreparePresenter();
    }

    public void handleModeChange(long mode) {
        super.handleModeChange(mode);
        MLog.info((Object)TAG, (String)"handleModeChange %d", (Object[])new Object[]{mode});
        ((MusicPlayerPresenter)this.getPresenter(MusicPlayerPresenter.class)).stopMusic(false);
        this.setSeatViewVisibility(true);
        if (this.getRoomData().isInChessGame()) {
            MLog.info((Object)TAG, (String)"switch to chess game", (Object[])new Object[0]);
            this.mRoomGameGold = new RoomGameGold(this);
        } else if (this.mRoomGameGold != null) {
            this.mRoomGameGold.destroy();
            this.mRoomGameGold = null;
        }
        this.loadGame();
    }

    public void reLoadGame() {
        super.reLoadGame();
        this.loadGame();
    }

    public void handleGameStateChange(boolean started) {
        super.handleGameStateChange(started);
        if (started) {
            this.loadGame();
        }
    }

    public void resumePlugin() {
        super.resumePlugin();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RoomGamePresenter.this.loadGame();
            }
        }, (long)100L);
    }

    public boolean interceptModeChange() {
        IGameCenterService gameCenterService = (IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class);
        if (gameCenterService.isPlaying()) {
            GameInfo gameInfo = gameCenterService.getCurPlayingGame();
            return gameInfo == null || !gameInfo.isRoomCheesGame();
        }
        return false;
    }

    @CallSuper
    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (this.mGameReadyToRun) {
            this.loadGame();
            this.mGameReadyToRun = false;
        }
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(this.mPageLifeCycle);
    }

    public void loadGame() {
        if (this.isDestroyed()) {
            return;
        }
        MLog.info((Object)TAG, (String)"loadGame isGamePlaying %b", (Object[])new Object[]{((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying()});
        if (((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
            MLog.warn((Object)TAG, (String)"loadGame \u6e38\u620f\u5df2\u7ecf\u5f00\u59cb\uff0c\u76f4\u63a5\u8fd4\u56de", (Object[])new Object[0]);
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_FAIL");
            this.setGameContainerVisibility(false);
            return;
        }
        Pair state = (Pair)((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).prepareState().getValue();
        MLog.debug((Object)TAG, (String)"loadGame prepareState %s", (Object[])new Object[]{state});
        if (state == null || "FAIL".equals(state.second) || "INIT".equals(state.second)) {
            ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_LOADING");
        }
        this.getRoomGameService().loadGame(this.getRoomData().getGameInfo().getPluginId(), new ILoadGameCallback(){
            int progress = 0;

            public void onDownloadGameStart(@NonNull GameInfo info) {
                if (RoomGamePresenter.this.isDestroyed()) {
                    return;
                }
                ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).setGameProgress(this.progress);
            }

            public void onDownloadProgress(@NonNull GameInfo info, long total, long current) {
                if (RoomGamePresenter.this.isDestroyed()) {
                    return;
                }
                int temp = (int)(1.0f * (float)current / (float)total * 100.0f);
                if (this.progress != temp) {
                    this.progress = temp;
                    MLog.debug((Object)RoomGamePresenter.TAG, (String)"onDownloadProgress %d", (Object[])new Object[]{this.progress});
                    ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).setGameProgress(this.progress);
                }
            }

            public void onFinished(@Nullable GameInfo info, int code, String msg) {
                MLog.info((Object)RoomGamePresenter.TAG, (String)"loadGame onFinished code=%s, GameInfo=%s", (Object[])new Object[]{code, info});
                if (RoomGamePresenter.this.isDestroyed()) {
                    return;
                }
                if (code == 2 || code == 3) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.short_tips_game_not_compat), (int)0);
                    ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_NOT_SUPPORT");
                } else if (code == 4 || code == 100 || code == 5) {
                    ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAME_FAIL");
                } else if (code == 1 && info != null && !FP.empty((CharSequence)info.gid)) {
                    boolean isChessGame = RoomGamePresenter.this.getRoomData().isInChessGame();
                    boolean isAssistGame = RoomGamePresenter.this.getRoomData().isInAssistGame();
                    if (info.gid.equals(RoomGamePresenter.this.getRoomData().getGameInfo().getPluginId())) {
                        MLog.info((Object)RoomGamePresenter.TAG, (String)"loadGame onFinished  isStarted: %s setGameStartUI %s ", (Object[])new Object[]{RoomGamePresenter.this.getRoomData().getRoomGame().isStarted(), RoomGamePresenter.this.getRoomData().getGameInfo()});
                        this.progress = 100;
                        ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).setGameProgress(this.progress);
                        if (RoomGamePresenter.this.getRoomData().getRoomGame().isStarted()) {
                            if (!RoomGamePresenter.this.isViewAttached()) {
                                MLog.error((Object)RoomGamePresenter.TAG, (String)"loadGame return!!!, view is not attach!!!", (Object[])new Object[0]);
                                RoomGamePresenter.this.mGameReadyToRun = true;
                                return;
                            }
                            ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAMING");
                            RoomGamePresenter.this.setGameContainerVisibility(true);
                            if (!isChessGame && !isAssistGame) {
                                RoomGamePresenter.this.setSeatViewVisibility(false);
                            }
                            if (RoomGamePresenter.this.mRoomGameGold != null) {
                                RoomGamePresenter.this.mRoomGameGold.queryJoinCoin();
                            }
                            RoomGamePresenter.this.startGame(RoomGamePresenter.this.getGameContainer().getGamingContainer());
                        } else {
                            String seatMode = isChessGame ? "GAMING" : "GAME_PREPARE";
                            ((GamePreparePresenter)RoomGamePresenter.this.getPresenter(GamePreparePresenter.class)).onGameStateChanged(seatMode);
                            RoomGamePresenter.this.setGameContainerVisibility(false);
                            ((SeatPresenter)RoomGamePresenter.this.getPresenter(SeatPresenter.class)).refreshSeat();
                            if (isChessGame || isAssistGame) {
                                Uri extra;
                                String uid = (String)RoomGamePresenter.this.getRoomData().getGameInfo().getExt("plugin_launcher", (Object)"0");
                                MLog.error((Object)RoomGamePresenter.TAG, (String)"uid from client:%s", (Object[])new Object[]{uid});
                                if (FP.eq((Object)uid, (Object)"0")) {
                                    String extJson = (String)RoomGamePresenter.this.getRoomData().getGameInfo().getExt("extString", (Object)"");
                                    MLog.error((Object)RoomGamePresenter.TAG, (String)"uid from ext:%s", (Object[])new Object[]{extJson});
                                    if (!FP.empty((CharSequence)extJson)) {
                                        try {
                                            JSONObject json = JsonParser.obtainJSONObject((String)extJson);
                                            uid = json.optString("plugin_launcher", "0");
                                        }
                                        catch (Exception e) {
                                            MLog.error((Object)RoomGamePresenter.TAG, (Throwable)e);
                                        }
                                    }
                                }
                                if (FP.eq((Object)uid, (Object)"0") && (extra = (Uri)((IChannelPageContext)RoomGamePresenter.this.getMvpContext()).getEnterChannelParams().getExtra("deep_link", null)) != null) {
                                    String queryParameter = extra.getQueryParameter("plugin_launcher");
                                    MLog.error((Object)RoomGamePresenter.TAG, (String)"uid from deeplink:%s", (Object[])new Object[]{queryParameter});
                                    if (StringUtils.isNotEmpty((String)queryParameter)) {
                                        uid = queryParameter;
                                    }
                                }
                                MLog.info((Object)RoomGamePresenter.TAG, (String)"loadGame onFinished isChessGame: %s isAssistGame %s  uid: %s, hash:%s", (Object[])new Object[]{isChessGame, isAssistGame, uid, RoomGamePresenter.this.getRoomData().getGameInfo().hashCode()});
                                if (AccountUtil.getUid() > 0L && StringUtils.equals((String)uid, (String)(AccountUtil.getUid() + ""))) {
                                    MLog.info((Object)RoomGamePresenter.TAG, (String)"need auto start!! isChess: %s  uid: %s", (Object[])new Object[]{isChessGame, uid});
                                    ((RoomGamePresenter)RoomGamePresenter.this.getPresenter(RoomGamePresenter.class)).getRoomGameService().startPlay((Callback)WeakCallback.of((IDestroyable)RoomGamePresenter.this, data -> MLog.info((Object)RoomGamePresenter.TAG, (String)"startPlay onResponse %b", (Object[])new Object[]{data})));
                                }
                            } else {
                                boolean isPlayManager = RoomGamePresenter.this.getRoomData().isPlayManager(AccountUtil.getUid());
                                if (isPlayManager && !RoomGamePresenter.this.getChannel().getSeatService().isMeReady()) {
                                    RoomGamePresenter.this.getChannel().getPluginService().ready(true, null);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    private void initGamePresenter() {
        if (this.mGamePresenter == null) {
            this.mGamePresenter = (GameMvp.IPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(GamePlayPresenter.class);
        }
        this.mGamePresenter.registerGameLifecycle((IGameLifecycle)this.gameLifecycle);
        if (this.getRoomData().isInAssistGame()) {
            // empty if block
        }
        this.mLocationGameBeanList = this.mGamePresenter.getSeatLocationBeanList();
        this.mLocationGameBeanList.observe((LifecycleOwner)this.getLifeCycleOwner(), this.mObserver);
        this.seatUpdateListener = seatUserList -> {
            ISeatService seatService = this.getChannel().getSeatService();
            boolean inFirstSeat = this.getChannel().getSeatService().isInFirstSeat(AccountUtil.getUid());
            if (inFirstSeat && !seatService.isMeReady() && !this.getRoomData().isInChessGame() && !this.getRoomData().isInAssistGame()) {
                this.getChannel().getPluginService().ready(true, null);
            }
        };
        this.getChannel().getSeatService().addSeatUpdateListener(this.seatUpdateListener);
    }

    private void initPreparePresenter() {
        ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).setRoomGameService((IRoomGameService)this.mRoomGameService);
        ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).setOnUiCallback(new SeatMvp.IGamePresenter.OnUiCallback(){

            public void showGameRule(GameInfo gameInfo) {
                if (RoomGamePresenter.this.mGamePresenter != null) {
                    if (gameInfo.isRoomCheesGame()) {
                        RoomGamePresenter.this.mGamePresenter.showGameRuleViewPage(gameInfo);
                    } else {
                        RoomGamePresenter.this.mGamePresenter.showGameRule(gameInfo);
                    }
                }
            }
        });
    }

    public void onDestroy() {
        if (this.mGamePresenter != null && this.gameLifecycle != null) {
            this.mGamePresenter.unRegisterGameLifecycle((IGameLifecycle)this.gameLifecycle);
        }
        if (this.roomGameContainer != null) {
            this.roomGameContainer.destroy();
        }
        this.mCurExtCallback = null;
        this.getRoomGameService().onDestroy();
        this.exitGame(null);
        if (this.mRoomGameGold != null) {
            this.mRoomGameGold.destroy();
            this.mRoomGameGold = null;
        }
        this.getNotifyDispatcher().removeHandler((INotifyDispatchService.INotifyHandler)this);
        this.getChannel().getSeatService().removeSeatUpdateListener(this.seatUpdateListener);
        super.onDestroy();
    }

    protected void startGame(YYFrameLayout gameContainer) {
        MLog.info((Object)TAG, (String)"startGame isGaming %b", (Object[])new Object[]{this.mGamePresenter.isGaming()});
        if (!this.mGamePresenter.isGaming()) {
            ChannelPluginData roomGameInfo = this.getRoomData().getGameInfo();
            String roomId = this.getRoomData().getRoomId();
            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameInfoByGid(roomGameInfo.getPluginId());
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"startGame RoomGameInfo %s, GameInfo %s", (Object[])new Object[]{roomGameInfo, gameInfo});
            }
            ConstraintSet set = new ConstraintSet();
            RoomGameContainer parent = this.getGameContainer();
            set.clone((ConstraintLayout)parent);
            String gameId = this.getRoomData().getGameInfo().getPluginId();
            boolean isChessGame = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getVoiceRoomGameInfoByGid(gameId).isRoomCheesGame();
            if (isChessGame) {
                set.setDimensionRatio(R.id.gaming_container, "H,24:15");
            } else if (this.getRoomData().isInAssistGame()) {
                int width = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext);
                set.constrainHeight(R.id.gaming_container, width - 2 * ResolutionUtils.dip2Px((float)10.0f));
                set.constrainWidth(R.id.gaming_container, width);
            } else {
                set.setDimensionRatio(R.id.gaming_container, "W,1:1");
            }
            set.applyTo((ConstraintLayout)parent);
            if (!isChessGame && !this.getRoomData().isInAssistGame()) {
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)gameContainer.getLayoutParams();
                params.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
                params.rightMargin = ResolutionUtils.dip2Px((float)10.0f);
                gameContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            this.mGamePresenter.startGame(gameContainer, gameInfo, roomId, roomGameInfo.getJoinCtx(), "ChannelWindow");
            if (this.getMvpContext() != null && ((IChannelPageContext)this.getMvpContext()).getContext() != null) {
                Window window = ((IChannelPageContext)this.getMvpContext()).getContext().getWindow();
                window.clearFlags(131072);
                window.setSoftInputMode(4);
            }
        }
    }

    public void exitGame(Callback<Boolean> callback) {
        if (this.mGamePresenter != null && this.mGamePresenter.isGaming()) {
            this.selfExitGame = true;
            this.mCurExtCallback = callback;
            this.mGamePresenter.exitGame(null);
        } else {
            this.mCurExtCallback = null;
            if (callback != null) {
                callback.onResponse((Object)true);
            }
        }
    }

    public IRoomGameService getRoomGameService() {
        return this.mRoomGameService;
    }

    private FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    public void onHandleNotify(ChannelNotify notify2) {
        if (notify2 == null || notify2.notify == null) {
            return;
        }
        if (notify2.uri == ChannelNotify.Uri.UriPluginFinishNotify) {
            this.handleGameFinish(notify2.notify.finish);
        }
    }

    private void handleGameFinish(NotifyDataDefine.GameFinishNotify notify2) {
        MLog.info((Object)TAG, (String)"handleGameFinish %s", (Object[])new Object[]{notify2});
        this.getRoomData().getRoomGame().update(false, "", "");
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onPageResume() {
        MLog.info((Object)TAG, (String)"onPageResume", (Object[])new Object[0]);
        if (!((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
            this.loadGame();
        }
    }

    public IPlugin.InterceptPluginChange canBeRemoveWhileRunning(@Nullable GameInfo cur, @Nullable GameInfo next) {
        IPlugin.InterceptPluginChange intercept = new IPlugin.InterceptPluginChange();
        intercept.canChange = null != cur && cur.getSubGameMode() == 2 ? true : !((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying();
        return intercept;
    }

    public boolean canChangeSeat() {
        return 100 == this.getChannel().getPluginService().getCurPluginData().mode || !((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying();
    }

    public boolean haveSelfFaceLocation() {
        return true;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return this.mLocationSeatList;
    }

    public boolean interceptRunningState() {
        return true;
    }

    private void handleGameSeat(List<GameAvatorLocationBean> gameAvatorLocationBeans) {
        if (gameAvatorLocationBeans != null) {
            HashMap<Long, FacePoint> map = new HashMap<Long, FacePoint>();
            for (GameAvatorLocationBean gameAvatorLocationBean : gameAvatorLocationBeans) {
                int[] location = new int[]{gameAvatorLocationBean.getPointx(), gameAvatorLocationBean.getPointy()};
                MLog.info((Object)TAG, (String)("gameX:" + location[0] + " gameY: " + location[1]), (Object[])new Object[0]);
                CocoViewBean cocoViewBean = ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).genGameViewDataInApp(location, gameAvatorLocationBean.getWidth(), gameAvatorLocationBean.getHeight());
                FacePoint point = new FacePoint();
                point.set(cocoViewBean.getLocation()[0] + gameAvatorLocationBean.getWidth() / 2, cocoViewBean.getLocation()[1] + gameAvatorLocationBean.getHeight() / 2);
                point.setWidth(gameAvatorLocationBean.getWidth());
                point.setHeight(gameAvatorLocationBean.getHeight());
                point.setType(1);
                map.put(gameAvatorLocationBean.getUid(), point);
                MLog.info((Object)TAG, (String)("realGameX:" + point.x + " realGameY: " + point.y), (Object[])new Object[0]);
                this.mLocationSeatList.setValue(map);
            }
        }
    }

    public boolean needAutoSendReady(@NonNull GameInfo info) {
        return "micup".equals(info.gid) || ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).isGameValid(info);
    }

    public boolean canOpSeat() {
        return !this.mGamePresenter.isGaming();
    }

    public boolean canOpMic() {
        return true;
    }

    public boolean canOpVideo() {
        return false;
    }

    public void setContainer(@NonNull View container) {
        super.setContainer(container);
        if (!(container instanceof YYPlaceHolderView)) {
            return;
        }
        this.roomGameContainer = this.getGameContainer();
        ((YYPlaceHolderView)container).inflate((View)this.roomGameContainer);
        this.roomGameContainer.setPresenter((IGameData)this);
        this.getGameContainer().setPreparePresenter((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class));
    }

    protected RoomGameContainer getGameContainer() {
        if (this.roomGameContainer == null) {
            this.roomGameContainer = new RoomGameContainer((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        }
        return this.roomGameContainer;
    }

    public boolean isCompatible() {
        return this.mRoomGameService.isSupportGame();
    }
}

