/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game;

import android.app.Dialog;
import android.content.Context;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import biz.CInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.web.IWebPageCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.MediaData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.callback.IChannelInfoCallBack;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.component.dragbar.assistgame.AssistGamePublicScreenBgPresenter;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityListPresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.plugins.game.R;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.IGamePlayPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.AssistGamePresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.base.GameRole;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.base.GameRoleInt;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.assistgame.operation.GameOperationPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.GameInnerStatus;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.IGamePlayStatusListener;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.NotifyGameInnerStatusHandler;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide.GameGuideHandler;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.guide.GameGuideUiCallbacks;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.handler.GameComponentHandler;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.handler.NotifyGameHandler;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.model.ChannelConfig;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.model.GamePubScreenData;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share.ShareHelper;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.share.ShareParam;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameAvatorLocationBean;
import com.yy.hiyo.game.base.GameComponentLocationBean;
import com.yy.hiyo.game.base.GameGoldChangeBean;
import com.yy.hiyo.game.base.RoomUserInfo;
import com.yy.hiyo.game.base.VoiceRoomData;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameShowUrlData;
import com.yy.hiyo.game.base.config.GameCommonConfig;
import com.yy.hiyo.game.base.config.GameCommonConfigData;
import com.yy.hiyo.game.base.gamemode.GameMvp;
import com.yy.hiyo.game.base.gamemode.GameRule;
import com.yy.hiyo.game.base.module.jscallappmodule.IComGameCallAppCallBack;
import com.yy.hiyo.game.base.widget.GameWebPanel;
import com.yy.hiyo.game.base.wrapper.ComponentGameWrapper;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.callback.IRoomGameBridge;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ihago.room.srv.follow.EPath;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GamePlayPresenter
extends IGamePlayPresenter
implements GameMvp.IPresenter,
NotifyGameHandler.INotifGameCallBack,
ISeatUpdateListener {
    private static final String TAG = "FTVoiceRoom Game GamePlayPresenter";
    private ComponentGameWrapper gameWrapper;
    private ShareHelper mShareHelper;
    private NotifyGameHandler mNotifyGameHandler = new NotifyGameHandler(this);
    private GameComponentHandler mGameConpomentHandler = new GameComponentHandler();
    private IQueueTaskExecutor mQueueExecutor = YYTaskExecutor.createAQueueExcuter();
    private MutableLiveData<List<GameAvatorLocationBean>> mLocationBeanList = new MutableLiveData();
    private IRoleService.IMemberOrMasterChangeListener mMemberOrMasterChangeListener;
    private boolean isPlayManager = false;
    private GameInfo mPlayingGameInfo;
    private GameInnerStatus mGameInnerStatus = new GameInnerStatus();
    private NotifyGameInnerStatusHandler mNotifyGameInnerStatusHandler = new NotifyGameInnerStatusHandler();
    private IRoomGameBridge roomGameBridge = new IRoomGameBridge(){

        public void openUserCard(long uid) {
            ((ProfileCardPresenter)GamePlayPresenter.this.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, OpenProfileFrom.FROM_OTHER);
        }

        public void micListStatusQuery(String json, IComGameCallAppCallBack callback) {
            List retDatas = GamePlayPresenter.this.getMicStatusBeans();
            GamePlayPresenter.this.onMicListStatusCallback(retDatas, callback);
        }

        public void showGameRule(String json) {
            FeatureLog.i((String)"FTVoiceRoom", (String)"show game rule,json:%s", (Object[])new Object[]{json});
            if (!StringUtils.isEmpty((String)json)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)json);
                    String gameId = jsonObject.optString("gameId");
                    if (!StringUtils.isEmpty((String)gameId)) {
                        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                        GamePlayPresenter.this.showGameRule(gameInfo);
                    }
                    String roomId = GamePlayPresenter.this.getChannelId();
                    RoomTrack.INSTANCE.reportGameRuleBtnClick(roomId);
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                }
            }
        }

        public void playerHasLeftGame() {
            FeatureLog.i((String)"FTVoiceRoom", (String)"playerHasLeftGame", (Object[])new Object[0]);
            if (GamePlayPresenter.this.gameWrapper != null) {
                GamePlayPresenter.this.gameWrapper.setUserHasLeftGame();
            }
        }

        public void postGameUserAvatorView(String json) {
            GamePlayPresenter.this.onGameUserAvatorChanged(json);
        }

        public void showShareView(GameInfo gameInfo, String param) {
            FeatureLog.i((String)"FTVoiceRoom", (String)("open image share dialog, param:" + param), (Object[])new Object[0]);
            YYTaskExecutor.execute(() -> {
                ShareParam shareParam = (ShareParam)JsonParser.parseJsonObject((String)param, ShareParam.class);
                YYTaskExecutor.postToMainThread(() -> {
                    if (GamePlayPresenter.this.mShareHelper != null) {
                        GamePlayPresenter.this.mShareHelper.showShareDialog(gameInfo, shareParam);
                    }
                });
            });
        }

        public void sendPublicScreen(String param) {
            FeatureLog.i((String)"FTVoiceRoom", (String)("send msg to public screen, param:" + param), (Object[])new Object[0]);
            YYTaskExecutor.execute(() -> {
                if (GamePlayPresenter.this.isDestroyed()) {
                    return;
                }
                GamePubScreenData gamePubScreenData = (GamePubScreenData)JsonParser.parseJsonObject((String)param, GamePubScreenData.class);
                YYTaskExecutor.postToMainThread(() -> {
                    IPublicScreenModulePresenter publicScreenPresenter = (IPublicScreenModulePresenter)GamePlayPresenter.this.getPresenter(IPublicScreenModulePresenter.class);
                    if (publicScreenPresenter.getPublicScreenPresenter() == null || gamePubScreenData == null) {
                        return;
                    }
                    PureTextMsg baseImMsg = null;
                    baseImMsg = gamePubScreenData.uid == 0L ? ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(GamePlayPresenter.this.getChannel().getChannelId(), (CharSequence)gamePubScreenData.content, 0, 0L) : ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(GamePlayPresenter.this.getChannel().getChannelId(), (CharSequence)gamePubScreenData.content, GamePlayPresenter.this.getChannel().getRoleService().getRoleCache(gamePubScreenData.uid), gamePubScreenData.uid);
                    baseImMsg.setMsgState(1);
                    publicScreenPresenter.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)baseImMsg);
                });
            });
        }

        public void showPanelWeb(String param) {
            String[] url = new String[1];
            YYTaskExecutor.execute(() -> {
                url[0] = ((GameShowUrlData)JsonParser.parseJsonObject((String)param, GameShowUrlData.class)).getUrl();
            }, () -> GamePlayPresenter.this.showPanelWebInner(url[0]));
        }

        public void showGiftPanel() {
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            ((IRevenueToolsModulePresenter)((IChannelPageContext)GamePlayPresenter.this.getMvpContext()).getPresenter(IRevenueToolsModulePresenter.class)).openGiftPanel(9);
        }

        public void onConpomentLoactionChange(String param) {
            GameComponentLocationBean[] bean = new GameComponentLocationBean[1];
            YYTaskExecutor.execute(() -> {
                try {
                    bean[0] = (GameComponentLocationBean)JsonParser.parseJsonObject((String)param, GameComponentLocationBean.class);
                }
                catch (Exception e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                }
            }, () -> {
                if (bean[0] != null) {
                    GamePlayPresenter.this.mGameConpomentHandler.onConpomentLocationChange(bean[0].getConpomentName(), bean[0]);
                }
            });
        }

        public void showGameRuleList(String json) {
            FeatureLog.i((String)"FTVoiceRoom", (String)"show game showGameRuleList,json:%s", (Object[])new Object[]{json});
            if (!StringUtils.isEmpty((String)json)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)json);
                    String gameId = jsonObject.optString("gameId");
                    if (!StringUtils.isEmpty((String)gameId)) {
                        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                        GamePlayPresenter.this.showGameRuleViewPage(gameInfo);
                    }
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                }
            }
        }

        public void getRoomUserInfo(String param, IComGameCallAppCallBack callback) {
            RoomUserInfo roomUserInfo = new RoomUserInfo();
            roomUserInfo.setUid(AccountUtil.getUid());
            roomUserInfo.setOwner(GamePlayPresenter.this.getChannel().getOwnerUid() == AccountUtil.getUid());
            roomUserInfo.setCanControlGame(GamePlayPresenter.this.isPlayManager(AccountUtil.getUid()));
            callback.callGame((Object)roomUserInfo);
        }

        public void getVoiceRoomData(String param, IComGameCallAppCallBack callback) {
            VoiceRoomData voiceRoomData = new VoiceRoomData();
            voiceRoomData.setOwnerId(GamePlayPresenter.this.getChannel().getOwnerUid());
            voiceRoomData.setRoomId(GamePlayPresenter.this.getChannelId());
            voiceRoomData.setvId(GamePlayPresenter.this.getChannelDetailInfo().baseInfo.cvid);
            voiceRoomData.setRoomName(GamePlayPresenter.this.getChannelName());
            callback.callGame((Object)voiceRoomData);
        }

        public void operateRoomSelfMic(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"operateRoomSelfMic param", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (!FP.empty((CharSequence)param)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                    boolean open = jsonObject.getBoolean("open");
                    ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).operateRoomSelfMic(open);
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"operateRoomSelfMic json ex: %s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }

        public void notifyAssistGameState(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameState param: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (!FP.empty((CharSequence)param)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                    int state = jsonObject.getInt("state");
                    ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).updateAssistState(state);
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameState json ex: %s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }

        public void notifyAssistMember(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyAssistMember param: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (!FP.empty((CharSequence)param)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                    boolean isAdd = jsonObject.getBoolean("isAdd");
                    JSONArray jsonArray = jsonObject.getJSONArray("uids");
                    ArrayList<Long> uidLst = new ArrayList<Long>(jsonArray.length());
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        long uid = jsonArray.getLong(i);
                        uidLst.add(uid);
                    }
                    ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).updateAssistUidList(isAdd, uidLst);
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameState json ex: %s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }

        public void changeGameContainerViewSize(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"changeGameContainerViewSize param: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (!FP.empty((CharSequence)param)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                    boolean fullSize = jsonObject.getBoolean("fullSize");
                    ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).changeGameContainerViewSize(fullSize);
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"changeGameContainerViewSize json ex: %s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }

        public void notifyAssistGameStateAndMemberList(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameStateAndMemberList param: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (!FP.empty((CharSequence)param)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                    int state = jsonObject.getInt("state");
                    JSONArray jsonArray = jsonObject.getJSONArray("uids");
                    ArrayList<Long> uidLst = new ArrayList<Long>(jsonArray.length());
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        long uid = jsonArray.getLong(i);
                        uidLst.add(uid);
                    }
                    ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).notifyAssistGameStateAndMemberList(state, uidLst);
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameStateAndMemberList json ex: %s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }

        public void getRoomViewParams(String param, IComGameCallAppCallBack callback) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"getRoomViewParams param: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).getRoomViewParams(param, callback);
        }

        public void queryChannelInfoById(String param, final IComGameCallAppCallBack callback) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"queryChannelInfoById param: %s", (Object[])new Object[]{param});
            if (!FP.empty((CharSequence)param)) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                    JSONArray jsonArray = jsonObject.getJSONArray("channelIds");
                    HashSet<String> channelList = new HashSet<String>(jsonArray.length());
                    int length = jsonArray.length();
                    for (int i = 0; i < length; ++i) {
                        String id2 = jsonArray.getString(i);
                        channelList.add(id2);
                    }
                    ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).queryChannelInfoById(channelList, new IChannelInfoCallBack(){

                        public void onGetChannelInfoList(List<CInfo> channelList) {
                            if (FP.empty(channelList)) {
                                GamePlayPresenter.this.sendMsgtoGame(CocosProxyType.queryRoomInfoByChannelIdCallback, Collections.EMPTY_LIST);
                                return;
                            }
                            ArrayList<VoiceRoomData> dataList = new ArrayList<VoiceRoomData>(channelList.size());
                            int size = channelList.size();
                            for (int i = 0; i < size; ++i) {
                                CInfo info = channelList.get(i);
                                if (info == null || FP.empty((CharSequence)info.cid)) continue;
                                VoiceRoomData data = new VoiceRoomData();
                                data.setOwnerId(info.owner.longValue());
                                data.setRoomId(info.cid);
                                data.setRoomName(info.name);
                                data.setvId(info.ccute_info == null ? "" : info.ccute_info.vcid);
                                dataList.add(data);
                            }
                            callback.callGame(dataList);
                        }

                        public void onFailed(String msg) {
                            callback.callGame((Object)Collections.EMPTY_LIST);
                        }
                    });
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameStateAndMemberList json ex: %s", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }

        public void notifyAssistGameResult(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameResult param: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (FP.empty((CharSequence)param)) {
                MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameResult param null", (Object[])new Object[0]);
                return;
            }
            try {
                JSONObject obj = JsonParser.obtainJSONObject((String)param);
                GameRole role = GameRoleInt.gameRole(obj.getInt("role"));
                boolean result = obj.getBoolean("result");
                ((AssistGamePresenter)GamePlayPresenter.this.getPresenter(AssistGamePresenter.class)).notifyAssistGameResult(role, result);
            }
            catch (JSONException e) {
                MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyAssistGameResult json ex: %s", (Object[])new Object[]{e});
            }
        }

        public void operateAppSeat(String param, IComGameCallAppCallBack callback) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"operateAppSeat json: %s", (Object[])new Object[]{param});
            if (StringUtils.isEmpty((String)param) || GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            ISeatService seatService = ((IChannelPageContext)GamePlayPresenter.this.getMvpContext()).getChannel().getSeatService();
            if (null == seatService) {
                return;
            }
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                boolean joinSeat = jo.getBoolean("operateAppSeat");
                if (joinSeat) {
                    seatService.sitDown(-1, data -> {
                        boolean isSuccess = false;
                        if (data != null && data >= 0) {
                            isSuccess = true;
                        }
                        try {
                            JSONObject jo1 = JsonParser.obtainJSONObject();
                            jo1.put("inSeat", seatService.isMeInSeat());
                            jo1.put("code", isSuccess ? 0 : 1);
                            if (null != callback) {
                                callback.callGame((Object)jo1);
                            }
                        }
                        catch (JSONException e) {
                            MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                        }
                    });
                } else {
                    seatService.standUp(data -> {
                        try {
                            JSONObject jo1 = JsonParser.obtainJSONObject();
                            jo1.put("inSeat", seatService.isMeInSeat());
                            jo1.put("code", data != false ? 0 : 1);
                            if (null != callback) {
                                callback.callGame((Object)jo1);
                            }
                        }
                        catch (JSONException e) {
                            MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                        }
                    });
                }
            }
            catch (JSONException e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void notifyGameSeat(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyGameSeat json: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (StringUtils.isEmpty((String)param)) {
                return;
            }
            try {
                boolean inSeat;
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                ((GamePlayPresenter)GamePlayPresenter.this).mGameInnerStatus.isMeInGameSeat = inSeat = jo.getBoolean("inSeat");
                ((GameOperationPresenter)GamePlayPresenter.this.getPresenter(GameOperationPresenter.class)).gameSeatStatusChanged(inSeat);
            }
            catch (Exception e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void changeSeatStyle(String param) {
        }

        public void changeRoomGame(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"changeRoomGame json: %s", (Object[])new Object[]{param});
            if (StringUtils.isEmpty((String)param)) {
                return;
            }
            String gid = "";
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                gid = jo.optString("gid", "");
            }
            catch (JSONException e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
            if (FP.empty((CharSequence)gid)) {
                MLog.error((Object)GamePlayPresenter.TAG, (String)"changeRoomGame gid empty", (Object[])new Object[0]);
                return;
            }
            IGameInfoService gameInfoService = (IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class);
            if (null != gameInfoService) {
                GameInfo nextGameInfo = gameInfoService.getGameInfoByGid(gid);
                if (null == nextGameInfo) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"changeRoomGame gameInfo null, gid:%s", (Object[])new Object[]{gid});
                    return;
                }
                IPluginService pluginService = GamePlayPresenter.this.getChannel().getPluginService();
                if (null == pluginService) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"changeRoomGame pluginService null", (Object[])new Object[0]);
                    return;
                }
                String currentGid = pluginService.getCurPluginData().getPluginId();
                GameInfo currentGameInfo = gameInfoService.getGameInfoByGid(currentGid);
                if (null == currentGameInfo) {
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"changeRoomGame currentGameInfo null", (Object[])new Object[0]);
                    return;
                }
                if (StringUtils.equal((String)currentGameInfo.gid, (String)nextGameInfo.gid)) {
                    MLog.info((Object)GamePlayPresenter.TAG, (String)"changeRoomGame the same game.", (Object[])new Object[0]);
                    return;
                }
                this.showChangeGameDialog(currentGameInfo.getGname(), nextGameInfo);
            }
        }

        private void showChangeGameDialog(String currentName, final @NotNull GameInfo nextGameInfo) {
            if (StringUtils.isEmpty((String)nextGameInfo.getGname())) {
                return;
            }
            String msg = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_voice_room_switch_mode), (Object[])new Object[]{currentName, nextGameInfo.getGname()});
            OkCancelDialog dialog2 = new OkCancelDialog.Builder().message((CharSequence)msg).cancelable(true).outSideCancelable(true).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes)).listener(new OkCancelDialogListener(){

                public void onCancel() {
                    MLog.info((Object)GamePlayPresenter.TAG, (String)"changeRoomGame dialog click cancel.", (Object[])new Object[0]);
                }

                public void onOk() {
                    if (GamePlayPresenter.this.isDestroyed()) {
                        return;
                    }
                    ((RoomGameAndActivityListPresenter)GamePlayPresenter.this.getPresenter(RoomGameAndActivityListPresenter.class)).selectGame(nextGameInfo);
                }
            }).build();
            ((IChannelPageContext)GamePlayPresenter.this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)dialog2);
        }

        public void changeRoomBackground(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"changeRoomBackground json: %s", (Object[])new Object[]{param});
            if (GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            if (StringUtils.isEmpty((String)param)) {
                return;
            }
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                String bgUrl = jo.optString("bgUrl", "");
                if (!FP.empty((CharSequence)bgUrl)) {
                    int width = ScreenUtils.getInstance().getWidthPixels();
                    int height = ScreenUtils.getInstance().getHeightPixels();
                    bgUrl = bgUrl + YYImageUtils.getThumbnailPostfixPx((int)width, (int)height, (boolean)true);
                    MLog.info((Object)GamePlayPresenter.TAG, (String)"changeRoomBackground bgUrl: %s", (Object[])new Object[]{bgUrl});
                    ((ThemePresenter)GamePlayPresenter.this.getPresenter(ThemePresenter.class)).getModeTheme().setValue((Object)new DrawableResThemeBean(bgUrl));
                    ((AssistGamePublicScreenBgPresenter)GamePlayPresenter.this.getPresenter(AssistGamePublicScreenBgPresenter.class)).setBgUrl(bgUrl);
                }
            }
            catch (JSONException e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void follow(String param, final IComGameCallAppCallBack callback) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"follow json: %s", (Object[])new Object[]{param});
            if (StringUtils.isEmpty((String)param)) {
                return;
            }
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                long uid = jo.optLong("uid", 0L);
                boolean isFollow = jo.optBoolean("isFollow");
                IRelationService relationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
                if (uid > 0L && null != relationService) {
                    RelationInfo relationInfo = relationService.getRelationLocal(uid);
                    if (isFollow) {
                        relationService.requestFollow(relationInfo, EPath.PATH_GAME.getValue(), (ICommonCallback)new ICommonCallback<Boolean>(){

                            public void onSuccess(Boolean aBoolean, Object ... ext) {
                                MLog.info((Object)GamePlayPresenter.TAG, (String)"requestFollow success", (Object[])new Object[0]);
                                try {
                                    JSONObject jo1 = JsonParser.obtainJSONObject();
                                    jo1.put("code", aBoolean != false ? 0 : 1);
                                    if (null != callback) {
                                        callback.callGame((Object)jo1);
                                    }
                                }
                                catch (JSONException e) {
                                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                                }
                            }

                            public void onFail(int errCode, String msg, Object ... ext) {
                                MLog.error((Object)GamePlayPresenter.TAG, (String)("requestFollow fail,cause = " + msg), (Object[])new Object[0]);
                                try {
                                    JSONObject jo1 = JsonParser.obtainJSONObject();
                                    jo1.put("code", 1);
                                    if (null != callback) {
                                        callback.callGame((Object)jo1);
                                    }
                                }
                                catch (JSONException e) {
                                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                                }
                            }
                        });
                    } else {
                        relationService.requestCancelFollow(relationInfo, (ICommonCallback)new ICommonCallback<Boolean>(){

                            public void onSuccess(Boolean aBoolean, Object ... ext) {
                                MLog.info((Object)GamePlayPresenter.TAG, (String)"requestCancelFollow success", (Object[])new Object[0]);
                                try {
                                    JSONObject jo1 = JsonParser.obtainJSONObject();
                                    jo1.put("code", aBoolean != false ? 0 : 1);
                                    if (null != callback) {
                                        callback.callGame((Object)jo1);
                                    }
                                }
                                catch (JSONException e) {
                                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                                }
                            }

                            public void onFail(int errCode, String msg, Object ... ext) {
                                MLog.error((Object)GamePlayPresenter.TAG, (String)("requestCancelFollow fail,cause = " + msg), (Object[])new Object[0]);
                                try {
                                    JSONObject jo1 = JsonParser.obtainJSONObject();
                                    jo1.put("code", 1);
                                    if (null != callback) {
                                        callback.callGame((Object)jo1);
                                    }
                                }
                                catch (JSONException e) {
                                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                                }
                            }
                        });
                    }
                }
            }
            catch (JSONException e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void checkFollowStatus(String param, IComGameCallAppCallBack callback) {
            block6: {
                MLog.info((Object)GamePlayPresenter.TAG, (String)"checkFollowStatus json: %s", (Object[])new Object[]{param});
                if (StringUtils.isEmpty((String)param)) {
                    return;
                }
                try {
                    JSONObject jo = JsonParser.obtainJSONObject((String)param);
                    long uid = jo.optLong("uid", 0L);
                    IRelationService relationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
                    if (uid <= 0L || null == relationService) break block6;
                    RelationInfo relationInfo = relationService.getRelationLocal(uid);
                    try {
                        JSONObject jo1 = JsonParser.obtainJSONObject();
                        jo1.put("isFollow", relationInfo.isFollow());
                        if (null != callback) {
                            callback.callGame((Object)jo1);
                        }
                    }
                    catch (JSONException e) {
                        MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                    }
                }
                catch (JSONException e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                }
            }
        }

        public void notifyGameStatus(String param) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"notifyGameStatus json: %s", (Object[])new Object[]{param});
            if (StringUtils.isEmpty((String)param)) {
                return;
            }
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                ((GamePlayPresenter)GamePlayPresenter.this).mGameInnerStatus.gameStatus = jo.optInt("status");
                GamePlayPresenter.this.mNotifyGameInnerStatusHandler.notifyGamePlayStatus(((GamePlayPresenter)GamePlayPresenter.this).mGameInnerStatus.gameStatus);
            }
            catch (Exception e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void getRoomEntry(String param, IComGameCallAppCallBack callback) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"getRoomEntry json: %s", (Object[])new Object[]{param});
            try {
                JSONObject jo = JsonParser.obtainJSONObject();
                if (null != GamePlayPresenter.this.getChannel() && null != GamePlayPresenter.this.getChannel().getEnterParam()) {
                    jo.put("entry", GamePlayPresenter.this.getChannel().getEnterParam().entry);
                    if (null != callback) {
                        callback.callGame((Object)jo);
                    }
                }
            }
            catch (JSONException e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void forbidMic(String param, final IComGameCallAppCallBack callback) {
            MLog.info((Object)GamePlayPresenter.TAG, (String)"forbidMic json: %s", (Object[])new Object[]{param});
            if (StringUtils.isEmpty((String)param) || GamePlayPresenter.this.isDestroyed()) {
                return;
            }
            IMediaService mediaService = ((IChannelPageContext)GamePlayPresenter.this.getMvpContext()).getChannel().getMediaService();
            if (null == mediaService) {
                return;
            }
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)param);
                final boolean isForbid = jo.optBoolean("isForbid");
                final long uid = jo.optLong("uid", 0L);
                if (uid != 0L) {
                    GamePlayPresenter.this.getChannel().getMediaService().changeMicByOwner(uid, !isForbid, new IOperationCallback(){

                        public void onSuccess() {
                            MLog.info((Object)GamePlayPresenter.TAG, (String)"\u7981\u9ea6 uid:%d\u7528\u6237\u7981\u9ea6:%b \u6210\u529f", (Object[])new Object[]{uid, isForbid});
                            try {
                                JSONObject jo1 = JsonParser.obtainJSONObject();
                                jo1.put("code", 0);
                                if (null != callback) {
                                    callback.callGame((Object)jo1);
                                }
                            }
                            catch (JSONException e) {
                                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                            }
                        }

                        public void onFail(long reason) {
                            MLog.error((Object)GamePlayPresenter.TAG, (String)"\u7981\u9ea6 uid:%d\u7528\u6237\u7981\u9ea6:%b \u5931\u8d25", (Object[])new Object[]{uid, isForbid});
                            try {
                                JSONObject jo1 = JsonParser.obtainJSONObject();
                                jo1.put("code", reason);
                                if (null != callback) {
                                    callback.callGame((Object)jo1);
                                }
                            }
                            catch (JSONException e) {
                                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (JSONException e) {
                MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
            }
        }

        public void onCommonGameReq(CocosProxyType type, String param, IComGameCallAppCallBack callback) {
            int entry = 0;
            int mode = 0;
            boolean isNewLudoUser = false;
            if (type == CocosProxyType.getChannelConfig) {
                if (GamePlayPresenter.this.getChannel() != null && GamePlayPresenter.this.getChannel().getEnterParam() != null) {
                    entry = GamePlayPresenter.this.getChannel().getEnterParam().entry;
                    isNewLudoUser = GamePlayPresenter.this.getChannel().getEnterParam().isLudoNewUser;
                }
                if (GamePlayPresenter.this.getMvpContext() != null && ((IChannelPageContext)GamePlayPresenter.this.getMvpContext()).getPluginData() != null) {
                    mode = ((IChannelPageContext)GamePlayPresenter.this.getMvpContext()).getPluginData().mode;
                }
                MLog.info((Object)GamePlayPresenter.TAG, (String)"getChannelConfig entry:%d, mode:%d, isNewLudoUser:%b", (Object[])new Object[]{entry, mode, isNewLudoUser});
                callback.callGame((Object)new ChannelConfig(entry, mode, isNewLudoUser));
            } else if (type == CocosProxyType.updateGameConfigToHago) {
                MLog.info((Object)GamePlayPresenter.TAG, (String)"updateGameConfigToHago config:%s, gInfo:%s", (Object[])new Object[]{param, GamePlayPresenter.this.mPlayingGameInfo});
                JSONObject obtainJSONObject = null;
                try {
                    obtainJSONObject = JsonParser.obtainJSONObject((String)param);
                    boolean optBoolean = obtainJSONObject.optBoolean("showGuideAfterExitChannel", false);
                    EnterParam enterParam = null;
                    if (GamePlayPresenter.this.mPlayingGameInfo != null && GamePlayPresenter.this.getChannel() != null && (enterParam = GamePlayPresenter.this.getChannel().getEnterParam()) != null) {
                        enterParam.guideGameConfig = optBoolean ? new EnterParam.GuideGameConfig(((GamePlayPresenter)GamePlayPresenter.this).mPlayingGameInfo.gid) : null;
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"updateGameConfigToHago error!!!:$e", (Object[])new Object[0]);
                }
            } else if (type == CocosProxyType.shareCurrentChannelToUser) {
                MLog.info((Object)GamePlayPresenter.TAG, (String)"shareCurrentChannelToUser config:%s", (Object[])new Object[]{param});
                JSONObject obtainJSONObject = null;
                try {
                    obtainJSONObject = JsonParser.obtainJSONObject((String)param);
                    long uid = obtainJSONObject.optLong("uid", 0L);
                    String transInfo = obtainJSONObject.optString("transInfo", "");
                    ((InvitePresenter)GamePlayPresenter.this.getPresenter(InvitePresenter.class)).inviteDir(uid, GamePlayPresenter.this.getTransKey(), transInfo, null);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    MLog.error((Object)GamePlayPresenter.TAG, (String)"updateGameConfigToHago error!!!:$e", (Object[])new Object[0]);
                }
            } else if (type == CocosProxyType.getShareChannelTransInfo) {
                JSONObject jsonObject = JsonParser.obtainJSONObject();
                String string2 = SharedPreferencesUtils.getDefaultPrf().getString(GamePlayPresenter.this.getTransKey(), "");
                MLog.info((Object)GamePlayPresenter.TAG, (String)"getShareChannelTransInfo string:%s", (Object[])new Object[]{string2});
                try {
                    jsonObject.put("transInfo", (Object)string2);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                callback.callGame((Object)jsonObject);
                SharedPreferencesUtils.getDefaultPrf().edit().remove(GamePlayPresenter.this.getTransKey()).apply();
            }
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private GameGuideHandler mGameGuideHandler = new GameGuideHandler(new GameGuideUiCallbacks(){

        @Override
        public void closeNewUserGuide() {
            GamePlayPresenter.this.getWindow().getPanelLayer().hidePanel(GamePlayPresenter.this.mGameGuideHandler.getBasePanel(), false);
        }
    });

    private String getTransKey() {
        if (this.mPlayingGameInfo != null) {
            return StringUtils.formatWitUSLocal((String)"tk_%s_%s", (Object[])new Object[]{this.getChannelId(), this.mPlayingGameInfo.gid});
        }
        return "";
    }

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
        this.mBinder.singleBindSourceTo((KvoSource)mvpContext.getChannel().getMediaService().getMediaData());
        this.mShareHelper = new ShareHelper((Context)mvpContext.getContext(), (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class));
        this.mMemberOrMasterChangeListener = new IRoleService.IMemberOrMasterChangeListener(){

            public void onMyRoleChanged(String channelId, int newRoleType) {
                GamePlayPresenter.this.notifyUserInfoChanged();
            }
        };
        this.getChannel().getRoleService().addDataListener(this.mMemberOrMasterChangeListener);
    }

    private void onGameUserAvatorChanged(final String json) {
        this.mQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"onGameUserAvatorChanged", (String)json, (Object[])new Object[0]);
                }
                try {
                    final List list = JsonParser.parseJsonList((String)json, GameAvatorLocationBean.class);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GamePlayPresenter.this.mLocationBeanList.setValue((Object)list);
                        }
                    });
                }
                catch (Exception e) {
                    MLog.error((Object)GamePlayPresenter.TAG, (Throwable)e);
                }
            }
        }, 0L);
    }

    public boolean startGame(YYFrameLayout viewContainer, GameInfo info, String roomId, String gameCtx, String windowTag) {
        if (this.gameWrapper == null) {
            this.gameWrapper = new ComponentGameWrapper(ServiceManagerProxy.getServiceManager());
        }
        String extend = "";
        try {
            extend = (String)((IChannelPageContext)this.getMvpContext()).getEnterChannelParams().extra.get("game_extend");
        }
        catch (Exception ex) {
            MLog.info((Object)TAG, (String)"startGame, ex:%s", (Object[])new Object[]{ex});
        }
        this.mPlayingGameInfo = info;
        return this.gameWrapper.startGame(viewContainer, info, gameCtx, roomId, (IRoomGameBridge)new MyRoomGameBridge(this.roomGameBridge), windowTag, extend, this.isTransGame(info != null ? info.gid : ""));
    }

    private boolean isTransGame(String gid) {
        GameCommonConfigData gameCommonConfigData;
        AConfigData configData2;
        int mode;
        return StringUtils.isNotEmpty((String)gid) && (mode = this.getPluginMode()) == 1 && (configData2 = UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_COMMON_CONFIG)) instanceof GameCommonConfig && (gameCommonConfigData = ((GameCommonConfig)configData2).mGameCommonConfigData) != null && gameCommonConfigData.getBaseRoomTransBgGame().contains(gid);
    }

    public IRoomGameBridge getRoomGameBridge() {
        return new MyRoomGameBridge(this.roomGameBridge);
    }

    public void exitGame(ILeaveGameCallback callback) {
        if (this.gameWrapper != null) {
            this.gameWrapper.exitGame((gameInfo, context) -> {
                this.gameWrapper = null;
                if (callback != null) {
                    callback.onGameLeaved(gameInfo, context);
                }
            });
        } else {
            if (callback != null) {
                callback.onGameLeaved(null, null);
            }
            FeatureLog.e((String)"FTVoiceRoom", (String)"exit game error,no wrapper!!!", (Object[])new Object[0]);
        }
        this.mGameConpomentHandler.clearLoaction();
        this.mPlayingGameInfo = null;
    }

    public void registerGameLifecycle(IGameLifecycle gameLifecycle2) {
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(gameLifecycle2);
    }

    public void unRegisterGameLifecycle(IGameLifecycle gameLifecycle2) {
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).unRegisterGameLifecycle(gameLifecycle2);
    }

    public boolean isGaming() {
        if (ServiceManagerProxy.getServiceManager() != null) {
            IGameCenterService service = (IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class);
            return service != null && service.isPlaying() && service.getCurPlayingGame().getGameMode() == 8;
        }
        return false;
    }

    public void showGameRule(final GameInfo gameInfo) {
        if (gameInfo == null) {
            FeatureLog.e((String)"FTVoiceRoom", (String)"showGameRule error,game info null", (Object[])new Object[0]);
            return;
        }
        final DialogLinkManager manager = new DialogLinkManager((Context)this.getContext());
        manager.showDialog(new BaseDialog(){
            private YYTextView mContentText;
            private YYTextView mContentTitle;
            private RoundImageView mContentImg;

            private void initView(View container) {
                this.mContentImg = (RoundImageView)container.findViewById(R.id.content_img);
                this.mContentTitle = (YYTextView)container.findViewById(R.id.content_title);
                this.mContentText = (YYTextView)container.findViewById(R.id.content_text);
            }

            public void init(Dialog dialog2) {
                dialog2.setContentView(R.layout.seat_game_rule_channel);
                dialog2.setCanceledOnTouchOutside(true);
                dialog2.setCancelable(true);
                View ruleView = dialog2.findViewById(R.id.rule_container);
                this.initView(ruleView);
                ruleView.findViewById(R.id.close_icon).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        manager.dismissDialog();
                    }
                });
                this.mContentTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
                this.mContentTitle.setText((CharSequence)gameInfo.getGname());
                if (!FP.empty((Collection)gameInfo.getGameRuleList())) {
                    ImageLoader.loadImage((ImageView)this.mContentImg, (String)((GameRule)gameInfo.getGameRuleList().get(0)).getBgUrl());
                    this.mContentText.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
                    this.mContentText.setText((CharSequence)((GameRule)gameInfo.getGameRuleList().get(0)).getContent());
                }
            }

            public int getId() {
                return 0;
            }
        });
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onHide() {
        if (this.gameWrapper != null) {
            this.gameWrapper.onHide();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onShow() {
        if (this.gameWrapper != null) {
            this.gameWrapper.onShow();
        }
    }

    public void addGamePlayStatusListener(IGamePlayStatusListener listener) {
        this.mNotifyGameInnerStatusHandler.addGamePlayStatusListener(listener);
    }

    public void removeGamePlayStatusListener(IGamePlayStatusListener listener) {
        this.mNotifyGameInnerStatusHandler.removeGamePlayStatusListener(listener);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBinder.clearAllKvoConnections();
        this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        this.mNotifyGameInnerStatusHandler.clear();
    }

    @KvoMethodAnnotation(name="listUpdated", sourceClass=MediaData.class, thread=1)
    void onSpeakListChange(KvoEventIntent event) {
        HashMap source = ((MediaData)event.source()).getSpeakList();
        this.onUserSpeakingStatus(source);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"GamePlayPresenter:%s", (Object[])new Object[]{source});
        }
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        List<MicStatusBean> retDatas = this.getMicStatusBeans();
        this.onMicListStatusChange(retDatas);
        if (this.isPlayManager != this.isPlayManager(AccountUtil.getUid())) {
            this.isPlayManager = this.isPlayManager(AccountUtil.getUid());
            this.notifyUserInfoChanged();
        }
    }

    public boolean isPlayManager(long uid) {
        return this.getChannel().getRoleService().isOwnerOrMaster(uid) || this.getChannelDetailInfo().baseInfo.roomShowType == 2 && this.getChannelDetailInfo().baseInfo.showUid == uid && this.getChannel().getSeatService().isInFirstSeat(uid);
    }

    @NonNull
    private List<MicStatusBean> getMicStatusBeans() {
        int needFillInBlankSeatSize;
        int i;
        List status = this.getChannel().getSeatService().getSeatStatusList();
        ArrayList seatStatusList = status != null ? new ArrayList(status) : new ArrayList();
        List uids = this.getChannel().getSeatService().getSeatUidsList();
        ArrayList seatUidList = uids != null ? new ArrayList(uids) : new ArrayList();
        ArrayList<MicStatusBean> retDatas = new ArrayList<MicStatusBean>();
        if (!seatUidList.isEmpty() && !seatStatusList.isEmpty()) {
            int length = Math.min(seatStatusList.size(), seatUidList.size());
            for (i = 0; i < length; ++i) {
                long speakStatus = (Long)seatStatusList.get(i);
                MicStatusBean statusBean = new MicStatusBean((Long)seatUidList.get(i), SeatStatusUtils.isMicOpen((long)speakStatus) ? 1 : (SeatStatusUtils.isMicForbidden((long)speakStatus) ? 2 : 0));
                retDatas.add(statusBean);
            }
        }
        if ((needFillInBlankSeatSize = 8 - retDatas.size()) > 0) {
            for (i = 0; i < needFillInBlankSeatSize; ++i) {
                retDatas.add(new MicStatusBean(Long.valueOf(0L), 0));
            }
        }
        return retDatas;
    }

    private void onUserSpeakingStatus(Map<Long, Boolean> speakList) {
        if (this.gameWrapper != null) {
            this.gameWrapper.onUserSpeakStatus(speakList);
        }
    }

    private void onMicListStatusChange(List<MicStatusBean> micStatusList) {
        if (this.gameWrapper != null) {
            this.gameWrapper.onMicListStatusChange(micStatusList);
        }
    }

    private void onMicListStatusCallback(List<MicStatusBean> micStatusList, IComGameCallAppCallBack callback) {
        if (this.gameWrapper != null) {
            this.gameWrapper.onMicListStatusCallback(micStatusList, callback);
        }
    }

    public MutableLiveData<List<GameAvatorLocationBean>> getSeatLocationBeanList() {
        return this.mLocationBeanList;
    }

    private FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    protected void showPanelWebInner(String url) {
        if (FP.empty((CharSequence)url)) {
            return;
        }
        final GameWebPanel webViewPanel = new GameWebPanel((Context)this.getContext());
        webViewPanel.loadUrl(url, new IWebPageCallback(){

            public void exitWebView() {
                GamePlayPresenter.this.getWindow().getPanelLayer().hidePanel((BasePanel)webViewPanel, true);
                webViewPanel.destroy();
            }
        });
        this.getWindow().getPanelLayer().showPanel((BasePanel)webViewPanel, true);
    }

    @Nullable
    public CocoViewBean getConpomentLocationByKey(String conpomentName) {
        return this.mGameConpomentHandler.getComponentLocationByKey(conpomentName);
    }

    public void notifyGoldChange(GameGoldChangeBean bean) {
        this.mNotifyGameHandler.notifyGoldChange(bean);
    }

    private void notifyUserInfoChanged() {
        RoomUserInfo info = new RoomUserInfo();
        info.setCanControlGame(this.isPlayManager(AccountUtil.getUid()));
        info.setOwner(this.getChannel().getRoleService().isMeOwner());
        info.setUid(AccountUtil.getUid());
        this.mNotifyGameHandler.notifyUserInfoChange(info);
    }

    public void showGameRuleViewPage(GameInfo gameInfo) {
        this.showGameListPanel(gameInfo);
    }

    public void showGameListPanel(GameInfo gameInfo) {
        BasePanel basePanel = this.mGameGuideHandler.createNewUserGuidePanel((Context)this.getContext(), gameInfo, this.getChannelId());
        this.getWindow().getPanelLayer().showPanel(basePanel, false);
    }

    public GameInnerStatus getGameInnerStatus() {
        return this.mGameInnerStatus;
    }

    @Override
    public void sendMsgtoGame(CocosProxyType type, Object jsonObject) {
        this.sendMsgtoGame(((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).getAppCallGameProxy().uniqueSeq(), type, jsonObject);
    }

    @Override
    public void sendMsgtoGame(long seqId, CocosProxyType event, Object jsonObject) {
        if (this.gameWrapper != null) {
            this.gameWrapper.callGameFun(seqId, event, jsonObject);
        }
    }

    private static class MyRoomGameBridge
    implements IRoomGameBridge {
        private WeakReference<IRoomGameBridge> mBridgeWeakReference;

        public MyRoomGameBridge(IRoomGameBridge roomGameBridge) {
            this.mBridgeWeakReference = new WeakReference<IRoomGameBridge>(roomGameBridge);
        }

        public void openUserCard(long uid) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.openUserCard(uid);
            }
        }

        public void micListStatusQuery(String json, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.micListStatusQuery(json, callback);
            }
        }

        public void showGameRule(String json) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.showGameRule(json);
            }
        }

        public void playerHasLeftGame() {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.playerHasLeftGame();
            }
        }

        public void postGameUserAvatorView(String json) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.postGameUserAvatorView(json);
            }
        }

        public void showShareView(GameInfo gameInfo, String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.showShareView(gameInfo, param);
            }
        }

        public void sendPublicScreen(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.sendPublicScreen(param);
            }
        }

        public void showPanelWeb(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.showPanelWeb(param);
            }
        }

        public void showGiftPanel() {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.showGiftPanel();
            }
        }

        public void onConpomentLoactionChange(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.onConpomentLoactionChange(param);
            }
        }

        public void showGameRuleList(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.showGameRuleList(param);
            }
        }

        public void getRoomUserInfo(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.getRoomUserInfo(param, callback);
            }
        }

        public void getVoiceRoomData(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.getVoiceRoomData(param, callback);
            }
        }

        public void operateRoomSelfMic(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.operateRoomSelfMic(param);
            }
        }

        public void notifyAssistGameState(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.notifyAssistGameState(param);
            }
        }

        public void notifyAssistMember(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.notifyAssistMember(param);
            }
        }

        public void changeGameContainerViewSize(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.changeGameContainerViewSize(param);
            }
        }

        public void notifyAssistGameStateAndMemberList(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.notifyAssistGameStateAndMemberList(param);
            }
        }

        public void getRoomViewParams(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.getRoomViewParams(param, callback);
            }
        }

        public void queryChannelInfoById(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.queryChannelInfoById(param, callback);
            }
        }

        public void notifyAssistGameResult(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.notifyAssistGameResult(param);
            }
        }

        public void operateAppSeat(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.operateAppSeat(param, callback);
            }
        }

        public void notifyGameSeat(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.notifyGameSeat(param);
            }
        }

        public void changeSeatStyle(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.changeSeatStyle(param);
            }
        }

        public void changeRoomBackground(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.changeRoomBackground(param);
            }
        }

        public void changeRoomGame(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.changeRoomGame(param);
            }
        }

        public void follow(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.follow(param, callback);
            }
        }

        public void checkFollowStatus(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.checkFollowStatus(param, callback);
            }
        }

        public void notifyGameStatus(String param) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.notifyGameStatus(param);
            }
        }

        public void getRoomEntry(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.getRoomEntry(param, callback);
            }
        }

        public void forbidMic(String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.forbidMic(param, callback);
            }
        }

        public void onCommonGameReq(CocosProxyType type, String param, IComGameCallAppCallBack callback) {
            if (this.mBridgeWeakReference == null) {
                return;
            }
            IRoomGameBridge bridge = (IRoomGameBridge)this.mBridgeWeakReference.get();
            if (bridge != null) {
                bridge.onCommonGameReq(type, param, callback);
            }
        }
    }
}

