/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.publicscreen;

import android.os.Message;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.R;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.bean.ChannelRobotInfo;
import com.yy.hiyo.channel.base.bean.MsgBizExt;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.SimpleCardInfo;
import com.yy.hiyo.channel.base.bean.fansgroup.FansBadgeBean;
import com.yy.hiyo.channel.base.callback.IMsgUpdate;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@DontProguardClass
public class BaseImMsg
extends KvoSource
implements IMsgUpdate {
    public static final int CHANNELTITLE_NONE = 0;
    @SerializedName(value="from")
    private long from;
    public static final String kvo_role = "role";
    @KvoFieldAnnotation(name="role")
    @SerializedName(value="role")
    private int role = 1;
    @SerializedName(value="ts")
    private long serverTime;
    @SerializedName(value="msgId")
    private String msgId;
    @SerializedName(value="flags")
    private long flags = 0L;
    @SerializedName(value="cid")
    private String cid;
    @SerializedName(value="cseq")
    private String cseq;
    @SerializedName(value="seqid")
    private long seqid;
    private String pid;
    private String cname;
    private String nick;
    private String avatar;
    private int sex;
    private String pwd;
    private boolean hasPartyLabel;
    private boolean isNewComer;
    private long upgradeLabelId;
    public static final String kvo_honerIds = "honerIds";
    @KvoFieldAnnotation(name="honerIds")
    @SerializedName(value="honerIds")
    private List<Integer> honerIds = new ArrayList<Integer>();
    private FansBadgeBean fansBadge;
    private MutableLiveData<List<SimpleCardInfo>> mUserTagInfos = new SafeLiveData();
    private MutableLiveData<List<Integer>> mMedalList = new MutableLiveData();
    @SerializedName(value="sections")
    private List<MsgSection> sections = new ArrayList<MsgSection>();
    @SerializedName(value="pushContent")
    private ChannelPushContent groupPushContent;
    private long mChannelOwnerId;
    private int channelType = 1;
    private String channelAvatar;
    private int version;
    private boolean isAtMeMsg = false;
    private int mRobotMsgType = 0;
    private ChannelRobotInfo mChannelRobotInfo;
    private MsgBizExt mMsgBizExt = new MsgBizExt();
    private String channelSource = "";
    private String channelNick = "";
    private int channelTitle = 0;
    private String highActiveTitle = "";
    private String midActiveTitle = "";
    private String lowActiveTitle = "";
    private boolean isShowChannelNick = true;
    private boolean isShowChannelTitle = true;
    private String channelTitleName = "";
    private String channelTitleBg = "";
    private String log = null;
    private boolean isLocalMsg = false;
    public static final String kvo_isFirstCharge = "isFirstCharge";
    @KvoFieldAnnotation(name="isFirstCharge")
    private boolean isFirstCharge = false;
    public static final String kvo_msgState = "msgState";
    @KvoFieldAnnotation(name="msgState")
    private transient int msgState = 0;
    private transient long clientTime = -1L;
    private transient long id = -1L;
    private WeakReference<IFuncBridge> mIFuncBridge;
    private boolean isValid = true;

    public String toString() {
        if (ChannelDefine.sUnEnableLog) {
            return "msgId:" + this.msgId + ", msgType:" + this.getMsgType();
        }
        if (StringUtils.isNotEmpty((String)this.log)) {
            return this.log;
        }
        this.log = "BaseImMsg{from='" + this.from + '\'' + "role='" + this.role + '\'' + "ts='" + this.serverTime + '\'' + "msgId='" + this.msgId + '\'' + "flags='" + this.flags + '\'' + "cid='" + this.cid + '\'' + "cseq='" + this.cseq + '\'' + "isAtMeMsg='" + this.isAtMeMsg + '\'' + "sections='" + (this.sections != null ? this.sections.toString() : "") + '\'' + "isRobotMsg=" + this.mRobotMsgType + '\'' + "robotInfo=" + (this.mChannelRobotInfo != null ? this.mChannelRobotInfo.toString() : "") + '\'' + "isShowChannelNick=" + this.isShowChannelNick + '\'' + "isShowChannelTitle=" + this.isShowChannelTitle + '\'' + '}';
        return this.log;
    }

    public BaseImMsg() {
    }

    public BaseImMsg(BaseImMsg msg) {
        this.from = msg.from;
        this.role = msg.role;
        this.serverTime = msg.serverTime;
        this.msgId = msg.msgId;
        this.flags = msg.flags;
        this.cid = msg.cid;
        this.cseq = msg.cseq;
        this.sections = msg.sections;
        this.msgState = msg.msgState;
        this.groupPushContent = msg.groupPushContent;
        this.nick = msg.nick;
        this.avatar = msg.avatar;
        this.pid = msg.pid;
        this.cname = msg.cname;
        this.sex = msg.sex;
        this.pwd = msg.pwd;
        this.seqid = msg.seqid;
        this.honerIds = msg.honerIds;
        this.mUserTagInfos = msg.mUserTagInfos;
        this.mMedalList = msg.mMedalList;
        this.fansBadge = msg.fansBadge;
        this.mChannelOwnerId = msg.getChannelOwnerId();
        this.channelType = msg.channelType;
        this.channelAvatar = msg.channelAvatar;
        this.isAtMeMsg = msg.isAtMeMsg;
        this.mRobotMsgType = msg.mRobotMsgType;
        this.mChannelRobotInfo = msg.mChannelRobotInfo;
        this.channelSource = msg.channelSource;
        this.channelNick = msg.channelNick;
        this.channelTitle = msg.channelTitle;
        this.isShowChannelNick = msg.isShowChannelNick;
        this.isNewComer = msg.isNewComer;
        this.isShowChannelTitle = msg.isShowChannelTitle;
        this.highActiveTitle = msg.highActiveTitle;
        this.lowActiveTitle = msg.lowActiveTitle;
        this.midActiveTitle = msg.midActiveTitle;
        this.channelTitleName = msg.channelTitleName;
        this.channelTitleBg = msg.channelTitleBg;
        this.isLocalMsg = msg.isLocalMsg;
        this.isFirstCharge = msg.isFirstCharge;
        this.hasPartyLabel = msg.hasPartyLabel;
        this.upgradeLabelId = msg.upgradeLabelId;
    }

    @Nullable
    public CharSequence getSessionTips() {
        if (this.isRevokeMsg()) {
            if (AccountUtil.getUid() == this.getFrom()) {
                return ResourceUtils.getString((int)R.string.im_revoked_msg_by_me);
            }
            return StringUtils.format((String)ResourceUtils.getString((int)R.string.im_revoked_msg_by_other), (Object[])new Object[]{this.getNick()});
        }
        return null;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long senderUid) {
        this.from = senderUid;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String getNick() {
        return this.nick == null ? "" : this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public String getAvatarUrl() {
        return this.avatar;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatar = avatarUrl;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getChannelName() {
        return this.cname;
    }

    public void setChannelName(String channelName) {
        this.cname = channelName;
    }

    public FansBadgeBean getFansBadge() {
        return this.fansBadge;
    }

    public void setFansBadge(FansBadgeBean fansBadge) {
        this.fansBadge = fansBadge;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.setValue(kvo_role, role);
    }

    public void setRoleUnbind(int role) {
        this.role = role;
    }

    public long getTs() {
        return this.serverTime;
    }

    public void setTs(long ts) {
        this.serverTime = ts;
    }

    public void setSendTime(long ts) {
        this.clientTime = ts;
    }

    public long getSendTime() {
        return this.clientTime;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    public long getDBId() {
        return this.id;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public int getMsgState() {
        return this.msgState;
    }

    public void setMsgState(int msgState) {
        this.setValue(kvo_msgState, msgState);
    }

    public void setMsgStateUnbind(int msgState) {
        this.msgState = msgState;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public List<MsgSection> getSections() {
        return this.sections;
    }

    public void setSections(List<MsgSection> sections) {
        this.sections.clear();
        if (sections != null && !sections.isEmpty()) {
            this.sections.addAll(sections);
        }
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getCseq() {
        return this.cseq;
    }

    public void setCseq(String cseq) {
        this.cseq = cseq;
    }

    public ChannelPushContent getGroupPushContent() {
        return this.groupPushContent;
    }

    public void setGroupPushContent(ChannelPushContent groupPushContent) {
        this.groupPushContent = groupPushContent;
    }

    public void onUpdate(BaseImMsg msg) {
        if (this.cseq == null || !this.cseq.equals(msg.getCseq())) {
            this.setCseq(msg.cseq);
        }
        if (StringUtils.isNotEmpty((String)msg.getMsgId()) && !msg.getMsgId().equals(this.msgId)) {
            this.setMsgId(msg.getMsgId());
        }
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setHonerIds(List<Integer> honerIds) {
        this.setValue(kvo_honerIds, honerIds);
    }

    public List<Integer> getHonerIds() {
        return this.honerIds;
    }

    public long getSeqid() {
        return this.seqid;
    }

    public void setSeqid(long seqid) {
        this.seqid = seqid;
    }

    public void setChannelOwnerId(long channelOwnerId) {
        this.mChannelOwnerId = channelOwnerId;
    }

    public long getChannelOwnerId() {
        return this.mChannelOwnerId;
    }

    public int getChannelType() {
        return this.channelType;
    }

    public void setChannelType(int channelType) {
        this.channelType = channelType;
    }

    public String getChannelAvatar() {
        return this.channelAvatar;
    }

    public void setChannelAvatar(String channelAvatar) {
        this.channelAvatar = channelAvatar;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getChannelSource() {
        return this.channelSource;
    }

    public void setChannelSource(String channelSource) {
        this.channelSource = channelSource;
    }

    public boolean isAtMeMsg() {
        return this.isAtMeMsg;
    }

    public void setAtMeMsg(boolean atMeMsg) {
        this.isAtMeMsg = atMeMsg;
    }

    public String getChannelNick() {
        return this.channelNick;
    }

    public void setChannelNick(String channelNick) {
        this.channelNick = channelNick;
    }

    public int getChannelTitle() {
        return this.channelTitle;
    }

    public void setChannelTitle(int channelTitle) {
        this.channelTitle = channelTitle;
    }

    public String getHighActiveTitle() {
        return this.highActiveTitle;
    }

    public void setHighActiveTitle(String highActiveTitle) {
        this.highActiveTitle = highActiveTitle;
    }

    public String getMidActiveTitle() {
        return this.midActiveTitle;
    }

    public void setMidActiveTitle(String midActiveTitle) {
        this.midActiveTitle = midActiveTitle;
    }

    public String getLowActiveTitle() {
        return this.lowActiveTitle;
    }

    public void setLowActiveTitle(String lowActiveTitle) {
        this.lowActiveTitle = lowActiveTitle;
    }

    public boolean isShowChannelNick() {
        return this.isShowChannelNick;
    }

    public void setShowChannelNick(boolean showChannelNick) {
        this.isShowChannelNick = showChannelNick;
    }

    public boolean isShowChannelTitle() {
        return this.isShowChannelTitle;
    }

    public void setShowChannelTitle(boolean showChannelTitle) {
        this.isShowChannelTitle = showChannelTitle;
    }

    public boolean isNewComer() {
        return this.isNewComer;
    }

    public void setIsNewComer(boolean isNewComer) {
        this.isNewComer = isNewComer;
    }

    public boolean hasPartyLabel() {
        return this.hasPartyLabel;
    }

    public void setHasPartyLabel(boolean hasPartyLabel) {
        this.hasPartyLabel = hasPartyLabel;
    }

    public boolean isLocalMsg() {
        return this.isLocalMsg;
    }

    public void setLocalMsg(boolean isLocalMsg) {
        this.isLocalMsg = isLocalMsg;
    }

    public boolean isFirstCharge() {
        if (SystemUtils.isShowEnvSetting()) {
            return this.isFirstCharge && !SettingFlags.getBoolean((String)"debug_first_charge_tag", (boolean)false);
        }
        return this.isFirstCharge;
    }

    public void setFirstCharge(boolean isFirstCharge) {
        this.setValue(kvo_isFirstCharge, isFirstCharge);
    }

    public String getChannelTitleName() {
        return this.channelTitleName;
    }

    public void setChannelTitleName(String channelTitleName) {
        this.channelTitleName = channelTitleName;
    }

    public String getChannelTitleBg() {
        return this.channelTitleBg;
    }

    public void setChannelTitleBg(String channelTitleBg) {
        this.channelTitleBg = channelTitleBg;
    }

    public LiveData<List<SimpleCardInfo>> getUserTagInfos() {
        return this.mUserTagInfos;
    }

    public void updateUserCards(List<SimpleCardInfo> infos) {
        this.mUserTagInfos.postValue(infos);
    }

    public MutableLiveData<List<Integer>> getMedalList() {
        return this.mMedalList;
    }

    public long getUpgradeLabelId() {
        return this.upgradeLabelId;
    }

    public void setUpgradeLabelId(long upgradeLabelId) {
        this.upgradeLabelId = upgradeLabelId;
    }

    public IFuncBridge getIFuncBridge() {
        return this.mIFuncBridge != null ? (IFuncBridge)this.mIFuncBridge.get() : null;
    }

    public void setIFuncBridge(IFuncBridge iFuncBridge) {
        this.mIFuncBridge = iFuncBridge != null ? new WeakReference<IFuncBridge>(iFuncBridge) : null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public void setRobotMsgType(int mRobotMsgType) {
        this.mRobotMsgType = mRobotMsgType;
    }

    public int getRobotMsgType() {
        return this.mRobotMsgType;
    }

    public ChannelRobotInfo getChannelRobotInfo() {
        return this.mChannelRobotInfo;
    }

    public void setChannelRobotInfo(ChannelRobotInfo mChannelRobotInfo) {
        this.mChannelRobotInfo = mChannelRobotInfo;
    }

    public MsgBizExt getMsgBizExt() {
        return this.mMsgBizExt;
    }

    public int getMsgType() {
        if (!FP.empty(this.sections) && this.sections.get(0) != null) {
            return this.sections.get(0).getType();
        }
        return 0;
    }

    public boolean isRevokeMsg() {
        return this.getMsgType() == 3609;
    }

    public boolean isDisposable(boolean isStrongNeed) {
        return false;
    }

    public boolean isOfficial() {
        return this.from == 10L || this.from == 14L;
    }

    public static class BaseImMsgComparator
    implements Comparator<BaseImMsg> {
        @Override
        public int compare(BaseImMsg p1, BaseImMsg p2) {
            return (int)(p1.serverTime - p2.serverTime);
        }
    }

    public static interface IFuncBridge {
        public void onNickClick(long var1, BaseImMsg var3);

        public void onSpanClick(Message var1);
    }
}

