/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.service;

import androidx.annotation.MainThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.JoinApproveData;
import com.yy.hiyo.channel.base.bean.OnlineInfo;
import com.yy.hiyo.channel.base.bean.OnlineWithStatusInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelBaseService;
import com.yy.hiyo.linkmic.base.bean.UserLinkMicInfo;
import com.yy.hiyo.proto.ProtoManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public interface IRoleService
extends IChannelBaseService {
    public void getOnlineUserList(ProtoManager.Page var1, IGetOnlineUserListCallBack var2);

    public void getPotentialOnlineUserList(ProtoManager.Page var1, IGetOnlineUserListCallBack var2);

    public void getChannelOnlineUserList(ProtoManager.Page var1, IGetOnlineUserListCallBack var2);

    public void getChannelOnlineWithStatusUserList(ProtoManager.Page var1, IGetOnlineUserWithStatusListCallBack var2);

    public void getMemberAndMasterList(int var1, int var2, IGetUserListCallBack var3);

    public void getMemberAndMasterList(int var1, int var2, IGetUserListCallBack var3, boolean var4);

    @MainThread
    public List<ChannelUser> getMemberAndMasterCache(int var1, int var2);

    public List<ChannelUser> getRoleFromCache(int var1);

    public void getRoleList(int var1, int var2, int var3, IGetUserListCallBack var4);

    public void isInChannel(List<Long> var1, IQueryUsersInThisChannelCallBack var2);

    public void updateMemberCacheFromServer(String var1);

    public int getRole(long var1, IGetRoleCallBack var3);

    public HashMap<Long, Integer> getRoles(List<Long> var1, IGetRolesCallBack var2);

    public HashMap<Long, ChannelUser> getRoles(List<Long> var1, IGetRoleUsersCallBack var2);

    public void getMyRole(IGetRoleCallBack var1);

    public int getMyRoleCache();

    public int getRoleCache(long var1);

    public void setRole(HashMap<Long, Integer> var1, String var2, ISetRolesCallBack var3);

    public void applyJoin(String var1, IJoinApplyCallBack var2);

    public void applyJoin(String var1, String var2, IJoinApplyCallBack var3);

    public void joinApprove(JoinApproveData var1, IJoinApproveCallBack var2);

    public void setRole(long var1, int var3, String var4, ISetRoleCallBack var5);

    public void acceptRole(String var1, boolean var2, IAcceptRoleInviteCallBack var3);

    public boolean isBanned(long var1, IIsBannedCallBack var3);

    public void banned(long var1, long var3, IBannedCallBack var5);

    public void addDataListener(IMemberOrMasterChangeListener var1);

    public void removeDataListener(IMemberOrMasterChangeListener var1);

    public boolean isLinkMicAudience(long var1);

    public void setLinkMicUserInfo(UserLinkMicInfo var1);

    public UserLinkMicInfo getLinkMicUserInfo();

    default public boolean isOwner(long uid) {
        int role = this.getRoleCache(uid);
        return role == 15;
    }

    default public boolean isMeOwner() {
        return this.isOwner(AccountUtil.getUid());
    }

    default public boolean isOwnerOrMaster(long uid) {
        int role = this.getRoleCache(uid);
        return role == 10 || role == 15;
    }

    public boolean isAnchor(long var1);

    default public boolean isMeAnchor() {
        return this.isAnchor(AccountUtil.getUid());
    }

    default public boolean isInChannel(long uid) {
        int role = this.getRoleCache(uid);
        return role == 10 || role == 15 || role == 5;
    }

    public long getAnchorUid();

    public long getAnchorUidFromSeat();

    public static interface IMemberOrMasterChangeListener {
        default public void onSpeakBanned(long uid, boolean banned) {
        }

        default public void onRoleChanged(String channelId, long uid, int roleType) {
        }

        default public void onMyRoleChanged(String channelId, int newRoleType) {
        }

        default public void onMemberListChanged(String channelId, ArrayList<ChannelUser> members) {
        }
    }

    public static interface IAcceptRoleInviteCallBack {
        public void onSuccess(String var1, ChannelUser var2);

        public void onInviteAlreadyInvalidError(String var1, String var2);

        public void onError(String var1, int var2, String var3, Exception var4);

        public void onFailByMemberReachLimit(String var1, String var2);

        public void onFailByJoinedChannelLimit(String var1, String var2);

        public void onAlreadyJoined(String var1, String var2);

        public void onFailByJoinedFrozeLimit(String var1, int var2);

        public void onChannelNoExit(String var1, long var2);

        public void onChannelBanned(String var1, long var2);

        public void onChannelJoinBanForever(String var1, long var2);

        public void onNotInChannel(String var1, long var2);

        public void onOtherRejected(String var1, long var2);

        public void onNoArrow(String var1, long var2);
    }

    public static interface IJoinApproveCallBack {
        public void onSuccess(String var1, String var2, ChannelUser var3);

        public void onNoPermissionError(String var1, String var2);

        public void onFailByMemberReachLimit(String var1, String var2);

        public void onApplyAlreadyInvalidError(String var1, String var2);

        public void onFailByJoinedChannelLimit(String var1, String var2);

        public void onAlreadyJoined(String var1, String var2);

        public void onError(String var1, int var2, String var3, Exception var4);

        public void onChannelNoExit(String var1, long var2);

        public void onChannelBanned(String var1, long var2);

        public void onChannelJoinBanForever(String var1, long var2);

        public void onNotInChannel(String var1, long var2);

        public void onOtherRejected(String var1, long var2);

        public void onNoArrow(String var1, long var2);

        public void onFailAlreadHaveFamily(String var1, long var2);
    }

    public static interface IJoinApplyCallBack {
        public void onSuccess(String var1, String var2, ChannelUser var3);

        public void onFailByMemberReachLimit(String var1);

        public void onFailByJoinedChannelLimit(String var1);

        public void onJoinBanForever(String var1);

        public void onAlreadyJoined(String var1);

        public void onHaveJoinedFamily(String var1);

        public void onFailByJoinedLvLimit(String var1);

        public void onFailByJoinedFrozeLimit(String var1, int var2);

        public void onFailByInOwnerBlackList(String var1, String var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface ISetRolesCallBack {
        public void onSuccess(String var1, HashMap<Long, SetRoleRes> var2);

        public void onHaveJoinedFamily(String var1);

        public void onFailByJoinedLvLimit(String var1);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static class SetRoleRes {
        public String channelId;
        public long uid;
        public boolean success;
        public boolean waitForAccept;
        public long errorCode;
    }

    public static interface ISetRoleCallBack {
        public void onSuccess(String var1, long var2, boolean var4);

        public void onNoPermissionError(String var1);

        public void onFailByAlreadyIsThisRole(String var1);

        public void onFailByMemberReachLimit();

        public void onFailByJoinedChannelLimit();

        public void onHaveJoinedFamily(String var1);

        public void onFailByJoinedLvLimit(String var1);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetRoleUsersCallBack {
        public void onSuccess(String var1, HashMap<Long, ChannelUser> var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetRolesCallBack {
        public void onSuccess(String var1, HashMap<Long, Integer> var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetRoleCallBack {
        public void onSuccess(String var1, int var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetAllMemberListCallBack {
        public void onSuccess(String var1, ArrayList<ChannelUser> var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IQueryUsersInChannelCallBack {
        public void onSuccess(HashMap<Long, String> var1);

        public void onError(int var1, String var2, Exception var3);

        default public void onSuccess(HashMap<Long, String> inChannelMap, List<Integer> onLines) {
        }
    }

    public static interface IQueryUsersInThisChannelCallBack {
        public void onSuccess(String var1, HashMap<Long, Boolean> var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetUserListCallBack {
        public void onSuccess(IChannel var1, long var2, List<ChannelUser> var4);

        public void onError(IChannel var1, int var2, String var3, Exception var4);
    }

    public static interface IGetOnlineUserWithStatusListCallBack {
        public void onSuccess(String var1, ProtoManager.Page var2, OnlineWithStatusInfo var3);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetOnlineUserListCallBack {
        public void onSuccess(String var1, ProtoManager.Page var2, OnlineInfo var3);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IBannedCallBack {
        public void onSuccess(IChannel var1, long var2, long var4);

        public void onFailUnauthorized();

        public void onError(IChannel var1, int var2, String var3, Exception var4);
    }

    public static interface IIsBannedCallBack {
        public void banned(String var1, long var2, long var4);
    }
}

